/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.ReferenceNameExpression;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RenameWrongRefFix
implements IntentionAction {
    private final PsiReferenceExpression myRefExpr;
    @NonNls
    private static final String INPUT_VARIABLE_NAME = "INPUTVAR";
    @NonNls
    private static final String OTHER_VARIABLE_NAME = "OTHERVAR";
    private final boolean myUnresolvedOnly;

    public RenameWrongRefFix(@NotNull PsiReferenceExpression refExpr) {
        if (refExpr == null) {
            RenameWrongRefFix.$$$reportNull$$$0(0);
        }
        this(refExpr, false);
    }

    public RenameWrongRefFix(@NotNull PsiReferenceExpression refExpr, boolean unresolvedOnly) {
        if (refExpr == null) {
            RenameWrongRefFix.$$$reportNull$$$0(1);
        }
        this.myRefExpr = refExpr;
        this.myUnresolvedOnly = unresolvedOnly;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("rename.wrong.reference.text", new Object[0]);
        if (string == null) {
            RenameWrongRefFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("rename.wrong.reference.family", new Object[0]);
        if (string == null) {
            RenameWrongRefFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            RenameWrongRefFix.$$$reportNull$$$0(4);
        }
        if (!this.myRefExpr.isValid() || !this.myRefExpr.getManager().isInProject((PsiElement)this.myRefExpr)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement refName = this.myRefExpr.getReferenceNameElement();
        if (refName == null) {
            return false;
        }
        TextRange textRange = refName.getTextRange();
        if (textRange == null || offset < textRange.getStartOffset() || offset > textRange.getEndOffset()) {
            return false;
        }
        return !CreateFromUsageUtils.isValidReference((PsiReference)this.myRefExpr, this.myUnresolvedOnly);
    }

    @NotNull
    private LookupElement[] collectItems() {
        boolean qualified;
        LinkedHashSet<LookupElementBuilder> items = new LinkedHashSet<LookupElementBuilder>();
        boolean bl = qualified = this.myRefExpr.getQualifierExpression() != null;
        if (!qualified && !(this.myRefExpr.getParent() instanceof PsiMethodCallExpression)) {
            PsiVariable[] vars;
            for (PsiVariable var : vars = CreateFromUsageUtils.guessMatchingVariables((PsiExpression)this.myRefExpr)) {
                items.add(LookupElementBuilder.create((String)var.getName()));
            }
        } else {
            PsiElement[] variants;
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                items.add(LookupElementBuilder.create((String)this.myRefExpr.getReferenceName()));
            }
            class MyScopeProcessor
            implements PsiScopeProcessor {
                ArrayList<PsiElement> myResult = new ArrayList();
                boolean myFilterMethods;
                boolean myFilterStatics;

                MyScopeProcessor(PsiReferenceExpression refExpression) {
                    this.myFilterMethods = refExpression.getParent() instanceof PsiMethodCallExpression;
                    PsiExpression qualifier = refExpression.getQualifierExpression();
                    if (qualifier instanceof PsiReferenceExpression) {
                        PsiElement e = ((PsiReferenceExpression)qualifier).resolve();
                        this.myFilterStatics = e instanceof PsiClass;
                    } else if (qualifier == null) {
                        PsiModifierListOwner scope = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)refExpression, PsiModifierListOwner.class);
                        this.myFilterStatics = scope != null && scope.hasModifierProperty("static");
                    }
                }

                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                    if (element == null) {
                        MyScopeProcessor.$$$reportNull$$$0(0);
                    }
                    if (state == null) {
                        MyScopeProcessor.$$$reportNull$$$0(1);
                    }
                    if (element instanceof PsiNamedElement && element instanceof PsiModifierListOwner && this.myFilterMethods == element instanceof PsiMethod && ((PsiModifierListOwner)element).hasModifierProperty("static") == this.myFilterStatics) {
                        this.myResult.add(element);
                    }
                    return true;
                }

                public PsiElement[] getVariants() {
                    return PsiUtilCore.toPsiElementArray(this.myResult);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "state";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/codeInsight/daemon/impl/quickfix/RenameWrongRefFix$1MyScopeProcessor";
                    objectArray[2] = "execute";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }
            MyScopeProcessor processor = new MyScopeProcessor(this.myRefExpr);
            this.myRefExpr.processVariants((PsiScopeProcessor)processor);
            for (PsiElement variant : variants = processor.getVariants()) {
                items.add(LookupElementBuilder.create((String)((PsiNamedElement)variant).getName()));
            }
        }
        LookupElement[] lookupElementArray = items.toArray(new LookupElement[items.size()]);
        if (lookupElementArray == null) {
            RenameWrongRefFix.$$$reportNull$$$0(5);
        }
        return lookupElementArray;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            RenameWrongRefFix.$$$reportNull$$$0(6);
        }
        PsiReferenceExpression[] refs = CreateFromUsageUtils.collectExpressions((PsiExpression)this.myRefExpr, PsiMember.class, PsiFile.class);
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)this.myRefExpr, (Class[])new Class[]{PsiMember.class, PsiFile.class});
        LookupElement[] items = this.collectItems();
        ReferenceNameExpression refExpr = new ReferenceNameExpression(items, this.myRefExpr.getReferenceName());
        TemplateBuilderImpl builder = new TemplateBuilderImpl(element);
        for (PsiReferenceExpression expr : refs) {
            if (!expr.equals(this.myRefExpr)) {
                builder.replaceElement(expr.getReferenceNameElement(), OTHER_VARIABLE_NAME, INPUT_VARIABLE_NAME, false);
                continue;
            }
            builder.replaceElement(expr.getReferenceNameElement(), INPUT_VARIABLE_NAME, (Expression)refExpr, true);
        }
        float proportion = EditorUtil.calcVerticalScrollProportion((Editor)editor);
        editor.getCaretModel().moveToOffset(element.getTextRange().getStartOffset());
        Template template = builder.buildInlineTemplate();
        editor.getCaretModel().moveToOffset(element.getTextRange().getStartOffset());
        TemplateManager.getInstance((Project)project).startTemplate(editor, template);
        EditorUtil.setVerticalScrollProportion((Editor)editor, (float)proportion);
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/RenameWrongRefFix";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/RenameWrongRefFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

