/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.codeInsight.folding.impl.ClosureFolding;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.NamedFoldingDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.text.CharArrayUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaFoldingBuilderBase
extends CustomFoldingBuilder
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.folding.impl.JavaFoldingBuilder");

    private static String getPlaceholderText(@NotNull PsiElement element) {
        if (element == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiImportList) {
            return "...";
        }
        if (element instanceof PsiMethod) {
            return JavaFoldingBuilderBase.getCodeBlockPlaceholder((PsiElement)((PsiMethod)element).getBody());
        }
        if (element instanceof PsiClassInitializer) {
            return JavaFoldingBuilderBase.getCodeBlockPlaceholder((PsiElement)((PsiClassInitializer)element).getBody());
        }
        if (element instanceof PsiClass || element instanceof PsiJavaModule) {
            return JavaFoldingBuilderBase.getCodeBlockPlaceholder(null);
        }
        if (element instanceof PsiLambdaExpression) {
            return JavaFoldingBuilderBase.getCodeBlockPlaceholder(((PsiLambdaExpression)element).getBody());
        }
        if (element instanceof PsiDocComment) {
            return "/**...*/";
        }
        if (element instanceof PsiFile) {
            return "/.../";
        }
        if (element instanceof PsiAnnotation) {
            return "@{...}";
        }
        if (element instanceof PsiReferenceParameterList) {
            return "<~>";
        }
        if (element instanceof PsiComment) {
            return "//...";
        }
        return "...";
    }

    private static String getCodeBlockPlaceholder(PsiElement codeBlock) {
        return codeBlock instanceof PsiCodeBlock && ((PsiCodeBlock)codeBlock).getStatements().length == 0 ? "{}" : "{...}";
    }

    private static boolean areOnAdjacentLines(@NotNull PsiElement e1, @NotNull PsiElement e2, @NotNull Document document) {
        if (e1 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(1);
        }
        if (e2 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(2);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(3);
        }
        return document.getLineNumber(e1.getTextRange().getEndOffset()) + 1 == document.getLineNumber(e2.getTextRange().getStartOffset());
    }

    private static boolean isSimplePropertyAccessor(@NotNull PsiMethod method) {
        PsiExpression expr;
        if (method == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(4);
        }
        if (DumbService.isDumb((Project)method.getProject())) {
            return false;
        }
        PsiCodeBlock body2 = method.getBody();
        if (body2 == null || body2.getLBrace() == null || body2.getRBrace() == null) {
            return false;
        }
        PsiStatement[] statements = body2.getStatements();
        if (statements.length == 0) {
            return false;
        }
        PsiStatement statement = statements[0];
        if (PropertyUtilBase.isSimplePropertyGetter((PsiMethod)method)) {
            if (statement instanceof PsiReturnStatement) {
                return ((PsiReturnStatement)statement).getReturnValue() instanceof PsiReferenceExpression;
            }
            return false;
        }
        if (statements.length > 1 && !(statements[1] instanceof PsiReturnStatement)) {
            return false;
        }
        if (statement instanceof PsiExpressionStatement && (expr = ((PsiExpressionStatement)statement).getExpression()) instanceof PsiAssignmentExpression) {
            PsiExpression lhs = ((PsiAssignmentExpression)expr).getLExpression();
            PsiExpression rhs = ((PsiAssignmentExpression)expr).getRExpression();
            return lhs instanceof PsiReferenceExpression && rhs instanceof PsiReferenceExpression && !((PsiReferenceExpression)rhs).isQualified() && PropertyUtilBase.isSimplePropertySetter((PsiMethod)method);
        }
        return false;
    }

    @Nullable
    private static TextRange getRangeToFold(@NotNull PsiElement element) {
        PsiElement body2;
        if (element == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(5);
        }
        if (element instanceof SyntheticElement) {
            return null;
        }
        if (element instanceof PsiMethod) {
            PsiCodeBlock body3 = ((PsiMethod)element).getBody();
            if (body3 == null) {
                return null;
            }
            return body3.getTextRange();
        }
        if (element instanceof PsiClassInitializer) {
            return ((PsiClassInitializer)element).getBody().getTextRange();
        }
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            PsiElement lBrace = aClass.getLBrace();
            if (lBrace == null) {
                return null;
            }
            PsiElement rBrace = aClass.getRBrace();
            if (rBrace == null) {
                return null;
            }
            return new TextRange(lBrace.getTextOffset(), rBrace.getTextOffset() + 1);
        }
        if (element instanceof PsiJavaModule) {
            PsiElement left = (PsiElement)SyntaxTraverser.psiTraverser().children((Object)element).find(e -> PsiUtil.isJavaToken((PsiElement)e, (IElementType)JavaTokenType.LBRACE));
            PsiElement right = (PsiElement)SyntaxTraverser.psiTraverser().children((Object)element).find(e -> PsiUtil.isJavaToken((PsiElement)e, (IElementType)JavaTokenType.RBRACE));
            return left != null && right != null ? new TextRange(left.getTextOffset(), right.getTextOffset() + 1) : null;
        }
        if (element instanceof PsiJavaFile) {
            return JavaFoldingBuilderBase.getFileHeader((PsiJavaFile)element);
        }
        if (element instanceof PsiImportList) {
            PsiImportList list = (PsiImportList)element;
            PsiImportStatementBase[] statements = list.getAllImportStatements();
            if (statements.length == 0) {
                return null;
            }
            PsiElement importKeyword = statements[0].getFirstChild();
            if (importKeyword == null) {
                return null;
            }
            int startOffset = importKeyword.getTextRange().getEndOffset() + 1;
            int endOffset = statements[statements.length - 1].getTextRange().getEndOffset();
            if (!JavaFoldingBuilderBase.hasErrorElementsNearby(element.getContainingFile(), startOffset, endOffset)) {
                return new TextRange(startOffset, endOffset);
            }
        }
        if (element instanceof PsiDocComment) {
            return element.getTextRange();
        }
        if (element instanceof PsiAnnotation) {
            int startOffset = element.getTextRange().getStartOffset();
            PsiElement last = element;
            while (element instanceof PsiAnnotation) {
                last = element;
                element = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element);
            }
            return new TextRange(startOffset, last.getTextRange().getEndOffset());
        }
        if (element instanceof PsiLambdaExpression && (body2 = ((PsiLambdaExpression)element).getBody()) instanceof PsiCodeBlock) {
            return body2.getTextRange();
        }
        return null;
    }

    public static boolean hasErrorElementsNearby(@NotNull PsiFile file, int startOffset, int endOffset) {
        if (file == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(6);
        }
        endOffset = CharArrayUtil.shiftForward((CharSequence)file.getViewProvider().getContents(), (int)endOffset, (String)" \t\n");
        for (PsiElement element : CollectHighlightsUtil.getElementsInRange((PsiElement)file, (int)startOffset, (int)endOffset)) {
            if (!(element instanceof PsiErrorElement)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static TextRange getFileHeader(@NotNull PsiJavaFile file) {
        PsiElement first;
        if (file == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(7);
        }
        if ((first = file.getFirstChild()) instanceof PsiWhiteSpace) {
            first = first.getNextSibling();
        }
        PsiElement element = first;
        while (element instanceof PsiComment && (element = element.getNextSibling()) instanceof PsiWhiteSpace) {
            element = element.getNextSibling();
        }
        if (element == null) {
            return null;
        }
        PsiElement prevSibling = element.getPrevSibling();
        if (prevSibling instanceof PsiWhiteSpace) {
            element = prevSibling;
        }
        if (element.equals(first)) {
            return null;
        }
        return new UnfairTextRange(first.getTextOffset(), element.getTextOffset());
    }

    private static void addAnnotationsToFold(@Nullable PsiModifierList modifierList, @NotNull List<FoldingDescriptor> foldElements, @NotNull Document document) {
        if (foldElements == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(8);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(9);
        }
        if (modifierList == null) {
            return;
        }
        PsiElement[] children = modifierList.getChildren();
        for (int i = 0; i < children.length; ++i) {
            PsiElement nextChild;
            int j;
            PsiElement child = children[i];
            if (!(child instanceof PsiAnnotation)) continue;
            JavaFoldingBuilderBase.addToFold(foldElements, child, document, false);
            for (j = i + 1; j < children.length && !((nextChild = children[j]) instanceof PsiModifier); ++j) {
            }
            i = j;
        }
    }

    private static void addCommentFolds(@NotNull PsiComment comment, @NotNull Set<PsiElement> processedComments, @NotNull List<FoldingDescriptor> foldElements) {
        ASTNode node;
        if (comment == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(10);
        }
        if (processedComments == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(11);
        }
        if (foldElements == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(12);
        }
        if (processedComments.contains(comment) || comment.getTokenType() != JavaTokenType.END_OF_LINE_COMMENT || JavaFoldingBuilderBase.isCustomRegionElement((PsiElement)comment)) {
            return;
        }
        processedComments.add((PsiElement)comment);
        PsiElement end = null;
        for (PsiElement current = comment.getNextSibling(); current != null && (node = current.getNode()) != null; current = current.getNextSibling()) {
            IElementType elementType = node.getElementType();
            if (elementType == JavaTokenType.END_OF_LINE_COMMENT && !JavaFoldingBuilderBase.isCustomRegionElement((PsiElement)current) && !processedComments.contains(current)) {
                end = current;
                processedComments.add(current);
                continue;
            }
            if (elementType != TokenType.WHITE_SPACE) break;
        }
        if (end != null) {
            foldElements.add(new FoldingDescriptor((PsiElement)comment, new TextRange(comment.getTextRange().getStartOffset(), end.getTextRange().getEndOffset())));
        }
    }

    private static void addMethodGenericParametersFolding(@NotNull PsiMethodCallExpression expression2, @NotNull List<FoldingDescriptor> foldElements, @NotNull Document document, boolean quick) {
        PsiReferenceExpression methodExpression;
        PsiReferenceParameterList list;
        if (expression2 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(13);
        }
        if (foldElements == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(14);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(15);
        }
        if ((list = (methodExpression = expression2.getMethodExpression()).getParameterList()) == null || list.getTextLength() <= 5) {
            return;
        }
        PsiMethodCallExpression element = expression2;
        while (true) {
            if (!quick && !JavaFoldingBuilderBase.resolvesCorrectly(element.getMethodExpression())) {
                return;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiExpressionList) || !(parent.getParent() instanceof PsiMethodCallExpression)) break;
            element = (PsiMethodCallExpression)parent.getParent();
        }
        JavaFoldingBuilderBase.addTypeParametersFolding(foldElements, document, list, 3, quick);
    }

    private static boolean resolvesCorrectly(@NotNull PsiReferenceExpression expression2) {
        if (expression2 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(16);
        }
        for (JavaResolveResult result : expression2.multiResolve(true)) {
            if (result.isValidResult()) continue;
            return false;
        }
        return true;
    }

    private static void addGenericParametersFolding(@NotNull PsiNewExpression expression2, @NotNull List<FoldingDescriptor> foldElements, @NotNull Document document, boolean quick) {
        PsiReferenceParameterList list;
        PsiAnonymousClass anonymousClass;
        PsiElement parent;
        if (expression2 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(17);
        }
        if (foldElements == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(18);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(19);
        }
        if (!((parent = expression2.getParent()) instanceof PsiVariable)) {
            return;
        }
        PsiType declType = ((PsiVariable)parent).getType();
        if (!(declType instanceof PsiClassReferenceType)) {
            return;
        }
        Object[] parameters2 = ((PsiClassType)declType).getParameters();
        if (parameters2.length == 0) {
            return;
        }
        PsiJavaCodeReferenceElement classReference2 = expression2.getClassReference();
        if (classReference2 == null && (anonymousClass = expression2.getAnonymousClass()) != null) {
            classReference2 = anonymousClass.getBaseClassReference();
            if (quick || ClosureFolding.seemsLikeLambda(anonymousClass.getSuperClass(), (PsiElement)anonymousClass)) {
                return;
            }
        }
        if (classReference2 != null && (list = classReference2.getParameterList()) != null) {
            PsiJavaCodeReferenceElement declReference;
            PsiReferenceParameterList declList;
            if (quick ? (declList = (declReference = ((PsiClassReferenceType)declType).getReference()).getParameterList()) == null || !list.getText().equals(declList.getText()) : !Arrays.equals(list.getTypeArguments(), parameters2)) {
                return;
            }
            JavaFoldingBuilderBase.addTypeParametersFolding(foldElements, document, list, 5, quick);
        }
    }

    private static void addTypeParametersFolding(@NotNull List<FoldingDescriptor> foldElements, @NotNull Document document, @NotNull PsiReferenceParameterList list, int ifLongerThan, boolean quick) {
        String text2;
        if (foldElements == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(20);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(21);
        }
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(22);
        }
        if (!quick) {
            for (PsiType type2 : list.getTypeArguments()) {
                if (!type2.isValid()) {
                    return;
                }
                if (!(type2 instanceof PsiClassType) && !(type2 instanceof PsiArrayType) || PsiUtil.resolveClassInType((PsiType)type2) != null) continue;
                return;
            }
        }
        if ((text2 = list.getText()).startsWith("<") && text2.endsWith(">") && text2.length() > ifLongerThan) {
            TextRange range = list.getTextRange();
            JavaFoldingBuilderBase.addFoldRegion(foldElements, (PsiElement)list, document, true, range);
        }
    }

    protected abstract boolean shouldShowExplicitLambdaType(@NotNull PsiAnonymousClass var1, @NotNull PsiNewExpression var2);

    private static void addToFold(@NotNull List<FoldingDescriptor> list, @NotNull PsiElement elementToFold, @NotNull Document document, boolean allowOneLiners) {
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(23);
        }
        if (elementToFold == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(24);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(25);
        }
        PsiUtilCore.ensureValid((PsiElement)elementToFold);
        TextRange range = JavaFoldingBuilderBase.getRangeToFold(elementToFold);
        if (range != null) {
            JavaFoldingBuilderBase.addFoldRegion(list, elementToFold, document, allowOneLiners, range);
        }
    }

    private static void addFoldRegion(@NotNull List<FoldingDescriptor> list, @NotNull PsiElement elementToFold, @NotNull Document document, boolean allowOneLiners, @NotNull TextRange range) {
        TextRange fileRange;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(26);
        }
        if (elementToFold == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(27);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(28);
        }
        if (range == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(29);
        }
        if (range.equals((Object)(fileRange = elementToFold.getContainingFile().getTextRange()))) {
            return;
        }
        LOG.assertTrue(range.getStartOffset() >= 0 && range.getEndOffset() <= fileRange.getEndOffset());
        if (range.getStartOffset() < 0 || range.getEndOffset() > fileRange.getEndOffset()) {
            return;
        }
        if (!allowOneLiners) {
            int endLine;
            int startLine = document.getLineNumber(range.getStartOffset());
            if (startLine < (endLine = document.getLineNumber(range.getEndOffset() - 1)) && range.getLength() > 1) {
                list.add(new FoldingDescriptor(elementToFold, range));
            }
        } else if (range.getLength() > JavaFoldingBuilderBase.getPlaceholderText(elementToFold).length()) {
            list.add(new FoldingDescriptor(elementToFold, range));
        }
    }

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        FoldingDescriptor classes2;
        PsiJavaModule module;
        TextRange rangeToFold;
        PsiImportStatementBase[] statements;
        if (descriptors == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(30);
        }
        if (root == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(31);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(32);
        }
        if (!(root instanceof PsiJavaFile)) {
            return;
        }
        PsiJavaFile file = (PsiJavaFile)root;
        PsiImportList importList = file.getImportList();
        if (importList != null && (statements = importList.getAllImportStatements()).length > 1 && (rangeToFold = JavaFoldingBuilderBase.getRangeToFold((PsiElement)importList)) != null && rangeToFold.getLength() > 1) {
            FoldingDescriptor descriptor = new FoldingDescriptor((PsiElement)importList, rangeToFold);
            descriptor.setCanBeRemovedWhenCollapsed(true);
            descriptors.add(descriptor);
        }
        if ((module = file.getModuleDeclaration()) != null) {
            JavaFoldingBuilderBase.addElementsToFold(descriptors, module, document);
        }
        for (PsiClass aClass : classes2 = file.getClasses()) {
            ProgressManager.checkCanceled();
            ProgressIndicatorProvider.checkCanceled();
            this.addElementsToFold(descriptors, aClass, document, true, quick);
        }
        TextRange range = JavaFoldingBuilderBase.getFileHeader(file);
        if (range != null && range.getLength() > 1 && document.getLineNumber(range.getEndOffset()) > document.getLineNumber(range.getStartOffset())) {
            ASTNode node;
            PsiJavaFile anchorElementToUse = file;
            PsiElement candidate = file.getFirstChild();
            if (candidate != null && candidate.getTextRange().equals((Object)range) && (node = candidate.getNode()) != null && node.getElementType() == JavaDocElementType.DOC_COMMENT) {
                anchorElementToUse = candidate;
            }
            descriptors.add(new FoldingDescriptor((PsiElement)anchorElementToUse, range));
        }
    }

    private static void addElementsToFold(@NotNull List<FoldingDescriptor> list, @NotNull PsiJavaModule module, @NotNull Document document) {
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(33);
        }
        if (module == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(34);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(35);
        }
        JavaFoldingBuilderBase.addToFold(list, (PsiElement)module, document, true);
        JavaFoldingBuilderBase.addDocCommentToFold(list, document, (PsiJavaDocumentedElement)module);
        JavaFoldingBuilderBase.addAnnotationsToFold(module.getModifierList(), list, document);
    }

    private void addElementsToFold(@NotNull List<FoldingDescriptor> list, @NotNull PsiClass aClass, @NotNull Document document, boolean foldJavaDocs, boolean quick) {
        PsiElement parent;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(36);
        }
        if (aClass == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(37);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(38);
        }
        if (!((parent = aClass.getParent()) instanceof PsiJavaFile) || ((PsiJavaFile)parent).getClasses().length > 1) {
            JavaFoldingBuilderBase.addToFold(list, (PsiElement)aClass, document, true);
        }
        if (foldJavaDocs) {
            JavaFoldingBuilderBase.addDocCommentToFold(list, document, (PsiJavaDocumentedElement)aClass);
        }
        JavaFoldingBuilderBase.addAnnotationsToFold(aClass.getModifierList(), list, document);
        HashSet<PsiElement> processedComments = new HashSet<PsiElement>();
        for (PsiElement child = aClass.getFirstChild(); child != null; child = child.getNextSibling()) {
            ProgressIndicatorProvider.checkCanceled();
            if (child instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)child;
                boolean oneLiner = this.addOneLineMethodFolding(list, method);
                if (!oneLiner) {
                    JavaFoldingBuilderBase.addToFold(list, (PsiElement)method, document, true);
                }
                JavaFoldingBuilderBase.addAnnotationsToFold(method.getModifierList(), list, document);
                if (foldJavaDocs) {
                    JavaFoldingBuilderBase.addDocCommentToFold(list, document, (PsiJavaDocumentedElement)method);
                }
                for (PsiParameter parameter2 : method.getParameterList().getParameters()) {
                    JavaFoldingBuilderBase.addAnnotationsToFold(parameter2.getModifierList(), list, document);
                }
                PsiCodeBlock body2 = method.getBody();
                if (body2 == null || oneLiner) continue;
                this.addCodeBlockFolds((PsiElement)body2, list, processedComments, document, quick);
                continue;
            }
            if (child instanceof PsiField) {
                PsiField field = (PsiField)child;
                if (foldJavaDocs) {
                    JavaFoldingBuilderBase.addDocCommentToFold(list, document, (PsiJavaDocumentedElement)field);
                }
                JavaFoldingBuilderBase.addAnnotationsToFold(field.getModifierList(), list, document);
                PsiExpression initializer = field.getInitializer();
                if (initializer != null) {
                    this.addCodeBlockFolds((PsiElement)initializer, list, processedComments, document, quick);
                    continue;
                }
                if (!(field instanceof PsiEnumConstant)) continue;
                this.addCodeBlockFolds((PsiElement)field, list, processedComments, document, quick);
                continue;
            }
            if (child instanceof PsiClassInitializer) {
                JavaFoldingBuilderBase.addToFold(list, child, document, true);
                this.addCodeBlockFolds(child, list, processedComments, document, quick);
                continue;
            }
            if (child instanceof PsiClass) {
                this.addElementsToFold(list, (PsiClass)child, document, true, quick);
                continue;
            }
            if (!(child instanceof PsiComment)) continue;
            JavaFoldingBuilderBase.addCommentFolds((PsiComment)child, processedComments, list);
        }
    }

    private static void addDocCommentToFold(@NotNull List<FoldingDescriptor> list, @NotNull Document document, @NotNull PsiJavaDocumentedElement element) {
        PsiDocComment docComment;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(39);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(40);
        }
        if (element == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(41);
        }
        if ((docComment = element.getDocComment()) != null) {
            JavaFoldingBuilderBase.addToFold(list, (PsiElement)docComment, document, true);
        }
    }

    private boolean addOneLineMethodFolding(@NotNull List<FoldingDescriptor> descriptorList, @NotNull PsiMethod method) {
        if (descriptorList == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(42);
        }
        if (method == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(43);
        }
        if (!JavaCodeFoldingSettings.getInstance().isCollapseOneLineMethods()) {
            return false;
        }
        Document document = method.getContainingFile().getViewProvider().getDocument();
        PsiCodeBlock body2 = method.getBody();
        PsiIdentifier nameIdentifier = method.getNameIdentifier();
        if (body2 == null || document == null || nameIdentifier == null) {
            return false;
        }
        if (document.getLineNumber(nameIdentifier.getTextRange().getStartOffset()) != document.getLineNumber(method.getParameterList().getTextRange().getEndOffset())) {
            return false;
        }
        PsiJavaToken lBrace = body2.getLBrace();
        PsiJavaToken rBrace = body2.getRBrace();
        PsiStatement[] statements = body2.getStatements();
        if (lBrace == null || rBrace == null || statements.length != 1) {
            return false;
        }
        PsiStatement statement = statements[0];
        if (statement.textContains('\n')) {
            return false;
        }
        if (!JavaFoldingBuilderBase.areOnAdjacentLines((PsiElement)lBrace, (PsiElement)statement, document) || !JavaFoldingBuilderBase.areOnAdjacentLines((PsiElement)statement, (PsiElement)rBrace, document)) {
            return false;
        }
        int leftStart = method.getParameterList().getTextRange().getEndOffset();
        int bodyStart = body2.getTextRange().getStartOffset();
        if (bodyStart > leftStart && !StringUtil.isEmptyOrSpaces((CharSequence)document.getCharsSequence().subSequence(leftStart + 1, bodyStart))) {
            return false;
        }
        int leftEnd = statement.getTextRange().getStartOffset();
        int rightStart = statement.getTextRange().getEndOffset();
        int rightEnd = body2.getTextRange().getEndOffset();
        if (leftEnd <= leftStart + 1 || rightEnd <= rightStart + 1) {
            return false;
        }
        String leftText = " { ";
        String rightText = " }";
        if (!this.fitsRightMargin((PsiElement)method, document, leftStart, rightEnd, rightStart - leftEnd + leftText.length() + rightText.length())) {
            return false;
        }
        FoldingGroup group = FoldingGroup.newGroup((String)"one-liner");
        descriptorList.add((FoldingDescriptor)new NamedFoldingDescriptor((PsiElement)lBrace, leftStart, leftEnd, group, leftText));
        descriptorList.add((FoldingDescriptor)new NamedFoldingDescriptor((PsiElement)rBrace, rightStart, rightEnd, group, rightText));
        return true;
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(44);
        }
        if (range == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(45);
        }
        return JavaFoldingBuilderBase.getPlaceholderText(SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)node));
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(46);
        }
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)node);
        JavaCodeFoldingSettings settings = JavaCodeFoldingSettings.getInstance();
        if (element instanceof PsiNewExpression || element instanceof PsiJavaToken && element.getParent() instanceof PsiAnonymousClass) {
            return settings.isCollapseLambdas();
        }
        if (element instanceof PsiJavaToken && element.getParent() instanceof PsiCodeBlock && element.getParent().getParent() instanceof PsiMethod) {
            return settings.isCollapseOneLineMethods();
        }
        if (element instanceof PsiReferenceParameterList) {
            return settings.isCollapseConstructorGenericParameters();
        }
        if (element instanceof PsiImportList) {
            return settings.isCollapseImports();
        }
        if (element instanceof PsiMethod || element instanceof PsiClassInitializer || element instanceof PsiCodeBlock) {
            if (element instanceof PsiMethod) {
                if (!settings.isCollapseAccessors() && !settings.isCollapseMethods()) {
                    return false;
                }
                if (JavaFoldingBuilderBase.isSimplePropertyAccessor((PsiMethod)element)) {
                    return settings.isCollapseAccessors();
                }
            }
            return settings.isCollapseMethods();
        }
        if (element instanceof PsiAnonymousClass) {
            return settings.isCollapseAnonymousClasses();
        }
        if (element instanceof PsiClass) {
            return !(element.getParent() instanceof PsiFile) && settings.isCollapseInnerClasses();
        }
        if (element instanceof PsiDocComment) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiJavaFile) {
                if (((PsiJavaFile)parent).getName().equals("package-info.java")) {
                    return false;
                }
                PsiElement firstChild = parent.getFirstChild();
                if (firstChild instanceof PsiWhiteSpace) {
                    firstChild = firstChild.getNextSibling();
                }
                if (element.equals(firstChild)) {
                    return settings.isCollapseFileHeader();
                }
            }
            return settings.isCollapseJavadocs();
        }
        if (element instanceof PsiJavaFile) {
            return settings.isCollapseFileHeader();
        }
        if (element instanceof PsiAnnotation) {
            return settings.isCollapseAnnotations();
        }
        if (element instanceof PsiComment) {
            return settings.isCollapseEndOfLineComments();
        }
        if (element instanceof PsiLambdaExpression) {
            return settings.isCollapseAnonymousClasses();
        }
        if (element instanceof PsiJavaModule) {
            return false;
        }
        LOG.error("Unknown element:" + element);
        return false;
    }

    private void addCodeBlockFolds(@NotNull PsiElement scope, final @NotNull List<FoldingDescriptor> foldElements, final @NotNull Set<PsiElement> processedComments, final @NotNull Document document, final boolean quick) {
        if (scope == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(47);
        }
        if (foldElements == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(48);
        }
        if (processedComments == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(49);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(50);
        }
        final boolean dumb = DumbService.isDumb((Project)scope.getProject());
        scope.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitClass(PsiClass aClass) {
                if (dumb || !JavaFoldingBuilderBase.this.addClosureFolding(aClass, document, foldElements, processedComments, quick)) {
                    JavaFoldingBuilderBase.addToFold(foldElements, (PsiElement)aClass, document, true);
                    JavaFoldingBuilderBase.this.addElementsToFold(foldElements, aClass, document, false, quick);
                }
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                if (!dumb) {
                    JavaFoldingBuilderBase.addMethodGenericParametersFolding(expression2, foldElements, document, quick);
                }
                super.visitMethodCallExpression(expression2);
            }

            public void visitNewExpression(PsiNewExpression expression2) {
                if (!dumb) {
                    JavaFoldingBuilderBase.addGenericParametersFolding(expression2, foldElements, document, quick);
                }
                super.visitNewExpression(expression2);
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                PsiElement body2 = expression2.getBody();
                if (body2 instanceof PsiCodeBlock) {
                    JavaFoldingBuilderBase.addToFold(foldElements, (PsiElement)expression2, document, true);
                }
                super.visitLambdaExpression(expression2);
            }

            public void visitComment(PsiComment comment) {
                JavaFoldingBuilderBase.addCommentFolds(comment, processedComments, foldElements);
                super.visitComment(comment);
            }
        });
    }

    private boolean addClosureFolding(@NotNull PsiClass aClass, @NotNull Document document, @NotNull List<FoldingDescriptor> foldElements, @NotNull Set<PsiElement> processedComments, boolean quick) {
        if (aClass == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(51);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(52);
        }
        if (foldElements == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(53);
        }
        if (processedComments == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(54);
        }
        if (!JavaCodeFoldingSettings.getInstance().isCollapseLambdas()) {
            return false;
        }
        if (aClass instanceof PsiAnonymousClass) {
            List<NamedFoldingDescriptor> descriptors;
            PsiAnonymousClass anonymousClass = (PsiAnonymousClass)aClass;
            ClosureFolding closureFolding = ClosureFolding.prepare(anonymousClass, quick, this);
            List<NamedFoldingDescriptor> list = descriptors = closureFolding == null ? null : closureFolding.process(document);
            if (descriptors != null) {
                foldElements.addAll(descriptors);
                this.addCodeBlockFolds((PsiElement)closureFolding.methodBody, foldElements, processedComments, document, quick);
                return true;
            }
        }
        return false;
    }

    @NotNull
    protected String rightArrow() {
        if ("->" == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(55);
        }
        return "->";
    }

    boolean fitsRightMargin(@NotNull PsiElement element, @NotNull Document document, int foldingStart, int foldingEnd, int collapsedLength) {
        if (element == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(56);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(57);
        }
        int beforeLength = foldingStart - document.getLineStartOffset(document.getLineNumber(foldingStart));
        int afterLength = document.getLineEndOffset(document.getLineNumber(foldingEnd)) - foldingEnd;
        return this.isBelowRightMargin(element.getProject(), beforeLength + collapsedLength + afterLength);
    }

    protected abstract boolean isBelowRightMargin(@NotNull Project var1, int var2);

    protected boolean isCustomFoldingCandidate(@NotNull ASTNode node) {
        if (node == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(58);
        }
        return node.getElementType() == JavaTokenType.END_OF_LINE_COMMENT;
    }

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        IElementType nodeType;
        if (node == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(59);
        }
        if ((nodeType = node.getElementType()) == JavaElementType.CLASS) {
            ASTNode parent = node.getTreeParent();
            return parent == null || parent.getElementType() != JavaElementType.CLASS;
        }
        return nodeType == JavaElementType.CODE_BLOCK;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 55: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 55: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e2";
                break;
            }
            case 3: 
            case 9: 
            case 15: 
            case 19: 
            case 21: 
            case 25: 
            case 28: 
            case 32: 
            case 35: 
            case 38: 
            case 40: 
            case 50: 
            case 52: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 12: 
            case 14: 
            case 18: 
            case 20: 
            case 48: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldElements";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 11: 
            case 49: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedComments";
                break;
            }
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 22: 
            case 23: 
            case 26: 
            case 33: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToFold";
                break;
            }
            case 29: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 37: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorList";
                break;
            }
            case 44: 
            case 46: 
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "rightArrow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "areOnAdjacentLines";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSimplePropertyAccessor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToFold";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasErrorElementsNearby";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileHeader";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotationsToFold";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addCommentFolds";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addMethodGenericParametersFolding";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolvesCorrectly";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addGenericParametersFolding";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addTypeParametersFolding";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addToFold";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addFoldRegion";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "buildLanguageFoldRegions";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addElementsToFold";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addDocCommentToFold";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addOneLineMethodFolding";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagePlaceholderText";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isRegionCollapsedByDefault";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "addCodeBlockFolds";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "addClosureFolding";
                break;
            }
            case 55: {
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "fitsRightMargin";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isCustomFoldingCandidate";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isCustomFoldingRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 55: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

