/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportHolder;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddSingleMemberStaticImportAction
extends BaseElementAtCaretIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.AddSingleMemberStaticImportAction");
    private static final Key<PsiElement> TEMP_REFERENT_USER_DATA = new Key("TEMP_REFERENT_USER_DATA");

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.add.single.member.static.import.family", (Object[])new Object[0]);
        if (string == null) {
            AddSingleMemberStaticImportAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static ImportAvailability getStaticImportClass(@NotNull PsiElement element) {
        JavaResolveResult[] results;
        if (element == null) {
            AddSingleMemberStaticImportAction.$$$reportNull$$$0(1);
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)element)) {
            return null;
        }
        if (!(element instanceof PsiIdentifier)) return null;
        PsiElement parent = element.getParent();
        if (parent instanceof PsiMethodReferenceExpression) {
            return null;
        }
        if (!(parent instanceof PsiJavaCodeReferenceElement) || ((PsiJavaCodeReferenceElement)parent).getQualifier() == null) return null;
        if (PsiTreeUtil.getParentOfType((PsiElement)parent, PsiImportList.class) != null) {
            return null;
        }
        PsiJavaCodeReferenceElement refExpr = (PsiJavaCodeReferenceElement)parent;
        if (AddSingleMemberStaticImportAction.checkParameterizedReference(refExpr)) {
            return null;
        }
        for (JavaResolveResult result : results = refExpr.multiResolve(false)) {
            String qName;
            PsiElement resolved = result.getElement();
            if ((!(resolved instanceof PsiMember) || !((PsiModifierListOwner)resolved).hasModifierProperty("static")) && !(resolved instanceof PsiClass)) continue;
            PsiClass aClass = AddSingleMemberStaticImportAction.getResolvedClass(element, (PsiMember)resolved);
            String string = qName = aClass != null ? aClass.getQualifiedName() : null;
            if (aClass == null || qName == null || PsiTreeUtil.isAncestor((PsiElement)aClass, (PsiElement)element, (boolean)true) || aClass.hasModifierProperty("private") || PsiUtil.isFromDefaultPackage((PsiClass)aClass)) continue;
            PsiElement gParent = refExpr.getParent();
            if (gParent instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)gParent.copy();
                PsiElement qualifier = call.getMethodExpression().getQualifier();
                if (qualifier == null) {
                    return null;
                }
                qualifier.delete();
                JavaResolveResult resolveResult = call.resolveMethodGenerics();
                PsiElement method = resolveResult.getElement();
                if (method instanceof PsiMethod) {
                    if (((PsiMethod)method).getContainingClass() == aClass) return new ImportAvailability(qName + "." + refExpr.getReferenceName(), (PsiMember)resolved);
                    PsiElement currentFileResolveScope = resolveResult.getCurrentFileResolveScope();
                    if (!(currentFileResolveScope instanceof PsiImportStaticStatement)) return null;
                    if (!MethodSignatureUtil.areSignaturesEqual((PsiMethod)((PsiMethod)method), (PsiMethod)((PsiMethod)resolved))) return new ImportAvailability(qName + "." + refExpr.getReferenceName(), (PsiMember)resolved);
                    return null;
                }
                if (method != null || call.getMethodExpression().multiResolve(false).length <= 0) return new ImportAvailability(qName + "." + refExpr.getReferenceName(), (PsiMember)resolved);
                return null;
            }
            PsiElement refNameElement = refExpr.getReferenceNameElement();
            if (refNameElement == null) {
                return null;
            }
            PsiJavaCodeReferenceElement copy = JavaPsiFacade.getElementFactory((Project)refNameElement.getProject()).createReferenceFromText(refNameElement.getText(), (PsiElement)refExpr);
            PsiElement target = copy.resolve();
            if (target == null || PsiTreeUtil.getParentOfType((PsiElement)target, PsiClass.class) == aClass) return new ImportAvailability(qName + "." + refExpr.getReferenceName(), (PsiMember)resolved);
            return null;
        }
        return null;
    }

    private static PsiImportStatementBase findExistingImport(PsiFile file, PsiClass aClass, String refName) {
        PsiImportList importList;
        if (file instanceof PsiJavaFile && (importList = ((PsiJavaFile)file).getImportList()) != null) {
            for (PsiImportStaticStatement staticStatement : importList.getImportStaticStatements()) {
                if (!staticStatement.isOnDemand() || staticStatement.resolveTargetClass() != aClass) continue;
                return staticStatement;
            }
            PsiImportStatementBase importStatement = importList.findSingleImportStatement(refName);
            if (importStatement instanceof PsiImportStaticStatement && ((PsiImportStaticStatement)importStatement).resolveTargetClass() == aClass) {
                return importStatement;
            }
        }
        return null;
    }

    private static boolean checkParameterizedReference(PsiJavaCodeReferenceElement refExpr) {
        PsiReferenceParameterList parameterList = refExpr instanceof PsiReferenceExpression ? refExpr.getParameterList() : null;
        return parameterList != null && parameterList.getFirstChild() != null;
    }

    @Nullable
    private static PsiClass getResolvedClass(PsiElement element, PsiMember resolved) {
        PsiElement qResolved;
        PsiElement qualifier;
        PsiClass aClass = resolved.getContainingClass();
        if (aClass != null && !PsiUtil.isAccessible((Project)aClass.getProject(), (PsiMember)aClass, (PsiElement)element, null) && (qualifier = ((PsiJavaCodeReferenceElement)element.getParent()).getQualifier()) instanceof PsiReferenceExpression && (qResolved = ((PsiReferenceExpression)qualifier).resolve()) instanceof PsiVariable) {
            aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)((PsiVariable)qResolved).getType());
        }
        return aClass;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        ImportAvailability availability;
        if (project == null) {
            AddSingleMemberStaticImportAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            AddSingleMemberStaticImportAction.$$$reportNull$$$0(3);
        }
        if ((availability = AddSingleMemberStaticImportAction.getStaticImportClass(element)) != null) {
            if (availability.resolved instanceof PsiClass) {
                this.setText(CodeInsightBundle.message((String)"intention.add.single.member.import.text", (Object[])new Object[]{availability.qName}));
            } else {
                PsiFile file = element.getContainingFile();
                if (!(file instanceof PsiJavaFile)) {
                    return false;
                }
                PsiImportStatementBase existingImport = AddSingleMemberStaticImportAction.findExistingImport(file, availability.resolved.getContainingClass(), StringUtil.getShortName((String)availability.qName));
                if (existingImport != null && !existingImport.isOnDemand()) {
                    this.setText(CodeInsightBundle.message((String)"intention.use.single.member.static.import.text", (Object[])new Object[]{availability.qName}));
                } else {
                    this.setText(CodeInsightBundle.message((String)"intention.add.single.member.static.import.text", (Object[])new Object[]{availability.qName}));
                }
            }
        }
        return availability != null;
    }

    public static void invoke(PsiFile file, PsiElement element) {
        JavaResolveResult[] targets;
        PsiJavaCodeReferenceElement refExpr = (PsiJavaCodeReferenceElement)element.getParent();
        String referenceName = refExpr.getReferenceName();
        for (JavaResolveResult target : targets = refExpr.multiResolve(false)) {
            PsiElement resolved = target.getElement();
            if (resolved == null) continue;
            AddSingleMemberStaticImportAction.bindAllClassRefs(file, resolved, referenceName, AddSingleMemberStaticImportAction.getResolvedClass(element, (PsiMember)resolved));
            return;
        }
    }

    public static void bindAllClassRefs(PsiFile file, @NotNull PsiElement resolved, final String referenceName, final PsiClass resolvedClass) {
        if (resolved == null) {
            AddSingleMemberStaticImportAction.$$$reportNull$$$0(4);
        }
        file.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                PsiElement resolved;
                super.visitReferenceElement(reference);
                if (referenceName != null && referenceName.equals(reference.getReferenceName()) && (resolved = reference.resolve()) != null) {
                    reference.putUserData(TEMP_REFERENT_USER_DATA, (Object)resolved);
                }
            }
        });
        PsiImportStatementBase existingImport = AddSingleMemberStaticImportAction.findExistingImport(file, resolvedClass, referenceName);
        if (existingImport == null && resolved instanceof PsiClass) {
            ((PsiImportHolder)file).importClass((PsiClass)resolved);
        } else if (existingImport == null || existingImport.isOnDemand() && resolvedClass != null && ImportHelper.hasConflictingOnDemandImport((PsiJavaFile)file, resolvedClass, referenceName)) {
            PsiReferenceExpressionImpl.bindToElementViaStaticImport(resolvedClass, referenceName, ((PsiJavaFile)file).getImportList());
        }
        file.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitImportList(PsiImportList list) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                block17: {
                    try {
                        if (AddSingleMemberStaticImportAction.checkParameterizedReference(reference)) {
                            return;
                        }
                        if (!referenceName.equals(reference.getReferenceName()) || reference instanceof PsiMethodReferenceExpression) break block17;
                        PsiElement qualifierExpression2 = reference.getQualifier();
                        PsiElement referent = (PsiElement)reference.getUserData(TEMP_REFERENT_USER_DATA);
                        if (!reference.isQualified()) {
                            if (referent instanceof PsiMember && referent != reference.resolve()) {
                                try {
                                    PsiClass containingClass = ((PsiMember)referent).getContainingClass();
                                    if (containingClass != null) {
                                        reference = AddSingleMemberStaticImportAction.rebind(reference, containingClass);
                                    }
                                }
                                catch (IncorrectOperationException e) {
                                    LOG.error((Throwable)e);
                                }
                            }
                        } else if ((referent == null || referent instanceof PsiClass || referent instanceof PsiMember && ((PsiMember)referent).hasModifierProperty("static")) && qualifierExpression2 instanceof PsiJavaCodeReferenceElement) {
                            PsiElement aClass = ((PsiJavaCodeReferenceElement)qualifierExpression2).resolve();
                            if (aClass instanceof PsiVariable) {
                                aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)((PsiVariable)aClass).getType());
                            }
                            if (aClass instanceof PsiClass && InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClass)aClass), (PsiClass)resolvedClass, (boolean)true)) {
                                try {
                                    qualifierExpression2.delete();
                                }
                                catch (IncorrectOperationException e) {
                                    LOG.error((Throwable)e);
                                }
                                if (!Comparing.equal((Object)reference.resolve(), (Object)referent)) {
                                    reference = AddSingleMemberStaticImportAction.rebind(reference, resolvedClass);
                                }
                            }
                        }
                        reference.putUserData(TEMP_REFERENT_USER_DATA, null);
                    }
                    finally {
                        super.visitReferenceElement(reference);
                    }
                }
            }
        });
    }

    private static PsiJavaCodeReferenceElement rebind(PsiJavaCodeReferenceElement reference, PsiClass targetClass) {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)reference.getProject()).getElementFactory();
        PsiReferenceExpression copy = (PsiReferenceExpression)factory.createExpressionFromText("A." + reference.getReferenceName(), null);
        reference = (PsiReferenceExpression)reference.replace((PsiElement)copy);
        ((PsiReferenceExpression)reference.getQualifier()).bindToElement((PsiElement)targetClass);
        return reference;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            AddSingleMemberStaticImportAction.$$$reportNull$$$0(5);
        }
        if (element == null) {
            AddSingleMemberStaticImportAction.$$$reportNull$$$0(6);
        }
        AddSingleMemberStaticImportAction.invoke(element.getContainingFile(), element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/AddSingleMemberStaticImportAction";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/AddSingleMemberStaticImportAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStaticImportClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindAllClassRefs";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ImportAvailability {
        private final String qName;
        private final PsiMember resolved;

        private ImportAvailability(String qName, PsiMember resolved) {
            this.qName = qName;
            this.resolved = resolved;
        }
    }
}

