/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ComposeFunctionChainAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)ComposeFunctionChainAction.class.getName());

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiMethodCallExpression call;
        if (project == null) {
            ComposeFunctionChainAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            ComposeFunctionChainAction.$$$reportNull$$$0(1);
        }
        if ((call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class, (boolean)false, (Class[])new Class[]{PsiStatement.class, PsiLambdaExpression.class})) == null) {
            return false;
        }
        if (!"apply".equals(call.getMethodExpression().getReferenceName())) {
            return false;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        if (!"java.util.function.Function".equals(aClass.getQualifiedName()) && !"java.util.function.BiFunction".equals(aClass.getQualifiedName())) {
            return false;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent());
        if (!(parent instanceof PsiExpressionList) || ((PsiExpressionList)parent).getExpressions().length != 1) {
            return false;
        }
        PsiElement gParent = parent.getParent();
        if (!(gParent instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethod outerMethod = ((PsiMethodCallExpression)gParent).resolveMethod();
        return outerMethod != null && Arrays.stream(outerMethod.getThrowsList().getReferencedTypes()).allMatch(ExceptionUtil::isUncheckedException);
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"intention.compose.function.text", (Object[])new Object[0]);
        if (string == null) {
            ComposeFunctionChainAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.compose.function.family", (Object[])new Object[0]);
        if (string == null) {
            ComposeFunctionChainAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiMethodCallExpression call;
        if (project == null) {
            ComposeFunctionChainAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            ComposeFunctionChainAction.$$$reportNull$$$0(5);
        }
        if ((call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class, (boolean)false, (Class[])new Class[]{PsiStatement.class, PsiLambdaExpression.class})) == null) {
            return;
        }
        PsiElement outer = call.getParent().getParent();
        if (!(outer instanceof PsiMethodCallExpression)) {
            return;
        }
        PsiMethodCallExpression outerCall = (PsiMethodCallExpression)outer;
        PsiMethod outerMethod = outerCall.resolveMethod();
        if (outerMethod == null) {
            return;
        }
        PsiClass outerClass = outerMethod.getContainingClass();
        if (outerClass == null) {
            return;
        }
        String outerClassName = outerClass.getQualifiedName();
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        PsiExpression outerQualifier = outerCall.getMethodExpression().getQualifierExpression();
        CommentTracker ct = new CommentTracker();
        String reference = outerMethod.getName().equals("apply") && "java.util.function.Function".equals(outerClassName) ? (outerQualifier == null ? "this" : ct.text((PsiElement)outerQualifier)) : (outerMethod.hasModifierProperty("static") ? outerClassName + "::" + outerMethod.getName() : (outerQualifier == null ? "this" : ct.text((PsiElement)outerQualifier) + "::" + outerMethod.getName()));
        String resultQualifier = qualifier != null ? ct.text((PsiElement)qualifier) + "." : "";
        String replacement = resultQualifier + "andThen(" + reference + ").apply" + ct.text((PsiElement)call.getArgumentList());
        PsiElement result = ct.replaceAndRestoreComments(outer, replacement);
        result = CodeStyleManager.getInstance((Project)project).reformat(result);
        PsiElement applyElement = ((PsiMethodCallExpression)result).getMethodExpression().getReferenceNameElement();
        if (applyElement != null) {
            editor.getCaretModel().moveToOffset(applyElement.getTextOffset() + applyElement.getTextLength());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/ComposeFunctionChainAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/ComposeFunctionChainAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

