/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SurroundAutoCloseableAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            SurroundAutoCloseableAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            SurroundAutoCloseableAction.$$$reportNull$$$0(1);
        }
        return element.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) && PsiUtil.getLanguageLevel((PsiElement)element).isAtLeast(LanguageLevel.JDK_1_7) && (SurroundAutoCloseableAction.findVariable(element) != null || SurroundAutoCloseableAction.findExpression(element) != null);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiLocalVariable variable;
        if (project == null) {
            SurroundAutoCloseableAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            SurroundAutoCloseableAction.$$$reportNull$$$0(3);
        }
        if ((variable = SurroundAutoCloseableAction.findVariable(element)) != null) {
            SurroundAutoCloseableAction.processVariable(project, editor, variable);
        } else {
            PsiExpression expression2 = SurroundAutoCloseableAction.findExpression(element);
            if (expression2 != null) {
                SurroundAutoCloseableAction.processExpression(project, editor, expression2);
            }
        }
    }

    private static PsiLocalVariable findVariable(PsiElement element) {
        PsiElement lastVar;
        PsiElement sibling;
        PsiLocalVariable variable = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLocalVariable.class);
        if (variable != null && variable.getParent() instanceof PsiDeclarationStatement && variable.getParent().getParent() instanceof PsiCodeBlock && SurroundAutoCloseableAction.rightType(variable.getType()) && SurroundAutoCloseableAction.validExpression(variable.getInitializer())) {
            return variable;
        }
        if (variable == null && element instanceof PsiWhiteSpace && (sibling = element.getPrevSibling()) instanceof PsiDeclarationStatement && (lastVar = (PsiElement)ArrayUtil.getLastElement((Object[])((PsiDeclarationStatement)sibling).getDeclaredElements())) instanceof PsiLocalVariable && SurroundAutoCloseableAction.rightType((variable = (PsiLocalVariable)lastVar).getType()) && SurroundAutoCloseableAction.validExpression(variable.getInitializer())) {
            return variable;
        }
        return null;
    }

    private static PsiExpression findExpression(PsiElement element) {
        PsiElement sibling;
        PsiExpression expression2 = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpression.class);
        if (expression2 != null && expression2.getParent() instanceof PsiExpressionStatement && expression2.getParent().getParent() instanceof PsiCodeBlock && SurroundAutoCloseableAction.validExpression(expression2)) {
            return expression2;
        }
        if (expression2 == null && element instanceof PsiWhiteSpace && (sibling = element.getPrevSibling()) instanceof PsiExpressionStatement && SurroundAutoCloseableAction.validExpression(expression2 = ((PsiExpressionStatement)sibling).getExpression())) {
            return expression2;
        }
        return null;
    }

    private static boolean rightType(PsiType type2) {
        return type2 != null && InheritanceUtil.isInheritor((PsiType)type2, (String)"java.lang.AutoCloseable");
    }

    private static boolean validExpression(PsiExpression expression2) {
        return expression2 != null && SurroundAutoCloseableAction.rightType(expression2.getType()) && PsiTreeUtil.findChildOfType((PsiElement)expression2, PsiErrorElement.class) == null;
    }

    private static void processVariable(Project project, Editor editor, PsiLocalVariable variable) {
        PsiJavaToken brace;
        PsiCodeBlock tryBlock;
        PsiExpression initializer = (PsiExpression)ObjectUtils.assertNotNull((Object)variable.getInitializer());
        PsiElement declaration2 = variable.getParent();
        PsiElement codeBlock = declaration2.getParent();
        LocalSearchScope scope = new LocalSearchScope(codeBlock);
        PsiElement last = null;
        for (PsiReference reference : ReferencesSearch.search((PsiElement)variable, (SearchScope)scope).findAll()) {
            PsiElement usage = PsiTreeUtil.findPrevParent((PsiElement)codeBlock, (PsiElement)reference.getElement());
            if (last != null && usage.getTextOffset() <= last.getTextOffset()) continue;
            last = usage;
        }
        CommentTracker tracker = new CommentTracker();
        String text2 = "try (" + variable.getTypeElement().getText() + " " + variable.getName() + " = " + tracker.markUnchanged(initializer).getText() + ") {}";
        PsiTryStatement armStatement = (PsiTryStatement)tracker.replaceAndRestoreComments(declaration2, text2);
        List<PsiElement> toFormat = null;
        if (last != null) {
            toFormat = SurroundAutoCloseableAction.moveStatements(last, armStatement);
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        PsiElement formattedElement = codeStyleManager.reformat((PsiElement)armStatement);
        if (toFormat != null) {
            for (PsiElement psiElement : toFormat) {
                codeStyleManager.reformat(psiElement);
            }
        }
        if (last == null && (tryBlock = ((PsiTryStatement)formattedElement).getTryBlock()) != null && (brace = tryBlock.getLBrace()) != null) {
            editor.getCaretModel().moveToOffset(brace.getTextOffset() + 1);
        }
    }

    private static List<PsiElement> moveStatements(PsiElement last, PsiTryStatement statement) {
        PsiCodeBlock tryBlock = statement.getTryBlock();
        assert (tryBlock != null) : statement.getText();
        PsiElement parent = statement.getParent();
        LocalSearchScope scope = new LocalSearchScope(parent);
        SmartList toFormat = new SmartList();
        PsiElement stopAt = last.getNextSibling();
        PsiElement i = statement.getNextSibling();
        while (i != null && i != stopAt) {
            PsiElement[] declaredElements;
            PsiElement child = i;
            i = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)i);
            if (!(child instanceof PsiDeclarationStatement)) continue;
            int endOffset = last.getTextRange().getEndOffset();
            if (child.getTextOffset() > endOffset) break;
            PsiElement anchor = child;
            for (PsiElement declared : declaredElements = ((PsiDeclarationStatement)child).getDeclaredElements()) {
                boolean contained;
                if (!(declared instanceof PsiLocalVariable) || (contained = ReferencesSearch.search((PsiElement)declared, (SearchScope)scope).forEach(ref -> ref.getElement().getTextOffset() <= endOffset))) continue;
                PsiLocalVariable var = (PsiLocalVariable)declared;
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)statement.getProject());
                String name = var.getName();
                assert (name != null) : child.getText();
                PsiDeclarationStatement declarationStatement = factory.createVariableDeclarationStatement(name, var.getType(), null);
                PsiUtil.setModifierProperty((PsiModifierListOwner)((PsiLocalVariable)declarationStatement.getDeclaredElements()[0]), (String)"final", (boolean)var.hasModifierProperty("final"));
                toFormat.add(parent.addBefore((PsiElement)declarationStatement, (PsiElement)statement));
                CommentTracker commentTracker = new CommentTracker();
                PsiExpression varInit = var.getInitializer();
                if (varInit != null) {
                    String varAssignText = name + " = " + commentTracker.markUnchanged(varInit).getText() + ";";
                    anchor = parent.addAfter((PsiElement)factory.createStatementFromText(varAssignText, parent), anchor);
                }
                commentTracker.deleteAndRestoreComments((PsiElement)(declaredElements.length == 1 ? child : var));
            }
            if (child != last || child.isValid()) continue;
            last = anchor;
        }
        PsiElement first = statement.getNextSibling();
        tryBlock.addRangeBefore(first, last, (PsiElement)tryBlock.getRBrace());
        parent.deleteChildRange(first, last);
        return toFormat;
    }

    private static void processExpression(Project project, Editor editor, PsiExpression expression2) {
        PsiType type2 = (PsiType)ObjectUtils.assertNotNull((Object)expression2.getType());
        PsiElement statement = expression2.getParent();
        CommentTracker commentTracker = new CommentTracker();
        String text2 = "try (" + type2.getCanonicalText(true) + " r = " + commentTracker.markUnchanged(expression2).getText() + ") {}";
        PsiTryStatement tryStatement = (PsiTryStatement)commentTracker.replaceAndRestoreComments(statement, text2);
        tryStatement = (PsiTryStatement)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)tryStatement);
        PsiResourceList resourceList = (tryStatement = (PsiTryStatement)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)tryStatement)).getResourceList();
        if (resourceList != null) {
            PsiResourceVariable var = (PsiResourceVariable)resourceList.iterator().next();
            PsiIdentifier id = var.getNameIdentifier();
            PsiExpression initializer = var.getInitializer();
            if (id != null && initializer != null) {
                type2 = initializer.getType();
                String[] names = IntroduceVariableBase.getSuggestedName((PsiType)type2, (PsiExpression)initializer).names;
                PsiType[] types = (PsiType[])Stream.of(new TypeSelectorManagerImpl(project, type2, initializer, PsiExpression.EMPTY_ARRAY).getTypesForAll()).filter(SurroundAutoCloseableAction::rightType).toArray(PsiType[]::new);
                TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)var);
                builder.replaceElement((PsiElement)id, (Expression)new NamesExpression(names));
                builder.replaceElement((PsiElement)var.getTypeElement(), (Expression)new TypeExpression(project, types));
                builder.run(editor, true);
            }
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.surround.resource.with.ARM.block", (Object[])new Object[0]);
        if (string == null) {
            SurroundAutoCloseableAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            SurroundAutoCloseableAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Template
    implements SurroundDescriptor,
    Surrounder {
        private Surrounder[] mySurrounders = new Surrounder[]{this};

        @NotNull
        public PsiElement[] getElementsToSurround(PsiFile file, int startOffset, int endOffset) {
            PsiElement[] psiElementArray;
            PsiExpression expr = CodeInsightUtil.findExpressionInRange(file, startOffset, endOffset);
            if (expr == null) {
                expr = SurroundAutoCloseableAction.findExpression(file.findElementAt(endOffset));
            }
            if (expr != null && SurroundAutoCloseableAction.rightType(expr.getType())) {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = expr;
            } else {
                psiElementArray = PsiElement.EMPTY_ARRAY;
            }
            if (psiElementArray == null) {
                Template.$$$reportNull$$$0(0);
            }
            return psiElementArray;
        }

        @NotNull
        public Surrounder[] getSurrounders() {
            if (this.mySurrounders == null) {
                Template.$$$reportNull$$$0(1);
            }
            return this.mySurrounders;
        }

        public boolean isExclusive() {
            return false;
        }

        public String getTemplateDescription() {
            return CodeInsightBundle.message((String)"intention.surround.with.ARM.block.template", (Object[])new Object[0]);
        }

        public boolean isApplicable(@NotNull PsiElement[] elements) {
            if (elements == null) {
                Template.$$$reportNull$$$0(2);
            }
            return true;
        }

        @Nullable
        public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) {
            if (project == null) {
                Template.$$$reportNull$$$0(3);
            }
            if (editor == null) {
                Template.$$$reportNull$$$0(4);
            }
            if (elements == null) {
                Template.$$$reportNull$$$0(5);
            }
            if (elements.length == 1 && elements[0] instanceof PsiExpression) {
                SurroundAutoCloseableAction.processExpression(project, editor, (PsiExpression)elements[0]);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction$Template";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementsToSurround";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSurrounders";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction$Template";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicable";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "surroundElements";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class NamesExpression
    extends Expression {
        private final String[] myNames;

        public NamesExpression(String[] names) {
            this.myNames = names;
        }

        public Result calculateResult(ExpressionContext context) {
            return this.calculateQuickResult(context);
        }

        public Result calculateQuickResult(ExpressionContext context) {
            return new TextResult(this.myNames[0]);
        }

        public LookupElement[] calculateLookupItems(ExpressionContext context) {
            return (LookupElement[])Stream.of(this.myNames).map(LookupElementBuilder::create).toArray(LookupElement[]::new);
        }
    }
}

