/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.impl.JavaTemplateUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class TypeExpression
extends Expression {
    private final LinkedHashSet<SmartTypePointer> myItems;

    public TypeExpression(@NotNull Project project, @NotNull PsiType[] types) {
        if (project == null) {
            TypeExpression.$$$reportNull$$$0(0);
        }
        if (types == null) {
            TypeExpression.$$$reportNull$$$0(1);
        }
        this.myItems = new LinkedHashSet();
        SmartTypePointerManager manager = SmartTypePointerManager.getInstance((Project)project);
        for (PsiType type2 : types) {
            this.myItems.add(manager.createSmartTypePointer(type2));
        }
    }

    public TypeExpression(@NotNull Project project, @NotNull Iterable<PsiType> types) {
        if (project == null) {
            TypeExpression.$$$reportNull$$$0(2);
        }
        if (types == null) {
            TypeExpression.$$$reportNull$$$0(3);
        }
        this.myItems = new LinkedHashSet();
        SmartTypePointerManager manager = SmartTypePointerManager.getInstance((Project)project);
        for (PsiType type2 : types) {
            this.myItems.add(manager.createSmartTypePointer(type2));
        }
    }

    public Result calculateResult(ExpressionContext context) {
        final Project project = context.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (this.myItems.isEmpty()) {
            return null;
        }
        final PsiType type2 = ((SmartTypePointer)this.myItems.iterator().next()).getType();
        return type2 == null ? null : new PsiTypeResult(type2, project){

            @Override
            public void handleRecalc(PsiFile psiFile, Document document, int segmentStart, int segmentEnd) {
                if (TypeExpression.this.myItems.size() <= 1) {
                    super.handleRecalc(psiFile, document, segmentStart, segmentEnd);
                } else {
                    JavaTemplateUtil.updateTypeBindings(this.getType(), psiFile, document, segmentStart, segmentEnd, true);
                }
            }

            @Override
            public String toString() {
                JavaCodeStyleSettings settings = JavaCodeStyleSettings.getInstance(project);
                return TypeExpression.this.myItems.size() == 1 || settings.isUseFqClassNames() ? super.toString() : type2.getPresentableText();
            }
        };
    }

    public Result calculateQuickResult(ExpressionContext context) {
        return this.calculateResult(context);
    }

    public LookupElement[] calculateLookupItems(ExpressionContext context) {
        if (this.myItems.size() <= 1) {
            return null;
        }
        PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
        ArrayList<PsiTypeLookupItem> result = new ArrayList<PsiTypeLookupItem>(this.myItems.size());
        for (SmartTypePointer item : this.myItems) {
            PsiType type2 = item.getType();
            if (type2 == null) continue;
            result.add(PsiTypeLookupItem.createLookupItem(type2, null));
        }
        return result.toArray(new LookupElement[result.size()]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "types";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/intention/impl/TypeExpression";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

