/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.javadoc;

import com.intellij.codeInsight.javadoc.AnnotationDocGenerator;
import com.intellij.codeInsight.javadoc.AnnotationFormat;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NonCodeAnnotationGenerator {
    private final PsiModifierListOwner myOwner;
    private final StringBuilder myOutput;

    NonCodeAnnotationGenerator(@NotNull PsiModifierListOwner owner, StringBuilder output) {
        if (owner == null) {
            NonCodeAnnotationGenerator.$$$reportNull$$$0(0);
        }
        this.myOwner = owner;
        this.myOutput = output;
    }

    void explainAnnotations() {
        MultiMap<PsiModifierListOwner, AnnotationDocGenerator> generators = NonCodeAnnotationGenerator.getSignatureNonCodeAnnotations(this.myOwner);
        if (generators.isEmpty()) {
            return;
        }
        this.myOutput.append("\n");
        this.myOutput.append(NonCodeAnnotationGenerator.getNonCodeHeader(generators.values())).append(":<br>\n");
        this.myOutput.append("<ul>\n");
        generators.keySet().forEach(owner -> {
            this.myOutput.append("<li>");
            if (generators.size() > 1) {
                this.myOutput.append(NonCodeAnnotationGenerator.getKind(owner)).append(" <code>").append(((PsiNamedElement)owner).getName()).append("</code>: ");
            }
            ArrayList annotations2 = ContainerUtil.newArrayList((Iterable)generators.get(owner));
            for (int i = 0; i < annotations2.size(); ++i) {
                if (i > 0) {
                    this.myOutput.append(" ");
                }
                ((AnnotationDocGenerator)annotations2.get(i)).generateAnnotation(this.myOutput, AnnotationFormat.JavaDocComplete);
            }
            this.myOutput.append("</li>\n");
        });
        this.myOutput.append("</ul>\n");
    }

    @NotNull
    public static MultiMap<PsiModifierListOwner, AnnotationDocGenerator> getSignatureNonCodeAnnotations(PsiModifierListOwner owner) {
        MultiMap generators = MultiMap.createLinked();
        for (PsiModifierListOwner each : NonCodeAnnotationGenerator.getSignatureOwners(owner)) {
            List nonCode = ContainerUtil.filter(AnnotationDocGenerator.getAnnotationsToShow(each), a -> a.isExternal() || a.isInferred());
            if (nonCode.isEmpty()) continue;
            generators.putValues((Object)each, (Collection)nonCode);
        }
        MultiMap multiMap = generators;
        if (multiMap == null) {
            NonCodeAnnotationGenerator.$$$reportNull$$$0(1);
        }
        return multiMap;
    }

    @NotNull
    private static List<PsiModifierListOwner> getSignatureOwners(PsiModifierListOwner owner) {
        ArrayList<PsiModifierListOwner> allOwners = new ArrayList<PsiModifierListOwner>();
        allOwners.add(owner);
        if (owner instanceof PsiMethod) {
            Collections.addAll(allOwners, ((PsiMethod)owner).getParameterList().getParameters());
        }
        ArrayList<PsiModifierListOwner> arrayList = allOwners;
        if (arrayList == null) {
            NonCodeAnnotationGenerator.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    public static String getNonCodeHeader(Collection<? extends AnnotationDocGenerator> values) {
        boolean hasExternal = values.stream().anyMatch(AnnotationDocGenerator::isExternal);
        boolean hasInferred = values.stream().anyMatch(AnnotationDocGenerator::isInferred);
        String string = (hasExternal && hasInferred ? "External and <i>inferred</i>" : (hasExternal ? "External" : "<i>Inferred</i>")) + " annotations available";
        if (string == null) {
            NonCodeAnnotationGenerator.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static String getKind(PsiModifierListOwner owner) {
        if (owner instanceof PsiParameter) {
            return "Parameter";
        }
        if (owner instanceof PsiMethod) {
            return ((PsiMethod)owner).isConstructor() ? "Constructor" : "Method";
        }
        return owner.getClass().getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/javadoc/NonCodeAnnotationGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/javadoc/NonCodeAnnotationGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatureNonCodeAnnotations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatureOwners";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonCodeHeader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

