/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ExcessiveLambdaUsageInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final ExcessiveLambdaInfo[] INFOS = new ExcessiveLambdaInfo[]{new ExcessiveLambdaInfo("java.util.Map", "computeIfAbsent", "putIfAbsent", 1, false), new ExcessiveLambdaInfo("java.util.Optional", "orElseGet", "orElse", 0, true), new ExcessiveLambdaInfo("java.util.OptionalInt", "orElseGet", "orElse", 0, true), new ExcessiveLambdaInfo("java.util.OptionalLong", "orElseGet", "orElse", 0, true), new ExcessiveLambdaInfo("java.util.OptionalDouble", "orElseGet", "orElse", 0, true), new ExcessiveLambdaInfo("com.google.common.base.Optional", "or", "*", 0, true), new ExcessiveLambdaInfo("java.util.Objects", "requireNonNull", "*", 1, true), new ExcessiveLambdaInfo("java.util.Objects", "requireNonNullElseGet", "requireNonNullElse", 1, true), new ExcessiveLambdaInfo("org.junit.jupiter.api.Assertions", "assert(?!Timeout).*|fail", "*", -1, true), new ExcessiveLambdaInfo("org.junit.jupiter.api.Assertions", "assert(True|False)", "*", 0, true)};

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ExcessiveLambdaUsageInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                ExcessiveLambdaUsageInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitLambdaExpression(PsiLambdaExpression lambda2) {
                PsiElement parent = lambda2.getParent();
                if (!(parent instanceof PsiExpressionList)) {
                    return;
                }
                PsiElement gParent = parent.getParent();
                if (!(gParent instanceof PsiMethodCallExpression)) {
                    return;
                }
                if (!(lambda2.getBody() instanceof PsiExpression)) {
                    return;
                }
                PsiExpression expr = (PsiExpression)lambda2.getBody();
                if (!ExpressionUtils.isSimpleExpression(expr)) {
                    return;
                }
                if (Stream.of(lambda2.getParameterList().getParameters()).anyMatch(param -> ExpressionUtils.isReferenceTo(expr, (PsiVariable)param))) {
                    return;
                }
                for (ExcessiveLambdaInfo info : INFOS) {
                    PsiMethodCallExpression call = (PsiMethodCallExpression)gParent;
                    if (!info.isApplicable(call, lambda2)) continue;
                    holder.registerProblem((PsiElement)lambda2, InspectionsBundle.message((String)"inspection.excessive.lambda.message", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new TextRange(0, expr.getStartOffsetInParent()), new LocalQuickFix[]{new RemoveExcessiveLambdaFix(info, info.getTargetName(call))});
                }
            }
        };
        if (javaElementVisitor == null) {
            ExcessiveLambdaUsageInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ExcessiveLambdaUsageInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ExcessiveLambdaUsageInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ExcessiveLambdaInfo {
        final String myClass;
        final Pattern myLambdaMethod;
        final String myConstantMethod;
        final int myParameterIndex;
        final boolean myCanUseReturnValue;

        ExcessiveLambdaInfo(String aClass, @RegExp String lambdaMethod, String constantMethod, int index, boolean canUseReturnValue) {
            this.myClass = aClass;
            this.myLambdaMethod = Pattern.compile(lambdaMethod);
            this.myConstantMethod = constantMethod;
            this.myParameterIndex = index;
            this.myCanUseReturnValue = canUseReturnValue;
        }

        boolean isApplicable(PsiMethodCallExpression call, PsiLambdaExpression lambda2) {
            int index;
            String name = call.getMethodExpression().getReferenceName();
            if (name == null || !this.myLambdaMethod.matcher(name).matches()) {
                return false;
            }
            if (!this.myCanUseReturnValue && !(call.getParent() instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length == 0) {
                return false;
            }
            int n = index = this.myParameterIndex == -1 ? args.length - 1 : this.myParameterIndex;
            if (args.length <= index || args[index] != lambda2) {
                return false;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            if (parameters2.length <= index) {
                return false;
            }
            PsiClass fnClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)parameters2[index].getType());
            return fnClass != null && LambdaUtil.getFunction((PsiClass)fnClass) != null && InheritanceUtil.isInheritor((PsiClass)method.getContainingClass(), (boolean)false, (String)this.myClass);
        }

        public String getTargetName(PsiMethodCallExpression call) {
            if (this.myConstantMethod.equals("*")) {
                return call.getMethodExpression().getReferenceName();
            }
            return this.myConstantMethod;
        }
    }

    static class RemoveExcessiveLambdaFix
    implements LocalQuickFix {
        private final ExcessiveLambdaInfo myInfo;
        private final String myName;

        public RemoveExcessiveLambdaFix(ExcessiveLambdaInfo info, String name) {
            this.myInfo = info;
            this.myName = name;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.excessive.lambda.fix.name", (Object[])new Object[]{this.myName});
            if (string == null) {
                RemoveExcessiveLambdaFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.excessive.lambda.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                RemoveExcessiveLambdaFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                RemoveExcessiveLambdaFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                RemoveExcessiveLambdaFix.$$$reportNull$$$0(3);
            }
            if (!((element = descriptor.getStartElement()) instanceof PsiLambdaExpression)) {
                return;
            }
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)element;
            PsiElement body2 = lambda2.getBody();
            if (body2 == null) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)lambda2, PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            ExpressionUtils.bindCallTo(call, this.myInfo.getTargetName(call));
            CommentTracker ct = new CommentTracker();
            ct.replaceAndRestoreComments((PsiElement)lambda2, ct.text(body2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ExcessiveLambdaUsageInspection$RemoveExcessiveLambdaFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ExcessiveLambdaUsageInspection$RemoveExcessiveLambdaFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

