/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.EffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.Effects;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;

class HardCodedPurity {
    static final boolean AGGRESSIVE_HARDCODED_PURITY = Registry.is((String)"java.annotations.inference.aggressive.hardcoded.purity", (boolean)true);
    private static final Set<Couple<String>> ownedFields = ContainerUtil.set((Object[])new Couple[]{new Couple((Object)"java/lang/AbstractStringBuilder", (Object)"value")});
    private static final Set<Method> thisChangingMethods = ContainerUtil.set((Object[])new Method[]{new Method("java/lang/Throwable", "fillInStackTrace", "()Ljava/lang/Throwable;")});
    private static final Set<Method> pureMethods = ContainerUtil.set((Object[])new Method[]{new Method("java/lang/Throwable", "toString", "()Ljava/lang/String;"), new Method("java/lang/StringBuilder", "toString", "()Ljava/lang/String;"), new Method("java/lang/StringBuffer", "toString", "()Ljava/lang/String;"), new Method("java/lang/Object", "getClass", "()Ljava/lang/Class;"), new Method("java/lang/Class", "getComponentType", "()Ljava/lang/Class;"), new Method("java/lang/reflect/Array", "newInstance", "(Ljava/lang/Class;I)Ljava/lang/Object;"), new Method("java/lang/reflect/Array", "newInstance", "(Ljava/lang/Class;[I)Ljava/lang/Object;"), new Method("java/lang/Float", "floatToRawIntBits", "(F)I"), new Method("java/lang/Float", "intBitsToFloat", "(I)F"), new Method("java/lang/Double", "doubleToRawLongBits", "(D)J"), new Method("java/lang/Double", "longBitsToDouble", "(J)D")});
    private static final Map<Method, Set<EffectQuantum>> solutions = new HashMap<Method, Set<EffectQuantum>>();
    private static final Set<EffectQuantum> thisChange = Collections.singleton(EffectQuantum.ThisChangeQuantum);

    HardCodedPurity() {
    }

    static HardCodedPurity getInstance() {
        return AGGRESSIVE_HARDCODED_PURITY ? new AggressiveHardCodedPurity() : new HardCodedPurity();
    }

    Effects getHardCodedSolution(Method method) {
        if (this.isThisChangingMethod(method)) {
            return new Effects(this.isBuilderChainCall(method) ? DataValue.ThisDataValue : DataValue.UnknownDataValue1, thisChange);
        }
        if (this.isPureMethod(method)) {
            return new Effects(DataValue.LocalDataValue, Collections.emptySet());
        }
        Set<EffectQuantum> effects = solutions.get(method);
        return effects == null ? null : new Effects(DataValue.UnknownDataValue1, effects);
    }

    boolean isThisChangingMethod(Method method) {
        return this.isBuilderChainCall(method) || thisChangingMethods.contains(method);
    }

    boolean isBuilderChainCall(Method method) {
        return (method.internalClassName.equals("java/lang/StringBuilder") || method.internalClassName.equals("java/lang/StringBuffer")) && method.methodName.startsWith("append");
    }

    boolean isPureMethod(Method method) {
        if (pureMethods.contains(method)) {
            return true;
        }
        return method.internalClassName.startsWith("[") && method.methodName.equals("clone") && method.methodDesc.equals("()Ljava/lang/Object;");
    }

    boolean isOwnedField(FieldInsnNode fieldInsn) {
        return ownedFields.contains(new Couple((Object)fieldInsn.owner, (Object)fieldInsn.name));
    }

    static {
        solutions.put(new Method("java/lang/System", "arraycopy", "(Ljava/lang/Object;ILjava/lang/Object;II)V"), Collections.singleton(new EffectQuantum.ParamChangeQuantum(2)));
        solutions.put(new Method("java/lang/Object", "hashCode", "()I"), Collections.emptySet());
    }

    static class AggressiveHardCodedPurity
    extends HardCodedPurity {
        static final Set<String> ITERABLES = ContainerUtil.set((Object[])new String[]{"java/lang/Iterable", "java/util/Collection", "java/util/List", "java/util/Set", "java/util/ArrayList", "java/util/HashSet", "java/util/AbstractList", "java/util/AbstractSet", "java/util/TreeSet"});

        AggressiveHardCodedPurity() {
        }

        @Override
        boolean isThisChangingMethod(Method method) {
            if (method.methodName.equals("next") && method.methodDesc.startsWith("()") && method.internalClassName.equals("java/util/Iterator")) {
                return true;
            }
            return super.isThisChangingMethod(method);
        }

        @Override
        boolean isPureMethod(Method method) {
            if (method.methodName.equals("toString") && method.methodDesc.equals("()Ljava/lang/String;")) {
                return true;
            }
            if (method.methodName.equals("iterator") && method.methodDesc.equals("()Ljava/util/Iterator;") && ITERABLES.contains(method.internalClassName)) {
                return true;
            }
            if (method.methodName.equals("hasNext") && method.methodDesc.equals("()Z") && method.internalClassName.equals("java/util/Iterator")) {
                return true;
            }
            return super.isPureMethod(method);
        }
    }
}

