/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Method;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

final class LambdaIndy {
    private static final String LAMBDA_METAFACTORY_CLASS = "java/lang/invoke/LambdaMetafactory";
    private static final String LAMBDA_METAFACTORY_METHOD = "metafactory";
    private static final String LAMBDA_METAFACTORY_DESCRIPTOR = "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;";
    private final int myTag;
    private final Type myFunctionalMethodType;
    private final Method myMethod;
    private final Type myFunctionalInterfaceType;

    private LambdaIndy(int tag, Type functionalMethodType, Method lambdaMethod, Type functionalInterfaceType) {
        this.myTag = tag;
        this.myFunctionalMethodType = functionalMethodType;
        this.myMethod = lambdaMethod;
        this.myFunctionalInterfaceType = functionalInterfaceType;
    }

    public int getTag() {
        return this.myTag;
    }

    public int getAssociatedOpcode() {
        switch (this.myTag) {
            case 6: {
                return 184;
            }
            case 7: {
                return 183;
            }
            case 9: {
                return 185;
            }
            case 5: {
                return 182;
            }
        }
        return -1;
    }

    public Type getFunctionalMethodType() {
        return this.myFunctionalMethodType;
    }

    public Method getMethod() {
        return this.myMethod;
    }

    public Type getFunctionalInterfaceType() {
        return this.myFunctionalInterfaceType;
    }

    List<BasicValue> getLambdaMethodArguments(List<? extends BasicValue> captured, Function<Type, BasicValue> valueSupplier) {
        return StreamEx.of((Object[])this.getFunctionalMethodType().getArgumentTypes()).map(valueSupplier).prepend(captured).toList();
    }

    public String toString() {
        return "Lambda [" + this.myMethod.methodName + "]: " + StringUtil.getShortName((String)this.myFunctionalInterfaceType.getClassName());
    }

    static LambdaIndy from(InvokeDynamicInsnNode indyNode) {
        Handle bsm = indyNode.bsm;
        if (LAMBDA_METAFACTORY_CLASS.equals(bsm.getOwner()) && LAMBDA_METAFACTORY_METHOD.equals(bsm.getName()) && LAMBDA_METAFACTORY_DESCRIPTOR.equals(bsm.getDesc()) && indyNode.bsmArgs.length >= 3 && indyNode.bsmArgs[1] instanceof Handle && indyNode.bsmArgs[2] instanceof Type) {
            Handle lambdaBody = (Handle)indyNode.bsmArgs[1];
            Type targetType = (Type)indyNode.bsmArgs[2];
            Method targetMethod = new Method(lambdaBody.getOwner(), lambdaBody.getName(), lambdaBody.getDesc());
            Type retType = Type.getReturnType((String)indyNode.desc);
            return new LambdaIndy(lambdaBody.getTag(), targetType, targetMethod, retType);
        }
        return null;
    }
}

