/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.DfaVariableState;
import com.intellij.codeInspection.dataFlow.DistinctPairSet;
import com.intellij.codeInspection.dataFlow.EqClass;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaFactMapValue;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnboxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.lang.constant.Constable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaMemoryStateImpl
implements DfaMemoryState {
    private static final Logger LOG = Logger.getInstance(DfaMemoryStateImpl.class);
    private final DfaValueFactory myFactory;
    private final List<EqClass> myEqClasses;
    private final TIntObjectHashMap<int[]> myIdToEqClassesIndices;
    private final Stack<DfaValue> myStack;
    private final DistinctPairSet myDistinctClasses;
    private final LinkedHashMap<DfaVariableValue, DfaVariableState> myVariableStates;
    private final Map<DfaVariableValue, DfaVariableState> myDefaultVariableStates;
    private final LinkedHashSet<DfaVariableValue> myUnknownVariables;
    private boolean myEphemeral;
    private LinkedHashSet<EqClass> myCachedNonTrivialEqClasses;
    private Integer myCachedHash;

    protected DfaMemoryStateImpl(DfaValueFactory factory) {
        this.myFactory = factory;
        this.myDefaultVariableStates = ContainerUtil.newTroveMap();
        this.myEqClasses = ContainerUtil.newArrayList();
        this.myUnknownVariables = ContainerUtil.newLinkedHashSet();
        this.myVariableStates = ContainerUtil.newLinkedHashMap();
        this.myDistinctClasses = new DistinctPairSet(this);
        this.myStack = new Stack();
        this.myIdToEqClassesIndices = new MyIdMap(20);
    }

    protected DfaMemoryStateImpl(DfaMemoryStateImpl toCopy) {
        this.myFactory = toCopy.myFactory;
        this.myEphemeral = toCopy.myEphemeral;
        this.myDefaultVariableStates = toCopy.myDefaultVariableStates;
        this.myStack = new Stack(toCopy.myStack);
        this.myDistinctClasses = new DistinctPairSet(this, toCopy.myDistinctClasses);
        this.myUnknownVariables = ContainerUtil.newLinkedHashSet(toCopy.myUnknownVariables);
        this.myEqClasses = ContainerUtil.newArrayList(toCopy.myEqClasses);
        this.myIdToEqClassesIndices = new MyIdMap(toCopy.myIdToEqClassesIndices.size());
        toCopy.myIdToEqClassesIndices.forEachEntry((id, set) -> {
            this.myIdToEqClassesIndices.put(id, set);
            return true;
        });
        this.myVariableStates = ContainerUtil.newLinkedHashMap(toCopy.myVariableStates);
        this.myCachedNonTrivialEqClasses = toCopy.myCachedNonTrivialEqClasses;
        this.myCachedHash = toCopy.myCachedHash;
    }

    @NotNull
    public DfaValueFactory getFactory() {
        DfaValueFactory dfaValueFactory = this.myFactory;
        if (dfaValueFactory == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(0);
        }
        return dfaValueFactory;
    }

    @Override
    @NotNull
    public DfaMemoryStateImpl createCopy() {
        DfaMemoryStateImpl dfaMemoryStateImpl = new DfaMemoryStateImpl(this);
        if (dfaMemoryStateImpl == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(1);
        }
        return dfaMemoryStateImpl;
    }

    @Override
    @NotNull
    public DfaMemoryStateImpl createClosureState() {
        DfaMemoryStateImpl copy = this.createCopy();
        copy.flushFields();
        HashSet<DfaVariableValue> vars = new HashSet<DfaVariableValue>(copy.myVariableStates.keySet());
        for (DfaVariableValue value2 : vars) {
            copy.flushDependencies(value2);
        }
        copy.emptyStack();
        DfaMemoryStateImpl dfaMemoryStateImpl = copy;
        if (dfaMemoryStateImpl == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(2);
        }
        return dfaMemoryStateImpl;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DfaMemoryStateImpl)) {
            return false;
        }
        DfaMemoryStateImpl that = (DfaMemoryStateImpl)obj;
        if (this.myCachedHash != null && that.myCachedHash != null && !this.myCachedHash.equals(that.myCachedHash)) {
            return false;
        }
        return this.equalsSuperficially(that) && this.equalsByUnknownVariables(that) && this.equalsByRelations(that) && this.equalsByVariableStates(that);
    }

    private boolean equalsByUnknownVariables(DfaMemoryStateImpl that) {
        return this.myUnknownVariables.equals(that.myUnknownVariables);
    }

    Object getSuperficialKey() {
        return Pair.create((Object)this.myEphemeral, this.myStack);
    }

    private boolean equalsSuperficially(DfaMemoryStateImpl other) {
        return this.myEphemeral == other.myEphemeral && this.myStack.equals(other.myStack);
    }

    boolean equalsByRelations(DfaMemoryStateImpl that) {
        return this.getNonTrivialEqClasses().equals(that.getNonTrivialEqClasses()) && this.getDistinctClassPairs().equals(that.getDistinctClassPairs());
    }

    boolean equalsByVariableStates(DfaMemoryStateImpl that) {
        return this.myVariableStates.equals(that.myVariableStates);
    }

    DistinctPairSet getDistinctClassPairs() {
        return this.myDistinctClasses;
    }

    LinkedHashSet<EqClass> getNonTrivialEqClasses() {
        if (this.myCachedNonTrivialEqClasses != null) {
            return this.myCachedNonTrivialEqClasses;
        }
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        for (EqClass eqClass : this.myEqClasses) {
            if (eqClass == null || eqClass.size() <= 1) continue;
            result.add(eqClass);
        }
        this.myCachedNonTrivialEqClasses = result;
        return this.myCachedNonTrivialEqClasses;
    }

    public int hashCode() {
        if (this.myCachedHash != null) {
            return this.myCachedHash;
        }
        int hash = this.getPartialHashCode(true, true);
        this.myCachedHash = hash;
        return hash;
    }

    int getPartialHashCode(boolean unknowns, boolean varStates) {
        int hash = (this.getNonTrivialEqClasses().hashCode() * 31 + this.getDistinctClassPairs().hashCode()) * 31 + this.myStack.hashCode();
        if (varStates) {
            hash = hash * 31 + this.myVariableStates.hashCode();
        }
        if (unknowns && !this.myUnknownVariables.isEmpty()) {
            hash = hash * 31 + this.myUnknownVariables.hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('<');
        if (this.myEphemeral) {
            result.append("ephemeral, ");
        }
        for (EqClass set : this.getNonTrivialEqClasses()) {
            result.append(set);
        }
        if (!this.myDistinctClasses.isEmpty()) {
            result.append("\n  distincts: ");
            String distincts = ((StreamEx)StreamEx.of((Collection)this.getDistinctClassPairs()).map(DistinctPairSet.DistinctPair::toString).sorted()).joining((CharSequence)" ");
            result.append(distincts);
        }
        if (!this.myStack.isEmpty()) {
            result.append("\n  stack: ").append(StringUtil.join(this.myStack, (String)","));
        }
        if (!this.myVariableStates.isEmpty()) {
            result.append("\n  vars: ");
            this.myVariableStates.forEach((key2, value2) -> result.append("[").append(key2).append("->").append(value2).append("] "));
        }
        if (!this.myUnknownVariables.isEmpty()) {
            result.append("\n  unknowns: ").append(new HashSet<DfaVariableValue>(this.myUnknownVariables));
        }
        result.append('>');
        return result.toString();
    }

    @Override
    @NotNull
    public DfaValue pop() {
        this.myCachedHash = null;
        DfaValue dfaValue = (DfaValue)this.myStack.pop();
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(3);
        }
        return dfaValue;
    }

    @Override
    @NotNull
    public DfaValue peek() {
        DfaValue dfaValue = (DfaValue)this.myStack.peek();
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(4);
        }
        return dfaValue;
    }

    @Override
    public void push(@NotNull DfaValue value2) {
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(5);
        }
        this.myCachedHash = null;
        this.myStack.push((Object)value2);
    }

    @Override
    public void emptyStack() {
        this.myCachedHash = null;
        while (!this.myStack.isEmpty() && !(this.myStack.peek() instanceof DfaControlTransferValue)) {
            this.myStack.pop();
        }
    }

    @Override
    public void setVarValue(DfaVariableValue var, DfaValue value2) {
        if (var == value2) {
            return;
        }
        value2 = this.handleFlush(var, value2);
        this.flushVariable(var);
        if (value2 instanceof DfaUnknownValue) {
            this.setVariableState(var, this.getVariableState(var).withNotNull());
            return;
        }
        DfaVariableState state = this.getVariableState(var).withValue(value2);
        if (value2 instanceof DfaFactMapValue) {
            this.setVariableState(var, state.withFacts(((DfaFactMapValue)value2).getFacts()));
        } else {
            this.setVariableState(var, this.isNull(value2) ? state.withFact(DfaFactType.CAN_BE_NULL, true) : state);
            DfaRelationValue dfaEqual = this.myFactory.getRelationFactory().createRelation(var, DfaRelationValue.RelationType.EQ, value2);
            if (dfaEqual == null) {
                return;
            }
            this.applyCondition(dfaEqual);
            if (value2 instanceof DfaVariableValue) {
                this.setVariableState(var, this.getVariableState((DfaVariableValue)value2));
            }
        }
        this.updateEqClassesByState(var);
    }

    private DfaValue handleFlush(DfaVariableValue flushed, DfaValue value2) {
        if (value2 instanceof DfaVariableValue && (value2 == flushed || this.myFactory.getVarFactory().getAllQualifiedBy(flushed).contains(value2))) {
            Nullness nullability = this.isNotNull(value2) ? Nullness.NOT_NULL : (this.isUnknownState(value2) ? Nullness.UNKNOWN : ((DfaVariableValue)value2).getInherentNullability());
            return this.myFactory.createTypeValue(((DfaVariableValue)value2).getVariableType(), nullability);
        }
        return value2;
    }

    @Nullable(value="for boxed values which can't be compared by ==")
    private Integer getOrCreateEqClassIndex(@NotNull DfaValue dfaValue) {
        int i;
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(6);
        }
        if ((i = this.getEqClassIndex(dfaValue)) != -1) {
            return i;
        }
        if (!DfaMemoryStateImpl.canBeInRelation(dfaValue) || !this.canBeReused(dfaValue) && !(((DfaBoxedValue)dfaValue).getWrappedValue() instanceof DfaConstValue)) {
            return null;
        }
        int freeIndex = this.myEqClasses.indexOf(null);
        int resultIndex = freeIndex >= 0 ? freeIndex : this.myEqClasses.size();
        EqClass aClass = new EqClass(this.myFactory);
        aClass.add(dfaValue.getID());
        if (freeIndex >= 0) {
            this.myEqClasses.set(freeIndex, aClass);
        } else {
            this.myEqClasses.add(aClass);
        }
        this.addToMap(dfaValue.getID(), resultIndex);
        this.checkInvariants();
        return this.tryMergeClassByQualifier(resultIndex);
    }

    private int tryMergeClassByQualifier(int classIndex) {
        List<DfaValue> values = this.myEqClasses.get(classIndex).getMemberValues();
        if (values.size() != 1) {
            return classIndex;
        }
        DfaValue dfaValue = values.get(0);
        if (!(dfaValue instanceof DfaVariableValue)) {
            return classIndex;
        }
        DfaVariableValue variableValue = (DfaVariableValue)dfaValue;
        DfaVariableValue qualifier = variableValue.getQualifier();
        PsiModifierListOwner variable = variableValue.getPsiVariable();
        if (qualifier == null) {
            return classIndex;
        }
        Integer index = this.getOrCreateEqClassIndex(qualifier);
        if (index == null) {
            return classIndex;
        }
        for (DfaValue eqQualifier : this.myEqClasses.get(index).getMemberValues()) {
            DfaVariableValue eqValue;
            int i;
            if (eqQualifier == qualifier || !(eqQualifier instanceof DfaVariableValue) || (i = this.getEqClassIndex(eqValue = this.getFactory().getVarFactory().createVariableValue(variable, variableValue.getVariableType(), variableValue.isNegated(), (DfaVariableValue)eqQualifier))) == -1) continue;
            this.uniteClasses(i, classIndex);
            return i;
        }
        return classIndex;
    }

    private void addToMap(int id, int index) {
        int[] classes2 = (int[])this.myIdToEqClassesIndices.get(id = DfaMemoryStateImpl.unwrap(this.myFactory.getValue(id)).getID());
        classes2 = classes2 == null ? new int[]{index} : ArrayUtil.append((int[])classes2, (int)index);
        this.myIdToEqClassesIndices.put(id, (Object)classes2);
    }

    private void removeFromMap(int id, int index) {
        int i;
        int[] classes2 = (int[])this.myIdToEqClassesIndices.get(id = DfaMemoryStateImpl.unwrap(this.myFactory.getValue(id)).getID());
        if (classes2 != null && (i = ArrayUtil.indexOf((int[])classes2, (int)index)) != -1) {
            classes2 = ArrayUtil.remove((int[])classes2, (int)i);
            this.myIdToEqClassesIndices.put(id, (Object)classes2);
        }
    }

    private void removeAllFromMap(int id) {
        if (id < 0) {
            return;
        }
        id = DfaMemoryStateImpl.unwrap(this.myFactory.getValue(id)).getID();
        this.myIdToEqClassesIndices.remove(id);
    }

    public boolean isSuperStateOf(DfaMemoryStateImpl that) {
        LinkedHashSet<EqClass> thatClasses;
        if (this.myEphemeral && !that.myEphemeral) {
            return false;
        }
        if (this.myStack.size() != that.myStack.size()) {
            return false;
        }
        if (StreamEx.zip(this.myStack, that.myStack, DfaMemoryStateImpl::isSuperValue).has((Object)false)) {
            return false;
        }
        if (!this.equalsByUnknownVariables(that) || !that.getDistinctClassPairs().containsAll(this.getDistinctClassPairs())) {
            return false;
        }
        LinkedHashSet<EqClass> thisClasses = this.getNonTrivialEqClasses();
        if (!thisClasses.equals(thatClasses = that.getNonTrivialEqClasses()) && thisClasses.stream().anyMatch(thisClass -> thatClasses.stream().noneMatch(thatClass -> thisClass.forEach(arg_0 -> ((EqClass)thatClass).contains(arg_0))))) {
            return false;
        }
        HashSet<DfaVariableValue> values = new HashSet<DfaVariableValue>(this.myVariableStates.keySet());
        values.addAll(that.myVariableStates.keySet());
        for (DfaVariableValue value2 : values) {
            DfaVariableState thatState;
            DfaVariableState thisState = this.getVariableState(value2);
            if (thisState.isSuperStateOf(thatState = that.getVariableState(value2))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSuperValue(DfaValue superValue, DfaValue subValue) {
        if (superValue == DfaUnknownValue.getInstance() || superValue == subValue) {
            return true;
        }
        if (superValue instanceof DfaFactMapValue && subValue instanceof DfaFactMapValue) {
            return ((DfaFactMapValue)superValue).getFacts().isSuperStateOf(((DfaFactMapValue)subValue).getFacts());
        }
        return false;
    }

    private static boolean canBeInRelation(@NotNull DfaValue dfaValue) {
        DfaValue unwrapped;
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(7);
        }
        return (unwrapped = DfaMemoryStateImpl.unwrap(dfaValue)) instanceof DfaVariableValue || unwrapped instanceof DfaConstValue;
    }

    @NotNull
    List<DfaValue> getEquivalentValues(@NotNull DfaValue dfaValue) {
        int index;
        EqClass set;
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(8);
        }
        EqClass eqClass = set = (index = this.getEqClassIndex(dfaValue)) == -1 ? null : this.myEqClasses.get(index);
        if (set == null) {
            List<DfaValue> list = Collections.emptyList();
            if (list == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<DfaValue> list = set.getMemberValues();
        if (list == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    private boolean canBeNaN(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(11);
        }
        for (DfaValue eq : this.getEquivalentValues(dfaValue)) {
            if (eq instanceof DfaBoxedValue) {
                eq = ((DfaBoxedValue)eq).getWrappedValue();
            }
            if (!(eq instanceof DfaConstValue) || DfaMemoryStateImpl.isNaN(eq)) continue;
            return false;
        }
        return dfaValue instanceof DfaVariableValue && TypeConversionUtil.isFloatOrDoubleType((PsiType)((DfaVariableValue)dfaValue).getVariableType());
    }

    private boolean isEffectivelyNaN(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(12);
        }
        for (DfaValue eqClass : this.getEquivalentValues(dfaValue)) {
            if (!DfaMemoryStateImpl.isNaN(eqClass)) continue;
            return true;
        }
        return false;
    }

    List<EqClass> getEqClasses() {
        return this.myEqClasses;
    }

    int getEqClassIndex(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(13);
        }
        int id = DfaMemoryStateImpl.unwrap(dfaValue).getID();
        int[] classes2 = (int[])this.myIdToEqClassesIndices.get(id);
        int result = -1;
        if (classes2 != null) {
            for (int index : classes2) {
                EqClass aClass = this.myEqClasses.get(index);
                if (!aClass.contains(dfaValue.getID())) continue;
                if (!this.canBeReused(dfaValue) && aClass.size() > 1) break;
                result = index;
                break;
            }
        }
        return result;
    }

    private boolean canBeReused(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(14);
        }
        if (dfaValue instanceof DfaBoxedValue) {
            DfaValue valueToWrap = ((DfaBoxedValue)dfaValue).getWrappedValue();
            if (valueToWrap instanceof DfaConstValue) {
                return DfaMemoryStateImpl.cacheable((DfaConstValue)valueToWrap);
            }
            if (valueToWrap instanceof DfaVariableValue) {
                if (PsiType.BOOLEAN.equals((Object)((DfaVariableValue)valueToWrap).getVariableType())) {
                    return true;
                }
                for (DfaValue value2 : this.getEquivalentValues(valueToWrap)) {
                    if (!(value2 instanceof DfaConstValue) || !DfaMemoryStateImpl.cacheable((DfaConstValue)value2)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private static boolean cacheable(@NotNull DfaConstValue dfaConstValue) {
        Object value2;
        if (dfaConstValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(15);
        }
        return DfaMemoryStateImpl.box(value2 = dfaConstValue.getValue()) == DfaMemoryStateImpl.box(value2);
    }

    private static Object box(Object value2) {
        Constable newBoxedValue;
        if (value2 instanceof Integer) {
            newBoxedValue = (int)((Integer)value2);
        } else if (value2 instanceof Byte) {
            newBoxedValue = (byte)((Byte)value2);
        } else if (value2 instanceof Short) {
            newBoxedValue = (short)((Short)value2);
        } else if (value2 instanceof Long) {
            newBoxedValue = (long)((Long)value2);
        } else if (value2 instanceof Boolean) {
            newBoxedValue = (Boolean)value2;
        } else if (value2 instanceof Character) {
            newBoxedValue = Character.valueOf(((Character)value2).charValue());
        } else {
            return new Object();
        }
        return newBoxedValue;
    }

    private boolean uniteClasses(int c1Index, int c2Index) {
        EqClass c1 = this.myEqClasses.get(c1Index);
        EqClass c2 = this.myEqClasses.get(c2Index);
        THashSet vars = ContainerUtil.newTroveSet();
        THashSet negatedVars = ContainerUtil.newTroveSet();
        int[] cs = new int[c1.size() + c2.size()];
        c1.set(0, cs, 0, c1.size());
        c2.set(0, cs, c1.size(), c2.size());
        int nConst = 0;
        for (int c : cs) {
            DfaValue dfaValue = DfaMemoryStateImpl.unwrap(this.myFactory.getValue(c));
            if (dfaValue instanceof DfaConstValue) {
                ++nConst;
            }
            if (dfaValue instanceof DfaVariableValue) {
                DfaVariableValue variableValue = (DfaVariableValue)dfaValue;
                if (variableValue.isNegated()) {
                    negatedVars.add(variableValue.createNegated());
                } else {
                    vars.add(variableValue);
                }
            }
            if (nConst <= 1) continue;
            return false;
        }
        if (ContainerUtil.intersects((Collection)vars, (Collection)negatedVars)) {
            return false;
        }
        EqClass newClass = new EqClass(c1);
        this.myEqClasses.set(c1Index, newClass);
        for (int i = 0; i < c2.size(); ++i) {
            int c = c2.get(i);
            newClass.add(c);
            this.removeFromMap(c, c2Index);
            this.addToMap(c, c1Index);
        }
        if (!this.myDistinctClasses.unite(c1Index, c2Index)) {
            return false;
        }
        this.myEqClasses.set(c2Index, null);
        this.checkInvariants();
        return true;
    }

    private void checkInvariants() {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        this.myIdToEqClassesIndices.forEachEntry((id, eqClasses) -> {
            for (int classNum : eqClasses) {
                if (this.myEqClasses.get(classNum) != null) continue;
                LOG.debug("Invariant violated: null-class for id=" + this.myFactory.getValue(id));
            }
            return true;
        });
    }

    @Override
    public boolean isNull(DfaValue dfaValue) {
        if (dfaValue instanceof DfaConstValue) {
            return ((DfaConstValue)dfaValue).getValue() == null;
        }
        if (dfaValue instanceof DfaVariableValue) {
            int c1Index = this.getEqClassIndex(dfaValue);
            return c1Index >= 0 && c1Index == this.getEqClassIndex(this.myFactory.getConstFactory().getNull());
        }
        return false;
    }

    @Override
    public boolean isNotNull(DfaValue dfaVar) {
        if (dfaVar instanceof DfaConstValue) {
            return ((DfaConstValue)dfaVar).getValue() != null;
        }
        if (dfaVar instanceof DfaBoxedValue) {
            return true;
        }
        if (dfaVar instanceof DfaFactMapValue) {
            return Boolean.FALSE.equals(((DfaFactMapValue)dfaVar).get(DfaFactType.CAN_BE_NULL));
        }
        if (dfaVar instanceof DfaVariableValue) {
            if (this.getVariableState((DfaVariableValue)dfaVar).isNotNull()) {
                return true;
            }
            DfaConstValue constantValue = this.getConstantValue((DfaVariableValue)dfaVar);
            if (constantValue != null && constantValue.getValue() != null) {
                return true;
            }
        }
        DfaConstValue dfaNull = this.myFactory.getConstFactory().getNull();
        Integer c1Index = this.getOrCreateEqClassIndex(dfaVar);
        int c2Index = this.getEqClassIndex(dfaNull);
        if (c1Index == null || c2Index < 0) {
            return false;
        }
        return this.myDistinctClasses.areDistinctUnordered(c1Index, c2Index);
    }

    @Override
    @Nullable
    public DfaConstValue getConstantValue(@NotNull DfaVariableValue value2) {
        int index;
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(16);
        }
        EqClass ec = (index = this.getEqClassIndex(value2)) == -1 ? null : this.myEqClasses.get(index);
        return ec == null ? null : (DfaConstValue)DfaMemoryStateImpl.unwrap(ec.findConstant(true));
    }

    @Override
    public void markEphemeral() {
        this.myEphemeral = true;
    }

    @Override
    public boolean isEphemeral() {
        return this.myEphemeral;
    }

    @Override
    public boolean isEmptyStack() {
        return this.myStack.isEmpty();
    }

    @Override
    public void cleanUpTempVariables() {
        Predicate<DfaVariableValue> sharesState = var -> this.getConstantValue((DfaVariableValue)var) == null && StreamEx.of(this.getEquivalentValues((DfaValue)var)).without(var).select(DfaVariableValue.class).findFirst().isPresent();
        List values = ((StreamEx)((StreamEx)StreamEx.ofKeys(this.myVariableStates).filter(var -> ControlFlowAnalyzer.isTempVariable(var.getPsiVariable()))).remove(sharesState)).toList();
        values.forEach(this::flushVariable);
    }

    @Override
    public boolean castTopOfStack(@NotNull DfaPsiType type2) {
        if (type2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(17);
        }
        DfaValue value2 = DfaMemoryStateImpl.unwrap(this.peek());
        DfaFactMap facts = null;
        if (value2 instanceof DfaVariableValue) {
            DfaVariableValue dfaVar = (DfaVariableValue)value2;
            if (this.isNull(dfaVar)) {
                return true;
            }
            if (this.isUnknownState(dfaVar)) {
                facts = this.getVariableState((DfaVariableValue)dfaVar).myFactMap;
            } else {
                DfaVariableState newState = this.getVariableState(dfaVar).withInstanceofValue(type2);
                if (newState == null) {
                    return false;
                }
                this.setVariableState(dfaVar, newState);
            }
        } else if (value2 instanceof DfaFactMapValue) {
            facts = ((DfaFactMapValue)value2).getFacts();
        }
        if (facts != null) {
            DfaFactMap newFacts = TypeConstraint.withInstanceOf(facts, type2);
            if (newFacts == null) {
                return false;
            }
            this.pop();
            this.push(this.myFactory.getFactFactory().createValue(newFacts));
        }
        return true;
    }

    <T> void setFact(DfaValue target, DfaFactType<T> factType, T fact) {
        if (target instanceof DfaVariableValue && !this.isUnknownState(target)) {
            this.setVariableState((DfaVariableValue)target, this.getVariableState((DfaVariableValue)target).withFact(factType, fact));
        }
    }

    private boolean applyFacts(DfaValue value2, DfaFactMap facts) {
        if (value2 instanceof DfaVariableValue && !this.isUnknownState(value2)) {
            DfaVariableState oldState = this.getVariableState((DfaVariableValue)value2);
            DfaVariableState newState = oldState.intersectMap(facts);
            if (newState == null) {
                newState = oldState.withoutFact(DfaFactType.TYPE_CONSTRAINT);
                if (newState.intersectMap(facts) != null && !Boolean.FALSE.equals(facts.get(DfaFactType.CAN_BE_NULL))) {
                    this.setVariableState((DfaVariableValue)value2, newState);
                    return this.applyRelation(value2, this.getFactory().getConstFactory().getNull(), false);
                }
                return false;
            }
            this.setVariableState((DfaVariableValue)value2, newState);
            this.updateEquivalentVariables((DfaVariableValue)value2, newState);
            return this.updateEqClassesByState((DfaVariableValue)value2);
        }
        return true;
    }

    private boolean updateEqClassesByState(DfaVariableValue value2) {
        if (Boolean.FALSE.equals(this.getVariableState(value2).getFact(DfaFactType.CAN_BE_NULL))) {
            return this.applyRelation(value2, this.getFactory().getConstFactory().getNull(), true);
        }
        return true;
    }

    @Override
    public <T> boolean applyFact(@NotNull DfaValue value2, @NotNull DfaFactType<T> factType, @Nullable T factValue) {
        DfaVariableValue var;
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(18);
        }
        if (factType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(19);
        }
        if (value2 instanceof DfaFactMapValue) {
            return ((DfaFactMapValue)value2).getFacts().intersect(factType, factValue) != null;
        }
        if (value2 instanceof DfaVariableValue && !this.isUnknownState(var = (DfaVariableValue)value2) && factValue != null) {
            DfaVariableState state = this.getVariableState(var);
            DfaVariableState newState = state.intersectFact(factType, factValue);
            if (newState == null) {
                return false;
            }
            this.setVariableState(var, newState);
            this.updateEquivalentVariables(var, newState);
            return this.updateEqClassesByState(var);
        }
        return true;
    }

    static DfaValue unwrap(DfaValue value2) {
        if (value2 instanceof DfaBoxedValue) {
            return ((DfaBoxedValue)value2).getWrappedValue();
        }
        if (value2 instanceof DfaUnboxedValue) {
            return ((DfaUnboxedValue)value2).getVariable();
        }
        return value2;
    }

    @Override
    public boolean applyContractCondition(DfaValue condition2) {
        DfaRelationValue relation;
        if (condition2 instanceof DfaRelationValue && (relation = (DfaRelationValue)condition2).isEquality() && relation.getRightOperand() == this.myFactory.getConstFactory().getNull() && (relation.getLeftOperand() instanceof DfaUnknownValue || relation.getLeftOperand() instanceof DfaVariableValue && this.getVariableState((DfaVariableValue)relation.getLeftOperand()).getNullability() == Nullness.UNKNOWN)) {
            this.markEphemeral();
        }
        return this.applyCondition(condition2);
    }

    @Override
    public boolean applyCondition(DfaValue dfaCond) {
        if (dfaCond instanceof DfaUnknownValue) {
            return true;
        }
        if (dfaCond instanceof DfaUnboxedValue) {
            DfaVariableValue dfaVar = ((DfaUnboxedValue)dfaCond).getVariable();
            boolean isNegated = dfaVar.isNegated();
            DfaVariableValue dfaNormalVar = isNegated ? dfaVar.createNegated() : dfaVar;
            DfaValue boxedTrue = this.myFactory.getBoxedFactory().createBoxed(this.myFactory.getConstFactory().getTrue());
            return this.applyRelationCondition(this.myFactory.getRelationFactory().createRelation(dfaNormalVar, DfaRelationValue.RelationType.equivalence(!isNegated), boxedTrue));
        }
        if (dfaCond instanceof DfaVariableValue) {
            DfaVariableValue dfaVar = (DfaVariableValue)dfaCond;
            boolean isNegated = dfaVar.isNegated();
            DfaVariableValue dfaNormalVar = isNegated ? dfaVar.createNegated() : dfaVar;
            DfaConstValue dfaTrue = this.myFactory.getConstFactory().getTrue();
            return this.applyRelationCondition(this.myFactory.getRelationFactory().createRelation(dfaNormalVar, DfaRelationValue.RelationType.equivalence(!isNegated), dfaTrue));
        }
        if (dfaCond instanceof DfaConstValue) {
            return dfaCond == this.myFactory.getConstFactory().getTrue() || dfaCond != this.myFactory.getConstFactory().getFalse();
        }
        if (!(dfaCond instanceof DfaRelationValue)) {
            return true;
        }
        return this.applyRelationCondition((DfaRelationValue)dfaCond);
    }

    private boolean applyRelationCondition(@NotNull DfaRelationValue dfaRelation) {
        if (dfaRelation == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(20);
        }
        DfaValue dfaLeft = dfaRelation.getLeftOperand();
        DfaValue dfaRight = dfaRelation.getRightOperand();
        if (dfaLeft instanceof DfaUnknownValue || dfaRight instanceof DfaUnknownValue) {
            return true;
        }
        DfaRelationValue.RelationType relationType = dfaRelation.getRelation();
        LongRangeSet left = this.getValueFact(dfaLeft, DfaFactType.RANGE);
        LongRangeSet right = this.getValueFact(dfaRight, DfaFactType.RANGE);
        if (!(left == null || right == null || this.applyFact(dfaLeft, DfaFactType.RANGE, right.fromRelation(relationType)) && this.applyFact(dfaRight, DfaFactType.RANGE, left.fromRelation(relationType.getFlipped())))) {
            return false;
        }
        if (dfaRight instanceof DfaFactMapValue) {
            DfaFactMapValue factValue = (DfaFactMapValue)dfaRight;
            if ((relationType == DfaRelationValue.RelationType.IS || relationType == DfaRelationValue.RelationType.EQ) && Boolean.FALSE.equals(factValue.get(DfaFactType.CAN_BE_NULL)) && !this.applyRelation(dfaLeft, this.getFactory().getConstFactory().getNull(), true)) {
                return false;
            }
            if (dfaLeft instanceof DfaVariableValue) {
                DfaVariableValue dfaVar = (DfaVariableValue)dfaLeft;
                if (this.isUnknownState(dfaVar)) {
                    return true;
                }
                switch (relationType) {
                    case IS: {
                        return this.applyFacts(dfaVar, factValue.getFacts());
                    }
                    case IS_NOT: {
                        Boolean optionalPresence = factValue.get(DfaFactType.OPTIONAL_PRESENCE);
                        if (optionalPresence != null) {
                            return this.applyFact(dfaVar, DfaFactType.OPTIONAL_PRESENCE, optionalPresence == false);
                        }
                        Boolean canBeNull = factValue.get(DfaFactType.CAN_BE_NULL);
                        TypeConstraint constraint = factValue.get(DfaFactType.TYPE_CONSTRAINT);
                        if (constraint != null && constraint.getNotInstanceofValues().isEmpty()) {
                            DfaVariableState state = this.getVariableState(dfaVar);
                            for (DfaPsiType type2 : constraint.getInstanceofValues()) {
                                if ((state = state.withNotInstanceofValue(type2)) == null) {
                                    return Boolean.FALSE.equals(canBeNull) && !this.getVariableState(dfaVar).isNotNull() && this.applyRelation(dfaVar, this.myFactory.getConstFactory().getNull(), false);
                                }
                                this.setVariableState(dfaVar, state);
                            }
                        }
                        return true;
                    }
                }
                return true;
            }
            if (relationType == DfaRelationValue.RelationType.IS || relationType == DfaRelationValue.RelationType.EQ) {
                return this.getFactMap(dfaLeft).intersect(factValue.getFacts()) != null;
            }
            return true;
        }
        if (this.isEffectivelyNaN(dfaLeft) || this.isEffectivelyNaN(dfaRight)) {
            this.applyEquivalenceRelation(dfaRelation, dfaLeft, dfaRight);
            return relationType == DfaRelationValue.RelationType.NE;
        }
        if (this.canBeNaN(dfaLeft) && this.canBeNaN(dfaRight)) {
            if (dfaLeft == dfaRight && dfaLeft instanceof DfaVariableValue && !(((DfaVariableValue)dfaLeft).getVariableType() instanceof PsiPrimitiveType)) {
                return !dfaRelation.isNonEquality();
            }
            this.applyEquivalenceRelation(dfaRelation, dfaLeft, dfaRight);
            return true;
        }
        return this.applyEquivalenceRelation(dfaRelation, dfaLeft, dfaRight);
    }

    private void updateVarStateOnComparison(@NotNull DfaVariableValue dfaVar, DfaValue value2) {
        if (dfaVar == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(21);
        }
        if (!this.isUnknownState(dfaVar) && !(dfaVar.getVariableType() instanceof PsiPrimitiveType)) {
            if (value2 instanceof DfaConstValue) {
                PsiType psiType;
                Object constValue = ((DfaConstValue)value2).getValue();
                if (constValue == null) {
                    this.setVariableState(dfaVar, this.getVariableState(dfaVar).withFact(DfaFactType.CAN_BE_NULL, true));
                    return;
                }
                if (constValue instanceof PsiVariable) {
                    psiType = ((PsiVariable)constValue).getType();
                } else {
                    PsiModifierListOwner context = dfaVar.getPsiVariable();
                    psiType = JavaPsiFacade.getElementFactory((Project)context.getProject()).createTypeByFQClassName(constValue.getClass().getName(), context.getResolveScope());
                }
                DfaPsiType dfaType = this.myFactory.createDfaType(psiType);
                DfaVariableState state = this.getVariableState(dfaVar).withInstanceofValue(dfaType);
                if (state != null) {
                    this.setVariableState(dfaVar, state);
                }
            }
            if (this.isNotNull(value2) && !this.isNotNull(dfaVar)) {
                this.setVariableState(dfaVar, this.getVariableState(dfaVar).withoutFact(DfaFactType.CAN_BE_NULL));
                this.applyRelation(dfaVar, this.myFactory.getConstFactory().getNull(), true);
            }
        }
    }

    private boolean applyEquivalenceRelation(@NotNull DfaRelationValue dfaRelation, DfaValue dfaLeft, DfaValue dfaRight) {
        boolean containsCalls;
        boolean isNegated;
        if (dfaRelation == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(22);
        }
        if (!(isNegated = dfaRelation.isNonEquality()) && !dfaRelation.isEquality()) {
            return true;
        }
        boolean bl = containsCalls = dfaLeft instanceof DfaVariableValue && ((DfaVariableValue)dfaLeft).containsCalls();
        if (dfaLeft == dfaRight) {
            return containsCalls || !isNegated;
        }
        if (this.isNull(dfaLeft) && this.isNotNull(dfaRight) || this.isNull(dfaRight) && this.isNotNull(dfaLeft)) {
            return isNegated;
        }
        if (!isNegated) {
            if (dfaLeft instanceof DfaVariableValue) {
                this.updateVarStateOnComparison((DfaVariableValue)dfaLeft, dfaRight);
            }
            if (dfaRight instanceof DfaVariableValue) {
                this.updateVarStateOnComparison((DfaVariableValue)dfaRight, dfaLeft);
            }
        }
        if (dfaRelation.getRelation() == DfaRelationValue.RelationType.LT ? !this.applyLessThanRelation(dfaLeft, dfaRight) : (dfaRelation.getRelation() == DfaRelationValue.RelationType.GT ? !this.applyLessThanRelation(dfaRight, dfaLeft) : !this.applyRelation(dfaLeft, dfaRight, isNegated))) {
            return false;
        }
        if (!this.checkCompareWithBooleanLiteral(dfaLeft, dfaRight, isNegated)) {
            return false;
        }
        if (dfaLeft instanceof DfaVariableValue) {
            if (!this.applyUnboxedRelation((DfaVariableValue)dfaLeft, dfaRight, isNegated)) {
                return false;
            }
            return this.applyBoxedRelation((DfaVariableValue)dfaLeft, dfaRight, isNegated);
        }
        return true;
    }

    private boolean applyBoxedRelation(@NotNull DfaVariableValue dfaLeft, DfaValue dfaRight, boolean negated) {
        if (dfaLeft == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(23);
        }
        if (!TypeConversionUtil.isPrimitiveAndNotNull((PsiType)dfaLeft.getVariableType())) {
            return true;
        }
        DfaBoxedValue.Factory boxedFactory = this.myFactory.getBoxedFactory();
        DfaValue boxedLeft = boxedFactory.createBoxed(dfaLeft);
        DfaValue boxedRight = boxedFactory.createBoxed(dfaRight);
        return boxedLeft == null || boxedRight == null || this.applyRelation(boxedLeft, boxedRight, negated);
    }

    private boolean applyUnboxedRelation(@NotNull DfaVariableValue dfaLeft, DfaValue dfaRight, boolean negated) {
        DfaValue unboxedRight;
        if (dfaLeft == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(24);
        }
        if (negated) {
            return true;
        }
        PsiType type2 = dfaLeft.getVariableType();
        if (!TypeConversionUtil.isPrimitiveWrapper((PsiType)type2)) {
            return true;
        }
        DfaBoxedValue.Factory boxedFactory = this.myFactory.getBoxedFactory();
        DfaValue unboxedLeft = boxedFactory.createUnboxed(dfaLeft);
        return this.applyRelation(unboxedLeft, unboxedRight = boxedFactory.createUnboxed(dfaRight), false) && this.checkCompareWithBooleanLiteral(unboxedLeft, unboxedRight, false);
    }

    private boolean checkCompareWithBooleanLiteral(DfaValue dfaLeft, DfaValue dfaRight, boolean negated) {
        Object constVal;
        if (dfaRight instanceof DfaConstValue && (constVal = ((DfaConstValue)dfaRight).getValue()) instanceof Boolean) {
            DfaConstValue negVal = this.myFactory.getBoolean((Boolean)constVal == false);
            return this.applyRelation(dfaLeft, negVal, !negated) && this.applyRelation(dfaLeft.createNegated(), negVal, negated);
        }
        return true;
    }

    static boolean isNaN(DfaValue dfa) {
        return dfa instanceof DfaConstValue && DfaUtil.isNaN(((DfaConstValue)dfa).getValue());
    }

    private boolean applyRelation(@NotNull DfaValue dfaLeft, @NotNull DfaValue dfaRight, boolean isNegated) {
        if (dfaLeft == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(25);
        }
        if (dfaRight == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(26);
        }
        if (this.isUnknownState(dfaLeft) || this.isUnknownState(dfaRight)) {
            return true;
        }
        Integer c1Index = this.getOrCreateEqClassIndex(dfaLeft);
        Integer c2Index = this.getOrCreateEqClassIndex(dfaRight);
        if (c1Index == null || c2Index == null) {
            return true;
        }
        if (!isNegated) {
            if (c1Index.equals(c2Index) || this.areCompatibleConstants(c1Index, c2Index)) {
                return true;
            }
            if (this.isUnstableValue(dfaLeft) || this.isUnstableValue(dfaRight)) {
                return true;
            }
            if (!this.uniteClasses(c1Index, c2Index)) {
                return false;
            }
            Iterator<DistinctPairSet.DistinctPair> iterator = this.myDistinctClasses.iterator();
            while (iterator.hasNext()) {
                DistinctPairSet.DistinctPair pair = iterator.next();
                DfaConstValue const1 = (DfaConstValue)pair.getFirst().findConstant(false);
                DfaConstValue const2 = (DfaConstValue)pair.getSecond().findConstant(false);
                if (const1 == null || const2 == null || DfaMemoryStateImpl.preserveConstantDistinction(const1.getValue(), const2.getValue())) continue;
                iterator.remove();
            }
            this.myCachedNonTrivialEqClasses = null;
        } else {
            if (c1Index.equals(c2Index) || this.areCompatibleConstants(c1Index, c2Index)) {
                return false;
            }
            if (this.isNull(dfaLeft) && DfaMemoryStateImpl.isPrimitive(dfaRight) || this.isNull(dfaRight) && DfaMemoryStateImpl.isPrimitive(dfaLeft)) {
                return true;
            }
            this.myDistinctClasses.addUnordered(c1Index, c2Index);
        }
        this.myCachedHash = null;
        return true;
    }

    private boolean applyLessThanRelation(@NotNull DfaValue dfaLeft, @NotNull DfaValue dfaRight) {
        if (dfaLeft == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(27);
        }
        if (dfaRight == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(28);
        }
        if (this.isUnknownState(dfaLeft) || this.isUnknownState(dfaRight)) {
            return true;
        }
        Integer c1Index = this.getOrCreateEqClassIndex(dfaLeft);
        Integer c2Index = this.getOrCreateEqClassIndex(dfaRight);
        if (c1Index == null || c2Index == null) {
            return true;
        }
        if (c1Index.equals(c2Index) || this.areCompatibleConstants(c1Index, c2Index)) {
            return false;
        }
        if (this.isNull(dfaLeft) && DfaMemoryStateImpl.isPrimitive(dfaRight) || this.isNull(dfaRight) && DfaMemoryStateImpl.isPrimitive(dfaLeft)) {
            return true;
        }
        this.myCachedHash = null;
        return this.myDistinctClasses.addOrdered(c1Index, c2Index);
    }

    private boolean isUnstableValue(DfaValue value2) {
        if (!(value2 instanceof DfaVariableValue)) {
            return false;
        }
        DfaVariableValue var = (DfaVariableValue)value2;
        PsiModifierListOwner owner = var.getPsiVariable();
        if (!(owner instanceof PsiMethod)) {
            return false;
        }
        if (var.getVariableType() instanceof PsiPrimitiveType) {
            return false;
        }
        if (PropertyUtilBase.isSimplePropertyGetter((PsiMethod)((PsiMethod)owner))) {
            return false;
        }
        return !this.isNull(var);
    }

    private static boolean isPrimitive(DfaValue value2) {
        return value2 instanceof DfaVariableValue && ((DfaVariableValue)value2).getVariableType() instanceof PsiPrimitiveType;
    }

    private static boolean preserveConstantDistinction(Object c1, Object c2) {
        return c1 == null && c2 instanceof PsiVariable || c2 == null && c1 instanceof PsiVariable;
    }

    private boolean areCompatibleConstants(int i1, int i2) {
        Double dv1 = this.getDoubleValue(i1);
        return dv1 != null && dv1.equals(this.getDoubleValue(i2));
    }

    @Nullable
    private Double getDoubleValue(int eqClassIndex) {
        EqClass ec = this.myEqClasses.get(eqClassIndex);
        DfaValue dfaConst = ec == null ? null : ec.findConstant(false);
        Object constValue = dfaConst instanceof DfaConstValue ? ((DfaConstValue)dfaConst).getValue() : null;
        return constValue instanceof Number ? Double.valueOf(((Number)constValue).doubleValue()) : null;
    }

    private boolean isUnknownState(DfaValue val) {
        if ((val = DfaMemoryStateImpl.unwrap(val)) instanceof DfaVariableValue) {
            DfaVariableValue var = (DfaVariableValue)val;
            if (this.myUnknownVariables.contains(val) || this.myUnknownVariables.contains(var.getNegatedValue())) {
                return true;
            }
            return this.equivalentVariables(var).anyMatch(v -> this.myUnknownVariables.contains(v) || this.myUnknownVariables.contains(v.getNegatedValue()));
        }
        return false;
    }

    @Override
    public boolean checkNotNullable(DfaValue value2) {
        if (value2 == this.myFactory.getConstFactory().getNull()) {
            return false;
        }
        if (value2 instanceof DfaFactMapValue && Boolean.TRUE.equals(((DfaFactMapValue)value2).get(DfaFactType.CAN_BE_NULL))) {
            return false;
        }
        if (value2 instanceof DfaVariableValue) {
            DfaVariableValue varValue = (DfaVariableValue)value2;
            if (varValue.getVariableType() instanceof PsiPrimitiveType) {
                return true;
            }
            if (this.isNotNull(varValue)) {
                return true;
            }
            return this.getVariableState(varValue).getNullability() != Nullness.NULLABLE;
        }
        return true;
    }

    @Override
    @Nullable
    public <T> T getValueFact(@NotNull DfaValue value2, @NotNull DfaFactType<T> factType) {
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(29);
        }
        if (factType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(30);
        }
        if (value2 instanceof DfaVariableValue) {
            T fact;
            DfaVariableValue var = (DfaVariableValue)value2;
            DfaVariableState state = this.findVariableState(var);
            if (state != null && (fact = state.getFact(factType)) != null) {
                return fact;
            }
            value2 = this.resolveVariableValue(var);
        }
        return factType.fromDfaValue(value2);
    }

    @Override
    public <T> void forceVariableFact(@NotNull DfaVariableValue var, @NotNull DfaFactType<T> factType, @Nullable T value2) {
        if (var == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(31);
        }
        if (factType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(32);
        }
        if (this.isUnknownState(var)) {
            return;
        }
        DfaVariableState state = this.getVariableState(var);
        this.flushVariable(var);
        this.setVariableState(var, state.withFact(factType, value2));
        this.updateEqClassesByState(var);
    }

    @NotNull
    private DfaValue resolveVariableValue(DfaVariableValue var) {
        DfaConstValue constValue = this.getConstantValue(var);
        if (constValue != null) {
            DfaConstValue dfaConstValue = constValue;
            if (dfaConstValue == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(33);
            }
            return dfaConstValue;
        }
        DfaVariableValue qualifier = var.getQualifier();
        if (qualifier != null) {
            DfaValue dfaValue = ((StreamEx)StreamEx.of((Object[])SpecialField.values()).filter(sf -> sf.isMyAccessor(var.getPsiVariable()))).map(sf -> sf.createValue(this.myFactory, qualifier)).nonNull().findFirst().orElse(var);
            if (dfaValue == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(34);
            }
            return dfaValue;
        }
        DfaVariableValue dfaVariableValue = var;
        if (dfaVariableValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(35);
        }
        return dfaVariableValue;
    }

    DfaFactMap getFactMap(@NotNull DfaValue value2) {
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(36);
        }
        if (value2 instanceof DfaVariableValue) {
            DfaVariableState state = this.findVariableState((DfaVariableValue)value2);
            if (state != null) {
                return state.myFactMap;
            }
            value2 = this.resolveVariableValue((DfaVariableValue)value2);
        }
        DfaValue finalValue = value2;
        return (DfaFactMap)StreamEx.of(DfaFactType.getTypes()).foldLeft((Object)DfaFactMap.EMPTY, (map, type2) -> DfaMemoryStateImpl.updateMap(map, type2, finalValue));
    }

    private static <T> DfaFactMap updateMap(DfaFactMap map, DfaFactType<T> factType, DfaValue value2) {
        return map.with(factType, factType.fromDfaValue(value2));
    }

    void setVariableState(DfaVariableValue dfaVar, DfaVariableState state) {
        assert (!this.myUnknownVariables.contains(dfaVar));
        if (state.equals(this.myDefaultVariableStates.get(dfaVar))) {
            this.myVariableStates.remove(dfaVar);
        } else {
            this.myVariableStates.put(dfaVar, state);
        }
        this.myCachedHash = null;
    }

    protected void updateEquivalentVariables(DfaVariableValue dfaVar, DfaVariableState state) {
        int index = this.getEqClassIndex(dfaVar);
        if (index != -1) {
            for (DfaValue value2 : this.myEqClasses.get(index).getMemberValues()) {
                if (value2 == dfaVar || !(value2 instanceof DfaVariableValue)) continue;
                this.setVariableState((DfaVariableValue)value2, state);
            }
        }
    }

    @NotNull
    private StreamEx<DfaVariableValue> equivalentVariables(DfaVariableValue var) {
        DfaVariableValue qualifier = var.getQualifier();
        if (qualifier == null) {
            StreamEx streamEx = StreamEx.empty();
            if (streamEx == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(37);
            }
            return streamEx;
        }
        int qualifierIndex = this.getEqClassIndex(qualifier);
        if (qualifierIndex == -1) {
            StreamEx streamEx = StreamEx.empty();
            if (streamEx == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(38);
            }
            return streamEx;
        }
        StreamEx streamEx = StreamEx.of(this.myEqClasses.get(qualifierIndex).getMemberValues()).without((Object)qualifier).select(DfaVariableValue.class).map(eqQualifier -> this.getFactory().getVarFactory().createVariableValue(var.getPsiVariable(), var.getVariableType(), var.isNegated(), (DfaVariableValue)eqQualifier));
        if (streamEx == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(39);
        }
        return streamEx;
    }

    private DfaVariableState findVariableState(DfaVariableValue var) {
        DfaVariableState state = this.myVariableStates.get(var);
        if (state != null) {
            return state;
        }
        return this.equivalentVariables(var).map(this.myVariableStates::get).nonNull().findFirst().orElse(null);
    }

    @NotNull
    DfaVariableState getVariableState(DfaVariableValue dfaVar) {
        DfaVariableState state = this.findVariableState(dfaVar);
        if (state == null) {
            state = this.myDefaultVariableStates.get(dfaVar);
            if (state == null) {
                state = this.createVariableState(dfaVar);
                DfaPsiType initialType = dfaVar.getDfaType();
                if (initialType != null) {
                    state = state.withInstanceofValue(initialType);
                    assert (state != null);
                }
                this.myDefaultVariableStates.put(dfaVar, state);
            }
            if (this.isUnknownState(dfaVar)) {
                DfaVariableState dfaVariableState = state.withNotNull();
                if (dfaVariableState == null) {
                    DfaMemoryStateImpl.$$$reportNull$$$0(40);
                }
                return dfaVariableState;
            }
        }
        DfaVariableState dfaVariableState = state;
        if (dfaVariableState == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(41);
        }
        return dfaVariableState;
    }

    void forVariableStates(BiConsumer<DfaVariableValue, DfaVariableState> consumer) {
        this.myVariableStates.forEach(consumer);
    }

    @NotNull
    protected DfaVariableState createVariableState(@NotNull DfaVariableValue var) {
        if (var == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(42);
        }
        DfaVariableState dfaVariableState = new DfaVariableState(var);
        if (dfaVariableState == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(43);
        }
        return dfaVariableState;
    }

    @Override
    public void flushFields() {
        LinkedHashSet vars = ContainerUtil.newLinkedHashSet(this.getChangedVariables());
        for (EqClass aClass : this.myEqClasses) {
            if (aClass == null) continue;
            vars.addAll(aClass.getVariables(true));
        }
        for (DfaVariableValue value2 : vars) {
            if (!value2.isFlushableByCalls() || value2.getQualifier() != null && this.getValueFact(value2.getQualifier(), DfaFactType.MUTABILITY) == Mutability.UNMODIFIABLE) continue;
            this.doFlush(value2, this.shouldMarkUnknown(value2));
        }
    }

    private boolean shouldMarkUnknown(@NotNull DfaVariableValue value2) {
        int eqClassIndex;
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(44);
        }
        if ((eqClassIndex = this.getEqClassIndex(value2)) < 0) {
            return false;
        }
        EqClass eqClass = this.myEqClasses.get(eqClassIndex);
        if (eqClass == null) {
            return false;
        }
        if (eqClass.findConstant(true) != null) {
            return true;
        }
        for (DistinctPairSet.DistinctPair pair : this.getDistinctClassPairs()) {
            EqClass otherClass = pair.getOtherClass(eqClassIndex);
            if (otherClass == null || otherClass.findConstant(true) == null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    Set<DfaVariableValue> getChangedVariables() {
        Set<DfaVariableValue> set = this.myVariableStates.keySet();
        if (set == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(45);
        }
        return set;
    }

    @Override
    public void flushVariable(@NotNull DfaVariableValue variable) {
        if (variable == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(46);
        }
        List updatedStack = ContainerUtil.map(this.myStack, value2 -> {
            if (variable == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(52);
            }
            return this.handleFlush(variable, (DfaValue)value2);
        });
        this.myStack.clear();
        for (DfaValue value3 : updatedStack) {
            this.myStack.push((Object)value3);
        }
        this.doFlush(variable, false);
        this.flushDependencies(variable);
        this.myUnknownVariables.remove(variable);
        this.myUnknownVariables.removeAll(this.myFactory.getVarFactory().getAllQualifiedBy(variable));
        this.myCachedHash = null;
    }

    void flushDependencies(@NotNull DfaVariableValue variable) {
        if (variable == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(47);
        }
        for (DfaVariableValue dependent : this.myFactory.getVarFactory().getAllQualifiedBy(variable)) {
            this.doFlush(dependent, false);
        }
    }

    @NotNull
    Set<DfaVariableValue> getUnknownVariables() {
        LinkedHashSet<DfaVariableValue> linkedHashSet = this.myUnknownVariables;
        if (linkedHashSet == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(48);
        }
        return linkedHashSet;
    }

    void doFlush(@NotNull DfaVariableValue varPlain, boolean markUnknown) {
        if (varPlain == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(49);
        }
        if (this.isNull(varPlain)) {
            this.myStack.replaceAll(val -> {
                if (varPlain == null) {
                    DfaMemoryStateImpl.$$$reportNull$$$0(51);
                }
                return val == varPlain ? this.myFactory.getConstFactory().getNull() : val;
            });
        }
        DfaVariableValue varNegated = varPlain.getNegatedValue();
        this.removeEquivalenceRelations(varPlain);
        this.myVariableStates.remove(varPlain);
        if (varNegated != null) {
            this.myVariableStates.remove(varNegated);
        }
        if (markUnknown) {
            this.myUnknownVariables.add(varPlain);
        }
        this.myCachedHash = null;
    }

    void removeEquivalenceRelations(@NotNull DfaVariableValue varPlain) {
        if (varPlain == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(50);
        }
        DfaVariableValue varNegated = varPlain.getNegatedValue();
        int idPlain = varPlain.getID();
        int idNegated = varNegated == null ? -1 : varNegated.getID();
        int[] classes2 = (int[])this.myIdToEqClassesIndices.get(idPlain);
        int[] negatedClasses = (int[])this.myIdToEqClassesIndices.get(idNegated);
        int[] result = ArrayUtil.mergeArrays((int[])((int[])ObjectUtils.notNull((Object)classes2, (Object)ArrayUtil.EMPTY_INT_ARRAY)), (int[])((int[])ObjectUtils.notNull((Object)negatedClasses, (Object)ArrayUtil.EMPTY_INT_ARRAY)));
        int interruptCount = 0;
        for (int varClassIndex : result) {
            Iterator<DistinctPairSet.DistinctPair> iterator;
            EqClass varClass = this.myEqClasses.get(varClassIndex);
            if ((++interruptCount & 0xF) == 0) {
                ProgressManager.checkCanceled();
            }
            varClass = new EqClass(varClass);
            this.myEqClasses.set(varClassIndex, varClass);
            for (int id : varClass.toNativeArray()) {
                int idUnwrapped;
                if (id != idPlain && id != idNegated && (idUnwrapped = DfaMemoryStateImpl.unwrap(this.myFactory.getValue(id)).getID()) != idPlain && idUnwrapped != idNegated) continue;
                varClass.removeValue(id);
            }
            if (varClass.isEmpty()) {
                this.myEqClasses.set(varClassIndex, null);
                iterator = this.myDistinctClasses.iterator();
                while (iterator.hasNext()) {
                    DistinctPairSet.DistinctPair pair = iterator.next();
                    if (pair.getOtherClass(varClassIndex) == null) continue;
                    iterator.remove();
                }
                continue;
            }
            if (!varClass.containsConstantsOnly()) continue;
            iterator = this.myDistinctClasses.iterator();
            while (iterator.hasNext()) {
                DistinctPairSet.DistinctPair pair = iterator.next();
                EqClass other = pair.getOtherClass(varClassIndex);
                if (other == null || !other.containsConstantsOnly()) continue;
                iterator.remove();
            }
        }
        this.removeAllFromMap(idPlain);
        this.removeAllFromMap(idNegated);
        this.checkInvariants();
        this.myCachedNonTrivialEqClasses = null;
        this.myCachedHash = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl";
                break;
            }
            case 5: 
            case 16: 
            case 18: 
            case 29: 
            case 36: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaValue";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaConstValue";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factType";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaRelation";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaVar";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaLeft";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaRight";
                break;
            }
            case 31: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 46: 
            case 47: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varPlain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createClosureState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "pop";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "peek";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEquivalentValues";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveVariableValue";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "equivalentVariables";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableState";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createVariableState";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedVariables";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnknownVariables";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateEqClassIndex";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canBeInRelation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getEquivalentValues";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canBeNaN";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isEffectivelyNaN";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getEqClassIndex";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "canBeReused";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "cacheable";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getConstantValue";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "castTopOfStack";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "applyFact";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "applyRelationCondition";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateVarStateOnComparison";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "applyEquivalenceRelation";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "applyBoxedRelation";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "applyUnboxedRelation";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "applyRelation";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "applyLessThanRelation";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getValueFact";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "forceVariableFact";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getFactMap";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createVariableState";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "shouldMarkUnknown";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "flushVariable";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "flushDependencies";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "doFlush";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "removeEquivalenceRelations";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doFlush$13";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "lambda$flushVariable$12";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyIdMap
    extends TIntObjectHashMap<int[]> {
        private MyIdMap(int initialCapacity) {
            super(initialCapacity);
        }

        public String toString() {
            final StringBuilder s = new StringBuilder("{");
            this.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<int[]>(){

                public boolean execute(int id, int[] set) {
                    DfaValue value2 = DfaMemoryStateImpl.this.myFactory.getValue(id);
                    s.append(value2).append(" -> ").append(Arrays.toString(set)).append(", ");
                    return true;
                }
            });
            s.append("}");
            return s.toString();
        }
    }
}

