/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public enum Mutability {
    UNKNOWN,
    MUTABLE,
    UNMODIFIABLE,
    UNMODIFIABLE_VIEW;


    @NotNull
    static Mutability getMutability(PsiModifierListOwner owner) {
        PsiParameterList list;
        PsiMethod method;
        if (owner instanceof PsiParameter && owner.getParent() instanceof PsiParameterList && (method = (PsiMethod)ObjectUtils.tryCast((Object)(list = (PsiParameterList)owner.getParent()).getParent(), PsiMethod.class)) != null) {
            int index = list.getParameterIndex((PsiParameter)owner);
            MutationSignature signature = MutationSignature.fromMethod(method);
            if (signature.mutatesArg(index)) {
                Mutability mutability = MUTABLE;
                if (mutability == null) {
                    Mutability.$$$reportNull$$$0(0);
                }
                return mutability;
            }
            if (signature.preservesArg(index) && PsiTreeUtil.findChildOfAnyType((PsiElement)method.getBody(), (Class[])new Class[]{PsiLambdaExpression.class, PsiClass.class}) == null) {
                Mutability mutability = UNMODIFIABLE_VIEW;
                if (mutability == null) {
                    Mutability.$$$reportNull$$$0(1);
                }
                return mutability;
            }
            Mutability mutability = UNKNOWN;
            if (mutability == null) {
                Mutability.$$$reportNull$$$0(2);
            }
            return mutability;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, Collections.singleton("org.jetbrains.annotations.Unmodifiable"), (int)7)) {
            Mutability mutability = UNMODIFIABLE;
            if (mutability == null) {
                Mutability.$$$reportNull$$$0(3);
            }
            return mutability;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, Collections.singleton("org.jetbrains.annotations.UnmodifiableView"), (int)7)) {
            Mutability mutability = UNMODIFIABLE_VIEW;
            if (mutability == null) {
                Mutability.$$$reportNull$$$0(4);
            }
            return mutability;
        }
        Mutability mutability = UNKNOWN;
        if (mutability == null) {
            Mutability.$$$reportNull$$$0(5);
        }
        return mutability;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/Mutability", "getMutability"));
    }
}

