/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeConstraint {
    public static final TypeConstraint EMPTY = new TypeConstraint(Collections.emptySet(), Collections.emptySet());
    @NotNull
    private final Set<DfaPsiType> myInstanceofValues;
    @NotNull
    private final Set<DfaPsiType> myNotInstanceofValues;

    private TypeConstraint(@NotNull Set<DfaPsiType> instanceofValues, @NotNull Set<DfaPsiType> notInstanceofValues) {
        if (instanceofValues == null) {
            TypeConstraint.$$$reportNull$$$0(0);
        }
        if (notInstanceofValues == null) {
            TypeConstraint.$$$reportNull$$$0(1);
        }
        this.myInstanceofValues = instanceofValues;
        this.myNotInstanceofValues = notInstanceofValues;
    }

    private static TypeConstraint create(@NotNull Set<DfaPsiType> instanceofValues, @NotNull Set<DfaPsiType> notInstanceofValues) {
        if (instanceofValues == null) {
            TypeConstraint.$$$reportNull$$$0(2);
        }
        if (notInstanceofValues == null) {
            TypeConstraint.$$$reportNull$$$0(3);
        }
        if (instanceofValues.isEmpty() && notInstanceofValues.isEmpty()) {
            return EMPTY;
        }
        if (instanceofValues.isEmpty()) {
            instanceofValues = Collections.emptySet();
        } else if (instanceofValues.size() == 1) {
            instanceofValues = Collections.singleton(instanceofValues.iterator().next());
        }
        if (notInstanceofValues.isEmpty()) {
            notInstanceofValues = Collections.emptySet();
        } else if (notInstanceofValues.size() == 1) {
            notInstanceofValues = Collections.singleton(notInstanceofValues.iterator().next());
        }
        return new TypeConstraint(instanceofValues, notInstanceofValues);
    }

    boolean checkInstanceofValue(@NotNull DfaPsiType dfaType) {
        if (dfaType == null) {
            TypeConstraint.$$$reportNull$$$0(4);
        }
        if (this.myInstanceofValues.contains(dfaType)) {
            return true;
        }
        for (DfaPsiType dfaTypeValue : this.myNotInstanceofValues) {
            if (!dfaTypeValue.isAssignableFrom(dfaType)) continue;
            return false;
        }
        for (DfaPsiType dfaTypeValue : this.myInstanceofValues) {
            if (dfaType.isConvertibleFrom(dfaTypeValue)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public TypeConstraint withInstanceofValue(@NotNull DfaPsiType type2) {
        PsiType psiType;
        if (type2 == null) {
            TypeConstraint.$$$reportNull$$$0(5);
        }
        if ((psiType = type2.getPsiType()) instanceof PsiPrimitiveType || LambdaUtil.notInferredType((PsiType)psiType)) {
            return this;
        }
        if (!this.checkInstanceofValue(type2)) {
            return null;
        }
        ArrayList<DfaPsiType> moreGeneric = new ArrayList<DfaPsiType>();
        for (DfaPsiType alreadyInstanceof : this.myInstanceofValues) {
            if (type2.isAssignableFrom(alreadyInstanceof)) {
                return this;
            }
            if (!alreadyInstanceof.isAssignableFrom(type2)) continue;
            moreGeneric.add(alreadyInstanceof);
        }
        HashSet newInstanceof = ContainerUtil.newHashSet(this.myInstanceofValues);
        newInstanceof.removeAll(moreGeneric);
        newInstanceof.add(type2);
        return TypeConstraint.create(newInstanceof, this.myNotInstanceofValues);
    }

    @Nullable
    public TypeConstraint withNotInstanceofValue(DfaPsiType type2) {
        if (this.myNotInstanceofValues.contains(type2)) {
            return this;
        }
        for (DfaPsiType dfaPsiType : this.myInstanceofValues) {
            if (!type2.isAssignableFrom(dfaPsiType)) continue;
            return null;
        }
        ArrayList<DfaPsiType> moreSpecific = new ArrayList<DfaPsiType>();
        for (DfaPsiType alreadyNotInstanceof : this.myNotInstanceofValues) {
            if (alreadyNotInstanceof.isAssignableFrom(type2)) {
                return this;
            }
            if (!type2.isAssignableFrom(alreadyNotInstanceof)) continue;
            moreSpecific.add(alreadyNotInstanceof);
        }
        HashSet hashSet = ContainerUtil.newHashSet(this.myNotInstanceofValues);
        hashSet.removeAll(moreSpecific);
        hashSet.add(type2);
        return TypeConstraint.create(this.myInstanceofValues, hashSet);
    }

    @NotNull
    TypeConstraint withoutType(@NotNull DfaPsiType type2) {
        if (type2 == null) {
            TypeConstraint.$$$reportNull$$$0(6);
        }
        if (this.myInstanceofValues.contains(type2)) {
            HashSet newInstanceof = ContainerUtil.newHashSet(this.myInstanceofValues);
            newInstanceof.remove(type2);
            TypeConstraint typeConstraint = TypeConstraint.create(newInstanceof, this.myNotInstanceofValues);
            if (typeConstraint == null) {
                TypeConstraint.$$$reportNull$$$0(7);
            }
            return typeConstraint;
        }
        if (this.myNotInstanceofValues.contains(type2)) {
            HashSet newNotInstanceof = ContainerUtil.newHashSet(this.myNotInstanceofValues);
            newNotInstanceof.remove(type2);
            TypeConstraint typeConstraint = TypeConstraint.create(this.myInstanceofValues, newNotInstanceof);
            if (typeConstraint == null) {
                TypeConstraint.$$$reportNull$$$0(8);
            }
            return typeConstraint;
        }
        TypeConstraint typeConstraint = this;
        if (typeConstraint == null) {
            TypeConstraint.$$$reportNull$$$0(9);
        }
        return typeConstraint;
    }

    @Nullable
    public PsiType getPsiType() {
        PsiType[] conjuncts = (PsiType[])StreamEx.of(this.myInstanceofValues).map(DfaPsiType::getPsiType).toArray((Object[])PsiType.EMPTY_ARRAY);
        return conjuncts.length == 0 ? null : PsiIntersectionType.createIntersection((boolean)true, (PsiType[])conjuncts);
    }

    boolean isSuperStateOf(@NotNull TypeConstraint that) {
        if (that == null) {
            TypeConstraint.$$$reportNull$$$0(10);
        }
        if (that.myNotInstanceofValues.containsAll(this.myNotInstanceofValues) && that.myInstanceofValues.containsAll(this.myInstanceofValues)) {
            return true;
        }
        if (this.myNotInstanceofValues.isEmpty() && that.myNotInstanceofValues.isEmpty() && this.myInstanceofValues.size() == 1) {
            DfaPsiType type2 = this.myInstanceofValues.iterator().next();
            return that.myInstanceofValues.stream().allMatch(type2::isAssignableFrom);
        }
        return false;
    }

    @Nullable
    public TypeConstraint union(@NotNull TypeConstraint other) {
        if (other == null) {
            TypeConstraint.$$$reportNull$$$0(11);
        }
        if (this.isSuperStateOf(other)) {
            return this;
        }
        if (other.isSuperStateOf(this)) {
            return other;
        }
        HashSet<DfaPsiType> leftTypes = new HashSet<DfaPsiType>(this.myInstanceofValues);
        HashSet<DfaPsiType> leftNotTypes = new HashSet<DfaPsiType>(this.myNotInstanceofValues);
        HashSet<DfaPsiType> rightTypes = new HashSet<DfaPsiType>(other.myInstanceofValues);
        HashSet<DfaPsiType> rightNotTypes = new HashSet<DfaPsiType>(other.myNotInstanceofValues);
        TypeConstraint.filter(leftTypes, rightTypes, rightNotTypes);
        TypeConstraint.filter(rightTypes, leftTypes, leftNotTypes);
        TypeConstraint left = TypeConstraint.create(leftTypes, leftNotTypes);
        TypeConstraint right = TypeConstraint.create(rightTypes, rightNotTypes);
        if (left.isSuperStateOf(right)) {
            return left;
        }
        if (right.isSuperStateOf(left)) {
            return right;
        }
        return null;
    }

    private static void filter(Set<DfaPsiType> leftTypes, Set<DfaPsiType> rightTypes, Set<DfaPsiType> rightNotTypes) {
        HashSet addTypes = new HashSet();
        Iterator<DfaPsiType> iterator = leftTypes.iterator();
        while (iterator.hasNext()) {
            DfaPsiType type2 = iterator.next();
            if (!rightNotTypes.remove(type2)) continue;
            iterator.remove();
            ((StreamEx)StreamEx.of(rightTypes).filter(t -> t.isAssignableFrom(type2))).into(addTypes);
        }
        leftTypes.addAll(addTypes);
    }

    @NotNull
    public Set<DfaPsiType> getInstanceofValues() {
        Set<DfaPsiType> set = Collections.unmodifiableSet(this.myInstanceofValues);
        if (set == null) {
            TypeConstraint.$$$reportNull$$$0(12);
        }
        return set;
    }

    @NotNull
    public Set<DfaPsiType> getNotInstanceofValues() {
        Set<DfaPsiType> set = Collections.unmodifiableSet(this.myNotInstanceofValues);
        if (set == null) {
            TypeConstraint.$$$reportNull$$$0(13);
        }
        return set;
    }

    public boolean isEmpty() {
        return this.myInstanceofValues.isEmpty() && this.myNotInstanceofValues.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeConstraint that = (TypeConstraint)o;
        return Objects.equals(this.myInstanceofValues, that.myInstanceofValues) && Objects.equals(this.myNotInstanceofValues, that.myNotInstanceofValues);
    }

    public int hashCode() {
        return Objects.hash(this.myInstanceofValues, this.myNotInstanceofValues);
    }

    public String toString() {
        return EntryStream.of((Object)"instanceof ", this.myInstanceofValues, (Object)"not instanceof ", this.myNotInstanceofValues).removeValues(Set::isEmpty).mapKeyValue((prefix, set) -> StreamEx.of((Collection)set).joining((CharSequence)",", (CharSequence)prefix, (CharSequence)"")).joining((CharSequence)" ");
    }

    @Nullable
    public static DfaFactMap withInstanceOf(@NotNull DfaFactMap map, @NotNull DfaPsiType type2) {
        TypeConstraint constraint;
        if (map == null) {
            TypeConstraint.$$$reportNull$$$0(14);
        }
        if (type2 == null) {
            TypeConstraint.$$$reportNull$$$0(15);
        }
        if ((constraint = map.get(DfaFactType.TYPE_CONSTRAINT)) == null) {
            constraint = EMPTY;
        }
        return (constraint = constraint.withInstanceofValue(type2)) == null ? null : map.with(DfaFactType.TYPE_CONSTRAINT, constraint);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceofValues";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notInstanceofValues";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaType";
                break;
            }
            case 5: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/TypeConstraint";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/TypeConstraint";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceofValues";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotInstanceofValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkInstanceofValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withInstanceofValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withoutType";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isSuperStateOf";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "withInstanceOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

