/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.lambda;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantLambdaParameterTypeInspection
extends AbstractBaseJavaLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance(RedundantLambdaParameterTypeInspection.class);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantLambdaParameterTypeInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitParameterList(PsiParameterList parameterList) {
                super.visitParameterList(parameterList);
                if (RedundantLambdaParameterTypeInspection.isApplicable(parameterList)) {
                    holder.registerProblem((PsiElement)parameterList, "Lambda parameter type is redundant", new LocalQuickFix[]{new LambdaParametersFix()});
                }
            }
        };
        if (javaElementVisitor == null) {
            RedundantLambdaParameterTypeInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    private static boolean isApplicable(@NotNull PsiParameterList parameterList) {
        PsiParameter[] parameters2;
        PsiElement parent;
        if (parameterList == null) {
            RedundantLambdaParameterTypeInspection.$$$reportNull$$$0(2);
        }
        if (!((parent = parameterList.getParent()) instanceof PsiLambdaExpression)) {
            return false;
        }
        PsiLambdaExpression expression2 = (PsiLambdaExpression)parent;
        for (PsiParameter parameter2 : parameters2 = parameterList.getParameters()) {
            if (parameter2.getTypeElement() != null) continue;
            return false;
        }
        if (parameters2.length == 0) {
            return false;
        }
        PsiType functionalInterfaceType = expression2.getFunctionalInterfaceType();
        if (functionalInterfaceType != null) {
            PsiElement gParent;
            PsiElement lambdaParent = expression2.getParent();
            if (lambdaParent instanceof PsiExpressionList && (gParent = lambdaParent.getParent()) instanceof PsiCallExpression && ((PsiCallExpression)gParent).getTypeArguments().length == 0) {
                JavaResolveResult resolveResult = ((PsiCallExpression)gParent).resolveMethodGenerics();
                PsiMethod method = (PsiMethod)resolveResult.getElement();
                if (method == null) {
                    return false;
                }
                int idx = LambdaUtil.getLambdaIdx((PsiExpressionList)((PsiExpressionList)lambdaParent), (PsiElement)expression2);
                if (idx < 0) {
                    return false;
                }
                PsiCallExpression copy = (PsiCallExpression)gParent.copy();
                PsiLambdaExpression lambdaToStripTypeParameters = (PsiLambdaExpression)copy.getArgumentList().getExpressions()[idx];
                for (PsiParameter parameter3 : lambdaToStripTypeParameters.getParameterList().getParameters()) {
                    parameter3.getTypeElement().delete();
                }
                return functionalInterfaceType.equals(lambdaToStripTypeParameters.getFunctionalInterfaceType());
            }
            return true;
        }
        return false;
    }

    private static void removeTypes(PsiLambdaExpression lambdaExpression) {
        if (lambdaExpression != null) {
            Object[] parameters2 = lambdaExpression.getParameterList().getParameters();
            String text2 = parameters2.length == 1 ? parameters2[0].getName() : "(" + StringUtil.join((Object[])parameters2, PsiNamedElement::getName, (String)", ") + ")";
            PsiLambdaExpression expression2 = (PsiLambdaExpression)JavaPsiFacade.getElementFactory((Project)lambdaExpression.getProject()).createExpressionFromText(text2 + "->{}", (PsiElement)lambdaExpression);
            lambdaExpression.getParameterList().replace((PsiElement)expression2.getParameterList());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/lambda/RedundantLambdaParameterTypeInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/lambda/RedundantLambdaParameterTypeInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LambdaParametersFix
    implements LocalQuickFix {
        private LambdaParametersFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Remove redundant parameter types" == null) {
                LambdaParametersFix.$$$reportNull$$$0(0);
            }
            return "Remove redundant parameter types";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            PsiElement parent;
            if (project == null) {
                LambdaParametersFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                LambdaParametersFix.$$$reportNull$$$0(2);
            }
            if ((parent = (element = descriptor.getPsiElement()).getParent()) instanceof PsiLambdaExpression) {
                RedundantLambdaParameterTypeInspection.removeTypes((PsiLambdaExpression)parent);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/lambda/RedundantLambdaParameterTypeInspection$LambdaParametersFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/lambda/RedundantLambdaParameterTypeInspection$LambdaParametersFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

