/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reflectiveAccess;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.reflectiveAccess.JavaReflectionInvocationInspection;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaLangClassMemberReference;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.CheckBox;
import com.siyeh.ig.ui.UiUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaReflectionMemberAccessInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Set<String> MEMBER_METHOD_NAMES = Collections.unmodifiableSet(ContainerUtil.set((Object[])new String[]{"getField", "getDeclaredField", "getMethod", "getDeclaredMethod", "getConstructor", "getDeclaredConstructor"}));
    private final List<String> ignoredClassNames = new ArrayList<String>();
    public boolean checkMemberExistsInNonFinalClasses = true;
    public String ignoredClassNamesString = "java.lang.Object,java.lang.Throwable";

    public JavaReflectionMemberAccessInspection() {
        this.parseSettings();
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        ListTable table = new ListTable(new ListWrappingTableModel(this.ignoredClassNames, InspectionsBundle.message((String)"inspection.reflection.member.access.check.exists.exclude", (Object[])new Object[0])));
        JPanel tablePanel = UiUtils.createAddRemoveTreeClassChooserPanel(table, InspectionsBundle.message((String)"inspection.reflection.member.access.check.exists.exclude.chooser", (Object[])new Object[0]), new String[0]);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        CheckBox checkBox = new CheckBox(InspectionsBundle.message((String)"inspection.reflection.member.access.check.exists", (Object[])new Object[0]), (InspectionProfileEntry)this, "checkMemberExistsInNonFinalClasses");
        panel.add((Component)checkBox, constraints);
        constraints.weighty = 1.0;
        constraints.gridy = 1;
        constraints.fill = 1;
        panel.add((Component)tablePanel, constraints);
        return panel;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            JavaReflectionMemberAccessInspection.$$$reportNull$$$0(0);
        }
        super.readSettings(element);
        this.parseSettings();
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            JavaReflectionMemberAccessInspection.$$$reportNull$$$0(1);
        }
        this.collectSettings();
        super.writeSettings(element);
    }

    private void parseSettings() {
        this.ignoredClassNames.clear();
        ContainerUtil.addAll(this.ignoredClassNames, (Object[])this.ignoredClassNamesString.split(","));
    }

    private void collectSettings() {
        this.ignoredClassNamesString = this.ignoredClassNames.stream().collect(Collectors.joining(","));
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            JavaReflectionMemberAccessInspection.$$$reportNull$$$0(2);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                PsiClass containingClass;
                PsiMethod method;
                super.visitMethodCallExpression(expression2);
                String referenceName = expression2.getMethodExpression().getReferenceName();
                if (referenceName != null && MEMBER_METHOD_NAMES.contains(referenceName) && (method = expression2.resolveMethod()) != null && (containingClass = method.getContainingClass()) != null && "java.lang.Class".equals(containingClass.getQualifiedName())) {
                    switch (referenceName) {
                        case "getField": {
                            JavaReflectionMemberAccessInspection.this.checkField(expression2, false, holder);
                            break;
                        }
                        case "getDeclaredField": {
                            JavaReflectionMemberAccessInspection.this.checkField(expression2, true, holder);
                            break;
                        }
                        case "getMethod": {
                            JavaReflectionMemberAccessInspection.this.checkMethod(expression2, false, holder);
                            break;
                        }
                        case "getDeclaredMethod": {
                            JavaReflectionMemberAccessInspection.this.checkMethod(expression2, true, holder);
                            break;
                        }
                        case "getConstructor": {
                            JavaReflectionMemberAccessInspection.this.checkConstructor(expression2, false, holder);
                            break;
                        }
                        case "getDeclaredConstructor": {
                            JavaReflectionMemberAccessInspection.this.checkConstructor(expression2, true, holder);
                        }
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            JavaReflectionMemberAccessInspection.$$$reportNull$$$0(3);
        }
        return javaElementVisitor;
    }

    private void checkField(@NotNull PsiMethodCallExpression callExpression, boolean isDeclared, @NotNull ProblemsHolder holder) {
        JavaReflectionReferenceUtil.ReflectiveClass ownerClass;
        PsiExpression nameExpression;
        String fieldName;
        PsiExpression[] arguments;
        if (callExpression == null) {
            JavaReflectionMemberAccessInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            JavaReflectionMemberAccessInspection.$$$reportNull$$$0(5);
        }
        if ((arguments = callExpression.getArgumentList().getExpressions()).length != 0 && (fieldName = JavaReflectionMemberAccessInspection.getMemberName(nameExpression = arguments[0])) != null && (ownerClass = JavaReflectionMemberAccessInspection.getOwnerClass(callExpression)) != null && ownerClass.isExact()) {
            PsiField field = ownerClass.getPsiClass().findFieldByName(fieldName, true);
            if (field == null) {
                if (this.reportUnresolvedMembersOf(ownerClass)) {
                    holder.registerProblem((PsiElement)nameExpression, InspectionsBundle.message((String)"inspection.reflection.member.access.cannot.resolve.field", (Object[])new Object[]{fieldName}), new LocalQuickFix[0]);
                }
                return;
            }
            if (isDeclared && field.getContainingClass() != ownerClass.getPsiClass()) {
                holder.registerProblem((PsiElement)nameExpression, InspectionsBundle.message((String)"inspection.reflection.member.access.field.not.in.class", (Object[])new Object[]{fieldName, ownerClass.getPsiClass().getQualifiedName()}), new LocalQuickFix[0]);
                return;
            }
            if (!isDeclared && !field.hasModifierProperty("public")) {
                holder.registerProblem((PsiElement)nameExpression, InspectionsBundle.message((String)"inspection.reflection.member.access.field.not.public", (Object[])new Object[]{fieldName}), new LocalQuickFix[0]);
            }
        }
    }

    private void checkMethod(@NotNull PsiMethodCallExpression callExpression, boolean isDeclared, @NotNull ProblemsHolder holder) {
        JavaReflectionReferenceUtil.ReflectiveClass ownerClass;
        PsiExpression nameExpression;
        String methodName;
        PsiExpression[] arguments;
        if (callExpression == null) {
            JavaReflectionMemberAccessInspection.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            JavaReflectionMemberAccessInspection.$$$reportNull$$$0(7);
        }
        if ((arguments = callExpression.getArgumentList().getExpressions()).length != 0 && (methodName = JavaReflectionMemberAccessInspection.getMemberName(nameExpression = arguments[0])) != null && (ownerClass = JavaReflectionMemberAccessInspection.getOwnerClass(callExpression)) != null && ownerClass.isExact()) {
            PsiMethod[] methods = ownerClass.getPsiClass().findMethodsByName(methodName, true);
            if (methods.length == 0) {
                if (this.reportUnresolvedMembersOf(ownerClass)) {
                    holder.registerProblem((PsiElement)nameExpression, InspectionsBundle.message((String)"inspection.reflection.member.access.cannot.resolve.method", (Object[])new Object[]{methodName}), new LocalQuickFix[0]);
                }
                return;
            }
            PsiMethod matchingMethod = JavaReflectionMemberAccessInspection.matchMethod(methods, arguments, 1);
            if (matchingMethod == null) {
                if (this.reportUnresolvedMembersOf(ownerClass)) {
                    holder.registerProblem((PsiElement)nameExpression, InspectionsBundle.message((String)"inspection.reflection.member.access.cannot.resolve.method.arguments", (Object[])new Object[]{methodName}), new LocalQuickFix[0]);
                }
                return;
            }
            if (isDeclared && matchingMethod.getContainingClass() != ownerClass.getPsiClass()) {
                holder.registerProblem((PsiElement)nameExpression, InspectionsBundle.message((String)"inspection.reflection.member.access.method.not.in.class", (Object[])new Object[]{methodName, ownerClass.getPsiClass().getQualifiedName()}), new LocalQuickFix[0]);
                return;
            }
            if (!isDeclared && !matchingMethod.hasModifierProperty("public")) {
                holder.registerProblem((PsiElement)nameExpression, InspectionsBundle.message((String)"inspection.reflection.member.access.method.not.public", (Object[])new Object[]{methodName}), new LocalQuickFix[0]);
            }
        }
    }

    private void checkConstructor(@NotNull PsiMethodCallExpression callExpression, boolean isDeclared, @NotNull ProblemsHolder holder) {
        JavaReflectionReferenceUtil.ReflectiveClass ownerClass;
        if (callExpression == null) {
            JavaReflectionMemberAccessInspection.$$$reportNull$$$0(8);
        }
        if (holder == null) {
            JavaReflectionMemberAccessInspection.$$$reportNull$$$0(9);
        }
        if ((ownerClass = JavaReflectionMemberAccessInspection.getOwnerClass(callExpression)) != null && ownerClass.isExact()) {
            PsiMethod constructorOrClass;
            PsiMethod[] methods = ownerClass.getPsiClass().getConstructors();
            PsiExpression[] arguments = callExpression.getArgumentList().getExpressions();
            if (methods.length != 0) {
                constructorOrClass = JavaReflectionMemberAccessInspection.matchMethod(methods, arguments, 0);
            } else {
                PsiClass psiClass = constructorOrClass = arguments.length == 0 ? ownerClass.getPsiClass() : null;
            }
            if (constructorOrClass == null) {
                if (this.reportUnresolvedMembersOf(ownerClass)) {
                    holder.registerProblem((PsiElement)callExpression.getArgumentList(), InspectionsBundle.message((String)"inspection.reflection.member.access.cannot.resolve.constructor.arguments", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
                return;
            }
            if (!isDeclared && !constructorOrClass.hasModifierProperty("public")) {
                holder.registerProblem((PsiElement)callExpression.getArgumentList(), InspectionsBundle.message((String)"inspection.reflection.member.access.constructor.not.public", (Object[])new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    private boolean reportUnresolvedMembersOf(@NotNull JavaReflectionReferenceUtil.ReflectiveClass ownerClass) {
        if (ownerClass == null) {
            JavaReflectionMemberAccessInspection.$$$reportNull$$$0(10);
        }
        return (this.checkMemberExistsInNonFinalClasses || ownerClass.getPsiClass().hasModifierProperty("final")) && !this.ignoredClassNames.contains(ownerClass.getPsiClass().getQualifiedName());
    }

    @Contract(value="null->null")
    @Nullable
    private static String getMemberName(@Nullable PsiExpression memberNameArgument) {
        return JavaReflectionReferenceUtil.computeConstantExpression(memberNameArgument, String.class);
    }

    @Nullable
    private static JavaReflectionReferenceUtil.ReflectiveClass getOwnerClass(@NotNull PsiMethodCallExpression callExpression) {
        if (callExpression == null) {
            JavaReflectionMemberAccessInspection.$$$reportNull$$$0(11);
        }
        return JavaReflectionReferenceUtil.getReflectiveClass(callExpression.getMethodExpression().getQualifierExpression());
    }

    @Nullable
    private static PsiMethod matchMethod(PsiMethod[] methods, PsiExpression[] arguments, int argumentOffset) {
        JavaReflectionInvocationInspection.Arguments methodArguments = JavaReflectionInvocationInspection.getActualMethodArguments(arguments, argumentOffset, true);
        if (methodArguments == null) {
            return null;
        }
        List argumentTypes = ContainerUtil.map((Object[])methodArguments.expressions, JavaReflectionReferenceUtil::getReflectiveType);
        return JavaLangClassMemberReference.matchMethod(methods, argumentTypes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reflectiveAccess/JavaReflectionMemberAccessInspection";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reflectiveAccess/JavaReflectionMemberAccessInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkField";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkConstructor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reportUnresolvedMembersOf";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOwnerClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

