/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.streamMigration.OperationReductionMigration;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BaseStreamApiMigration {
    private boolean myShouldWarn;
    private final String myReplacement;

    protected BaseStreamApiMigration(boolean shouldWarn, String replacement) {
        this.myShouldWarn = shouldWarn;
        this.myReplacement = replacement;
    }

    public String getReplacement() {
        return this.myReplacement;
    }

    abstract PsiElement migrate(@NotNull Project var1, @NotNull PsiElement var2, @NotNull TerminalBlock var3);

    public boolean isShouldWarn() {
        return this.myShouldWarn;
    }

    public void setShouldWarn(boolean shouldWarn) {
        this.myShouldWarn = shouldWarn;
    }

    static PsiElement replaceWithOperation(PsiStatement loopStatement, PsiVariable var, String streamText, PsiType expressionType, OperationReductionMigration.ReductionOperation reductionOperation, CommentTracker ct) {
        PsiExpression initializer;
        ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus(var, loopStatement);
        if (status != ControlFlowUtils.InitializerUsageStatus.UNKNOWN && (initializer = var.getInitializer()) != null && reductionOperation.getInitializerExpressionRestriction().test(initializer)) {
            PsiType type2 = var.getType();
            String replacement = (type2.isAssignableFrom(expressionType) ? "" : "(" + type2.getCanonicalText() + ") ") + streamText;
            return BaseStreamApiMigration.replaceInitializer(loopStatement, var, initializer, replacement, status, ct);
        }
        return ct.replaceAndRestoreComments((PsiElement)loopStatement, var.getName() + reductionOperation.getOperation() + "=" + streamText + ";");
    }

    static PsiElement replaceInitializer(PsiStatement loopStatement, PsiVariable var, PsiExpression initializer, String replacement, ControlFlowUtils.InitializerUsageStatus status, CommentTracker ct) {
        if (status == ControlFlowUtils.InitializerUsageStatus.DECLARED_JUST_BEFORE) {
            ct.replace((PsiElement)initializer, replacement);
            BaseStreamApiMigration.removeLoop(ct, loopStatement);
            return var;
        }
        if (status == ControlFlowUtils.InitializerUsageStatus.AT_WANTED_PLACE_ONLY) {
            ct.delete((PsiElement)initializer);
        }
        return ct.replaceAndRestoreComments((PsiElement)loopStatement, var.getName() + " = " + replacement + ";");
    }

    @Nullable
    static PsiElement replaceWithFindExtremum(@NotNull CommentTracker ct, @NotNull PsiStatement loopStatement, @NotNull PsiVariable extremumHolder, @NotNull String streamText, @Nullable PsiVariable keyExtremum) {
        if (ct == null) {
            BaseStreamApiMigration.$$$reportNull$$$0(0);
        }
        if (loopStatement == null) {
            BaseStreamApiMigration.$$$reportNull$$$0(1);
        }
        if (extremumHolder == null) {
            BaseStreamApiMigration.$$$reportNull$$$0(2);
        }
        if (streamText == null) {
            BaseStreamApiMigration.$$$reportNull$$$0(3);
        }
        if (keyExtremum != null) {
            ct.delete((PsiElement)keyExtremum);
        }
        ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus(extremumHolder, loopStatement);
        return BaseStreamApiMigration.replaceInitializer(loopStatement, extremumHolder, extremumHolder.getInitializer(), streamText, status, ct);
    }

    static void removeLoop(CommentTracker ct, @NotNull PsiStatement statement) {
        PsiElement parent;
        if (statement == null) {
            BaseStreamApiMigration.$$$reportNull$$$0(4);
        }
        if ((parent = statement.getParent()) instanceof PsiLabeledStatement) {
            ct.deleteAndRestoreComments(parent);
        } else {
            ct.deleteAndRestoreComments((PsiElement)statement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ct";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loopStatement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extremumHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/streamMigration/BaseStreamApiMigration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceWithFindExtremum";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeLoop";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

