/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.streamMigration.CollectMigration;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.Objects;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FuseStreamOperationsInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher STREAM_COLLECT = CallMatcher.instanceCall("java.util.stream.Stream", "collect").parameterTypes("java.util.stream.Collector");
    private static final CallMatcher COLLECT_TO_COLLECTION = CallMatcher.anyOf(CallMatcher.staticCall("java.util.stream.Collectors", "toList", "toSet").parameterCount(0), CallMatcher.staticCall("java.util.stream.Collectors", "toCollection").parameterCount(1));

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FuseStreamOperationsInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                FuseStreamOperationsInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                if (STREAM_COLLECT.test(call)) {
                    PsiMethodCallExpression arg = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getArgumentList().getExpressions()[0]), PsiMethodCallExpression.class);
                    if (COLLECT_TO_COLLECTION.test(arg)) {
                        CollectMigration.CollectTerminal newTerminal = FuseStreamOperationsInspection.extractTerminal(call);
                        if (newTerminal == null) {
                            return;
                        }
                        PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
                        if (nameElement == null) {
                            return;
                        }
                        String fusedSteps = ((StreamEx)newTerminal.fusedElements().mapLastOrElse(s -> StreamEx.of((Object[])new String[]{", ", s}), s -> StreamEx.of((Object[])new String[]{" and ", s})).flatMap(Function.identity()).skip(1L)).joining();
                        holder.registerProblem(nameElement, InspectionsBundle.message((String)"inspection.fuse.stream.operations.message", (Object[])new Object[]{fusedSteps}), new LocalQuickFix[]{new FuseStreamOperationsFix(fusedSteps)});
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            FuseStreamOperationsInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    @Nullable
    private static CollectMigration.CollectTerminal extractTerminal(PsiMethodCallExpression streamChain) {
        PsiElement nextElement;
        StreamCollectChain terminal;
        if (streamChain.getMethodExpression().getQualifierExpression() == null) {
            return null;
        }
        PsiMethodCallExpression collector = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)ArrayUtil.getFirstElement((Object[])streamChain.getArgumentList().getExpressions()))), PsiMethodCallExpression.class);
        PsiLocalVariable var = (PsiLocalVariable)ObjectUtils.tryCast((Object)streamChain.getParent(), PsiLocalVariable.class);
        if (var == null) {
            terminal = new StreamCollectChainNoVar(streamChain, collector);
            nextElement = RefactoringUtil.getParentStatement((PsiElement)streamChain, false);
        } else {
            PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)var.getParent(), PsiDeclarationStatement.class);
            if (declaration2 == null || declaration2.getDeclaredElements().length != 1) {
                return null;
            }
            terminal = new StreamCollectChain(var, streamChain, collector);
            nextElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)declaration2);
        }
        CollectMigration.CollectTerminal newTerminal = CollectMigration.includePostStatements(terminal, nextElement);
        if (newTerminal == terminal) {
            return null;
        }
        return newTerminal;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/streamMigration/FuseStreamOperationsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/streamMigration/FuseStreamOperationsInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FuseStreamOperationsFix
    implements LocalQuickFix {
        private String myFusedSteps;

        public FuseStreamOperationsFix(String fusedSteps) {
            this.myFusedSteps = fusedSteps;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.fuse.stream.operations.fix.name", (Object[])new Object[]{this.myFusedSteps});
            if (string == null) {
                FuseStreamOperationsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.fuse.stream.operations.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                FuseStreamOperationsFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement result;
            PsiMethodCallExpression chain;
            if (project == null) {
                FuseStreamOperationsFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                FuseStreamOperationsFix.$$$reportNull$$$0(3);
            }
            if ((chain = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiMethodCallExpression.class)) == null) {
                return;
            }
            CollectMigration.CollectTerminal terminal = FuseStreamOperationsInspection.extractTerminal(chain);
            if (terminal == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            String stream = terminal.generateIntermediate(ct) + terminal.generateTerminal(ct);
            PsiElement toReplace = terminal.getElementToReplace();
            if (toReplace != null) {
                result = ct.replaceAndRestoreComments(toReplace, stream);
            } else {
                PsiVariable variable = (PsiVariable)Objects.requireNonNull(terminal.getTargetVariable());
                PsiExpression initializer = Objects.requireNonNull(variable.getInitializer());
                result = ct.replaceAndRestoreComments((PsiElement)initializer, stream);
            }
            terminal.cleanUp();
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/streamMigration/FuseStreamOperationsInspection$FuseStreamOperationsFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/streamMigration/FuseStreamOperationsInspection$FuseStreamOperationsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class StreamCollectChainNoVar
    extends StreamCollectChain {
        protected StreamCollectChainNoVar(PsiMethodCallExpression chain, PsiMethodCallExpression collector) {
            super(null, chain, collector);
        }

        StreamEx<PsiExpression> targetReferences() {
            return StreamEx.of((Object)this.myChain);
        }

        @Override
        boolean isTargetReference(PsiExpression expression2) {
            return expression2 == this.myChain;
        }
    }

    private static class StreamCollectChain
    extends CollectMigration.CollectTerminal {
        final PsiMethodCallExpression myCollector;
        final PsiMethodCallExpression myChain;

        protected StreamCollectChain(PsiLocalVariable variable, PsiMethodCallExpression chain, PsiMethodCallExpression collector) {
            super(variable, null, ControlFlowUtils.InitializerUsageStatus.DECLARED_JUST_BEFORE);
            this.myCollector = collector;
            this.myChain = chain;
        }

        @Override
        String generateIntermediate(CommentTracker ct) {
            PsiExpression qualifier = this.myChain.getMethodExpression().getQualifierExpression();
            return ct.text((PsiElement)Objects.requireNonNull(qualifier));
        }

        @Override
        String generateTerminal(CommentTracker ct) {
            return ".collect(" + ct.text((PsiElement)this.myCollector) + ")";
        }

        private static PsiClass resolveClassCreatedByFunction(PsiExpression function) {
            PsiJavaCodeReferenceElement classReference2;
            PsiExpression body2;
            PsiNewExpression newExpression;
            if ((function = PsiUtil.skipParenthesizedExprDown((PsiExpression)function)) instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)function).isConstructor()) {
                PsiElement target = ((PsiMethodReferenceExpression)function).resolve();
                return target instanceof PsiClass ? (PsiClass)target : (target instanceof PsiMethod ? ((PsiMethod)target).getContainingClass() : null);
            }
            if (function instanceof PsiLambdaExpression && (newExpression = (PsiNewExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)(body2 = LambdaUtil.extractSingleExpressionFromBody((PsiElement)((PsiLambdaExpression)function).getBody()))), PsiNewExpression.class)) != null && newExpression.getAnonymousClass() == null && newExpression.getQualifier() == null && newExpression.getArgumentList() != null && newExpression.getArgumentList().getExpressions().length == 0 && (classReference2 = newExpression.getClassReference()) != null) {
                return (PsiClass)ObjectUtils.tryCast((Object)classReference2.resolve(), PsiClass.class);
            }
            return null;
        }

        @Override
        String getIntermediateStepsFromCollection() {
            String name = this.myCollector.getMethodExpression().getReferenceName();
            if ("toList".equals(name)) {
                return "";
            }
            if ("toSet".equals(name)) {
                return ".distinct()";
            }
            if ("toCollection".equals(name)) {
                PsiExpression collectionFunction = this.myCollector.getArgumentList().getExpressions()[0];
                PsiClass psiClass = StreamCollectChain.resolveClassCreatedByFunction(collectionFunction);
                if (psiClass == null) {
                    return null;
                }
                return CollectMigration.INTERMEDIATE_STEPS.get(psiClass.getQualifiedName());
            }
            return null;
        }
    }
}

