/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javadoc;

import com.google.common.collect.Streams;
import com.intellij.analysis.AnalysisScope;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaCommandLineStateUtil;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.ArgumentFileFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.RegexpFilter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.BrowserUtil;
import com.intellij.javadoc.JavadocBundle;
import com.intellij.javadoc.JavadocConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.projectRoots.ex.PathUtilEx;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.ServerPageFile;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class JavadocGeneratorRunProfile
implements ModuleRunProfile {
    private final Project myProject;
    private final AnalysisScope myGenerationScope;
    private final JavadocConfiguration myConfiguration;

    public JavadocGeneratorRunProfile(Project project, AnalysisScope generationScope, JavadocConfiguration configuration) {
        this.myProject = project;
        this.myGenerationScope = generationScope;
        this.myConfiguration = configuration;
    }

    public static Sdk getSdk(@NotNull Project project) {
        if (project == null) {
            JavadocGeneratorRunProfile.$$$reportNull$$$0(0);
        }
        return PathUtilEx.getAnyJdk((Project)project);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            JavadocGeneratorRunProfile.$$$reportNull$$$0(1);
        }
        if (env == null) {
            JavadocGeneratorRunProfile.$$$reportNull$$$0(2);
        }
        return new MyJavaCommandLineState(this.myConfiguration, this.myProject, this.myGenerationScope, env);
    }

    public String getName() {
        return JavadocBundle.message("javadoc.settings.title", new Object[0]);
    }

    public Icon getIcon() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javadoc/JavadocGeneratorRunProfile";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSdk";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyContentIterator
    extends PsiRecursiveElementWalkingVisitor {
        private final PsiManager myPsiManager;
        private final Set<Module> myModules;
        private final Set<VirtualFile> mySourceFiles;

        public MyContentIterator(Project project, Set<Module> modules, Set<VirtualFile> sources) {
            this.myPsiManager = PsiManager.getInstance((Project)project);
            this.myModules = modules;
            this.mySourceFiles = sources;
        }

        public void visitFile(PsiFile file) {
            VirtualFile vFile;
            if (file instanceof PsiJavaFile && !(file instanceof ServerPageFile) && (vFile = file.getVirtualFile()) != null && vFile.isInLocalFileSystem()) {
                this.mySourceFiles.add(vFile);
                Module module = ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)this.myPsiManager.getProject());
                if (module != null) {
                    this.myModules.add(module);
                }
            }
        }
    }

    private static class MyJavaCommandLineState
    extends CommandLineState {
        private static final String INDEX_HTML = "index.html";
        private final AnalysisScope myGenerationOptions;
        private final Project myProject;
        private final JavadocConfiguration myConfiguration;
        private final ArgumentFileFilter myArgFileFilter = new ArgumentFileFilter();

        public MyJavaCommandLineState(JavadocConfiguration configuration, Project project, AnalysisScope generationOptions, ExecutionEnvironment env) {
            super(env);
            this.myGenerationOptions = generationOptions;
            this.myProject = project;
            this.myConfiguration = configuration;
            this.addConsoleFilters(new Filter[]{new RegexpFilter(project, "$FILE_PATH$:$LINE$:[^\\^]+\\^"), new RegexpFilter(project, "$FILE_PATH$:$LINE$: warning - .+$"), this.myArgFileFilter});
        }

        @NotNull
        protected OSProcessHandler startProcess() throws ExecutionException {
            OSProcessHandler handler = JavaCommandLineStateUtil.startProcess((GeneralCommandLine)this.createCommandLine());
            ProcessTerminatedListener.attach((ProcessHandler)handler, (Project)this.myProject, (String)JavadocBundle.message("javadoc.generate.exited", new Object[0]));
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    File index;
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (((MyJavaCommandLineState)this).myConfiguration.OPEN_IN_BROWSER && event.getExitCode() == 0 && (index = new File(((MyJavaCommandLineState)this).myConfiguration.OUTPUT_DIRECTORY, MyJavaCommandLineState.INDEX_HTML)).exists()) {
                        BrowserUtil.browse((File)index);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javadoc/JavadocGeneratorRunProfile$MyJavaCommandLineState$1", "processTerminated"));
                }
            });
            OSProcessHandler oSProcessHandler = handler;
            if (oSProcessHandler == null) {
                MyJavaCommandLineState.$$$reportNull$$$0(0);
            }
            return oSProcessHandler;
        }

        private GeneralCommandLine createCommandLine() throws ExecutionException {
            GeneralCommandLine cmdLine = new GeneralCommandLine();
            Sdk jdk = JavadocGeneratorRunProfile.getSdk(this.myProject);
            this.setExecutable(jdk, cmdLine);
            this.setParameters(jdk, cmdLine);
            return cmdLine;
        }

        private void setExecutable(Sdk jdk, GeneralCommandLine cmdLine) throws ExecutionException {
            String binPath;
            String string = binPath = jdk != null && jdk.getSdkType() instanceof JavaSdkType ? ((JavaSdkType)jdk.getSdkType()).getBinPath(jdk) : null;
            if (binPath == null) {
                throw new CantRunException(JavadocBundle.message("javadoc.generate.no.jdk.path", new Object[0]));
            }
            cmdLine.setWorkDirectory((File)null);
            String toolName = SystemInfo.isWindows ? "javadoc.exe" : "javadoc";
            File tool = new File(binPath, toolName);
            if (!(tool.exists() || (tool = new File(new File(binPath).getParent(), toolName)).exists() || (tool = new File(new File(System.getProperty("java.home")).getParent(), "bin/" + toolName)).exists())) {
                throw new CantRunException(JavadocBundle.message("javadoc.generate.no.jdk.path", new Object[0]));
            }
            cmdLine.setExePath(tool.getPath());
            if (this.myConfiguration.HEAP_SIZE != null && this.myConfiguration.HEAP_SIZE.trim().length() != 0) {
                String param = JavaSdkUtil.isJdkAtLeast(jdk, JavaSdkVersion.JDK_1_2) ? "-J-Xmx" : "-J-mx";
                cmdLine.getParametersList().prepend(param + this.myConfiguration.HEAP_SIZE + "m");
            }
        }

        private void setParameters(Sdk jdk, GeneralCommandLine cmdLine) throws CantRunException {
            ParametersList parameters2 = cmdLine.getParametersList();
            if (this.myConfiguration.LOCALE != null && this.myConfiguration.LOCALE.length() > 0) {
                parameters2.add("-locale");
                parameters2.add(this.myConfiguration.LOCALE);
            }
            if (this.myConfiguration.OPTION_SCOPE != null) {
                parameters2.add("-" + this.myConfiguration.OPTION_SCOPE);
            }
            if (!this.myConfiguration.OPTION_HIERARCHY) {
                parameters2.add("-notree");
            }
            if (!this.myConfiguration.OPTION_NAVIGATOR) {
                parameters2.add("-nonavbar");
            }
            if (!this.myConfiguration.OPTION_INDEX) {
                parameters2.add("-noindex");
            } else if (this.myConfiguration.OPTION_SEPARATE_INDEX) {
                parameters2.add("-splitindex");
            }
            if (this.myConfiguration.OPTION_DOCUMENT_TAG_USE) {
                parameters2.add("-use");
            }
            if (this.myConfiguration.OPTION_DOCUMENT_TAG_AUTHOR) {
                parameters2.add("-author");
            }
            if (this.myConfiguration.OPTION_DOCUMENT_TAG_VERSION) {
                parameters2.add("-version");
            }
            if (!this.myConfiguration.OPTION_DOCUMENT_TAG_DEPRECATED) {
                parameters2.add("-nodeprecated");
            } else if (!this.myConfiguration.OPTION_DEPRECATED_LIST) {
                parameters2.add("-nodeprecatedlist");
            }
            parameters2.addParametersString(this.myConfiguration.OTHER_OPTIONS);
            if (this.myConfiguration.OPTION_LINK_TO_JDK_DOCS) {
                for (String url : jdk.getRootProvider().getUrls(JavadocOrderRootType.getInstance())) {
                    parameters2.add("-link");
                    parameters2.add(url);
                }
            }
            if (this.myConfiguration.OUTPUT_DIRECTORY != null) {
                parameters2.add("-d");
                parameters2.add(this.myConfiguration.OUTPUT_DIRECTORY.replace('/', File.separatorChar));
            }
            try {
                File argsFile = FileUtil.createTempFile((String)"javadoc_args", null);
                try (PrintWriter writer = new PrintWriter(new FileWriter(argsFile));){
                    LinkedHashSet modules = new LinkedHashSet();
                    HashSet sources = new HashSet();
                    Runnable r = () -> this.lambda$setParameters$0(modules, (Set)sources);
                    String title = JavadocBundle.message("javadoc.generate.sources.progress", new Object[0]);
                    if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(r, title, true, this.myProject)) {
                        return;
                    }
                    if (sources.isEmpty()) {
                        throw new CantRunException(JavadocBundle.message("javadoc.generate.no.classes.in.selected.packages.error", new Object[0]));
                    }
                    boolean hasJavaModules = sources.stream().anyMatch(f -> "module-info.java".equals(f.getName()));
                    if (hasJavaModules && modules.size() > 1) {
                        throw new CantRunException("At the moment, IDEA cannot generate Javadoc for multiple modules with module-info.java files in them. Sorry. We're working on this.");
                    }
                    OrderEnumerator sourcePathEnumerator = ProjectRootManager.getInstance((Project)this.myProject).orderEntries(modules);
                    if (!this.myConfiguration.OPTION_INCLUDE_LIBS) {
                        sourcePathEnumerator = sourcePathEnumerator.withoutSdk().withoutLibraries();
                    }
                    if (!this.myGenerationOptions.isIncludeTestSource()) {
                        sourcePathEnumerator = sourcePathEnumerator.productionOnly();
                    }
                    List sourceRoots = sourcePathEnumerator.getSourcePathsList().getRootDirs();
                    OrderEnumerator classPathEnumerator = ProjectRootManager.getInstance((Project)this.myProject).orderEntries(modules).withoutModuleSourceEntries();
                    if (jdk.getSdkType() instanceof JavaSdk) {
                        classPathEnumerator = classPathEnumerator.withoutSdk();
                    }
                    if (!this.myGenerationOptions.isIncludeTestSource()) {
                        classPathEnumerator = classPathEnumerator.productionOnly();
                    }
                    List classRoots = classPathEnumerator.getPathsList().getRootDirs();
                    if (sourceRoots.size() + classRoots.size() > 0) {
                        if (hasJavaModules) {
                            String path;
                            if (!sourceRoots.isEmpty()) {
                                path = sourceRoots.stream().map(MyJavaCommandLineState::localPath).collect(Collectors.joining(File.pathSeparator));
                                writer.println("--source-path");
                                writer.println(StringUtil.wrapWithDoubleQuote((String)path));
                            }
                            if (!classRoots.isEmpty()) {
                                path = classRoots.stream().map(MyJavaCommandLineState::localPath).collect(Collectors.joining(File.pathSeparator));
                                writer.println("--module-path");
                                writer.println(StringUtil.wrapWithDoubleQuote((String)path));
                            }
                        } else {
                            Stream roots = Streams.concat((Stream[])new Stream[]{sourceRoots.stream(), classRoots.stream()});
                            String path = roots.map(MyJavaCommandLineState::localPath).collect(Collectors.joining(File.pathSeparator));
                            writer.println("-classpath");
                            writer.println(StringUtil.wrapWithDoubleQuote((String)path));
                        }
                    }
                    for (VirtualFile source : sources) {
                        writer.println(StringUtil.wrapWithDoubleQuote((String)source.getPath()));
                    }
                }
                this.myArgFileFilter.setPath(argsFile.getPath());
                parameters2.add("@" + argsFile.getPath());
                OSProcessHandler.deleteFileOnTermination((GeneralCommandLine)cmdLine, (File)argsFile);
            }
            catch (IOException e) {
                throw new CantRunException(JavadocBundle.message("javadoc.generate.temp.file.error", new Object[0]), (Throwable)e);
            }
        }

        private static String localPath(VirtualFile root) {
            return VfsUtil.getLocalFile((VirtualFile)root).getPath();
        }

        private /* synthetic */ void lambda$setParameters$0(Set modules, Set sources) {
            this.myGenerationOptions.accept((PsiElementVisitor)new MyContentIterator(this.myProject, modules, sources));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javadoc/JavadocGeneratorRunProfile$MyJavaCommandLineState", "startProcess"));
        }
    }
}

