/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.actions;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.EmptyExpression;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.lang.java.actions.CreateEnumConstantAction;
import com.intellij.lang.java.actions.CreateEnumConstantActionKt;
import com.intellij.lang.java.actions.CreateFieldActionBase;
import com.intellij.lang.java.actions.EnumConstantData;
import com.intellij.lang.jvm.actions.CreateFieldRequest;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J%\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J$\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/lang/java/actions/CreateEnumConstantAction;", "Lcom/intellij/lang/java/actions/CreateFieldActionBase;", "targetClass", "Lcom/intellij/psi/PsiClass;", "request", "Lcom/intellij/lang/jvm/actions/CreateFieldRequest;", "(Lcom/intellij/psi/PsiClass;Lcom/intellij/lang/jvm/actions/CreateFieldRequest;)V", "myData", "Lcom/intellij/lang/java/actions/EnumConstantData;", "getMyData", "()Lcom/intellij/lang/java/actions/EnumConstantData;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "java-impl"})
public final class CreateEnumConstantAction
extends CreateFieldActionBase {
    private final EnumConstantData getMyData() {
        PsiClass targetClass = (PsiClass)this.getMyTargetClass().getElement();
        if (targetClass == null || !this.getMyRequest().isValid()) {
            return null;
        }
        return CreateEnumConstantActionKt.access$extractRenderData(targetClass, this.getMyRequest());
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        EnumConstantData enumConstantData = this.getMyData();
        if (enumConstantData == null) {
            return false;
        }
        EnumConstantData data = enumConstantData;
        this.setText(QuickFixBundle.message("create.enum.constant.from.usage.text", data.getConstantName()));
        return true;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        EnumConstantData enumConstantData = this.getMyData();
        if (enumConstantData == null) {
            return;
        }
        EnumConstantData data = enumConstantData;
        String name = data.getConstantName();
        PsiClass targetClass = data.getTargetClass();
        PsiElementFactory psiElementFactory = JavaPsiFacade.getElementFactory((Project)project);
        if (psiElementFactory == null) {
            Intrinsics.throwNpe();
        }
        PsiElementFactory elementFactory = psiElementFactory;
        PsiEnumConstant psiEnumConstant = elementFactory.createEnumConstantFromText(name, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiEnumConstant, (String)"elementFactory.createEnu\u2026stantFromText(name, null)");
        PsiEnumConstant enumConstant = psiEnumConstant;
        PsiElement psiElement = targetClass.add((PsiElement)enumConstant);
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiEnumConstant");
        }
        enumConstant = (PsiEnumConstant)psiElement;
        PsiMethod psiMethod = (PsiMethod)ArraysKt.firstOrNull((Object[])targetClass.getConstructors());
        if (psiMethod == null) {
            return;
        }
        PsiMethod constructor = psiMethod;
        PsiParameter[] parameters2 = constructor.getParameterList().getParameters();
        Object[] objectArray = parameters2;
        if (objectArray.length == 0) {
            return;
        }
        String paramString2 = ArraysKt.joinToString$default((Object[])parameters2, (CharSequence)",", null, null, (int)0, null, (Function1)invoke.paramString.1.INSTANCE, (int)30, null);
        PsiElement psiElement2 = enumConstant.replace((PsiElement)elementFactory.createEnumConstantFromText("" + name + '(' + paramString2 + ')', null));
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiEnumConstant");
        }
        enumConstant = (PsiEnumConstant)psiElement2;
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)enumConstant);
        PsiExpressionList psiExpressionList = enumConstant.getArgumentList();
        if (psiExpressionList == null) {
            Intrinsics.throwNpe();
        }
        PsiExpressionList argumentList = psiExpressionList;
        for (PsiExpression expression2 : argumentList.getExpressions()) {
            builder.replaceElement((PsiElement)expression2, (Expression)new EmptyExpression());
        }
        PsiElement psiElement3 = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)((PsiElement)enumConstant));
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"forcePsiPostprocessAndRestoreElement(enumConstant)");
        enumConstant = (PsiEnumConstant)psiElement3;
        Template template = builder.buildTemplate();
        Editor editor2 = CreateFromUsageBaseFix.positionCursor(project, targetClass.getContainingFile(), (PsiElement)enumConstant);
        if (editor2 == null) {
            return;
        }
        Editor newEditor = editor2;
        TextRange range = enumConstant.getTextRange();
        newEditor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        CreateFromUsageBaseFix.startTemplate(newEditor, template, project);
    }

    public CreateEnumConstantAction(@NotNull PsiClass targetClass, @NotNull CreateFieldRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        super(targetClass, request);
    }
}

