/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.actions;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.java.actions.JavaMethodRenderer;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.actions.CreateMethodRequest;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.psi.util.PointersKt;
import com.intellij.psi.util.PsiUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J%\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J$\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u0019\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/lang/java/actions/CreateMethodAction;", "Lcom/intellij/codeInsight/intention/impl/BaseIntentionAction;", "targetClass", "Lcom/intellij/psi/PsiClass;", "abstract", "", "myRequest", "Lcom/intellij/lang/jvm/actions/CreateMethodRequest;", "(Lcom/intellij/psi/PsiClass;ZLcom/intellij/lang/jvm/actions/CreateMethodRequest;)V", "myTargetClass", "Lcom/intellij/psi/SmartPsiElementPointer;", "getElementToMakeWritable", "Lcom/intellij/psi/PsiElement;", "currentFile", "Lcom/intellij/psi/PsiFile;", "getFamilyName", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "isAvailable", "startInWriteAction", "java-impl"})
public final class CreateMethodAction
extends BaseIntentionAction {
    private final SmartPsiElementPointer<PsiClass> myTargetClass;
    private final boolean abstract;
    private final CreateMethodRequest myRequest;

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.method.from.usage.family", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message(\"create.method.from.usage.family\")");
        return string;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        Intrinsics.checkParameterIsNotNull((Object)currentFile, (String)"currentFile");
        return this.myTargetClass.getElement();
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        PsiClass psiClass = (PsiClass)this.myTargetClass.getElement();
        if (psiClass == null) {
            return false;
        }
        PsiClass targetClass = psiClass;
        if (!this.myRequest.isValid()) {
            return false;
        }
        String name = this.myRequest.getMethodName();
        if (!PsiNameHelper.getInstance((Project)targetClass.getProject()).isIdentifier(name)) {
            return false;
        }
        Collection requestedModifiers = this.myRequest.getModifiers();
        boolean bl = requestedModifiers.contains(JvmModifier.STATIC);
        if (this.abstract && bl) {
            return false;
        }
        if (this.abstract) {
            if (!targetClass.hasModifierProperty("abstract")) {
                return false;
            }
            if (targetClass.isInterface()) {
                return false;
            }
        } else if (bl) {
            if (targetClass.isInterface() && !PsiUtil.isLanguageLevel8OrHigher((PsiElement)((PsiElement)targetClass))) {
                return false;
            }
            if (targetClass.getContainingClass() != null && !targetClass.hasModifierProperty("static")) {
                return false;
            }
        }
        String className = ClassPresentationUtil.getNameForClass(targetClass, false);
        this.setText(this.abstract ? QuickFixBundle.message("create.abstract.method.from.usage.full.text", name, className) : QuickFixBundle.message("create.method.from.usage.full.text", name, className));
        return true;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        PsiClass psiClass = (PsiClass)this.myTargetClass.getElement();
        if (psiClass == null) {
            String string = "Target class was invalidated between isAvailable() and invoke()";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        PsiClass targetClass = psiClass;
        boolean bl = this.myRequest.isValid();
        if (_Assertions.ENABLED && !bl) {
            String string = "Request was invalidates between isAvailable() and invoke()";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        PsiClass psiClass2 = targetClass;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass2, (String)"targetClass");
        new JavaMethodRenderer(project, this.abstract, psiClass2, this.myRequest).doMagic();
    }

    public CreateMethodAction(@NotNull PsiClass targetClass, boolean bl, @NotNull CreateMethodRequest myRequest) {
        Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
        Intrinsics.checkParameterIsNotNull((Object)myRequest, (String)"myRequest");
        this.abstract = bl;
        this.myRequest = myRequest;
        this.myTargetClass = PointersKt.createSmartPointer$default((PsiElement)targetClass, null, 1, null);
    }
}

