/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.scopeChooser.GroupByScopeTypeAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.packageDependencies.ui.FileNode;
import com.intellij.packageDependencies.ui.GeneralGroupNode;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.ModuleGroupNode;
import com.intellij.packageDependencies.ui.ModuleNode;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.packageDependencies.ui.PackageNode;
import com.intellij.packageDependencies.ui.PatternDialectProvider;
import com.intellij.packageDependencies.ui.RootNode;
import com.intellij.packageDependencies.ui.TreeModel;
import com.intellij.packageDependencies.ui.TreeModelBuilder;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PatternPackageSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagePatternProvider
extends PatternDialectProvider {
    @NonNls
    public static final String PACKAGES = "package";
    private static final Logger LOG = Logger.getInstance(PackagePatternProvider.class);

    @Nullable
    private static GeneralGroupNode getGroupParent(PackageDependenciesNode node) {
        if (node instanceof GeneralGroupNode) {
            return (GeneralGroupNode)node;
        }
        if (node == null || node instanceof RootNode) {
            return null;
        }
        return PackagePatternProvider.getGroupParent((PackageDependenciesNode)node.getParent());
    }

    public PackageSet createPackageSet(PackageDependenciesNode node, boolean recursively) {
        GeneralGroupNode groupParent = PackagePatternProvider.getGroupParent(node);
        String scope1 = "";
        if (groupParent != null) {
            String name = groupParent.toString();
            if (TreeModelBuilder.PRODUCTION_NAME.equals(name)) {
                scope1 = "src";
            } else if (TreeModelBuilder.TEST_NAME.equals(name)) {
                scope1 = "test";
            } else if (TreeModelBuilder.LIBRARY_NAME.equals(name)) {
                scope1 = "lib";
            }
        }
        String scope = scope1;
        if (node instanceof ModuleGroupNode) {
            if (!recursively) {
                return null;
            }
            String modulePattern = "group:" + ((ModuleGroupNode)node).getModuleGroup().toString();
            return new PatternPackageSet("*..*", scope, modulePattern);
        }
        if (node instanceof ModuleNode) {
            if (!recursively) {
                return null;
            }
            String modulePattern = ((ModuleNode)node).getModuleName();
            return new PatternPackageSet("*..*", scope, modulePattern);
        }
        if (node instanceof PackageNode) {
            String pattern = ((PackageNode)node).getPackageQName();
            pattern = pattern != null ? pattern + (recursively ? "..*" : ".*") : (recursively ? "*..*" : "*");
            return new PatternPackageSet(pattern, scope, PackagePatternProvider.getModulePattern((PackageDependenciesNode)node));
        }
        if (node instanceof FileNode) {
            if (recursively) {
                return null;
            }
            FileNode fNode = (FileNode)node;
            PsiElement element = fNode.getPsiElement();
            String qName = null;
            if (element instanceof PsiClassOwner) {
                PsiClassOwner javaFile = (PsiClassOwner)element;
                VirtualFile virtualFile = javaFile.getVirtualFile();
                LOG.assertTrue(virtualFile != null);
                String packageName = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex().getPackageNameByDirectory(virtualFile.getParent());
                String name = virtualFile.getNameWithoutExtension();
                if (!PsiNameHelper.getInstance((Project)element.getProject()).isIdentifier(name)) {
                    return null;
                }
                qName = StringUtil.getQualifiedName((String)packageName, (String)name);
            }
            if (qName != null) {
                return new PatternPackageSet(qName, scope, PackagePatternProvider.getModulePattern((PackageDependenciesNode)node));
            }
        } else if (node instanceof GeneralGroupNode) {
            return new PatternPackageSet("*..*", scope, null);
        }
        return null;
    }

    public Icon getIcon() {
        return AllIcons.General.PackagesTab;
    }

    public TreeModel createTreeModel(Project project, Marker marker) {
        return TreeModelBuilder.createTreeModel(project, false, marker);
    }

    public TreeModel createTreeModel(Project project, Set<PsiFile> deps, Marker marker, DependenciesPanel.DependencyPanelSettings settings) {
        return TreeModelBuilder.createTreeModel(project, false, deps, marker, settings);
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"title.packages", (Object[])new Object[0]);
    }

    @NotNull
    public String getShortName() {
        if (PACKAGES == null) {
            PackagePatternProvider.$$$reportNull$$$0(0);
        }
        return PACKAGES;
    }

    public AnAction[] createActions(Project project, Runnable update2) {
        return new AnAction[]{new GroupByScopeTypeAction(update2)};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/ui/PackagePatternProvider", "getShortName"));
    }
}

