/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PackagePrefixIndex;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.HashMap;
import org.jetbrains.annotations.NotNull;

public class PackagePrefixElementFinder
extends PsiElementFinder
implements DumbAware {
    private final Project myProject;
    private final PackagePrefixIndex myPackagePrefixIndex;

    public PackagePrefixElementFinder(Project project) {
        this.myProject = project;
        this.myPackagePrefixIndex = new PackagePrefixIndex(project);
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            PackagePrefixElementFinder.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            PackagePrefixElementFinder.$$$reportNull$$$0(1);
        }
        return null;
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            PackagePrefixElementFinder.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            PackagePrefixElementFinder.$$$reportNull$$$0(3);
        }
        if (PsiClass.EMPTY_ARRAY == null) {
            PackagePrefixElementFinder.$$$reportNull$$$0(4);
        }
        return PsiClass.EMPTY_ARRAY;
    }

    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            PackagePrefixElementFinder.$$$reportNull$$$0(5);
        }
        if (this.packagePrefixExists(qualifiedName)) {
            return new PsiPackageImpl(PsiManager.getInstance((Project)this.myProject), qualifiedName);
        }
        return null;
    }

    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            PackagePrefixElementFinder.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            PackagePrefixElementFinder.$$$reportNull$$$0(7);
        }
        HashMap packagesMap = new HashMap();
        String qualifiedName = psiPackage.getQualifiedName();
        for (String prefix : this.myPackagePrefixIndex.getAllPackagePrefixes(scope)) {
            int i;
            String childName;
            if (!StringUtil.isEmpty((String)qualifiedName) && !StringUtil.startsWithConcatenation((String)prefix, (String[])new String[]{qualifiedName, "."}) || packagesMap.containsKey(childName = (i = prefix.indexOf(46, qualifiedName.length() + 1)) >= 0 ? prefix.substring(0, i) : prefix)) continue;
            packagesMap.put(childName, new PsiPackageImpl(psiPackage.getManager(), childName));
        }
        packagesMap.remove(qualifiedName);
        PsiPackage[] psiPackageArray = packagesMap.values().toArray(new PsiPackage[packagesMap.size()]);
        if (psiPackageArray == null) {
            PackagePrefixElementFinder.$$$reportNull$$$0(8);
        }
        return psiPackageArray;
    }

    public boolean packagePrefixExists(String packageQName) {
        for (String prefix : this.myPackagePrefixIndex.getAllPackagePrefixes(null)) {
            if (!StringUtil.startsWithConcatenation((String)prefix, (String[])new String[]{packageQName, "."}) && !prefix.equals(packageQName)) continue;
            return true;
        }
        return false;
    }

    public static PackagePrefixElementFinder getInstance(Project project) {
        for (PsiElementFinder o : (PsiElementFinder[])Extensions.getExtensions((ExtensionPointName)PsiElementFinder.EP_NAME, (AreaInstance)project)) {
            if (!(o instanceof PackagePrefixElementFinder)) continue;
            return (PackagePrefixElementFinder)o;
        }
        throw new UnsupportedOperationException("couldn't find self");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PackagePrefixElementFinder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PackagePrefixElementFinder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSubPackages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

