/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.stubs.LightStubBuilder;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class JavaLightStubBuilder
extends LightStubBuilder {
    @NotNull
    protected StubElement createStubForFile(@NotNull PsiFile file, @NotNull LighterAST tree) {
        LighterASTNode ref;
        if (file == null) {
            JavaLightStubBuilder.$$$reportNull$$$0(0);
        }
        if (tree == null) {
            JavaLightStubBuilder.$$$reportNull$$$0(1);
        }
        if (!(file instanceof PsiJavaFile)) {
            StubElement stubElement = super.createStubForFile(file, tree);
            if (stubElement == null) {
                JavaLightStubBuilder.$$$reportNull$$$0(2);
            }
            return stubElement;
        }
        String refText = "";
        LighterASTNode pkg = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)tree.getRoot(), (IElementType)JavaElementType.PACKAGE_STATEMENT);
        if (pkg != null && (ref = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)pkg, (IElementType)JavaElementType.JAVA_CODE_REFERENCE)) != null) {
            refText = JavaSourceUtil.getReferenceText(tree, ref);
        }
        PsiJavaFileStubImpl psiJavaFileStubImpl = new PsiJavaFileStubImpl((PsiJavaFile)file, refText, null, false);
        if (psiJavaFileStubImpl == null) {
            JavaLightStubBuilder.$$$reportNull$$$0(3);
        }
        return psiJavaFileStubImpl;
    }

    public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent, @NotNull ASTNode node) {
        IElementType nodeType;
        IElementType parentType;
        if (parent == null) {
            JavaLightStubBuilder.$$$reportNull$$$0(4);
        }
        if (node == null) {
            JavaLightStubBuilder.$$$reportNull$$$0(5);
        }
        if (JavaLightStubBuilder.checkByTypes(parentType = parent.getElementType(), nodeType = node.getElementType())) {
            return true;
        }
        if (nodeType == JavaElementType.CODE_BLOCK) {
            CodeBlockVisitor visitor = new CodeBlockVisitor();
            ((TreeElement)node).acceptTree((TreeElementVisitor)visitor);
            return visitor.result;
        }
        return false;
    }

    protected boolean skipChildProcessingWhenBuildingStubs(@NotNull LighterAST tree, @NotNull LighterASTNode parent, @NotNull LighterASTNode node) {
        if (tree == null) {
            JavaLightStubBuilder.$$$reportNull$$$0(6);
        }
        if (parent == null) {
            JavaLightStubBuilder.$$$reportNull$$$0(7);
        }
        if (node == null) {
            JavaLightStubBuilder.$$$reportNull$$$0(8);
        }
        return JavaLightStubBuilder.checkByTypes(parent.getTokenType(), node.getTokenType()) || JavaLightStubBuilder.isCodeBlockWithoutStubs(node);
    }

    public static boolean isCodeBlockWithoutStubs(@NotNull LighterASTNode node) {
        if (node == null) {
            JavaLightStubBuilder.$$$reportNull$$$0(9);
        }
        if (node.getTokenType() == JavaElementType.CODE_BLOCK && node instanceof LighterLazyParseableNode) {
            CodeBlockVisitor visitor = new CodeBlockVisitor();
            ((LighterLazyParseableNode)node).accept((LighterLazyParseableNode.Visitor)visitor);
            return visitor.result;
        }
        return false;
    }

    private static boolean checkByTypes(IElementType parentType, IElementType nodeType) {
        if (ElementType.IMPORT_STATEMENT_BASE_BIT_SET.contains(parentType)) {
            return true;
        }
        if (nodeType == JavaElementType.RECEIVER_PARAMETER) {
            return true;
        }
        if (nodeType == JavaElementType.PARAMETER && parentType != JavaElementType.PARAMETER_LIST) {
            return true;
        }
        if (nodeType == JavaElementType.PARAMETER_LIST && parentType == JavaElementType.LAMBDA_EXPRESSION) {
            return true;
        }
        return nodeType == JavaDocElementType.DOC_COMMENT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/JavaLightStubBuilder";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/JavaLightStubBuilder";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createStubForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStubForFile";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "skipChildProcessingWhenBuildingStubs";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isCodeBlockWithoutStubs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CodeBlockVisitor
    extends RecursiveTreeElementWalkingVisitor
    implements LighterLazyParseableNode.Visitor {
        private static final TokenSet BLOCK_ELEMENTS = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.CLASS, JavaElementType.ANONYMOUS_CLASS, JavaTokenType.ARROW, JavaTokenType.DOUBLE_COLON, JavaTokenType.AT});
        private boolean result = true;
        private IElementType preLast;
        private IElementType last;
        private boolean seenNew;
        private boolean seenLParen;

        private CodeBlockVisitor() {
        }

        protected void visitNode(TreeElement element) {
            if (BLOCK_ELEMENTS.contains(element.getElementType())) {
                this.result = false;
                this.stopWalking();
                return;
            }
            super.visitNode(element);
        }

        public boolean visit(IElementType type2) {
            if (ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(type2)) {
                return true;
            }
            if (type2 == JavaTokenType.AT || type2 == JavaTokenType.ARROW || type2 == JavaTokenType.DOUBLE_COLON) {
                this.result = false;
                return false;
            }
            if (type2 == JavaTokenType.NEW_KEYWORD) {
                this.seenNew = true;
            } else if (this.seenNew && type2 == JavaTokenType.SEMICOLON) {
                this.seenNew = false;
                this.seenLParen = false;
            } else {
                if (this.seenNew && type2 == JavaTokenType.LBRACE && this.seenLParen) {
                    this.result = false;
                    return false;
                }
                if (this.seenNew && type2 == JavaTokenType.LPARENTH) {
                    this.seenLParen = true;
                } else if (type2 == JavaTokenType.CLASS_KEYWORD && (this.last != JavaTokenType.DOT || this.preLast != JavaTokenType.IDENTIFIER) || type2 == JavaTokenType.ENUM_KEYWORD || type2 == JavaTokenType.INTERFACE_KEYWORD) {
                    this.result = false;
                    return false;
                }
            }
            this.preLast = this.last;
            this.last = type2;
            return true;
        }
    }
}

