/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotatedJavaCodeReferenceElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PsiClassReferenceType
extends PsiClassType.Stub {
    private final Computable<PsiJavaCodeReferenceElement> myReference;

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel level) {
        if (reference == null) {
            PsiClassReferenceType.$$$reportNull$$$0(0);
        }
        this(reference, level, PsiClassReferenceType.collectAnnotations(reference));
    }

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel level, @NotNull PsiAnnotation[] annotations2) {
        if (reference == null) {
            PsiClassReferenceType.$$$reportNull$$$0(1);
        }
        if (annotations2 == null) {
            PsiClassReferenceType.$$$reportNull$$$0(2);
        }
        super(level, annotations2);
        this.myReference = new Computable.PredefinedValueComputable((Object)reference);
    }

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel level, @NotNull TypeAnnotationProvider provider) {
        if (reference == null) {
            PsiClassReferenceType.$$$reportNull$$$0(3);
        }
        if (provider == null) {
            PsiClassReferenceType.$$$reportNull$$$0(4);
        }
        this((Computable<PsiJavaCodeReferenceElement>)new Computable.PredefinedValueComputable((Object)reference), level, provider);
    }

    public PsiClassReferenceType(@NotNull Computable<PsiJavaCodeReferenceElement> reference, LanguageLevel level, @NotNull TypeAnnotationProvider provider) {
        if (reference == null) {
            PsiClassReferenceType.$$$reportNull$$$0(5);
        }
        if (provider == null) {
            PsiClassReferenceType.$$$reportNull$$$0(6);
        }
        super(level, provider);
        this.myReference = reference;
    }

    @NotNull
    private static PsiAnnotation[] collectAnnotations(PsiJavaCodeReferenceElement reference) {
        List result = null;
        for (PsiElement child = reference.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiAnnotation)) continue;
            if (result == null) {
                result = new SmartList();
            }
            result.add((PsiAnnotation)child);
        }
        PsiAnnotation[] psiAnnotationArray = result == null ? PsiAnnotation.EMPTY_ARRAY : result.toArray(new PsiAnnotation[result.size()]);
        if (psiAnnotationArray == null) {
            PsiClassReferenceType.$$$reportNull$$$0(7);
        }
        return psiAnnotationArray;
    }

    public boolean isValid() {
        PsiJavaCodeReferenceElement reference = (PsiJavaCodeReferenceElement)this.myReference.compute();
        if (reference != null && reference.isValid()) {
            for (PsiAnnotation annotation : this.getAnnotations(false)) {
                if (annotation.isValid()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equalsToText(@NotNull String text2) {
        if (text2 == null) {
            PsiClassReferenceType.$$$reportNull$$$0(8);
        }
        return Comparing.equal((String)text2, (String)this.getCanonicalText());
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.getReference().getResolveScope();
        if (globalSearchScope == null) {
            PsiClassReferenceType.$$$reportNull$$$0(9);
        }
        return globalSearchScope;
    }

    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations(true);
        if (psiAnnotationArray == null) {
            PsiClassReferenceType.$$$reportNull$$$0(10);
        }
        return psiAnnotationArray;
    }

    private PsiAnnotation[] getAnnotations(boolean merge) {
        PsiJavaCodeReferenceElement reference;
        Object[] annotations2 = super.getAnnotations();
        if (merge && (reference = (PsiJavaCodeReferenceElement)this.myReference.compute()) != null && reference.isValid() && reference.isQualified()) {
            Object[] embedded = PsiClassReferenceType.collectAnnotations(reference);
            if (annotations2.length > 0 && embedded.length > 0) {
                LinkedHashSet set = ContainerUtil.newLinkedHashSet();
                ContainerUtil.addAll((Collection)set, (Object[])annotations2);
                ContainerUtil.addAll((Collection)set, (Object[])embedded);
                annotations2 = set.toArray(PsiAnnotation.EMPTY_ARRAY);
            } else {
                annotations2 = (PsiAnnotation[])ArrayUtil.mergeArrays((Object[])annotations2, (Object[])embedded);
            }
        }
        return annotations2;
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        if (this.myLanguageLevel != null) {
            LanguageLevel languageLevel = this.myLanguageLevel;
            if (languageLevel == null) {
                PsiClassReferenceType.$$$reportNull$$$0(11);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)this.getReference());
        if (languageLevel == null) {
            PsiClassReferenceType.$$$reportNull$$$0(12);
        }
        return languageLevel;
    }

    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            PsiClassReferenceType.$$$reportNull$$$0(13);
        }
        if (languageLevel.equals((Object)this.myLanguageLevel)) {
            PsiClassReferenceType psiClassReferenceType = this;
            if (psiClassReferenceType == null) {
                PsiClassReferenceType.$$$reportNull$$$0(14);
            }
            return psiClassReferenceType;
        }
        PsiClassReferenceType psiClassReferenceType = new PsiClassReferenceType(this.getReference(), languageLevel, this.getAnnotationProvider());
        if (psiClassReferenceType == null) {
            PsiClassReferenceType.$$$reportNull$$$0(15);
        }
        return psiClassReferenceType;
    }

    public PsiClass resolve() {
        return this.resolveGenerics().getElement();
    }

    @NotNull
    public PsiClassType.ClassResolveResult resolveGenerics() {
        PsiJavaCodeReferenceElement reference = this.getReference();
        PsiUtilCore.ensureValid((PsiElement)reference);
        JavaResolveResult result = reference.advancedResolve(false);
        Object object = result.getElement() == null ? PsiClassType.ClassResolveResult.EMPTY : new DelegatingClassResolveResult(result);
        if (object == null) {
            PsiClassReferenceType.$$$reportNull$$$0(16);
        }
        return object;
    }

    @NotNull
    public PsiClassType rawType() {
        PsiJavaCodeReferenceElement reference = this.getReference();
        PsiElement resolved = reference.resolve();
        if (resolved instanceof PsiClass) {
            PsiClass aClass = (PsiClass)resolved;
            if (!PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass).iterator().hasNext()) {
                PsiClassReferenceType psiClassReferenceType = this;
                if (psiClassReferenceType == null) {
                    PsiClassReferenceType.$$$reportNull$$$0(17);
                }
                return psiClassReferenceType;
            }
            PsiManager manager = reference.getManager();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
            PsiSubstitutor rawSubstitutor = factory.createRawSubstitutor((PsiTypeParameterListOwner)aClass);
            PsiImmediateClassType psiImmediateClassType = new PsiImmediateClassType(aClass, rawSubstitutor, this.getLanguageLevel(), this.getAnnotationProvider());
            if (psiImmediateClassType == null) {
                PsiClassReferenceType.$$$reportNull$$$0(18);
            }
            return psiImmediateClassType;
        }
        String qualifiedName = reference.getQualifiedName();
        String name = reference.getReferenceName();
        if (name == null) {
            name = "";
        }
        LightClassReference lightReference = new LightClassReference(reference.getManager(), name, qualifiedName, reference.getResolveScope());
        PsiClassReferenceType psiClassReferenceType = new PsiClassReferenceType((PsiJavaCodeReferenceElement)lightReference, null, this.getAnnotationProvider());
        if (psiClassReferenceType == null) {
            PsiClassReferenceType.$$$reportNull$$$0(19);
        }
        return psiClassReferenceType;
    }

    public String getClassName() {
        return this.getReference().getReferenceName();
    }

    @NotNull
    public PsiType[] getParameters() {
        PsiType[] psiTypeArray = this.getReference().getTypeParameters();
        if (psiTypeArray == null) {
            PsiClassReferenceType.$$$reportNull$$$0(20);
        }
        return psiTypeArray;
    }

    @NotNull
    public String getPresentableText(boolean annotated) {
        PsiAnnotation[] annotations2;
        String presentableText = PsiNameHelper.getPresentableText((PsiJavaCodeReferenceElement)this.getReference());
        PsiAnnotation[] psiAnnotationArray = annotations2 = annotated ? this.getAnnotations(false) : PsiAnnotation.EMPTY_ARRAY;
        if (annotations2.length == 0) {
            String string = presentableText;
            if (string == null) {
                PsiClassReferenceType.$$$reportNull$$$0(21);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder();
        PsiNameHelper.appendAnnotations((StringBuilder)sb, (PsiAnnotation[])annotations2, (boolean)false);
        sb.append(presentableText);
        String string = sb.toString();
        if (string == null) {
            PsiClassReferenceType.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.getText(annotated);
        if (string == null) {
            PsiClassReferenceType.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public String getInternalCanonicalText() {
        String string = this.getCanonicalText(true);
        if (string == null) {
            PsiClassReferenceType.$$$reportNull$$$0(24);
        }
        return string;
    }

    private String getText(boolean annotated) {
        PsiJavaCodeReferenceElement reference = this.getReference();
        if (reference instanceof PsiAnnotatedJavaCodeReferenceElement) {
            PsiAnnotatedJavaCodeReferenceElement ref = (PsiAnnotatedJavaCodeReferenceElement)reference;
            PsiAnnotation[] annotations2 = annotated ? this.getAnnotations(false) : PsiAnnotation.EMPTY_ARRAY;
            return ref.getCanonicalText(annotated, annotations2.length == 0 ? null : annotations2);
        }
        return reference.getCanonicalText();
    }

    @NotNull
    public PsiJavaCodeReferenceElement getReference() {
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = (PsiJavaCodeReferenceElement)ObjectUtils.assertNotNull((Object)this.myReference.compute());
        if (psiJavaCodeReferenceElement == null) {
            PsiClassReferenceType.$$$reportNull$$$0(25);
        }
        return psiJavaCodeReferenceElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiClassReferenceType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiClassReferenceType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAnnotations";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "setLanguageLevel";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGenerics";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "rawType";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "equalsToText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setLanguageLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DelegatingClassResolveResult
    implements PsiClassType.ClassResolveResult {
        private final JavaResolveResult myDelegate;

        private DelegatingClassResolveResult(@NotNull JavaResolveResult delegate) {
            if (delegate == null) {
                DelegatingClassResolveResult.$$$reportNull$$$0(0);
            }
            this.myDelegate = delegate;
        }

        @NotNull
        public PsiSubstitutor getSubstitutor() {
            PsiSubstitutor psiSubstitutor = this.myDelegate.getSubstitutor();
            if (psiSubstitutor == null) {
                DelegatingClassResolveResult.$$$reportNull$$$0(1);
            }
            return psiSubstitutor;
        }

        public boolean isValidResult() {
            return this.myDelegate.isValidResult();
        }

        public boolean isAccessible() {
            return this.myDelegate.isAccessible();
        }

        public boolean isStaticsScopeCorrect() {
            return this.myDelegate.isStaticsScopeCorrect();
        }

        public PsiElement getCurrentFileResolveScope() {
            return this.myDelegate.getCurrentFileResolveScope();
        }

        public boolean isPackagePrefixPackageReference() {
            return this.myDelegate.isPackagePrefixPackageReference();
        }

        public PsiClass getElement() {
            PsiElement element = this.myDelegate.getElement();
            return element instanceof PsiClass ? (PsiClass)element : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/PsiClassReferenceType$DelegatingClassResolveResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/PsiClassReferenceType$DelegatingClassResolveResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubstitutor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

