/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportHolder;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiQualifiedReferenceElement;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.ReferenceAdjuster;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.SourceJavaCodeReference;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaReferenceAdjuster
implements ReferenceAdjuster {
    public ASTNode process(@NotNull ASTNode element, boolean addImports, boolean incompleteCode, boolean useFqInJavadoc, boolean useFqInCode) {
        IElementType elementType;
        if (element == null) {
            JavaReferenceAdjuster.$$$reportNull$$$0(0);
        }
        if (!((elementType = element.getElementType()) != JavaElementType.JAVA_CODE_REFERENCE && elementType != JavaElementType.REFERENCE_EXPRESSION || JavaReferenceAdjuster.isAnnotated(element))) {
            IElementType parentType = element.getTreeParent().getElementType();
            if (elementType == JavaElementType.JAVA_CODE_REFERENCE || incompleteCode || parentType == JavaElementType.REFERENCE_EXPRESSION || parentType == JavaElementType.METHOD_REF_EXPRESSION) {
                PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)element.getPsi();
                PsiReferenceParameterList parameterList = ref.getParameterList();
                if (parameterList != null) {
                    PsiTypeElement[] typeParameters;
                    for (PsiTypeElement typeParameter : typeParameters = parameterList.getTypeParameterElements()) {
                        this.process(typeParameter.getNode(), addImports, incompleteCode, useFqInJavadoc, useFqInCode);
                    }
                }
                boolean rightKind = true;
                if (elementType == JavaElementType.JAVA_CODE_REFERENCE) {
                    PsiJavaCodeReferenceElementImpl impl = (PsiJavaCodeReferenceElementImpl)element;
                    int kind2 = impl.getKind(impl.getContainingFile());
                    boolean bl = rightKind = kind2 == 1 || kind2 == 3;
                }
                if (rightKind) {
                    PsiElement refElement;
                    boolean isShort;
                    List annotations2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)ref, PsiAnnotation.class);
                    for (PsiAnnotation annotation : annotations2) {
                        this.process(annotation.getNode(), addImports, incompleteCode, useFqInJavadoc, useFqInCode);
                    }
                    boolean isInsideDocComment = TreeUtil.findParent((ASTNode)element, (IElementType)JavaDocElementType.DOC_COMMENT) != null;
                    boolean bl = isShort = !ref.isQualified();
                    if ((isInsideDocComment ? !useFqInJavadoc : !useFqInCode) && isShort) {
                        return element;
                    }
                    if (!incompleteCode) {
                        refElement = ref.resolve();
                    } else {
                        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)ref.getManager().getProject()).getResolveHelper();
                        SourceJavaCodeReference reference = (SourceJavaCodeReference)element;
                        refElement = helper.resolveReferencedClass(reference.getClassNameText(), (PsiElement)ref);
                    }
                    if (refElement instanceof PsiClass) {
                        PsiElement qualifier;
                        PsiClass psiClass = (PsiClass)refElement;
                        if (isInsideDocComment ? useFqInJavadoc : useFqInCode) {
                            String qName = psiClass.getQualifiedName();
                            if (qName == null) {
                                return element;
                            }
                            PsiFile file = ref.getContainingFile();
                            if (file instanceof PsiJavaFile) {
                                if (ImportHelper.isImplicitlyImported(qName, (PsiJavaFile)file)) {
                                    if (isShort) {
                                        return element;
                                    }
                                    return JavaReferenceAdjuster.makeShortReference((CompositeElement)element, psiClass, addImports);
                                }
                                String thisPackageName = ((PsiJavaFile)file).getPackageName();
                                if (ImportHelper.hasPackage(qName, thisPackageName) && !isShort) {
                                    return JavaReferenceAdjuster.makeShortReference((CompositeElement)element, psiClass, addImports);
                                }
                            }
                            return JavaReferenceAdjuster.replaceReferenceWithFQ(element, psiClass);
                        }
                        int oldLength = element.getTextLength();
                        ASTNode treeElement = JavaReferenceAdjuster.makeShortReference((CompositeElement)element, psiClass, addImports);
                        if (treeElement.getTextLength() == oldLength && psiClass.getContainingClass() != null && (qualifier = ref.getQualifier()) instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)qualifier).resolve() instanceof PsiClass) {
                            this.process(qualifier.getNode(), addImports, incompleteCode, useFqInJavadoc, useFqInCode);
                        }
                        return treeElement;
                    }
                }
            }
        }
        for (ASTNode child = element.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            child = this.process(child, addImports, incompleteCode, useFqInJavadoc, useFqInCode);
        }
        return element;
    }

    public ASTNode process(@NotNull ASTNode element, boolean addImports, boolean incompleteCode, Project project) {
        if (element == null) {
            JavaReferenceAdjuster.$$$reportNull$$$0(1);
        }
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project);
        JavaCodeStyleSettings javaSettings = (JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class);
        return this.process(element, addImports, incompleteCode, javaSettings.useFqNamesInJavadocAlways(), javaSettings.USE_FQ_CLASS_NAMES);
    }

    private static boolean isAnnotated(ASTNode element) {
        PsiModifierList modifierList;
        PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)element.getPsi();
        PsiElement qualifier = ref.getQualifier();
        if (qualifier instanceof PsiJavaCodeReferenceElement) {
            if (((PsiJavaCodeReferenceElement)qualifier).resolve() instanceof PsiPackage) {
                return false;
            }
            if (PsiTreeUtil.getChildOfType((PsiElement)qualifier, PsiAnnotation.class) != null) {
                return true;
            }
        }
        if ((modifierList = PsiImplUtil.findNeighbourModifierList(ref)) != null) {
            for (PsiAnnotation annotation : modifierList.getAnnotations()) {
                if (AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)annotation, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_USE}) == null) continue;
                return true;
            }
        }
        return false;
    }

    public void processRange(@NotNull ASTNode element, int startOffset, int endOffset, boolean useFqInJavadoc, boolean useFqInCode) {
        if (element == null) {
            JavaReferenceAdjuster.$$$reportNull$$$0(2);
        }
        ArrayList<ASTNode> array = new ArrayList<ASTNode>();
        JavaReferenceAdjuster.addReferencesInRange(array, element, startOffset, endOffset);
        for (ASTNode ref : array) {
            if (!ref.getPsi().isValid()) continue;
            this.process(ref, true, true, useFqInJavadoc, useFqInCode);
        }
    }

    public void processRange(@NotNull ASTNode element, int startOffset, int endOffset, Project project) {
        if (element == null) {
            JavaReferenceAdjuster.$$$reportNull$$$0(3);
        }
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project);
        JavaCodeStyleSettings javaSettings = (JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class);
        this.processRange(element, startOffset, endOffset, javaSettings.useFqNamesInJavadocAlways(), javaSettings.USE_FQ_CLASS_NAMES);
    }

    private static void addReferencesInRange(List<ASTNode> array, ASTNode parent, int startOffset, int endOffset) {
        JspFile jspFile;
        if (parent.getElementType() == JavaElementType.JAVA_CODE_REFERENCE || parent.getElementType() == JavaElementType.REFERENCE_EXPRESSION) {
            array.add(parent);
            return;
        }
        if (parent.getPsi() instanceof PsiFile && (jspFile = JspPsiUtil.getJspFile((PsiElement)parent.getPsi())) != null) {
            JspClass jspClass = (JspClass)jspFile.getJavaClass();
            if (jspClass != null) {
                JavaReferenceAdjuster.addReferencesInRange(array, jspClass.getNode(), startOffset, endOffset);
            }
            return;
        }
        JavaReferenceAdjuster.addReferencesInRangeForComposite(array, parent, startOffset, endOffset);
    }

    private static void addReferencesInRangeForComposite(List<ASTNode> array, ASTNode parent, int startOffset, int endOffset) {
        int offset = 0;
        for (ASTNode child = parent.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            int length = child.getTextLength();
            if (startOffset <= offset + length && offset <= endOffset) {
                IElementType type2 = child.getElementType();
                if (type2 == JavaElementType.JAVA_CODE_REFERENCE || type2 == JavaElementType.REFERENCE_EXPRESSION) {
                    array.add(child);
                } else {
                    JavaReferenceAdjuster.addReferencesInRangeForComposite(array, child, startOffset - offset, endOffset - offset);
                }
            }
            offset += length;
        }
    }

    @NotNull
    private static ASTNode makeShortReference(@NotNull CompositeElement reference, @NotNull PsiClass refClass, boolean addImports) {
        PsiJavaCodeReferenceElement psiReference;
        PsiQualifiedReferenceElement reference1;
        if (reference == null) {
            JavaReferenceAdjuster.$$$reportNull$$$0(4);
        }
        if (refClass == null) {
            JavaReferenceAdjuster.$$$reportNull$$$0(5);
        }
        if ((reference1 = JavaReferenceAdjuster.getClassReferenceToShorten(refClass, addImports, (PsiQualifiedReferenceElement)(psiReference = (PsiJavaCodeReferenceElement)reference.getPsi()))) != null) {
            JavaReferenceAdjuster.replaceReferenceWithShort(reference1);
        }
        CompositeElement compositeElement = reference;
        if (compositeElement == null) {
            JavaReferenceAdjuster.$$$reportNull$$$0(6);
        }
        return compositeElement;
    }

    @Nullable
    public static PsiQualifiedReferenceElement getClassReferenceToShorten(@NotNull PsiClass refClass, boolean addImports, @NotNull PsiQualifiedReferenceElement reference) {
        PsiClass parentClass;
        if (refClass == null) {
            JavaReferenceAdjuster.$$$reportNull$$$0(7);
        }
        if (reference == null) {
            JavaReferenceAdjuster.$$$reportNull$$$0(8);
        }
        if ((parentClass = refClass.getContainingClass()) != null) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)parentClass.getProject());
            PsiResolveHelper resolveHelper = facade.getResolveHelper();
            if (resolveHelper.isAccessible((PsiMember)refClass, (PsiElement)reference, null) && JavaReferenceAdjuster.isSafeToShortenReference(reference.getReferenceName(), (PsiElement)reference, refClass)) {
                return reference;
            }
            if (!((JavaCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)reference.getProject()).getCustomSettings(JavaCodeStyleSettings.class)).INSERT_INNER_CLASS_IMPORTS) {
                PsiElement qualifier = reference.getQualifier();
                if (qualifier instanceof PsiQualifiedReferenceElement) {
                    return JavaReferenceAdjuster.getClassReferenceToShorten(parentClass, addImports, (PsiQualifiedReferenceElement)qualifier);
                }
                return null;
            }
        }
        if (addImports && !((PsiImportHolder)reference.getContainingFile()).importClass(refClass)) {
            return null;
        }
        if (!JavaReferenceAdjuster.isSafeToShortenReference((PsiElement)reference, refClass)) {
            return null;
        }
        return reference;
    }

    private static boolean isSafeToShortenReference(@NotNull PsiElement psiReference, @NotNull PsiClass refClass) {
        if (psiReference == null) {
            JavaReferenceAdjuster.$$$reportNull$$$0(9);
        }
        if (refClass == null) {
            JavaReferenceAdjuster.$$$reportNull$$$0(10);
        }
        return JavaReferenceAdjuster.isSafeToShortenReference(refClass.getName(), psiReference, refClass);
    }

    private static boolean isSafeToShortenReference(String referenceText, PsiElement psiReference, PsiClass refClass) {
        JavaPsiFacade facade;
        PsiResolveHelper helper;
        PsiManager manager = refClass.getManager();
        if (manager.areElementsEquivalent((PsiElement)refClass, (PsiElement)(helper = (facade = JavaPsiFacade.getInstance((Project)manager.getProject())).getResolveHelper()).resolveReferencedClass(referenceText, psiReference))) {
            if (psiReference instanceof PsiJavaCodeReferenceElement) {
                PsiClass containingClass;
                PsiElement parent = psiReference.getParent();
                if (parent instanceof PsiNewExpression || parent.getParent() instanceof PsiNewExpression) {
                    return true;
                }
                if (parent instanceof PsiTypeElement && parent.getParent() instanceof PsiInstanceOfExpression && (containingClass = refClass.getContainingClass()) != null && containingClass.hasTypeParameters()) {
                    return false;
                }
            }
            return helper.resolveReferencedVariable(referenceText, psiReference) == null;
        }
        return false;
    }

    @NotNull
    private static ASTNode replaceReferenceWithShort(PsiQualifiedReferenceElement reference) {
        ASTNode node = reference.getNode();
        assert (node != null);
        JavaReferenceAdjuster.deQualifyImpl((CompositeElement)node);
        ASTNode aSTNode = node;
        if (aSTNode == null) {
            JavaReferenceAdjuster.$$$reportNull$$$0(11);
        }
        return aSTNode;
    }

    private static void deQualifyImpl(@NotNull CompositeElement reference) {
        ASTNode qualifier;
        if (reference == null) {
            JavaReferenceAdjuster.$$$reportNull$$$0(12);
        }
        if ((qualifier = reference.findChildByRole(54)) != null) {
            ASTNode firstChildNode = qualifier.getFirstChildNode();
            boolean markToReformatBefore = firstChildNode instanceof TreeElement && CodeEditUtil.isMarkedToReformatBefore((TreeElement)((TreeElement)firstChildNode));
            reference.deleteChildInternal(qualifier);
            if (markToReformatBefore && (firstChildNode = reference.getFirstChildNode()) != null) {
                CodeEditUtil.markToReformatBefore((ASTNode)firstChildNode, (boolean)true);
            }
        }
    }

    private static ASTNode replaceReferenceWithFQ(ASTNode reference, PsiClass refClass) {
        ((SourceJavaCodeReference)reference).fullyQualify(refClass);
        return reference;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refClass";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/JavaReferenceAdjuster";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/JavaReferenceAdjuster";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "makeShortReference";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceReferenceWithShort";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processRange";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "makeShortReference";
                break;
            }
            case 6: 
            case 11: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getClassReferenceToShorten";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isSafeToShortenReference";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deQualifyImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

