/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.completion.scope.JavaCompletionProcessor;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.daemon.quickFix.CreateClassOrPackageFix;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.impl.GenericReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizableReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.ClassCandidateInfo;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.ClassKind;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaClassReference
extends GenericReference
implements PsiJavaReference,
LocalQuickFixProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference");
    protected final int myIndex;
    private TextRange myRange;
    private final String myText;
    private final boolean myInStaticImport;
    private final JavaClassReferenceSet myJavaClassReferenceSet;

    public JavaClassReference(JavaClassReferenceSet referenceSet, TextRange range, int index, String text2, boolean staticImport) {
        super(referenceSet.getProvider());
        this.myInStaticImport = staticImport;
        LOG.assertTrue(range.getEndOffset() <= referenceSet.getElement().getTextLength());
        this.myIndex = index;
        this.myRange = range;
        this.myText = text2;
        this.myJavaClassReferenceSet = referenceSet;
    }

    @Override
    @Nullable
    public PsiElement getContext() {
        PsiReference contextRef = this.getContextReference();
        assert (contextRef != this) : this.getCanonicalText();
        return contextRef != null ? contextRef.resolve() : null;
    }

    @Override
    public void processVariants(final @NotNull PsiScopeProcessor processor) {
        Map<CustomizableReferenceProvider.CustomizationKey, Object> options;
        if (processor == null) {
            JavaClassReference.$$$reportNull$$$0(0);
        }
        if (processor instanceof JavaCompletionProcessor && ((options = this.getOptions()) != null && (JavaClassReferenceProvider.SUPER_CLASSES.getValue(options) != null || JavaClassReferenceProvider.NOT_INTERFACE.getBooleanValue(options) || JavaClassReferenceProvider.CONCRETE.getBooleanValue(options)) || JavaClassReferenceProvider.CLASS_KIND.getValue(options) != null)) {
            ((JavaCompletionProcessor)processor).setCompletionElements(this.getVariants());
            return;
        }
        PsiScopeProcessor processorToUse = processor;
        if (this.myInStaticImport) {
            processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.CHANGE_LEVEL, null);
        } else {
            if (this.isDefinitelyStatic()) {
                processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.START_STATIC, null);
            }
            processorToUse = new PsiScopeProcessor(){

                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (state == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return !(element instanceof PsiClass) && !(element instanceof PsiPackage) || processor.execute(element, state);
                }

                public <V> V getHint(@NotNull Key<V> hintKey) {
                    if (hintKey == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return (V)processor.getHint(hintKey);
                }

                public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
                    if (event == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    processor.handleEvent(event, associated);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "state";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "hintKey";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReference$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "execute";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getHint";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "handleEvent";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        super.processVariants(processorToUse);
    }

    private boolean isDefinitelyStatic() {
        String s = this.getElement().getText();
        return this.isStaticClassReference(s, true);
    }

    private boolean isStaticClassReference(String s, boolean strict) {
        if (this.myIndex == 0) {
            return false;
        }
        char c = s.charAt(this.getRangeInElement().getStartOffset() - 1);
        return this.myJavaClassReferenceSet.isStaticSeparator(c, strict);
    }

    @Override
    @Nullable
    public PsiReference getContextReference() {
        return this.myIndex > 0 ? this.myJavaClassReferenceSet.getReference(this.myIndex - 1) : null;
    }

    private boolean canReferencePackage() {
        return this.myJavaClassReferenceSet.canReferencePackage(this.myIndex);
    }

    public PsiElement getElement() {
        return this.myJavaClassReferenceSet.getElement();
    }

    public boolean isReferenceTo(PsiElement element) {
        return (element instanceof PsiMember || element instanceof PsiPackage) && super.isReferenceTo(element);
    }

    public TextRange getRangeInElement() {
        return this.myRange;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myText;
        if (string == null) {
            JavaClassReference.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isSoft() {
        return this.myJavaClassReferenceSet.isSoft();
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ElementManipulator manipulator = JavaClassReference.getManipulator((PsiElement)this.getElement());
        PsiElement element = manipulator.handleContentChange(this.getElement(), this.getRangeInElement(), newElementName);
        this.myRange = new TextRange(this.getRangeInElement().getStartOffset(), this.getRangeInElement().getStartOffset() + newElementName.length());
        return element;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        String newName;
        if (element == null) {
            JavaClassReference.$$$reportNull$$$0(2);
        }
        if (this.isReferenceTo(element)) {
            return this.getElement();
        }
        if (element instanceof PsiClass) {
            newName = this.getQualifiedClassNameToInsert((PsiClass)element);
        } else if (element instanceof PsiPackage) {
            PsiPackage psiPackage = (PsiPackage)element;
            newName = psiPackage.getQualifiedName();
        } else {
            throw new IncorrectOperationException("Cannot bind to " + element);
        }
        assert (newName != null);
        int end = this.getRangeInElement().getEndOffset();
        String text2 = this.getElement().getText();
        int lt = text2.indexOf(60, this.getRangeInElement().getStartOffset());
        if (lt >= 0 && lt < end) {
            end = CharArrayUtil.shiftBackward((CharSequence)text2, (int)(lt - 1), (String)"\n\t ") + 1;
        }
        TextRange range = new TextRange(this.myJavaClassReferenceSet.getReference(0).getRangeInElement().getStartOffset(), end);
        ElementManipulator manipulator = JavaClassReference.getManipulator((PsiElement)this.getElement());
        PsiElement finalElement = manipulator.handleContentChange(this.getElement(), range, newName);
        this.myJavaClassReferenceSet.reparse(finalElement, TextRange.from((int)range.getStartOffset(), (int)newName.length()));
        return finalElement;
    }

    private String getQualifiedClassNameToInsert(PsiClass psiClass) {
        boolean jvmFormat = Boolean.TRUE.equals(JavaClassReferenceProvider.JVM_FORMAT.getValue(this.getOptions()));
        return jvmFormat ? ClassUtil.getJVMClassName((PsiClass)psiClass) : psiClass.getQualifiedName();
    }

    public PsiElement resolveInner() {
        return this.advancedResolve(true).getElement();
    }

    @NotNull
    public Object[] getVariants() {
        PsiElement context = this.getCompletionContext();
        if (context instanceof PsiPackage) {
            Object[] objectArray = this.processPackage((PsiPackage)context);
            if (objectArray == null) {
                JavaClassReference.$$$reportNull$$$0(3);
            }
            return objectArray;
        }
        if (context instanceof PsiClass) {
            PsiClass aClass = (PsiClass)context;
            if (this.myInStaticImport) {
                Object[] objectArray = ArrayUtil.mergeArrays((Object[])aClass.getInnerClasses(), (Object[])aClass.getFields(), (ArrayFactory)ArrayUtil.OBJECT_ARRAY_FACTORY);
                if (objectArray == null) {
                    JavaClassReference.$$$reportNull$$$0(4);
                }
                return objectArray;
            }
            if (this.isDefinitelyStatic()) {
                PsiClass[] psiClasses = aClass.getInnerClasses();
                ArrayList<PsiClass> staticClasses = new ArrayList<PsiClass>(psiClasses.length);
                for (PsiClass c : psiClasses) {
                    if (!c.hasModifierProperty("static")) continue;
                    staticClasses.add(c);
                }
                Object[] objectArray = staticClasses.isEmpty() ? PsiClass.EMPTY_ARRAY : staticClasses.toArray(new PsiClass[staticClasses.size()]);
                if (objectArray == null) {
                    JavaClassReference.$$$reportNull$$$0(5);
                }
                return objectArray;
            }
        }
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            JavaClassReference.$$$reportNull$$$0(6);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Nullable
    public PsiElement getCompletionContext() {
        PsiElement context = this.getContext();
        return context == null ? JavaPsiFacade.getInstance((Project)this.getElement().getProject()).findPackage("") : context;
    }

    @Nullable
    public String[] getExtendClassNames() {
        List<String> result = this.getSuperClasses();
        return result.isEmpty() ? null : ArrayUtil.toStringArray(result);
    }

    @NotNull
    public List<String> getSuperClasses() {
        List values = (List)JavaClassReferenceProvider.SUPER_CLASSES.getValue(this.getOptions());
        List list = values == null ? Collections.emptyList() : values;
        if (list == null) {
            JavaClassReference.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private LookupElement[] processPackage(@NotNull PsiPackage aPackage) {
        if (aPackage == null) {
            JavaClassReference.$$$reportNull$$$0(8);
        }
        ArrayList list = ContainerUtil.newArrayList();
        int startOffset = StringUtil.isEmpty((String)aPackage.getName()) ? 0 : aPackage.getQualifiedName().length() + 1;
        GlobalSearchScope scope = this.getScope(this.getJavaContextFile());
        for (PsiPackage subPackage : aPackage.getSubPackages(scope)) {
            String shortName = subPackage.getQualifiedName().substring(startOffset);
            if (!PsiNameHelper.getInstance((Project)subPackage.getProject()).isIdentifier(shortName)) continue;
            list.add(LookupElementBuilder.create((PsiNamedElement)subPackage).withIcon(subPackage.getIcon(1)));
        }
        List classes2 = ContainerUtil.filter((Object[])aPackage.getClasses(scope), psiClass -> StringUtil.isNotEmpty((String)psiClass.getName()));
        Map<CustomizableReferenceProvider.CustomizationKey, Object> options = this.getOptions();
        if (options != null) {
            boolean instantiatable = JavaClassReferenceProvider.INSTANTIATABLE.getBooleanValue(options);
            boolean concrete = JavaClassReferenceProvider.CONCRETE.getBooleanValue(options);
            boolean notInterface = JavaClassReferenceProvider.NOT_INTERFACE.getBooleanValue(options);
            boolean notEnum = JavaClassReferenceProvider.NOT_ENUM.getBooleanValue(options);
            ClassKind classKind = this.getClassKind();
            for (PsiClass clazz : classes2) {
                if (!JavaClassReference.isClassAccepted(clazz, classKind, instantiatable, concrete, notInterface, notEnum)) continue;
                list.add(JavaClassNameCompletionContributor.createClassLookupItem(clazz, false));
            }
        } else {
            for (PsiClass clazz : classes2) {
                list.add(JavaClassNameCompletionContributor.createClassLookupItem(clazz, false));
            }
        }
        LookupElement[] lookupElementArray = list.toArray(new LookupElement[list.size()]);
        if (lookupElementArray == null) {
            JavaClassReference.$$$reportNull$$$0(9);
        }
        return lookupElementArray;
    }

    @Nullable
    public ClassKind getClassKind() {
        return (ClassKind)JavaClassReferenceProvider.CLASS_KIND.getValue(this.getOptions());
    }

    private static boolean isClassAccepted(PsiClass clazz, @Nullable ClassKind classKind, boolean instantiatable, boolean concrete, boolean notInterface, boolean notEnum) {
        if (classKind == ClassKind.ANNOTATION) {
            return clazz.isAnnotationType();
        }
        if (classKind == ClassKind.ENUM) {
            return clazz.isEnum();
        }
        if (instantiatable) {
            if (PsiUtil.isInstantiatable((PsiClass)clazz)) {
                return true;
            }
        } else if (concrete) {
            if (!clazz.hasModifierProperty("abstract") && !clazz.isInterface()) {
                return true;
            }
        } else if (notInterface) {
            if (!clazz.isInterface()) {
                return true;
            }
        } else if (notEnum) {
            if (!clazz.isEnum()) {
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        PsiFile file = this.getJavaContextFile();
        ResolveCache resolveCache = ResolveCache.getInstance((Project)file.getProject());
        JavaResolveResult javaResolveResult = (JavaResolveResult)resolveCache.resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantContextResolver)MyResolver.INSTANCE, false, false, file)[0];
        if (javaResolveResult == null) {
            JavaClassReference.$$$reportNull$$$0(10);
        }
        return javaResolveResult;
    }

    private PsiFile getJavaContextFile() {
        return this.myJavaClassReferenceSet.getProvider().getContextFile(this.getElement());
    }

    @NotNull
    private JavaResolveResult doAdvancedResolve(@NotNull PsiFile containingFile) {
        JavaResolveResult viaImports;
        int endOffset;
        PsiElement psiElement;
        if (containingFile == null) {
            JavaClassReference.$$$reportNull$$$0(11);
        }
        if (!(psiElement = this.getElement()).isValid()) {
            JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
            if (javaResolveResult == null) {
                JavaClassReference.$$$reportNull$$$0(12);
            }
            return javaResolveResult;
        }
        String elementText = psiElement.getText();
        PsiElement context = this.getContext();
        if (context instanceof PsiClass) {
            if (this.isStaticClassReference(elementText, false)) {
                PsiClass psiClass = ((PsiClass)context).findInnerClassByName(this.getCanonicalText(), false);
                if (psiClass != null) {
                    ClassCandidateInfo classCandidateInfo = new ClassCandidateInfo((PsiElement)psiClass, PsiSubstitutor.EMPTY, false, psiElement);
                    if (classCandidateInfo == null) {
                        JavaClassReference.$$$reportNull$$$0(13);
                    }
                    return classCandidateInfo;
                }
                PsiElement member = JavaClassReference.doResolveMember((PsiClass)context, this.myText);
                Object object = member == null ? JavaResolveResult.EMPTY : new CandidateInfo(member, PsiSubstitutor.EMPTY, false, false, psiElement);
                if (object == null) {
                    JavaClassReference.$$$reportNull$$$0(14);
                }
                return object;
            }
            if (!this.myInStaticImport && this.myJavaClassReferenceSet.isAllowDollarInNames()) {
                JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
                if (javaResolveResult == null) {
                    JavaClassReference.$$$reportNull$$$0(15);
                }
                return javaResolveResult;
            }
        }
        LOG.assertTrue((endOffset = this.getRangeInElement().getEndOffset()) <= elementText.length(), (Object)elementText);
        int startOffset = this.myJavaClassReferenceSet.getReference(0).getRangeInElement().getStartOffset();
        String qName = elementText.substring(startOffset, endOffset);
        if (!qName.contains(".") && (viaImports = (JavaResolveResult)JBIterable.from((Iterable)((Iterable)JavaClassReferenceProvider.IMPORTS.getValue(this.getOptions()))).map(o -> {
            if (containingFile == null) {
                JavaClassReference.$$$reportNull$$$0(29);
            }
            return o == null ? JavaResolveResult.EMPTY : this.advancedResolveInner(psiElement, o + "." + qName, containingFile);
        }).find(o -> o != JavaResolveResult.EMPTY)) != null) {
            JavaResolveResult javaResolveResult = viaImports;
            if (javaResolveResult == null) {
                JavaClassReference.$$$reportNull$$$0(16);
            }
            return javaResolveResult;
        }
        JavaResolveResult javaResolveResult = this.advancedResolveInner(psiElement, qName, containingFile);
        if (javaResolveResult == null) {
            JavaClassReference.$$$reportNull$$$0(17);
        }
        return javaResolveResult;
    }

    private JavaResolveResult advancedResolveInner(@NotNull PsiElement psiElement, @NotNull String qName, @NotNull PsiFile containingFile) {
        PsiPackage resolveResult;
        if (psiElement == null) {
            JavaClassReference.$$$reportNull$$$0(18);
        }
        if (qName == null) {
            JavaClassReference.$$$reportNull$$$0(19);
        }
        if (containingFile == null) {
            JavaClassReference.$$$reportNull$$$0(20);
        }
        PsiManager manager = containingFile.getManager();
        GlobalSearchScope scope = this.getScope(containingFile);
        if (this.myIndex == this.myJavaClassReferenceSet.getReferences().length - 1) {
            PsiClass aClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(qName, scope);
            if (aClass != null) {
                return new ClassCandidateInfo((PsiElement)aClass, PsiSubstitutor.EMPTY, false, psiElement);
            }
            if (!JavaClassReferenceProvider.ADVANCED_RESOLVE.getBooleanValue(this.getOptions())) {
                return JavaResolveResult.EMPTY;
            }
        }
        if ((resolveResult = JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage(qName)) == null) {
            resolveResult = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(qName, scope);
        }
        if (this.myInStaticImport && resolveResult == null) {
            resolveResult = JavaClassReference.resolveMember(qName, manager, this.getElement().getResolveScope());
        }
        if (resolveResult == null && containingFile instanceof PsiJavaFile) {
            if (containingFile instanceof ServerPageFile && (containingFile = containingFile.getViewProvider().getPsi((Language)JavaLanguage.INSTANCE)) == null) {
                return JavaResolveResult.EMPTY;
            }
            ClassResolverProcessor processor = new ClassResolverProcessor(this.getCanonicalText(), psiElement, containingFile);
            PsiClass contextClass = this.myJavaClassReferenceSet.getProvider().getContextClass(psiElement);
            if (contextClass != null) {
                PsiScopesUtil.treeWalkUp(processor, (PsiElement)contextClass, null);
            } else {
                containingFile.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), null, psiElement);
            }
            if (processor.getResult().length == 1) {
                JavaResolveResult javaResolveResult = processor.getResult()[0];
                if (javaResolveResult != JavaResolveResult.EMPTY && this.getOptions() != null) {
                    String qualifiedName;
                    Boolean value2 = (Boolean)JavaClassReferenceProvider.RESOLVE_QUALIFIED_CLASS_NAME.getValue(this.getOptions());
                    PsiClass psiClass = (PsiClass)javaResolveResult.getElement();
                    if (value2 != null && value2.booleanValue() && psiClass != null && !qName.equals(qualifiedName = psiClass.getQualifiedName())) {
                        return JavaResolveResult.EMPTY;
                    }
                }
                return javaResolveResult;
            }
        }
        return resolveResult != null ? new CandidateInfo((PsiElement)resolveResult, PsiSubstitutor.EMPTY, false, false, psiElement) : JavaResolveResult.EMPTY;
    }

    private GlobalSearchScope getScope(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            JavaClassReference.$$$reportNull$$$0(21);
        }
        Project project = containingFile.getProject();
        GlobalSearchScope scope = this.myJavaClassReferenceSet.getProvider().getScope(project);
        if (scope == null) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)containingFile);
            return module == null ? GlobalSearchScope.allScope((Project)project) : module.getModuleWithDependenciesAndLibrariesScope(true);
        }
        return scope;
    }

    @Nullable
    private Map<CustomizableReferenceProvider.CustomizationKey, Object> getOptions() {
        return this.myJavaClassReferenceSet.getOptions();
    }

    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult javaResolveResult = this.advancedResolve(incompleteCode);
        if (javaResolveResult.getElement() == null) {
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                JavaClassReference.$$$reportNull$$$0(22);
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        JavaResolveResult[] javaResolveResultArray = new JavaResolveResult[]{javaResolveResult};
        if (javaResolveResultArray == null) {
            JavaClassReference.$$$reportNull$$$0(23);
        }
        return javaResolveResultArray;
    }

    @Nullable
    private List<? extends LocalQuickFix> registerFixes() {
        ClassKind kind2;
        List list = QuickFixFactory.getInstance().registerOrderEntryFixes((QuickFixActionRegistrar)new QuickFixActionRegistrarImpl(null), (PsiReference)this);
        String[] extendClasses = this.getExtendClassNames();
        String extendClass = extendClasses != null && extendClasses.length > 0 ? extendClasses[0] : null;
        JavaClassReference[] references = this.getJavaClassReferenceSet().getAllReferences();
        PsiPackage contextPackage = null;
        for (int i = this.myIndex; i >= 0; --i) {
            PsiElement context = references[i].getContext();
            if (context == null) continue;
            if (!(context instanceof PsiPackage)) break;
            contextPackage = (PsiPackage)context;
            break;
        }
        boolean createJavaClass = !this.canReferencePackage();
        ClassKind classKind = kind2 = createJavaClass ? this.getClassKind() : null;
        if (createJavaClass && kind2 == null) {
            kind2 = ClassKind.CLASS;
        }
        String templateName = (String)JavaClassReferenceProvider.CLASS_TEMPLATE.getValue(this.getOptions());
        TextRange range = new TextRange(references[0].getRangeInElement().getStartOffset(), this.getRangeInElement().getEndOffset());
        String qualifiedName = range.substring(this.getElement().getText());
        CreateClassOrPackageFix action = CreateClassOrPackageFix.createFix(qualifiedName, this.getScope(this.getJavaContextFile()), this.getElement(), contextPackage, kind2, extendClass, templateName);
        if (action != null) {
            if (list == null) {
                return Collections.singletonList(action);
            }
            ArrayList<CreateClassOrPackageFix> fixes = new ArrayList<CreateClassOrPackageFix>(list.size() + 1);
            fixes.addAll(list);
            fixes.add(action);
            return fixes;
        }
        return list;
    }

    public void processSubclassVariants(@NotNull PsiPackage context, @NotNull String[] extendClasses, Consumer<LookupElement> result) {
        if (context == null) {
            JavaClassReference.$$$reportNull$$$0(24);
        }
        if (extendClasses == null) {
            JavaClassReference.$$$reportNull$$$0(25);
        }
        GlobalSearchScope packageScope = PackageScope.packageScope((PsiPackage)context, (boolean)true);
        GlobalSearchScope scope = this.myJavaClassReferenceSet.getProvider().getScope(this.getElement().getProject());
        if (scope != null) {
            packageScope = packageScope.intersectWith(scope);
        }
        GlobalSearchScope allScope = ProjectScope.getAllScope((Project)context.getProject());
        boolean instantiatable = JavaClassReferenceProvider.INSTANTIATABLE.getBooleanValue(this.getOptions());
        boolean notInterface = JavaClassReferenceProvider.NOT_INTERFACE.getBooleanValue(this.getOptions());
        boolean notEnum = JavaClassReferenceProvider.NOT_ENUM.getBooleanValue(this.getOptions());
        boolean concrete = JavaClassReferenceProvider.CONCRETE.getBooleanValue(this.getOptions());
        ClassKind classKind = this.getClassKind();
        for (String extendClassName : extendClasses) {
            PsiClass extendClass = JavaPsiFacade.getInstance((Project)context.getProject()).findClass(extendClassName, allScope);
            if (extendClass == null) continue;
            if (packageScope.contains(extendClass.getContainingFile().getVirtualFile()) && JavaClassReference.isClassAccepted(extendClass, classKind, instantiatable, concrete, notInterface, notEnum)) {
                result.consume((Object)this.createSubclassLookupValue(extendClass));
            }
            for (PsiClass clazz : ClassInheritorsSearch.search((PsiClass)extendClass, (SearchScope)packageScope, (boolean)true)) {
                String qname = clazz.getQualifiedName();
                if (qname == null || !JavaClassReference.isClassAccepted(clazz, classKind, instantiatable, concrete, notInterface, notEnum)) continue;
                result.consume((Object)this.createSubclassLookupValue(clazz));
            }
        }
    }

    @NotNull
    private LookupElementBuilder createSubclassLookupValue(@NotNull PsiClass clazz) {
        if (clazz == null) {
            JavaClassReference.$$$reportNull$$$0(26);
        }
        LookupElementBuilder lookupElementBuilder = JavaLookupElementBuilder.forClass(clazz, this.getQualifiedClassNameToInsert(clazz), true).withPresentableText((String)ObjectUtils.assertNotNull((Object)clazz.getName()));
        if (lookupElementBuilder == null) {
            JavaClassReference.$$$reportNull$$$0(27);
        }
        return lookupElementBuilder;
    }

    public LocalQuickFix[] getQuickFixes() {
        List<? extends LocalQuickFix> list = this.registerFixes();
        return list == null ? LocalQuickFix.EMPTY_ARRAY : list.toArray(new LocalQuickFix[list.size()]);
    }

    @Nullable
    public static PsiElement resolveMember(String fqn, PsiManager manager, GlobalSearchScope resolveScope) {
        PsiClass aClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(fqn, resolveScope);
        if (aClass != null) {
            return aClass;
        }
        int i = fqn.lastIndexOf(46);
        if (i == -1) {
            return null;
        }
        String memberName = fqn.substring(i + 1);
        fqn = fqn.substring(0, i);
        aClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(fqn, resolveScope);
        if (aClass == null) {
            return null;
        }
        return JavaClassReference.doResolveMember(aClass, memberName);
    }

    @Nullable
    private static PsiElement doResolveMember(PsiClass aClass, String memberName) {
        PsiField member = aClass.findFieldByName(memberName, true);
        if (member != null) {
            return member;
        }
        PsiMethod[] methods = aClass.findMethodsByName(memberName, true);
        return methods.length == 0 ? null : methods[0];
    }

    public JavaClassReferenceSet getJavaClassReferenceSet() {
        return this.myJavaClassReferenceSet;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = this.myJavaClassReferenceSet.getUnresolvedMessagePattern(this.myIndex);
        if (string == null) {
            JavaClassReference.$$$reportNull$$$0(28);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 11: 
            case 20: 
            case 21: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extendClasses";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClasses";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "processPackage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "advancedResolve";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "doAdvancedResolve";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createSubclassLookupValue";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processVariants";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 27: 
            case 28: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processPackage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doAdvancedResolve";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "advancedResolveInner";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processSubclassVariants";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createSubclassLookupValue";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doAdvancedResolve$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyResolver
    implements ResolveCache.PolyVariantContextResolver<JavaClassReference> {
        private static final MyResolver INSTANCE = new MyResolver();

        private MyResolver() {
        }

        @NotNull
        public ResolveResult[] resolve(@NotNull JavaClassReference ref, @NotNull PsiFile containingFile, boolean incompleteCode) {
            if (ref == null) {
                MyResolver.$$$reportNull$$$0(0);
            }
            if (containingFile == null) {
                MyResolver.$$$reportNull$$$0(1);
            }
            JavaResolveResult[] javaResolveResultArray = new JavaResolveResult[]{ref.doAdvancedResolve(containingFile)};
            if (javaResolveResultArray == null) {
                MyResolver.$$$reportNull$$$0(2);
            }
            return javaResolveResultArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReference$MyResolver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReference$MyResolver";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

