/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PatternUtil;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternPackageReferenceSet
extends PackageReferenceSet {
    public PatternPackageReferenceSet(@NotNull String packageName, @NotNull PsiElement element, int startInElement, @NotNull GlobalSearchScope scope) {
        if (packageName == null) {
            PatternPackageReferenceSet.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PatternPackageReferenceSet.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            PatternPackageReferenceSet.$$$reportNull$$$0(2);
        }
        super(packageName, element, startInElement, scope);
    }

    @Override
    public Collection<PsiPackage> resolvePackageName(@Nullable PsiPackage context, String packageName) {
        if (context == null) {
            return Collections.emptySet();
        }
        if (packageName.contains("*")) {
            LinkedHashSet<PsiPackage> packages = new LinkedHashSet<PsiPackage>();
            Pattern pattern = PatternUtil.fromMask((String)packageName);
            this.processSubPackages(context, (Processor<PsiPackage>)((Processor)psiPackage -> {
                String name = psiPackage.getName();
                if (name != null && pattern.matcher(name).matches()) {
                    packages.add((PsiPackage)psiPackage);
                }
                return true;
            }));
            return packages;
        }
        return super.resolvePackageName(context, packageName);
    }

    protected boolean processSubPackages(PsiPackage pkg, Processor<PsiPackage> processor) {
        for (PsiPackage aPackage : pkg.getSubPackages(this.getResolveScope())) {
            if (!processor.process((Object)aPackage)) {
                return false;
            }
            if (this.processSubPackages(aPackage, processor)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "packageName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "scope";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/PatternPackageReferenceSet";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

