/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.injection.ConcatenationAwareInjector;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.InjectedLanguagePlaces;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.tree.PsiCommentImpl;
import com.intellij.psi.impl.source.tree.injected.JavaConcatenationInjectorManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MyTestInjector {
    private final PsiManager myPsiManager;

    public MyTestInjector(PsiManager psiManager) {
        this.myPsiManager = psiManager;
    }

    public void injectAll(Disposable parent) {
        MyTestInjector.injectVariousStuffEverywhere(parent, this.myPsiManager);
        Project project = this.myPsiManager.getProject();
        Language ql = Language.findLanguageByID((String)"JPAQL");
        Language js = Language.findLanguageByID((String)"JavaScript");
        MyTestInjector.registerForStringVarInitializer(parent, project, ql, "ql", null, null);
        MyTestInjector.registerForStringVarInitializer(parent, project, ql, "qlPrefixed", "xxx", null);
        MyTestInjector.registerForStringVarInitializer(parent, project, js, "js", null, null);
        MyTestInjector.registerForStringVarInitializer(parent, project, js, "jsSeparated", " + ", " + 'separator'");
        MyTestInjector.registerForStringVarInitializer(parent, project, js, "jsBrokenPrefix", "xx ", "");
        MyTestInjector.registerForStringVarInitializer(parent, project, Language.findLanguageByID((String)"Oracle"), "oracle", null, null);
        MyTestInjector.registerForParameterValue(parent, project, Language.findLanguageByID((String)"Groovy"), "groovy");
        MyTestInjector.registerForStringVarInitializer(parent, project, (Language)JavaLanguage.INSTANCE, "java", "", "");
    }

    private static void registerForParameterValue(Disposable parent, Project project, final Language language, final String paramName) {
        if (language == null) {
            return;
        }
        final ConcatenationAwareInjector injector = new ConcatenationAwareInjector(){

            public void getLanguagesToInject(@NotNull MultiHostRegistrar injectionPlacesRegistrar, PsiElement ... operands2) {
                PsiElement operand2;
                if (injectionPlacesRegistrar == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (operands2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!((operand2 = operands2[0]) instanceof PsiLiteralExpression)) {
                    return;
                }
                if (!(operand2.getParent() instanceof PsiExpressionList)) {
                    return;
                }
                PsiExpressionList expressionList = (PsiExpressionList)operand2.getParent();
                int i = ArrayUtil.indexOf((Object[])expressionList.getExpressions(), (Object)operand2);
                if (!(operand2.getParent().getParent() instanceof PsiMethodCallExpression)) {
                    return;
                }
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)operand2.getParent().getParent();
                PsiMethod method = methodCallExpression.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiParameter[] parameters2 = method.getParameterList().getParameters();
                if (i >= parameters2.length) {
                    return;
                }
                PsiParameter parameter2 = parameters2[i];
                if (!paramName.equals(parameter2.getName())) {
                    return;
                }
                TextRange textRange = MyTestInjector.textRangeToInject((PsiLanguageInjectionHost)operand2);
                injectionPlacesRegistrar.startInjecting(language).addPlace(null, null, (PsiLanguageInjectionHost)operand2, textRange).doneInjecting();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "injectionPlacesRegistrar";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "operands";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/psi/impl/source/tree/injected/MyTestInjector$1";
                objectArray[2] = "getLanguagesToInject";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        final JavaConcatenationInjectorManager injectorManager = JavaConcatenationInjectorManager.getInstance(project);
        injectorManager.registerConcatenationInjector(injector);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                boolean b = injectorManager.unregisterConcatenationInjector(injector);
                assert (b);
            }
        });
    }

    private static void registerForStringVarInitializer(@NotNull Disposable parent, @NotNull Project project, final Language language, final @NotNull @NonNls String varName, final @NonNls String prefix, final @NonNls String suffix) {
        if (parent == null) {
            MyTestInjector.$$$reportNull$$$0(0);
        }
        if (project == null) {
            MyTestInjector.$$$reportNull$$$0(1);
        }
        if (varName == null) {
            MyTestInjector.$$$reportNull$$$0(2);
        }
        if (language == null) {
            return;
        }
        final ConcatenationAwareInjector injector = new ConcatenationAwareInjector(){

            public void getLanguagesToInject(@NotNull MultiHostRegistrar injectionPlacesRegistrar, PsiElement ... operands2) {
                PsiVariable variable;
                if (injectionPlacesRegistrar == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (operands2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                if ((variable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)operands2[0], PsiVariable.class)) == null) {
                    return;
                }
                if (!varName.equals(variable.getName())) {
                    return;
                }
                if (!(operands2[0] instanceof PsiLiteralExpression)) {
                    return;
                }
                boolean started = false;
                String prefixFromPrev = "";
                for (int i = 0; i < operands2.length; ++i) {
                    PsiElement operand2 = operands2[i];
                    if (!(operand2 instanceof PsiLiteralExpression)) continue;
                    Object value2 = ((PsiLiteralExpression)operand2).getValue();
                    if (!(value2 instanceof String)) {
                        prefixFromPrev = prefixFromPrev + value2;
                        continue;
                    }
                    TextRange textRange = MyTestInjector.textRangeToInject((PsiLanguageInjectionHost)operand2);
                    if (!started) {
                        injectionPlacesRegistrar.startInjecting(language);
                        started = true;
                    }
                    injectionPlacesRegistrar.addPlace(prefixFromPrev + (i == 0 ? "" : (prefix == null ? "" : prefix)), i == operands2.length - 1 ? null : suffix, (PsiLanguageInjectionHost)operand2, textRange);
                    prefixFromPrev = "";
                }
                if (started) {
                    injectionPlacesRegistrar.doneInjecting();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "injectionPlacesRegistrar";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "operands";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/psi/impl/source/tree/injected/MyTestInjector$3";
                objectArray[2] = "getLanguagesToInject";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        final JavaConcatenationInjectorManager injectorManager = JavaConcatenationInjectorManager.getInstance(project);
        injectorManager.registerConcatenationInjector(injector);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                boolean b = injectorManager.unregisterConcatenationInjector(injector);
                assert (b);
            }
        });
    }

    private static void injectVariousStuffEverywhere(Disposable parent, PsiManager psiManager) {
        final Language ql = Language.findLanguageByID((String)"JPAQL");
        final Language js = Language.findLanguageByID((String)"JavaScript 1.6");
        final Language html = Language.findLanguageByID((String)"HTML");
        if (ql == null || js == null) {
            return;
        }
        final Language ecma4 = Language.findLanguageByID((String)"ECMA Script Level 4");
        MultiHostInjector myMultiHostInjector = new MultiHostInjector(){

            public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
                String attrName;
                XmlAttributeValue value2;
                PsiElement parent;
                if (registrar == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    5.$$$reportNull$$$0(1);
                }
                if ((parent = (value2 = (XmlAttributeValue)context).getParent()) instanceof XmlAttribute && "jsInBraces".equals(attrName = ((XmlAttribute)parent).getLocalName())) {
                    registrar.startInjecting(js);
                    String text2 = value2.getText();
                    int index = 0;
                    while (text2.indexOf(123, index) != -1) {
                        int lbrace = text2.indexOf(123, index);
                        int rbrace = text2.indexOf(125, index);
                        registrar.addPlace("", "", (PsiLanguageInjectionHost)value2, new TextRange(lbrace + 1, rbrace));
                        index = rbrace + 1;
                    }
                    registrar.doneInjecting();
                }
            }

            @NotNull
            public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
                List<Class> list = Arrays.asList(XmlAttributeValue.class);
                if (list == null) {
                    5.$$$reportNull$$$0(2);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "registrar";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/MyTestInjector$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/MyTestInjector$5";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "elementsToInjectIn";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getLanguagesToInject";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        InjectedLanguageManager.getInstance((Project)psiManager.getProject()).registerMultiHostInjector(myMultiHostInjector, parent);
        final LanguageInjector myInjector = new LanguageInjector(){

            public void getLanguagesToInject(@NotNull PsiLanguageInjectionHost host, @NotNull InjectedLanguagePlaces placesToInject) {
                String text2;
                String text3;
                XmlAttributeValue value2;
                PsiElement parent;
                if (host == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (placesToInject == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (host instanceof XmlAttributeValue && (parent = (value2 = (XmlAttributeValue)host).getParent()) instanceof XmlAttribute) {
                    String attrName = ((XmlAttribute)parent).getLocalName();
                    if ("ql".equals(attrName)) {
                        MyTestInjector.inject(host, placesToInject, ql);
                        return;
                    }
                    if ("js".equals(attrName)) {
                        MyTestInjector.inject(host, placesToInject, js);
                        return;
                    }
                    if ("jsprefix".equals(attrName)) {
                        MyTestInjector.inject(host, placesToInject, js, "function foo(doc, window){", "}");
                        return;
                    }
                }
                if (host instanceof XmlText) {
                    int end;
                    int start;
                    XmlText xmlText = (XmlText)host;
                    XmlTag tag = xmlText.getParentTag();
                    if (tag == null) {
                        return;
                    }
                    if ("ql".equals(tag.getLocalName())) {
                        MyTestInjector.inject(host, placesToInject, ql);
                        return;
                    }
                    if ("js".equals(tag.getLocalName())) {
                        MyTestInjector.inject(host, placesToInject, js);
                        return;
                    }
                    if ("htmlInject".equals(tag.getLocalName())) {
                        MyTestInjector.inject(host, placesToInject, html);
                        return;
                    }
                    if (ecma4 != null && "ecma4".equals(tag.getLocalName())) {
                        MyTestInjector.inject(host, placesToInject, ecma4);
                        return;
                    }
                    if ("jsprefix".equals(tag.getLocalName())) {
                        MyTestInjector.inject(host, placesToInject, js, "function foo(doc, window){", "}");
                        return;
                    }
                    if ("jsInHash".equals(tag.getLocalName()) && (text3 = xmlText.getText()).contains("#") && (start = text3.indexOf(35)) != (end = text3.lastIndexOf(35)) && start != -1) {
                        placesToInject.addPlace(js, new TextRange(start + 1, end), null, null);
                        return;
                    }
                }
                if (host instanceof PsiComment && ((PsiComment)host).getTokenType() == JavaTokenType.C_STYLE_COMMENT) {
                    text2 = host.getText();
                    String prefix = "/*\n * {{{\n";
                    String suffix = " }}}\n */";
                    if (text2.startsWith(prefix) && text2.endsWith(suffix)) {
                        String s = StringUtil.trimEnd((String)StringUtil.trimStart((String)text2, (String)prefix), (String)suffix);
                        int off = 0;
                        while (!s.isEmpty()) {
                            String t = s.trim();
                            if (t.startsWith("*")) {
                                t = t.substring(1).trim();
                            }
                            int i = s.length() - t.length();
                            off += i;
                            int endOfLine = t.indexOf(10);
                            if (endOfLine == -1) {
                                endOfLine = t.length();
                            }
                            placesToInject.addPlace(js, TextRange.from((int)(prefix.length() + off), (int)endOfLine), "", "\n");
                            off += endOfLine;
                            s = s.substring(i + endOfLine);
                        }
                        return;
                    }
                }
                if (host instanceof PsiCommentImpl) {
                    text2 = host.getText();
                    if (text2.startsWith("/*--{") && text2.endsWith("}--*/")) {
                        TextRange textRange = new TextRange(4, text2.length() - 4);
                        if (!(host.getParent() instanceof PsiMethod)) {
                            return;
                        }
                        PsiMethod method = (PsiMethod)host.getParent();
                        if (!method.hasModifierProperty("native") || !method.hasModifierProperty("public")) {
                            return;
                        }
                        String paramList = "";
                        for (PsiParameter parameter2 : method.getParameterList().getParameters()) {
                            if (!paramList.isEmpty()) {
                                paramList = paramList + ",";
                            }
                            paramList = paramList + parameter2.getName();
                        }
                        String header = "function " + method.getName() + "(" + paramList + ") {";
                        Language gwt = Language.findLanguageByID((String)"GWT JavaScript");
                        placesToInject.addPlace(gwt, textRange, header, "}");
                        return;
                    }
                    parent = host.getParent();
                    if (parent instanceof PsiMethod && ((PsiMethod)parent).getName().equals("xml")) {
                        placesToInject.addPlace(StdLanguages.XML, new TextRange(2, host.getTextLength() - 2), null, null);
                        return;
                    }
                }
                if (host instanceof PsiLiteralExpression && ((PsiLiteralExpression)host).getValue() instanceof String) {
                    PsiVariable variable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)host, PsiVariable.class);
                    if (variable == null) {
                        return;
                    }
                    if (host.getParent() instanceof PsiPolyadicExpression) {
                        return;
                    }
                    if ("ql".equals(variable.getName())) {
                        placesToInject.addPlace(ql, MyTestInjector.textRangeToInject(host), null, null);
                    }
                    if ("xml".equals(variable.getName())) {
                        placesToInject.addPlace(StdLanguages.XML, MyTestInjector.textRangeToInject(host), null, null);
                    }
                    if ("js".equals(variable.getName())) {
                        placesToInject.addPlace(js, MyTestInjector.textRangeToInject(host), "function foo(doc,window) {", "}");
                    }
                    if ("lang".equals(variable.getName())) {
                        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiClass.class);
                        text3 = (aClass = aClass.findInnerClassByName("Language", false)).getInitializers()[0].getBody().getFirstBodyElement().getNextSibling().getText().substring(2);
                        Language language = Language.findLanguageByID((String)text3);
                        if (language != null) {
                            placesToInject.addPlace(language, MyTestInjector.textRangeToInject(host), "", "");
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "host";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "placesToInject";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/psi/impl/source/tree/injected/MyTestInjector$6";
                objectArray[2] = "getLanguagesToInject";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        final ExtensionPoint extensionPoint = Extensions.getRootArea().getExtensionPoint(LanguageInjector.EXTENSION_POINT_NAME);
        extensionPoint.registerExtension((Object)myInjector);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                extensionPoint.unregisterExtension((Object)myInjector);
            }
        });
    }

    private static void inject(PsiLanguageInjectionHost host, InjectedLanguagePlaces placesToInject, Language language) {
        MyTestInjector.inject(host, placesToInject, language, null, null);
    }

    private static void inject(PsiLanguageInjectionHost host, InjectedLanguagePlaces placesToInject, Language language, @NonNls String prefix, String suffix) {
        TextRange insideQuotes = MyTestInjector.textRangeToInject(host);
        placesToInject.addPlace(language, insideQuotes, prefix, suffix);
    }

    public static TextRange textRangeToInject(PsiLanguageInjectionHost host) {
        ASTNode[] children = host.getNode().getChildren(null);
        ProperTextRange insideQuotes = new ProperTextRange(0, host.getTextLength());
        if (children.length > 1 && children[0].getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            insideQuotes = new ProperTextRange(children[1].getTextRange().getStartOffset() - host.getTextRange().getStartOffset(), insideQuotes.getEndOffset());
        }
        if (children.length > 1 && children[children.length - 1].getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
            insideQuotes = new ProperTextRange(insideQuotes.getStartOffset(), children[children.length - 2].getTextRange().getEndOffset() - host.getTextRange().getStartOffset());
        }
        if (host instanceof PsiLiteralExpression) {
            insideQuotes = new ProperTextRange(1, host.getTextLength() - 1);
        }
        return insideQuotes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "varName";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/impl/source/tree/injected/MyTestInjector";
        objectArray[2] = "registerForStringVarInitializer";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

