/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class PsiArrayAccessExpressionImpl
extends ExpressionPsiElement
implements PsiArrayAccessExpression,
Constants {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiArrayAccessExpressionImpl");

    public PsiArrayAccessExpressionImpl() {
        super(ARRAY_ACCESS_EXPRESSION);
    }

    @NotNull
    public PsiExpression getArrayExpression() {
        PsiExpression psiExpression = (PsiExpression)this.findChildByRoleAsPsiElement(88);
        if (psiExpression == null) {
            PsiArrayAccessExpressionImpl.$$$reportNull$$$0(0);
        }
        return psiExpression;
    }

    public PsiExpression getIndexExpression() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(89);
    }

    public PsiType getType() {
        PsiType arrayType = this.getArrayExpression().getType();
        if (!(arrayType instanceof PsiArrayType)) {
            return null;
        }
        PsiType componentType = ((PsiArrayType)arrayType).getComponentType();
        if (PsiUtil.isAccessedForWriting((PsiExpression)this)) {
            return componentType;
        }
        return PsiUtil.captureToplevelWildcards((PsiType)componentType, (PsiElement)this);
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 88: {
                return this.getFirstChildNode();
            }
            case 89: {
                ASTNode lbracket = this.findChildByRole(74);
                if (lbracket == null) {
                    return null;
                }
                for (ASTNode child = lbracket.getTreeNext(); child != null; child = child.getTreeNext()) {
                    if (!EXPRESSION_BIT_SET.contains(child.getElementType())) continue;
                    return child;
                }
                return null;
            }
            case 74: {
                return this.findChildByType(LBRACKET);
            }
            case 75: 
        }
        return this.findChildByType(RBRACKET);
    }

    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == LBRACKET) {
            return 74;
        }
        if (i == RBRACKET) {
            return 75;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return child == this.getFirstChildNode() ? 88 : 89;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiArrayAccessExpressionImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitArrayAccessExpression((PsiArrayAccessExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiArrayAccessExpression:" + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/java/PsiArrayAccessExpressionImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiArrayAccessExpressionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

