/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.processor;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodResolveProcessor
implements PsiScopeProcessor,
ElementClassHint,
NameHint {
    private final String myNameHint;
    private final List<PsiMethod> myMethods = new ArrayList<PsiMethod>();

    public MethodResolveProcessor() {
        this.myNameHint = null;
    }

    public MethodResolveProcessor(String name) {
        this.myNameHint = name;
    }

    public PsiMethod[] getMethods() {
        return this.myMethods.toArray(new PsiMethod[this.myMethods.size()]);
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            MethodResolveProcessor.$$$reportNull$$$0(0);
        }
        if (state == null) {
            MethodResolveProcessor.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiMethod) {
            ContainerUtil.addIfNotNull(this.myMethods, (Object)((PsiMethod)element));
        }
        return true;
    }

    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            MethodResolveProcessor.$$$reportNull$$$0(2);
        }
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        if (hintKey == NameHint.KEY && this.myNameHint != null) {
            return (T)this;
        }
        return null;
    }

    @Override
    public boolean shouldProcess(ElementClassHint.DeclarationKind kind2) {
        return kind2 == ElementClassHint.DeclarationKind.METHOD;
    }

    public static PsiMethod[] findMethod(PsiClass psiClass, String methodName) {
        MethodResolveProcessor processor = new MethodResolveProcessor(methodName);
        psiClass.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), null, (PsiElement)psiClass);
        return processor.getMethods();
    }

    public static PsiMethod[] getAllMethods(PsiClass psiClass) {
        MethodResolveProcessor processor = new MethodResolveProcessor();
        psiClass.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), null, (PsiElement)psiClass);
        return processor.getMethods();
    }

    @Override
    @Nullable
    public String getName(@NotNull ResolveState state) {
        if (state == null) {
            MethodResolveProcessor.$$$reportNull$$$0(3);
        }
        return this.myNameHint;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintKey";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/scope/processor/MethodResolveProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getHint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

