/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.ui.JBUI;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class ProjectIconsAccessor {
    @NonNls
    private static final String JAVAX_SWING_ICON = "javax.swing.Icon";
    private static final int ICON_MAX_WEIGHT = 16;
    private static final int ICON_MAX_HEIGHT = 16;
    private static final int ICON_MAX_SIZE = 0x200000;
    private static final List<String> ICON_EXTENSIONS = ContainerUtil.immutableList((Object[])new String[]{"png", "ico", "bmp", "gif", "jpg"});
    private final Project myProject;
    private final SLRUMap<String, Pair<Long, Icon>> iconsCache = new SLRUMap(500, 1000);

    ProjectIconsAccessor(Project project) {
        this.myProject = project;
    }

    public static ProjectIconsAccessor getInstance(Project project) {
        return (ProjectIconsAccessor)ServiceManager.getService((Project)project, ProjectIconsAccessor.class);
    }

    @Nullable
    public VirtualFile resolveIconFile(PsiElement initializer) {
        final ArrayList refs = new ArrayList();
        UElement initializerElement = UastContextKt.toUElement((PsiElement)initializer);
        if (initializerElement == null) {
            return null;
        }
        initializerElement.accept((UastVisitor)new AbstractUastVisitor(){

            public boolean visitLiteralExpression(ULiteralExpression node) {
                PsiElement psi = node.getPsi();
                if (psi != null) {
                    for (PsiReference ref : psi.getReferences()) {
                        if (!(ref instanceof FileReference)) continue;
                        refs.add((FileReference)ref);
                    }
                }
                super.visitLiteralExpression(node);
                return true;
            }
        });
        for (FileReference ref : refs) {
            PsiFileSystemItem psiFileSystemItem = ref.resolve();
            VirtualFile file = null;
            if (psiFileSystemItem == null) {
                ResolveResult[] results;
                for (ResolveResult result : results = ref.multiResolve(false)) {
                    PsiElement element = result.getElement();
                    if (!(element instanceof PsiBinaryFile)) continue;
                    file = ((PsiFile)element).getVirtualFile();
                    break;
                }
            } else {
                file = psiFileSystemItem.getVirtualFile();
            }
            if (file == null || file.isDirectory() || !ProjectIconsAccessor.isIconFileExtension(file.getExtension()) || file.getLength() > 0x200000L) continue;
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Icon getIcon(@NotNull VirtualFile file) {
        Pair iconInfo;
        if (file == null) {
            ProjectIconsAccessor.$$$reportNull$$$0(0);
        }
        String path = file.getPath();
        long stamp = file.getModificationStamp();
        SLRUMap<String, Pair<Long, Icon>> sLRUMap = this.iconsCache;
        synchronized (sLRUMap) {
            iconInfo = (Pair)this.iconsCache.get((Object)path);
            if (iconInfo == null || (Long)iconInfo.getFirst() < stamp) {
                try {
                    Icon icon = ProjectIconsAccessor.createOrFindBetterIcon(file, ProjectIconsAccessor.isIdeaProject(this.myProject));
                    iconInfo = new Pair((Object)stamp, (Object)(ProjectIconsAccessor.hasProperSize(icon) ? icon : null));
                    this.iconsCache.put((Object)file.getPath(), (Object)iconInfo);
                }
                catch (Exception e) {
                    iconInfo = null;
                    this.iconsCache.remove((Object)path);
                }
            }
        }
        return iconInfo == null ? null : (Icon)iconInfo.getSecond();
    }

    public static boolean isIconClassType(PsiType type2) {
        return InheritanceUtil.isInheritor((PsiType)type2, (String)JAVAX_SWING_ICON);
    }

    private static boolean isIconFileExtension(String extension) {
        return extension != null && ICON_EXTENSIONS.contains(extension.toLowerCase(Locale.US));
    }

    private static boolean hasProperSize(Icon icon) {
        return icon.getIconHeight() <= JBUI.scale((int)16) && icon.getIconWidth() <= JBUI.scale((int)16);
    }

    private static boolean isIdeaProject(Project project) {
        if (project == null) {
            return false;
        }
        VirtualFile baseDir = project.getBaseDir();
        return baseDir != null && (baseDir.findChild("idea.iml") != null || baseDir.findChild("community-main.iml") != null);
    }

    private static Icon createOrFindBetterIcon(VirtualFile file, boolean useIconLoader) throws IOException {
        if (useIconLoader) {
            return IconLoader.findIcon((URL)new File(file.getPath()).toURI().toURL());
        }
        return new ImageIcon(file.contentsToByteArray());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/util/ProjectIconsAccessor", "getIcon"));
    }
}

