/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.VariableData;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParametersFolder {
    private final Map<PsiVariable, PsiExpression> myExpressions = new HashMap<PsiVariable, PsiExpression>();
    private final Map<PsiVariable, String> myArgs = new HashMap<PsiVariable, String>();
    private final Map<PsiVariable, List<PsiExpression>> myMentionedInExpressions = new HashMap<PsiVariable, List<PsiExpression>>();
    private final Set<PsiVariable> myDeleted = new HashSet<PsiVariable>();
    private boolean myFoldingSelectedByDefault;

    public void clear() {
        this.myExpressions.clear();
        this.myMentionedInExpressions.clear();
        this.myDeleted.clear();
    }

    public boolean isParameterSafeToDelete(@NotNull VariableData data, @NotNull LocalSearchScope scope) {
        if (data == null) {
            ParametersFolder.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            ParametersFolder.$$$reportNull$$$0(1);
        }
        block0: for (PsiReference reference : ReferencesSearch.search((PsiElement)data.variable, (SearchScope)scope)) {
            PsiElement expression2 = reference.getElement();
            while (expression2 != null) {
                for (PsiExpression psiExpression : this.myExpressions.values()) {
                    if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)expression2, (PsiElement)psiExpression)) continue;
                    continue block0;
                }
                expression2 = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiExpression.class);
            }
            return false;
        }
        PsiExpression psiExpression = this.myExpressions.get(data.variable);
        if (psiExpression == null) {
            return true;
        }
        for (PsiVariable variable : this.myExpressions.keySet()) {
            PsiExpression expr;
            if (variable == data.variable || this.myDeleted.contains(variable) || (expr = this.myExpressions.get(variable)) == null || !PsiEquivalenceUtil.areElementsEquivalent((PsiElement)expr, (PsiElement)psiExpression)) continue;
            this.myDeleted.add(data.variable);
            return true;
        }
        return false;
    }

    public void foldParameterUsagesInBody(@NotNull List<VariableData> datum, PsiElement[] elements, SearchScope scope) {
        if (datum == null) {
            ParametersFolder.$$$reportNull$$$0(2);
        }
        LinkedHashMap equivalentExpressions = new LinkedHashMap();
        for (VariableData data : datum) {
            PsiExpression psiExpression;
            if (this.myDeleted.contains(data.variable) || (psiExpression = this.myExpressions.get(data.variable)) == null) continue;
            HashSet<PsiExpression> eqExpressions = new HashSet<PsiExpression>();
            for (PsiReference reference : ReferencesSearch.search((PsiElement)data.variable, (SearchScope)scope)) {
                PsiExpression expression2 = ParametersFolder.findEquivalent(psiExpression, reference.getElement());
                if (expression2 == null || !expression2.isValid()) continue;
                eqExpressions.add(expression2);
            }
            equivalentExpressions.put(data, eqExpressions);
        }
        for (VariableData data : equivalentExpressions.keySet()) {
            Set eqExpressions = (Set)equivalentExpressions.get((Object)data);
            block3: for (PsiExpression expression3 : eqExpressions) {
                if (!expression3.isValid()) continue;
                PsiExpression refExpression = JavaPsiFacade.getElementFactory((Project)expression3.getProject()).createExpressionFromText(data.name, (PsiElement)expression3);
                PsiElement replaced = expression3.replace((PsiElement)refExpression);
                for (PsiElement psiElement : elements) {
                    if (expression3 != psiElement) continue;
                    elements[i] = replaced;
                    continue block3;
                }
            }
        }
    }

    boolean isParameterFoldable(@NotNull VariableData data, @NotNull LocalSearchScope scope, @NotNull List<? extends PsiVariable> inputVariables, UniqueNameGenerator nameGenerator, String defaultName) {
        List<PsiExpression> mentionedInExpressions;
        if (data == null) {
            ParametersFolder.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            ParametersFolder.$$$reportNull$$$0(4);
        }
        if (inputVariables == null) {
            ParametersFolder.$$$reportNull$$$0(5);
        }
        if ((mentionedInExpressions = this.getMentionedExpressions(data.variable, scope, inputVariables)) == null) {
            return false;
        }
        int currentRank = 0;
        PsiExpression mostRanked = null;
        for (int i = mentionedInExpressions.size() - 1; i >= 0; --i) {
            int r;
            boolean arrayAccess;
            PsiExpression expression2 = mentionedInExpressions.get(i);
            boolean bl = arrayAccess = expression2 instanceof PsiArrayAccessExpression && !ParametersFolder.isConditional((PsiElement)expression2, scope);
            if (arrayAccess) {
                this.myFoldingSelectedByDefault = true;
            }
            if (currentRank >= (r = ParametersFolder.findUsedVariables(data, inputVariables, expression2).size()) && (!arrayAccess || currentRank != r)) continue;
            currentRank = r;
            mostRanked = expression2;
        }
        if (mostRanked != null) {
            this.myExpressions.put(data.variable, mostRanked);
            this.myArgs.put(data.variable, mostRanked.getText());
            data.type = RefactoringChangeUtil.getTypeByExpression(mostRanked);
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)mostRanked.getProject());
            SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, mostRanked, data.type);
            if (nameInfo.names.length > 0 && !Comparing.equal((String)nameInfo.names[0], (String)data.name) && !Comparing.equal((String)nameInfo.names[0], (String)defaultName)) {
                data.name = nameInfo.names[0];
                ParametersFolder.setUniqueName(data, nameGenerator, scope, mostRanked);
            }
        }
        return mostRanked != null;
    }

    private static boolean isConditional(PsiElement expr, LocalSearchScope scope) {
        while (expr != null) {
            PsiElement parent = expr.getParent();
            if (parent != null && scope.containsRange(parent.getContainingFile(), parent.getTextRange())) {
                if (parent instanceof PsiIfStatement ? ((PsiIfStatement)parent).getCondition() != expr : (parent instanceof PsiConditionalExpression ? ((PsiConditionalExpression)parent).getCondition() != expr : parent instanceof PsiSwitchStatement && ((PsiSwitchStatement)parent).getExpression() != expr)) {
                    return true;
                }
            } else {
                return false;
            }
            expr = parent;
        }
        return false;
    }

    private static void setUniqueName(VariableData data, UniqueNameGenerator nameGenerator, LocalSearchScope scope, PsiExpression expr) {
        String name = data.name;
        int idx = 1;
        while (true) {
            PsiVariable definedVariable;
            if (nameGenerator.isUnique(name, "", "") && ((definedVariable = PsiResolveHelper.SERVICE.getInstance((Project)expr.getProject()).resolveReferencedVariable(name, (PsiElement)expr)) == null || !scope.containsRange(expr.getContainingFile(), definedVariable.getTextRange()))) break;
            name = data.name + idx++;
        }
        data.name = name;
        nameGenerator.addExistingName(name);
    }

    private static Set<PsiVariable> findUsedVariables(VariableData data, final List<? extends PsiVariable> inputVariables, PsiExpression expression2) {
        final HashSet<PsiVariable> found = new HashSet<PsiVariable>();
        expression2.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression referenceExpression) {
                super.visitReferenceExpression(referenceExpression);
                PsiElement resolved = referenceExpression.resolve();
                if (resolved instanceof PsiVariable && inputVariables.contains(resolved)) {
                    found.add((PsiVariable)resolved);
                }
            }
        });
        found.remove(data.variable);
        return found;
    }

    public boolean isFoldable() {
        return !this.myExpressions.isEmpty();
    }

    @Nullable
    private List<PsiExpression> getMentionedExpressions(PsiVariable var, LocalSearchScope scope, List<? extends PsiVariable> inputVariables) {
        if (this.myMentionedInExpressions.containsKey(var)) {
            return this.myMentionedInExpressions.get(var);
        }
        PsiElement[] scopeElements = scope.getScope();
        ArrayList<PsiExpression> expressions2 = null;
        block0: for (PsiReference reference : ReferencesSearch.search((PsiElement)var, (SearchScope)scope)) {
            PsiElement expression2 = reference.getElement();
            if (expressions2 == null) {
                expressions2 = new ArrayList<PsiExpression>();
                while (expression2 instanceof PsiExpression) {
                    PsiType expressionType;
                    PsiElement parent;
                    if (ParametersFolder.isAccessedForWriting((PsiExpression)expression2)) {
                        return null;
                    }
                    if (ParametersFolder.isAncestor(expression2, scopeElements) || ParametersFolder.dependsOnLocals(expression2, inputVariables) || (parent = expression2.getParent()) instanceof PsiExpressionStatement || (expressionType = ((PsiExpression)expression2).getType()) == null || PsiType.VOID.equals((Object)expressionType) || ParametersFolder.isTooLongExpressionChain(expression2)) continue block0;
                    if (!ParametersFolder.isMethodNameExpression(expression2)) {
                        expressions2.add((PsiExpression)expression2);
                    }
                    expression2 = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiExpression.class);
                }
                continue;
            }
            Iterator iterator = expressions2.iterator();
            while (iterator.hasNext()) {
                if (ParametersFolder.findEquivalent((PsiExpression)iterator.next(), expression2) != null) continue;
                iterator.remove();
            }
        }
        this.myMentionedInExpressions.put(var, expressions2);
        return expressions2;
    }

    private static boolean isAccessedForWriting(PsiExpression expression2) {
        final PsiExpression[] exprWithWriteAccessInside = new PsiExpression[1];
        expression2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (exprWithWriteAccessInside[0] != null) {
                    return;
                }
                super.visitElement(element);
            }

            public void visitExpression(PsiExpression expression2) {
                if (PsiUtil.isAccessedForWriting((PsiExpression)expression2)) {
                    exprWithWriteAccessInside[0] = expression2;
                }
                super.visitExpression(expression2);
            }
        });
        return exprWithWriteAccessInside[0] != null;
    }

    private static boolean isAncestor(PsiElement expression2, PsiElement[] scopeElements) {
        for (PsiElement scopeElement : scopeElements) {
            if (!PsiTreeUtil.isAncestor((PsiElement)expression2, (PsiElement)scopeElement, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTooLongExpressionChain(PsiElement expression2) {
        int count = 0;
        PsiElement element = ParametersFolder.getInnerExpression(expression2);
        while (element != null) {
            if (++count > 1) {
                return true;
            }
            element = ParametersFolder.getInnerExpression(element);
        }
        return false;
    }

    private static PsiElement getInnerExpression(PsiElement expression2) {
        if (expression2 instanceof PsiMethodCallExpression) {
            return ((PsiMethodCallExpression)expression2).getMethodExpression().getQualifierExpression();
        }
        if (expression2 instanceof PsiArrayAccessExpression) {
            while (expression2 instanceof PsiArrayAccessExpression) {
                expression2 = ((PsiArrayAccessExpression)expression2).getArrayExpression();
            }
            return expression2;
        }
        return null;
    }

    private static boolean isMethodNameExpression(@NotNull PsiElement expression2) {
        if (expression2 == null) {
            ParametersFolder.$$$reportNull$$$0(6);
        }
        PsiElement parent = expression2.getParent();
        return expression2 instanceof PsiReferenceExpression && parent instanceof PsiMethodCallExpression && ((PsiReferenceExpression)expression2).getReferenceNameElement() == ((PsiMethodCallExpression)parent).getMethodExpression().getReferenceNameElement();
    }

    private static boolean dependsOnLocals(PsiElement expression2, final List<? extends PsiVariable> inputVariables) {
        final boolean[] localVarsUsed = new boolean[]{false};
        expression2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                PsiVariable variable;
                PsiElement resolved = expression2.resolve();
                if (resolved instanceof PsiVariable && !((variable = (PsiVariable)resolved) instanceof PsiField) && !inputVariables.contains(variable)) {
                    localVarsUsed[0] = true;
                    return;
                }
                super.visitReferenceExpression(expression2);
            }
        });
        return localVarsUsed[0];
    }

    @NotNull
    public String getGeneratedCallArgument(@NotNull VariableData data) {
        if (data == null) {
            ParametersFolder.$$$reportNull$$$0(7);
        }
        String string = this.myArgs.containsKey(data.variable) ? this.myArgs.get(data.variable) : data.variable.getName();
        if (string == null) {
            ParametersFolder.$$$reportNull$$$0(8);
        }
        return string;
    }

    void putCallArgument(@NotNull PsiVariable argument, @NotNull PsiExpression value2) {
        if (argument == null) {
            ParametersFolder.$$$reportNull$$$0(9);
        }
        if (value2 == null) {
            ParametersFolder.$$$reportNull$$$0(10);
        }
        this.myArgs.put(argument, value2.getText());
    }

    public boolean annotateWithParameter(@NotNull VariableData data, @NotNull PsiElement element) {
        PsiExpression expression2;
        PsiExpression psiExpression;
        if (data == null) {
            ParametersFolder.$$$reportNull$$$0(11);
        }
        if (element == null) {
            ParametersFolder.$$$reportNull$$$0(12);
        }
        if ((psiExpression = this.myExpressions.get(data.variable)) != null && (expression2 = ParametersFolder.findEquivalent(psiExpression, element)) != null) {
            expression2.putUserData(DuplicatesFinder.PARAMETER, (Object)Pair.create((Object)data.variable, (Object)expression2.getType()));
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiExpression findEquivalent(PsiExpression expr, PsiElement element) {
        PsiElement expression2 = element;
        while (expression2 != null) {
            if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)expression2, (PsiElement)expr)) {
                PsiExpression psiExpression = (PsiExpression)expression2;
                return PsiUtil.isAccessedForWriting((PsiExpression)psiExpression) ? null : psiExpression;
            }
            expression2 = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiExpression.class);
        }
        return null;
    }

    public boolean wasExcluded(PsiVariable variable) {
        return this.myDeleted.contains(variable) || this.myMentionedInExpressions.containsKey(variable) && this.myExpressions.get(variable) == null;
    }

    public boolean isFoldingSelectedByDefault() {
        return this.myFoldingSelectedByDefault;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "datum";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputVariables";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethod/ParametersFolder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethod/ParametersFolder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratedCallArgument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isParameterSafeToDelete";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "foldParameterUsagesInBody";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isParameterFoldable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isMethodNameExpression";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getGeneratedCallArgument";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "putCallArgument";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "annotateWithParameter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

