/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessorBase;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaChangeInfoImpl;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.inline.InlineParameterHandler;
import com.intellij.refactoring.inline.InlineViewDescriptor;
import com.intellij.refactoring.safeDelete.JavaSafeDeleteProcessor;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineParameterExpressionProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.inline.InlineParameterExpressionProcessor");
    public static final Key<Boolean> CREATE_LOCAL_FOR_TESTS = Key.create((String)"CREATE_INLINE_PARAMETER_LOCAL_FOR_TESTS");
    private final PsiCallExpression myMethodCall;
    private final PsiMethod myMethod;
    private final PsiParameter myParameter;
    private PsiExpression myInitializer;
    private final boolean mySameClass;
    private final PsiCodeBlock myCallingBlock;
    private final boolean myCreateLocal;
    private JavaChangeInfo myChangeInfo;
    private UsageInfo[] myChangeSignatureUsages;

    public InlineParameterExpressionProcessor(PsiCallExpression methodCall, PsiMethod method, PsiParameter parameter2, PsiExpression initializer, boolean createLocal) {
        super(method.getProject());
        this.myMethodCall = methodCall;
        this.myMethod = method;
        this.myParameter = parameter2;
        this.myInitializer = initializer;
        this.myCreateLocal = createLocal;
        PsiClass callingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiClass.class);
        this.mySameClass = callingClass == this.myMethod.getContainingClass();
        this.myCallingBlock = (PsiCodeBlock)PsiTreeUtil.getTopmostParentOfType((PsiElement)this.myMethodCall, PsiCodeBlock.class);
    }

    @NotNull
    protected String getCommandName() {
        String string = InlineParameterHandler.REFACTORING_NAME;
        if (string == null) {
            InlineParameterExpressionProcessor.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            InlineParameterExpressionProcessor.$$$reportNull$$$0(1);
        }
        InlineViewDescriptor inlineViewDescriptor = new InlineViewDescriptor((PsiElement)this.myParameter);
        if (inlineViewDescriptor == null) {
            InlineParameterExpressionProcessor.$$$reportNull$$$0(2);
        }
        return inlineViewDescriptor;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        int parameterIndex = this.myMethod.getParameterList().getParameterIndex(this.myParameter);
        final HashMap<PsiVariable, PsiExpression> localToParamRef = new HashMap<PsiVariable, PsiExpression>();
        PsiExpression[] arguments = this.myMethodCall.getArgumentList().getExpressions();
        for (int i = 0; i < arguments.length; ++i) {
            Object referenceExpression;
            PsiElement element;
            if (i == parameterIndex || !(arguments[i] instanceof PsiReferenceExpression) || !((element = (referenceExpression = (PsiReferenceExpression)arguments[i]).resolve()) instanceof PsiLocalVariable) && !(element instanceof PsiParameter)) continue;
            PsiParameter param = this.myMethod.getParameterList().getParameters()[i];
            PsiExpression paramRef = JavaPsiFacade.getInstance((Project)this.myMethod.getProject()).getElementFactory().createExpressionFromText(param.getName(), (PsiElement)this.myMethod);
            localToParamRef.put((PsiVariable)element, paramRef);
        }
        final ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        this.myInitializer.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                super.visitReferenceExpression(expression2);
                PsiElement element = expression2.resolve();
                if (element instanceof PsiLocalVariable) {
                    PsiLocalVariable localVariable = (PsiLocalVariable)element;
                    PsiElement[] elements = DefUseUtil.getDefs(InlineParameterExpressionProcessor.this.myCallingBlock, (PsiVariable)localVariable, (PsiElement)expression2);
                    if (elements.length == 1) {
                        PsiReferenceExpression refElement;
                        PsiElement parent;
                        PsiExpression localInitializer = null;
                        if (elements[0] instanceof PsiLocalVariable) {
                            localInitializer = ((PsiLocalVariable)elements[0]).getInitializer();
                        } else if (elements[0] instanceof PsiAssignmentExpression) {
                            localInitializer = ((PsiAssignmentExpression)elements[0]).getRExpression();
                        } else if (elements[0] instanceof PsiReferenceExpression && (parent = (refElement = (PsiReferenceExpression)elements[0]).getParent()) instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)parent).getLExpression() == refElement) {
                            localInitializer = ((PsiAssignmentExpression)parent).getRExpression();
                        }
                        if (localInitializer != null) {
                            PsiElement replacement = localToParamRef.containsKey(localVariable) ? (PsiElement)localToParamRef.get(localVariable) : InlineParameterExpressionProcessor.replaceArgs(localToParamRef, localInitializer.copy());
                            result.add(new LocalReplacementUsageInfo((PsiReference)expression2, replacement));
                        }
                    }
                }
            }
        });
        if (!this.myCreateLocal) {
            for (PsiReference ref : ReferencesSearch.search((PsiElement)this.myParameter).findAll()) {
                result.add(new UsageInfo(ref));
            }
        }
        PsiParameter[] parameters2 = this.myMethod.getParameterList().getParameters();
        ArrayList<ParameterInfoImpl> psiParameters = new ArrayList<ParameterInfoImpl>();
        int paramIdx = 0;
        String paramName = this.myParameter.getName();
        for (PsiParameter param : parameters2) {
            if (!Comparing.strEqual((String)paramName, (String)param.getName())) {
                psiParameters.add(new ParameterInfoImpl(paramIdx, param.getName(), param.getType()));
            }
            ++paramIdx;
        }
        PsiType returnType = this.myMethod.getReturnType();
        this.myChangeInfo = new JavaChangeInfoImpl(VisibilityUtil.getVisibilityModifier((PsiModifierList)this.myMethod.getModifierList()), this.myMethod, this.myMethod.getName(), returnType != null ? CanonicalTypes.createTypeWrapper(returnType) : null, psiParameters.toArray(new ParameterInfoImpl[psiParameters.size()]), null, false, Collections.emptySet(), Collections.emptySet());
        this.myChangeSignatureUsages = ChangeSignatureProcessorBase.findUsages((ChangeInfo)this.myChangeInfo);
        UsageInfo[] usageInfos = result.toArray(new UsageInfo[result.size()]);
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])usageInfos);
        if (usageInfoArray == null) {
            InlineParameterExpressionProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    private static PsiElement replaceArgs(final Map<PsiVariable, PsiElement> elementsToReplace, PsiElement expression2) {
        final HashMap<PsiElement, PsiElement> replacements = new HashMap<PsiElement, PsiElement>();
        expression2.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression referenceExpression) {
                PsiVariable variable;
                PsiElement replacement;
                super.visitReferenceExpression(referenceExpression);
                PsiElement resolved = referenceExpression.resolve();
                if (resolved instanceof PsiVariable && (replacement = (PsiElement)elementsToReplace.get(variable = (PsiVariable)resolved)) != null) {
                    replacements.put(referenceExpression, replacement);
                }
            }
        });
        return RefactoringUtil.replaceElementsWithMap(expression2, replacements);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            InlineParameterExpressionProcessor.$$$reportNull$$$0(4);
        }
        MultiMap conflicts = new MultiMap();
        JavaSafeDeleteProcessor.collectMethodConflicts((MultiMap<PsiElement, String>)conflicts, this.myMethod, this.myParameter);
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        InaccessibleExpressionsDetector detector = new InaccessibleExpressionsDetector((MultiMap<PsiElement, String>)conflicts);
        this.myInitializer.accept((PsiElementVisitor)detector);
        for (UsageInfo usage : usages) {
            PsiElement replacement;
            if (!(usage instanceof LocalReplacementUsageInfo) || (replacement = ((LocalReplacementUsageInfo)usage).getReplacement()) == null) continue;
            replacement.accept((PsiElementVisitor)detector);
        }
        HashSet<PsiVariable> vars = new HashSet<PsiVariable>();
        for (UsageInfo usageInfo : usages) {
            PsiVariable var;
            if (!(usageInfo instanceof LocalReplacementUsageInfo) || (var = ((LocalReplacementUsageInfo)usageInfo).getVariable()) == null) continue;
            vars.add(var);
        }
        block2: for (PsiVariable var : vars) {
            for (PsiReference ref : ReferencesSearch.search((PsiElement)var)) {
                PsiElement element = ref.getElement();
                if (!(element instanceof PsiExpression) || !InlineParameterExpressionProcessor.isAccessedForWriting((PsiExpression)element)) continue;
                conflicts.putValue((Object)element, (Object)"Parameter initializer depends on value which is not available inside method and cannot be inlined");
                continue block2;
            }
        }
        return this.showConflicts(conflicts, usages);
    }

    private static boolean isAccessedForWriting(PsiExpression expr) {
        while (expr.getParent() instanceof PsiArrayAccessExpression) {
            expr = (PsiExpression)expr.getParent();
        }
        return PsiUtil.isAccessedForWriting((PsiExpression)expr);
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            InlineParameterExpressionProcessor.$$$reportNull$$$0(5);
        }
        List<PsiClassType> thrownExceptions = ExceptionUtil.getThrownCheckedExceptions(new PsiElement[]{this.myInitializer});
        HashSet<PsiVariable> varsUsedInInitializer = new HashSet<PsiVariable>();
        HashSet<PsiJavaCodeReferenceElement> paramRefsToInline = new HashSet<PsiJavaCodeReferenceElement>();
        HashMap<PsiElement, PsiElement> replacements = new HashMap<PsiElement, PsiElement>();
        for (UsageInfo usage : usages) {
            if (usage instanceof LocalReplacementUsageInfo) {
                LocalReplacementUsageInfo replacementUsageInfo = (LocalReplacementUsageInfo)usage;
                PsiElement element = replacementUsageInfo.getElement();
                PsiElement replacement = replacementUsageInfo.getReplacement();
                if (element != null && replacement != null) {
                    replacements.put(element, replacement);
                }
                varsUsedInInitializer.add(replacementUsageInfo.getVariable());
                continue;
            }
            LOG.assertTrue(!this.myCreateLocal);
            paramRefsToInline.add((PsiJavaCodeReferenceElement)usage.getElement());
        }
        this.myInitializer = (PsiExpression)RefactoringUtil.replaceElementsWithMap((PsiElement)this.myInitializer, replacements);
        if (this.myCreateLocal) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myMethod.getProject()).getElementFactory();
            PsiDeclarationStatement localDeclaration = factory.createVariableDeclarationStatement(this.myParameter.getName(), this.myParameter.getType(), this.myInitializer);
            PsiLocalVariable declaredVar = (PsiLocalVariable)localDeclaration.getDeclaredElements()[0];
            PsiUtil.setModifierProperty((PsiModifierListOwner)declaredVar, (String)"final", (boolean)this.myParameter.hasModifierProperty("final"));
            PsiExpression localVarInitializer = InlineUtil.inlineVariable((PsiVariable)this.myParameter, this.myInitializer, (PsiJavaCodeReferenceElement)((PsiReferenceExpression)factory.createExpressionFromText(this.myParameter.getName(), (PsiElement)this.myMethod)));
            PsiExpression initializer = declaredVar.getInitializer();
            LOG.assertTrue(initializer != null);
            initializer.replace((PsiElement)localVarInitializer);
            PsiCodeBlock body2 = this.myMethod.getBody();
            if (body2 != null) {
                PsiElement anchor = this.findAnchorForLocalVariableDeclaration(body2);
                body2.addAfter((PsiElement)localDeclaration, anchor);
            }
        } else {
            for (PsiJavaCodeReferenceElement paramRef : paramRefsToInline) {
                InlineUtil.inlineVariable((PsiVariable)this.myParameter, this.myInitializer, paramRef);
            }
        }
        for (PsiVariable variable : varsUsedInInitializer) {
            if (variable == null || !variable.isValid() || ReferencesSearch.search((PsiElement)variable).findFirst() != null) continue;
            variable.delete();
        }
        ChangeSignatureProcessorBase.doChangeSignature((ChangeInfo)this.myChangeInfo, (UsageInfo[])this.myChangeSignatureUsages);
        if (!thrownExceptions.isEmpty()) {
            for (PsiClassType exception : thrownExceptions) {
                PsiClass exceptionClass = exception.resolve();
                if (exceptionClass == null) continue;
                PsiUtil.addException((PsiMethod)this.myMethod, (PsiClass)exceptionClass);
            }
        }
    }

    @Nullable
    private PsiElement findAnchorForLocalVariableDeclaration(PsiCodeBlock body2) {
        String referenceName;
        PsiExpression expression2;
        PsiStatement[] statements;
        PsiJavaToken anchor = body2.getLBrace();
        if (this.myMethod.isConstructor() && (statements = body2.getStatements()).length > 0 && statements[0] instanceof PsiExpressionStatement && (expression2 = ((PsiExpressionStatement)statements[0]).getExpression()) instanceof PsiMethodCallExpression && ("super".equals(referenceName = ((PsiMethodCallExpression)expression2).getMethodExpression().getReferenceName()) || "this".equals(referenceName))) {
            anchor = statements[0];
        }
        return anchor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/inline/InlineParameterExpressionProcessor";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/inline/InlineParameterExpressionProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class InaccessibleExpressionsDetector
    extends JavaRecursiveElementWalkingVisitor {
        private final MultiMap<PsiElement, String> myConflicts;

        public InaccessibleExpressionsDetector(MultiMap<PsiElement, String> conflicts) {
            this.myConflicts = conflicts;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            super.visitReferenceExpression(expression2);
            PsiElement element = expression2.resolve();
            if (element instanceof PsiMember && !((PsiModifierListOwner)element).hasModifierProperty("static") && InlineParameterExpressionProcessor.this.myMethod.hasModifierProperty("static")) {
                this.myConflicts.putValue((Object)expression2, (Object)("Parameter initializer depends on " + RefactoringUIUtil.getDescription((PsiElement)element, (boolean)false) + " which is not available inside the static method"));
            }
            if (element instanceof PsiMethod || element instanceof PsiField) {
                if (!InlineParameterExpressionProcessor.this.mySameClass && !((PsiModifierListOwner)element).hasModifierProperty("static")) {
                    this.myConflicts.putValue((Object)expression2, (Object)"Parameter initializer depends on non static member from some other class");
                } else if (!PsiUtil.isAccessible((PsiMember)((PsiMember)element), (PsiElement)InlineParameterExpressionProcessor.this.myMethod, null)) {
                    this.myConflicts.putValue((Object)expression2, (Object)"Parameter initializer depends on value which is not available inside method");
                }
            } else if (element instanceof PsiParameter) {
                boolean bound = false;
                for (PsiParameter parameter2 : InlineParameterExpressionProcessor.this.myMethod.getParameterList().getParameters()) {
                    if (!parameter2.getType().equals(((PsiParameter)element).getType()) || !parameter2.getName().equals(((PsiParameter)element).getName())) continue;
                    bound = true;
                }
                if (!bound) {
                    this.myConflicts.putValue((Object)expression2, (Object)"Parameter initializer depends on callers parameter");
                }
            }
        }

        public void visitThisExpression(PsiThisExpression thisExpression) {
            super.visitThisExpression(thisExpression);
            PsiJavaCodeReferenceElement qualifier = thisExpression.getQualifier();
            PsiElement containingClass = qualifier != null ? qualifier.resolve() : PsiTreeUtil.getParentOfType((PsiElement)InlineParameterExpressionProcessor.this.myMethodCall, PsiClass.class);
            PsiClass methodContainingClass = InlineParameterExpressionProcessor.this.myMethod.getContainingClass();
            LOG.assertTrue(methodContainingClass != null);
            if (!PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)methodContainingClass, (boolean)false)) {
                this.myConflicts.putValue((Object)thisExpression, (Object)"Parameter initializer depends on this which is not available inside the method and cannot be inlined");
            } else if (InlineParameterExpressionProcessor.this.myMethod.hasModifierProperty("static")) {
                this.myConflicts.putValue((Object)thisExpression, (Object)"Parameter initializer depends on this which is not available inside the static method");
            }
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            PsiElement resolved;
            super.visitReferenceElement(reference);
            if (InlineParameterExpressionProcessor.this.myMethod.hasModifierProperty("static") && (resolved = reference.resolve()) instanceof PsiClass && !((PsiClass)resolved).hasModifierProperty("static")) {
                this.myConflicts.putValue((Object)reference, (Object)"Parameter initializer depends on non static class which is not available inside static method");
            }
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            PsiElement resolved;
            super.visitNewExpression(expression2);
            PsiJavaCodeReferenceElement reference = expression2.getClassOrAnonymousClassReference();
            if (reference != null && (resolved = reference.resolve()) instanceof PsiClass) {
                PsiClass refClass = (PsiClass)resolved;
                String classUnavailableMessage = "Parameter initializer depends on " + RefactoringUIUtil.getDescription((PsiElement)refClass, (boolean)true) + " which is not available inside method and cannot be inlined";
                if (!PsiUtil.isAccessible((PsiMember)refClass, (PsiElement)InlineParameterExpressionProcessor.this.myMethod, null)) {
                    this.myConflicts.putValue((Object)expression2, (Object)classUnavailableMessage);
                } else {
                    PsiClass methodContainingClass = InlineParameterExpressionProcessor.this.myMethod.getContainingClass();
                    LOG.assertTrue(methodContainingClass != null);
                    if (!PsiTreeUtil.isAncestor((PsiElement)InlineParameterExpressionProcessor.this.myMethod, (PsiElement)refClass, (boolean)false)) {
                        PsiClass parent = refClass;
                        while ((parent = parent.getParent()) instanceof PsiClass && PsiUtil.isAccessible((PsiMember)parent, (PsiElement)InlineParameterExpressionProcessor.this.myMethod, null)) {
                        }
                        if (!(parent instanceof PsiFile)) {
                            this.myConflicts.putValue((Object)expression2, (Object)classUnavailableMessage);
                        }
                    }
                }
            }
        }
    }

    private static class LocalReplacementUsageInfo
    extends UsageInfo {
        private final PsiElement myReplacement;
        private final PsiVariable myVariable;

        public LocalReplacementUsageInfo(@NotNull PsiReference element, @NotNull PsiElement replacement) {
            if (element == null) {
                LocalReplacementUsageInfo.$$$reportNull$$$0(0);
            }
            if (replacement == null) {
                LocalReplacementUsageInfo.$$$reportNull$$$0(1);
            }
            super(element);
            PsiElement resolved = element.resolve();
            this.myVariable = resolved instanceof PsiVariable ? (PsiVariable)resolved : null;
            this.myReplacement = replacement;
        }

        @Nullable
        public PsiElement getReplacement() {
            return this.myReplacement.isValid() ? this.myReplacement : null;
        }

        @Nullable
        public PsiVariable getVariable() {
            return this.myVariable != null && this.myVariable.isValid() ? this.myVariable : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "replacement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/refactoring/inline/InlineParameterExpressionProcessor$LocalReplacementUsageInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

