/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.util.ImportsUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.inline.JavaInlineActionHandler;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InlineStaticImportHandler
extends JavaInlineActionHandler {
    private static final String REFACTORING_NAME = "Expand static import";
    public static final String REFACTORING_ID = "refactoring.inline.import";

    public boolean canInlineElement(PsiElement element) {
        if (element.getContainingFile() == null) {
            return false;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStaticStatement.class) != null;
    }

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        final PsiImportStaticStatement staticStatement = (PsiImportStaticStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStaticStatement.class);
        final List referenceElements = ImportsUtil.collectReferencesThrough((PsiFile)element.getContainingFile(), null, (PsiImportStaticStatement)staticStatement);
        RefactoringEventData data = new RefactoringEventData();
        data.addElement(element);
        ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(REFACTORING_ID, data);
        new WriteCommandAction(project, REFACTORING_NAME, new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                ImportsUtil.replaceAllAndDeleteImport((List)referenceElements, null, (PsiImportStaticStatement)staticStatement);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/refactoring/inline/InlineStaticImportHandler$1", "run"));
            }
        }.execute();
        ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(REFACTORING_ID, null);
    }
}

