/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.migration;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.migration.MigrationProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;

public class MigrationUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.migration.MigrationUtil");

    private MigrationUtil() {
    }

    public static UsageInfo[] findPackageUsages(Project project, PsiMigration migration, String qName, GlobalSearchScope searchScope) {
        PsiPackage aPackage = MigrationUtil.findOrCreatePackage(project, migration, qName);
        return MigrationUtil.findRefs((PsiElement)aPackage, searchScope);
    }

    private static PsiElement bindNonJavaReference(PsiElement bindTo, PsiElement element, UsageInfo usage) {
        ProperTextRange range = usage.getRangeInElement();
        for (PsiReference reference : element.getReferences()) {
            JavaClassReference classReference2;
            if (!(reference instanceof JavaClassReference) || !(classReference2 = (JavaClassReference)reference).getRangeInElement().equals((Object)range)) continue;
            return classReference2.bindToElement(bindTo);
        }
        return bindTo;
    }

    public static UsageInfo[] findClassUsages(Project project, PsiMigration migration, String qName, GlobalSearchScope searchScope) {
        PsiClass aClass = MigrationUtil.findOrCreateClass(project, migration, qName);
        return MigrationUtil.findRefs((PsiElement)aClass, searchScope);
    }

    private static UsageInfo[] findRefs(PsiElement aClass, GlobalSearchScope searchScope) {
        ArrayList<UsageInfo> results = new ArrayList<UsageInfo>();
        for (PsiReference usage : ReferencesSearch.search((PsiElement)aClass, (SearchScope)searchScope, (boolean)false)) {
            results.add(new UsageInfo(usage));
        }
        return results.toArray(new UsageInfo[results.size()]);
    }

    static void doMigration(PsiElement elementToBind, String newQName, UsageInfo[] usages, ArrayList<SmartPsiElementPointer<PsiElement>> refsToShorten) {
        try {
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)elementToBind.getProject());
            for (UsageInfo usage : usages) {
                PsiElement psiElement;
                PsiElement element;
                if (!(usage instanceof MigrationProcessor.MigrationUsageInfo)) continue;
                MigrationProcessor.MigrationUsageInfo usageInfo = (MigrationProcessor.MigrationUsageInfo)usage;
                if (!Comparing.equal((String)newQName, (String)usageInfo.mapEntry.getNewName()) || (element = usage.getElement()) == null || !element.isValid() || (psiElement = element instanceof PsiJavaCodeReferenceElement ? ((PsiJavaCodeReferenceElement)element).bindToElement(elementToBind) : MigrationUtil.bindNonJavaReference(elementToBind, element, usage)) == null) continue;
                refsToShorten.add((SmartPsiElementPointer<PsiElement>)smartPointerManager.createSmartPsiElementPointer(psiElement));
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    static PsiPackage findOrCreatePackage(Project project, PsiMigration migration, String qName) {
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(qName);
        if (aPackage != null) {
            return aPackage;
        }
        return (PsiPackage)WriteAction.compute(() -> migration.createPackage(qName));
    }

    static PsiClass findOrCreateClass(Project project, PsiMigration migration, String qName) {
        PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(qName, GlobalSearchScope.allScope((Project)project));
        if (aClass == null) {
            aClass = (PsiClass)WriteAction.compute(() -> migration.createClass(qName));
        }
        return aClass;
    }
}

