/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class AutomaticTestRenamerFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            AutomaticTestRenamerFactory.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiTypeParameter) {
            return false;
        }
        return element instanceof PsiClass && TestFrameworks.detectFramework((PsiClass)((PsiClass)element)) == null;
    }

    public String getOptionName() {
        return RefactoringBundle.message((String)"rename.tests");
    }

    public boolean isEnabled() {
        return JavaRefactoringSettings.getInstance().isToRenameTests();
    }

    public void setEnabled(boolean enabled) {
        JavaRefactoringSettings.getInstance().setRenameTests(enabled);
    }

    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        return new TestsRenamer((PsiClass)element, newName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/rename/naming/AutomaticTestRenamerFactory", "isApplicable"));
    }

    private static class TestsRenamer
    extends AutomaticRenamer {
        public TestsRenamer(PsiClass aClass, String newClassName) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
            if (module != null) {
                GlobalSearchScope moduleScope = GlobalSearchScope.moduleWithDependentsScope((Module)module);
                PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)aClass.getProject());
                String klassName = aClass.getName();
                Pattern pattern = Pattern.compile(".*" + klassName + ".*");
                HashSet names = new HashSet();
                cache.getAllClassNames(names);
                int count = 0;
                for (String eachName : names) {
                    if (!pattern.matcher(eachName).matches()) continue;
                    if (count++ > 1000) break;
                    for (PsiClass eachClass : cache.getClassesByName(eachName, moduleScope)) {
                        if (TestFrameworks.detectFramework((PsiClass)eachClass) == null) continue;
                        this.myElements.add(eachClass);
                    }
                }
                this.suggestAllNames(aClass.getName(), newClassName);
            }
        }

        public String getDialogTitle() {
            return RefactoringBundle.message((String)"rename.tests.title");
        }

        public String getDialogDescription() {
            return RefactoringBundle.message((String)"rename.tests.with.the.following.names.to");
        }

        public String entityName() {
            return RefactoringBundle.message((String)"entity.name.test");
        }
    }
}

