/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.codeInsight.generation.GetterSetterPrototypeProvider;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.safeDelete.ImportSearcher;
import com.intellij.refactoring.safeDelete.JavaSafeDeleteDelegate;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.OverridingMethodsDialog;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.refactoring.safeDelete.SafeDeleteJavaCalleeChooser;
import com.intellij.refactoring.safeDelete.SafeDeleteJavaCallerChooser;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegateBase;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteAnnotation;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteExtendsClassUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteFieldWriteReference;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteMemberCalleeUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteOverrideAnnotation;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteOverridingMethodUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteParameterCallHierarchyUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeletePrivatizeMethod;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceJavaDeleteUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteUsageInfo;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.UsageInfoToUsageConverter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSafeDeleteProcessor
extends SafeDeleteProcessorDelegateBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.safeDelete.JavaSafeDeleteProcessor");

    public boolean handlesElement(PsiElement element) {
        return element instanceof PsiClass || element instanceof PsiMethod || element instanceof PsiField || element instanceof PsiParameter || element instanceof PsiLocalVariable || element instanceof PsiPackage;
    }

    @Nullable
    public NonCodeUsageSearchInfo findUsages(@NotNull PsiElement element, @NotNull PsiElement[] allElementsToDelete, @NotNull List<UsageInfo> usages) {
        if (element == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(0);
        }
        if (allElementsToDelete == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(1);
        }
        if (usages == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(2);
        }
        Condition<PsiElement> insideDeletedCondition = JavaSafeDeleteProcessor.getUsageInsideDeletedFilter(allElementsToDelete);
        if (element instanceof PsiClass) {
            JavaSafeDeleteProcessor.findClassUsages((PsiClass)element, allElementsToDelete, usages);
            if (element instanceof PsiTypeParameter) {
                JavaSafeDeleteProcessor.findTypeParameterExternalUsages((PsiTypeParameter)element, usages);
            }
        } else if (element instanceof PsiMethod) {
            insideDeletedCondition = JavaSafeDeleteProcessor.findMethodUsages((PsiMethod)element, allElementsToDelete, usages);
        } else if (element instanceof PsiField) {
            insideDeletedCondition = JavaSafeDeleteProcessor.findFieldUsages((PsiField)element, usages, allElementsToDelete);
        } else if (element instanceof PsiParameter) {
            LOG.assertTrue(((PsiParameter)element).getDeclarationScope() instanceof PsiMethod);
            JavaSafeDeleteProcessor.findParameterUsages((PsiParameter)element, usages);
        } else if (element instanceof PsiLocalVariable) {
            for (PsiReference reference : ReferencesSearch.search((PsiElement)element)) {
                PsiExpressionList expressionList;
                PsiReferenceExpression referencedElement = (PsiReferenceExpression)reference.getElement();
                PsiElement statementOrExprInList = PsiTreeUtil.getParentOfType((PsiElement)referencedElement, PsiStatement.class);
                if (statementOrExprInList instanceof PsiExpressionListStatement && (expressionList = ((PsiExpressionListStatement)statementOrExprInList).getExpressionList()) != null) {
                    statementOrExprInList = PsiTreeUtil.findPrevParent((PsiElement)expressionList, (PsiElement)referencedElement);
                }
                boolean isSafeToDelete = PsiUtil.isAccessedForWriting((PsiExpression)referencedElement);
                boolean hasSideEffects = false;
                if (PsiUtil.isOnAssignmentLeftHand((PsiExpression)referencedElement)) {
                    hasSideEffects = RemoveUnusedVariableUtil.checkSideEffects(((PsiAssignmentExpression)referencedElement.getParent()).getRExpression(), (PsiVariable)((PsiLocalVariable)element), new ArrayList<PsiElement>());
                }
                usages.add((UsageInfo)new SafeDeleteReferenceJavaDeleteUsageInfo(statementOrExprInList, element, isSafeToDelete && !hasSideEffects));
            }
        }
        return new NonCodeUsageSearchInfo(insideDeletedCondition, element);
    }

    @Nullable
    public Collection<? extends PsiElement> getElementsToSearch(@NotNull PsiElement element, @Nullable Module module, @NotNull Collection<PsiElement> allElementsToDelete) {
        int index;
        PsiTypeParameterList typeParameterList;
        PsiTypeParameterListOwner owner;
        if (element == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(3);
        }
        if (allElementsToDelete == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(4);
        }
        Project project = element.getProject();
        if (element instanceof PsiPackage && module != null) {
            PsiDirectory[] directories = ((PsiPackage)element).getDirectories(module.getModuleScope());
            if (directories.length == 0) {
                return null;
            }
            return Arrays.asList(directories);
        }
        if (element instanceof PsiMethod) {
            PsiMethod[] methods = SuperMethodWarningUtil.checkSuperMethods((PsiMethod)element, RefactoringBundle.message((String)"to.delete.with.usage.search"), allElementsToDelete);
            if (methods.length == 0) {
                return null;
            }
            ArrayList<PsiMethod> psiMethods = new ArrayList<PsiMethod>(Arrays.asList(methods));
            psiMethods.add((PsiMethod)element);
            return psiMethods;
        }
        if (element instanceof PsiParameter && ((PsiParameter)element).getDeclarationScope() instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)((PsiParameter)element).getDeclarationScope();
            HashSet<PsiParameter> parametersToDelete = new HashSet<PsiParameter>();
            parametersToDelete.add((PsiParameter)element);
            int parameterIndex = method.getParameterList().getParameterIndex((PsiParameter)element);
            ArrayList<PsiMethod> superMethods = new ArrayList<PsiMethod>(Arrays.asList(method.findDeepestSuperMethods()));
            if (superMethods.isEmpty()) {
                superMethods.add(method);
            }
            for (PsiMethod superMethod : superMethods) {
                parametersToDelete.add(superMethod.getParameterList().getParameters()[parameterIndex]);
                OverridingMethodsSearch.search((PsiMethod)superMethod).forEach(overrider -> {
                    parametersToDelete.add(overrider.getParameterList().getParameters()[parameterIndex]);
                    return true;
                });
            }
            if (parametersToDelete.size() > 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
                String message2 = RefactoringBundle.message((String)"0.is.a.part.of.method.hierarchy.do.you.want.to.delete.multiple.parameters", (Object[])new Object[]{UsageViewUtil.getLongName((PsiElement)method)});
                int result = Messages.showYesNoCancelDialog((Project)project, (String)message2, (String)SafeDeleteHandler.REFACTORING_NAME, (Icon)Messages.getQuestionIcon());
                if (result == 2) {
                    return null;
                }
                if (result == 1) {
                    return Collections.singletonList(element);
                }
            }
            return parametersToDelete;
        }
        if (element instanceof PsiTypeParameter && (owner = ((PsiTypeParameter)element).getOwner()) instanceof PsiMethod && !owner.hasModifierProperty("static") && (typeParameterList = owner.getTypeParameterList()) != null && (index = typeParameterList.getTypeParameterIndex((PsiTypeParameter)element)) >= 0) {
            ArrayList<PsiTypeParameter> overriders = new ArrayList<PsiTypeParameter>();
            overriders.add((PsiTypeParameter)element);
            OverridingMethodsSearch.search((PsiMethod)((PsiMethod)owner)).forEach(overrider -> {
                PsiTypeParameter[] typeParameters = overrider.getTypeParameters();
                if (index < typeParameters.length) {
                    overriders.add(typeParameters[index]);
                }
                return true;
            });
            if (overriders.size() > 1) {
                int result;
                String message3 = RefactoringBundle.message((String)"0.is.a.part.of.method.hierarchy.do.you.want.to.delete.multiple.type.parameters", (Object[])new Object[]{UsageViewUtil.getLongName((PsiElement)owner)});
                int n = result = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoCancelDialog((Project)project, (String)message3, (String)SafeDeleteHandler.REFACTORING_NAME, (Icon)Messages.getQuestionIcon());
                if (result == 2) {
                    return null;
                }
                if (result == 0) {
                    return overriders;
                }
            }
        }
        return Collections.singletonList(element);
    }

    public UsageView showUsages(UsageInfo[] usages, UsageViewPresentation presentation, UsageViewManager manager, PsiElement[] elements) {
        ArrayList<PsiMethod> overridingMethods = new ArrayList<PsiMethod>();
        ArrayList<UsageInfo> others = new ArrayList<UsageInfo>();
        for (UsageInfo usage : usages) {
            if (usage instanceof SafeDeleteOverridingMethodUsageInfo) {
                overridingMethods.add(((SafeDeleteOverridingMethodUsageInfo)usage).getOverridingMethod());
                continue;
            }
            others.add(usage);
        }
        UsageTarget[] targets = new UsageTarget[elements.length + overridingMethods.size()];
        for (int i = 0; i < targets.length; ++i) {
            targets[i] = new PsiElement2UsageTargetAdapter(i < elements.length ? elements[i] : (PsiElement)overridingMethods.get(i - elements.length));
        }
        return manager.showUsages(targets, UsageInfoToUsageConverter.convert((PsiElement[])elements, (UsageInfo[])others.toArray(new UsageInfo[others.size()])), presentation);
    }

    public Collection<PsiElement> getAdditionalElementsToDelete(@NotNull PsiElement element, @NotNull Collection<PsiElement> allElementsToDelete, boolean askUser) {
        if (element == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(5);
        }
        if (allElementsToDelete == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(6);
        }
        if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            Project project = element.getProject();
            String propertyName = JavaCodeStyleManager.getInstance((Project)project).variableNameToPropertyName(field.getName(), VariableKind.FIELD);
            PsiClass aClass = field.getContainingClass();
            if (aClass != null) {
                PsiMethod setter;
                boolean isStatic = field.hasModifierProperty("static");
                PsiMethod[] getters = GetterSetterPrototypeProvider.findGetters(aClass, propertyName, isStatic);
                if (getters != null) {
                    ArrayList<PsiMethod> validGetters = new ArrayList<PsiMethod>(1);
                    for (PsiMethod getter : getters) {
                        if (allElementsToDelete.contains(getter) || getter == null || !getter.isPhysical()) continue;
                        validGetters.add(getter);
                    }
                    PsiMethod[] psiMethodArray = getters = validGetters.isEmpty() ? null : validGetters.toArray(new PsiMethod[validGetters.size()]);
                }
                if (allElementsToDelete.contains(setter = PropertyUtilBase.findPropertySetter((PsiClass)aClass, (String)propertyName, (boolean)isStatic, (boolean)false)) || setter != null && !setter.isPhysical()) {
                    setter = null;
                }
                if (askUser && (getters != null || setter != null)) {
                    String message2 = RefactoringMessageUtil.getGetterSetterMessage(field.getName(), RefactoringBundle.message((String)"delete.title"), getters != null ? getters[0] : null, setter);
                    if (!ApplicationManager.getApplication().isUnitTestMode() && Messages.showYesNoDialog((Project)project, (String)message2, (String)RefactoringBundle.message((String)"safe.delete.title"), (Icon)Messages.getQuestionIcon()) != 0) {
                        getters = null;
                        setter = null;
                    }
                }
                ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
                if (setter != null) {
                    elements.add((PsiElement)setter);
                }
                if (getters != null) {
                    Collections.addAll(elements, getters);
                }
                return elements;
            }
        }
        return null;
    }

    public Collection<String> findConflicts(PsiElement element, PsiElement[] elements, UsageInfo[] usages) {
        String methodRefFound = null;
        if (element instanceof PsiMethod || element instanceof PsiParameter) {
            PsiMethod method;
            if (element instanceof PsiMethod) {
                method = (PsiMethod)element;
            } else {
                UsageInfo[] declarationScope = ((PsiParameter)element).getDeclarationScope();
                PsiMethod psiMethod = method = declarationScope instanceof PsiMethod ? (PsiMethod)declarationScope : null;
            }
            if (method != null) {
                for (UsageInfo usage : usages) {
                    PsiElement refElement = usage.getElement();
                    if (!(refElement instanceof PsiMethodReferenceExpression) || !method.equals(((PsiMethodReferenceExpression)refElement).resolve())) continue;
                    methodRefFound = RefactoringBundle.message((String)"expand.method.reference.warning");
                    break;
                }
            }
        }
        if (methodRefFound != null) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(methodRefFound);
            Collection conflicts = super.findConflicts(element, elements, usages);
            if (conflicts != null) {
                result.addAll(conflicts);
            }
            return result;
        }
        return super.findConflicts(element, elements, usages);
    }

    public Collection<String> findConflicts(@NotNull PsiElement element, @NotNull PsiElement[] allElementsToDelete) {
        PsiElement scope;
        if (element == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(7);
        }
        if (allElementsToDelete == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(8);
        }
        if (element instanceof PsiMethod) {
            PsiClass containingClass = ((PsiMethod)element).getContainingClass();
            if (containingClass != null && !containingClass.hasModifierProperty("abstract")) {
                PsiMethod[] superMethods;
                for (PsiMethod superMethod : superMethods = ((PsiMethod)element).findSuperMethods()) {
                    if (JavaSafeDeleteProcessor.isInside((PsiElement)superMethod, allElementsToDelete) || !superMethod.hasModifierProperty("abstract")) continue;
                    String message2 = RefactoringBundle.message((String)"0.implements.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)element, (boolean)true), RefactoringUIUtil.getDescription((PsiElement)superMethod, (boolean)true)});
                    return Collections.singletonList(message2);
                }
            }
        } else if (element instanceof PsiParameter && (scope = ((PsiParameter)element).getDeclarationScope()) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)scope;
            MultiMap conflicts = new MultiMap();
            JavaSafeDeleteProcessor.collectMethodConflicts((MultiMap<PsiElement, String>)conflicts, method, (PsiParameter)element);
            return conflicts.values();
        }
        return null;
    }

    @Nullable
    public UsageInfo[] preprocessUsages(Project project, UsageInfo[] usages) {
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<UsageInfo> overridingMethods = new ArrayList<UsageInfo>();
        final ArrayList<SafeDeleteParameterCallHierarchyUsageInfo> delegatingParams = new ArrayList<SafeDeleteParameterCallHierarchyUsageInfo>();
        final ArrayList<SafeDeleteMemberCalleeUsageInfo> calleesSafeToDelete = new ArrayList<SafeDeleteMemberCalleeUsageInfo>();
        for (UsageInfo usage : usages) {
            if (usage.isNonCodeUsage) {
                ExternalAnnotationsManager annotationsManager;
                List annotationsFiles;
                PsiElement element;
                if (usage instanceof SafeDeleteUsageInfo && (element = ((SafeDeleteUsageInfo)usage).getReferencedElement()) instanceof PsiModifierListOwner && (annotationsFiles = (annotationsManager = ExternalAnnotationsManager.getInstance((Project)element.getProject())).findExternalAnnotationsFiles((PsiModifierListOwner)element)) != null && annotationsFiles.contains(usage.getFile())) {
                    result.add((Object)new SafeDeleteExternalAnnotationsUsageInfo(element, usage.getElement()));
                    continue;
                }
                result.add(usage);
                continue;
            }
            if (usage instanceof SafeDeleteMemberCalleeUsageInfo) {
                calleesSafeToDelete.add((SafeDeleteMemberCalleeUsageInfo)usage);
                continue;
            }
            if (usage instanceof SafeDeleteOverridingMethodUsageInfo) {
                overridingMethods.add(usage);
                continue;
            }
            if (usage instanceof SafeDeleteParameterCallHierarchyUsageInfo) {
                delegatingParams.add((SafeDeleteParameterCallHierarchyUsageInfo)usage);
                continue;
            }
            if (usage instanceof SafeDeleteAnnotation) {
                result.add((Object)new SafeDeleteAnnotation((PsiAnnotation)usage.getElement(), ((SafeDeleteAnnotation)usage).getReferencedElement(), true));
                continue;
            }
            result.add(usage);
        }
        if (!overridingMethods.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                result.addAll(overridingMethods);
            } else {
                OverridingMethodsDialog dialog = new OverridingMethodsDialog(project, overridingMethods);
                if (!dialog.showAndGet()) {
                    return null;
                }
                ArrayList<UsageInfo> selected = dialog.getSelected();
                HashSet<UsageInfo> unselected = new HashSet<UsageInfo>(overridingMethods);
                unselected.removeAll(selected);
                if (!unselected.isEmpty()) {
                    List unselectedMethods = ContainerUtil.map(unselected, info -> ((SafeDeleteOverridingMethodUsageInfo)((Object)info)).getOverridingMethod());
                    result.removeIf(info -> info instanceof SafeDeleteOverrideAnnotation && !JavaSafeDeleteProcessor.allSuperMethodsSelectedToDelete(unselectedMethods, ((SafeDeleteOverrideAnnotation)((Object)info)).getMethod()));
                }
                result.addAll(selected);
            }
        }
        if (!delegatingParams.isEmpty()) {
            SafeDeleteParameterCallHierarchyUsageInfo parameterHierarchyUsageInfo = (SafeDeleteParameterCallHierarchyUsageInfo)((Object)delegatingParams.get(0));
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                result.addAll(delegatingParams);
            } else {
                PsiMethod method = parameterHierarchyUsageInfo.getCalledMethod();
                PsiParameter parameter2 = parameterHierarchyUsageInfo.getReferencedElement();
                final int parameterIndex = method.getParameterList().getParameterIndex(parameter2);
                SafeDeleteJavaCallerChooser chooser = new SafeDeleteJavaCallerChooser(method, project, result){

                    @Override
                    protected ArrayList<SafeDeleteParameterCallHierarchyUsageInfo> getTopLevelItems() {
                        return delegatingParams;
                    }

                    @Override
                    protected int getParameterIdx() {
                        return parameterIndex;
                    }

                    @Override
                    protected PsiParameter getParameterInCaller(PsiMethod called, int paramIdx, PsiMethod caller) {
                        return delegatingParams.stream().filter(usage -> caller.equals(usage.getCallerMethod())).map(usage -> usage.getParameterInCaller()).findFirst().orElse(super.getParameterInCaller(called, paramIdx, caller));
                    }
                };
                TreeUtil.expand((JTree)chooser.getTree(), (int)2);
                if (!chooser.showAndGet()) {
                    return null;
                }
            }
        }
        if (!calleesSafeToDelete.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                result.addAll(calleesSafeToDelete);
            } else {
                PsiMember member = ((SafeDeleteMemberCalleeUsageInfo)((Object)calleesSafeToDelete.get(0))).getCallerMember();
                ArrayList list = new ArrayList();
                SafeDeleteJavaCalleeChooser chooser = new SafeDeleteJavaCalleeChooser(member, project, list){

                    @Override
                    protected ArrayList<SafeDeleteMemberCalleeUsageInfo> getTopLevelItems() {
                        return calleesSafeToDelete;
                    }
                };
                TreeUtil.expand((JTree)chooser.getTree(), (int)2);
                if (!chooser.showAndGet()) {
                    return null;
                }
                result.addAll(list);
                ArrayList<Object> methodsToDelete = new ArrayList<Object>();
                for (UsageInfo info2 : list) {
                    methodsToDelete.add(info2.getElement());
                }
                methodsToDelete.add(member);
                Condition<PsiElement> insideDeletedCondition = JavaSafeDeleteProcessor.getUsageInsideDeletedFilter(methodsToDelete.toArray(new PsiElement[methodsToDelete.size()]));
                for (UsageInfo info3 : list) {
                    PsiElement psi = info3.getElement();
                    JavaRefactoringSettings refactoringSettings = JavaRefactoringSettings.getInstance();
                    SafeDeleteProcessor.addNonCodeUsages((PsiElement)psi, result, insideDeletedCondition, (boolean)(psi instanceof PsiMethod ? refactoringSettings.RENAME_SEARCH_FOR_TEXT_FOR_METHOD : refactoringSettings.RENAME_SEARCH_FOR_TEXT_FOR_FIELD), (boolean)(psi instanceof PsiMethod ? refactoringSettings.RENAME_SEARCH_IN_COMMENTS_FOR_METHOD : refactoringSettings.RENAME_SEARCH_IN_COMMENTS_FOR_FIELD));
                }
            }
        }
        return result.toArray(new UsageInfo[result.size()]);
    }

    private static boolean allSuperMethodsSelectedToDelete(List<PsiMethod> unselectedMethods, PsiMethod method) {
        ArrayList<PsiMethod> superMethods = new ArrayList<PsiMethod>(Arrays.asList(method.findSuperMethods()));
        superMethods.retainAll(unselectedMethods);
        return superMethods.isEmpty();
    }

    public void prepareForDeletion(PsiElement element) throws IncorrectOperationException {
        if (element instanceof PsiVariable) {
            ((PsiVariable)element).normalizeDeclaration();
        }
    }

    public boolean isToSearchInComments(PsiElement element) {
        if (element instanceof PsiClass) {
            return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_CLASS;
        }
        if (element instanceof PsiMethod) {
            return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_METHOD;
        }
        if (element instanceof PsiVariable) {
            return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_VARIABLE;
        }
        if (element instanceof PsiPackage) {
            return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE;
        }
        return false;
    }

    public void setToSearchInComments(PsiElement element, boolean enabled) {
        if (element instanceof PsiClass) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_CLASS = enabled;
        } else if (element instanceof PsiMethod) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_METHOD = enabled;
        } else if (element instanceof PsiVariable) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_VARIABLE = enabled;
        } else if (element instanceof PsiPackage) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE = enabled;
        }
    }

    public boolean isToSearchForTextOccurrences(PsiElement element) {
        if (element instanceof PsiClass) {
            return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_CLASS;
        }
        if (element instanceof PsiMethod) {
            return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_METHOD;
        }
        if (element instanceof PsiVariable) {
            return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_VARIABLE;
        }
        if (element instanceof PsiPackage) {
            return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_PACKAGE;
        }
        return false;
    }

    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        if (element instanceof PsiClass) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_CLASS = enabled;
        } else if (element instanceof PsiMethod) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_METHOD = enabled;
        } else if (element instanceof PsiVariable) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_VARIABLE = enabled;
        } else if (element instanceof PsiPackage) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_PACKAGE = enabled;
        }
    }

    private static Condition<PsiElement> getUsageInsideDeletedFilter(PsiElement[] allElementsToDelete) {
        return usage -> !(usage instanceof PsiFile) && JavaSafeDeleteProcessor.isInside(usage, allElementsToDelete);
    }

    private static void findClassUsages(PsiClass psiClass, PsiElement[] allElementsToDelete, List<UsageInfo> usages) {
        boolean justPrivates = JavaSafeDeleteProcessor.containsOnlyPrivates(psiClass);
        String qualifiedName = psiClass.getQualifiedName();
        boolean annotationType = psiClass.isAnnotationType() && qualifiedName != null;
        PsiElement[] topElementsToDelete = (PsiElement[])Arrays.stream(allElementsToDelete).map(element -> {
            PsiClass[] classes2;
            PsiElement parent;
            if (element instanceof PsiClass && (parent = element.getParent()) instanceof PsiClassOwner && (classes2 = ((PsiClassOwner)parent).getClasses()).length == 1 && classes2[0] == element) {
                return element.getContainingFile();
            }
            return element;
        }).toArray(PsiElement[]::new);
        ReferencesSearch.search((PsiElement)psiClass).forEach(reference -> {
            PsiElement element = reference.getElement();
            if (!JavaSafeDeleteProcessor.isInside(element, topElementsToDelete)) {
                boolean safeDelete;
                PsiElement pparent;
                PsiElement parent = element.getParent();
                if (parent instanceof PsiReferenceList && (pparent = parent.getParent()) instanceof PsiClass && element instanceof PsiJavaCodeReferenceElement) {
                    PsiClass inheritor = (PsiClass)pparent;
                    if (justPrivates && (parent.equals(inheritor.getExtendsList()) || parent.equals(inheritor.getImplementsList()))) {
                        usages.add((UsageInfo)new SafeDeleteExtendsClassUsageInfo((PsiJavaCodeReferenceElement)element, psiClass, inheritor));
                        return true;
                    }
                }
                LOG.assertTrue(element.getTextRange() != null);
                PsiFile containingFile = psiClass.getContainingFile();
                boolean sameFileWithSingleClass = false;
                if (containingFile instanceof PsiClassOwner) {
                    PsiClass[] classes2 = ((PsiClassOwner)containingFile).getClasses();
                    sameFileWithSingleClass = classes2.length == 1 && classes2[0] == psiClass && element.getContainingFile() == containingFile;
                }
                boolean bl = safeDelete = sameFileWithSingleClass || JavaSafeDeleteProcessor.isInNonStaticImport(element);
                if (annotationType && parent instanceof PsiAnnotation) {
                    usages.add((UsageInfo)new SafeDeleteAnnotation((PsiAnnotation)parent, (PsiElement)psiClass, safeDelete));
                } else {
                    usages.add((UsageInfo)new SafeDeleteReferenceJavaDeleteUsageInfo(element, (PsiElement)psiClass, safeDelete));
                }
            }
            return true;
        });
    }

    private static boolean isInNonStaticImport(PsiElement element) {
        return ImportSearcher.getImport(element, true) != null;
    }

    private static boolean containsOnlyPrivates(PsiClass aClass) {
        PsiClass[] inners;
        PsiMethod[] methods;
        PsiField[] fields;
        for (PsiField field : fields = aClass.getFields()) {
            if (field.hasModifierProperty("private")) continue;
            return false;
        }
        for (PsiMethod method : methods = aClass.getMethods()) {
            PsiReferenceExpression methodExpression;
            PsiExpression expression2;
            PsiStatement[] statements;
            PsiCodeBlock body2;
            if (method.hasModifierProperty("private") || method.isConstructor() && (body2 = method.getBody()) != null && ((statements = body2.getStatements()).length == 0 || statements.length == 1 && statements[0] instanceof PsiExpressionStatement && (expression2 = ((PsiExpressionStatement)statements[0]).getExpression()) instanceof PsiMethodCallExpression && (methodExpression = ((PsiMethodCallExpression)expression2).getMethodExpression()).getText().equals("super"))) continue;
            return false;
        }
        for (PsiClass inner : inners = aClass.getInnerClasses()) {
            if (inner.hasModifierProperty("private")) continue;
            return false;
        }
        return true;
    }

    private static void findTypeParameterExternalUsages(PsiTypeParameter typeParameter, Collection<UsageInfo> usages) {
        PsiTypeParameterList parameterList;
        PsiTypeParameterListOwner owner = typeParameter.getOwner();
        if (owner != null && (parameterList = owner.getTypeParameterList()) != null) {
            int paramsCount = parameterList.getTypeParameters().length;
            int index = parameterList.getTypeParameterIndex(typeParameter);
            ReferencesSearch.search((PsiElement)owner).forEach(reference -> {
                PsiTypeElement[] typeArgs;
                PsiReferenceParameterList parameterList1;
                if (reference instanceof PsiJavaCodeReferenceElement && (parameterList1 = ((PsiJavaCodeReferenceElement)reference).getParameterList()) != null && (typeArgs = parameterList1.getTypeParameterElements()).length > index) {
                    if (typeArgs.length == 1 && paramsCount > 1 && typeArgs[0].getType() instanceof PsiDiamondType) {
                        return true;
                    }
                    usages.add((UsageInfo)new SafeDeleteReferenceJavaDeleteUsageInfo((PsiElement)typeArgs[index], (PsiElement)typeParameter, true));
                }
                return true;
            });
        }
    }

    @Nullable
    private static Condition<PsiElement> findMethodUsages(PsiMethod psiMethod, PsiElement[] allElementsToDelete, List<UsageInfo> usages) {
        Collection references = ReferencesSearch.search((PsiElement)psiMethod).findAll();
        if (psiMethod.isConstructor()) {
            return JavaSafeDeleteProcessor.findConstructorUsages(psiMethod, references, usages, allElementsToDelete);
        }
        Object[] overridingMethods = JavaSafeDeleteProcessor.removeDeletedMethods((PsiMethod[])OverridingMethodsSearch.search((PsiMethod)psiMethod).toArray((Object[])PsiMethod.EMPTY_ARRAY), allElementsToDelete);
        JavaSafeDeleteProcessor.findFunctionalExpressions(usages, (PsiMethod[])ArrayUtil.prepend((Object)psiMethod, (Object[])overridingMethods));
        HashMap methodToReferences = new HashMap();
        for (Object overridingMethod : overridingMethods) {
            Collection overridingReferences = ReferencesSearch.search((PsiElement)overridingMethod).findAll();
            methodToReferences.put(overridingMethod, (Object)overridingReferences);
        }
        Set<PsiMethod> validOverriding = JavaSafeDeleteProcessor.validateOverridingMethods(psiMethod, references, Arrays.asList(overridingMethods), (Map<PsiMethod, Collection<PsiReference>>)methodToReferences, usages, allElementsToDelete);
        for (PsiReference reference : references) {
            PsiElement element = reference.getElement();
            if (JavaSafeDeleteProcessor.isInside(element, allElementsToDelete) || JavaSafeDeleteProcessor.isInside(element, validOverriding)) continue;
            usages.add((UsageInfo)new SafeDeleteReferenceJavaDeleteUsageInfo(element, (PsiElement)psiMethod, PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStaticStatement.class) != null));
        }
        JavaSafeDeleteProcessor.appendCallees((PsiMember)psiMethod, usages);
        return usage -> {
            if (usage instanceof PsiFile) {
                return false;
            }
            return JavaSafeDeleteProcessor.isInside(usage, allElementsToDelete) || JavaSafeDeleteProcessor.isInside(usage, validOverriding);
        };
    }

    private static void appendCallees(@NotNull PsiMember method, @NotNull List<UsageInfo> usages) {
        List<PsiMember> calleesSafeToDelete;
        if (method == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(9);
        }
        if (usages == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(10);
        }
        if ((calleesSafeToDelete = SafeDeleteJavaCalleeChooser.computeCalleesSafeToDelete(method)) != null) {
            for (PsiMember callee : calleesSafeToDelete) {
                usages.add((UsageInfo)new SafeDeleteMemberCalleeUsageInfo(callee, method));
            }
        }
    }

    private static void findFunctionalExpressions(List<UsageInfo> usages, PsiMethod ... methods) {
        for (PsiMethod method : methods) {
            PsiClass containingClass = method.getContainingClass();
            FunctionalExpressionSearch.search((PsiMethod)method).forEach(expression2 -> {
                usages.add((UsageInfo)new SafeDeleteFunctionalExpressionUsageInfo((PsiElement)expression2, (PsiElement)containingClass));
                return true;
            });
        }
    }

    private static PsiMethod[] removeDeletedMethods(PsiMethod[] methods, PsiElement[] allElementsToDelete) {
        ArrayList<PsiMethod> list = new ArrayList<PsiMethod>();
        for (PsiMethod method : methods) {
            boolean isDeleted = false;
            for (PsiElement element : allElementsToDelete) {
                if (element != method) continue;
                isDeleted = true;
                break;
            }
            if (isDeleted) continue;
            list.add(method);
        }
        return list.toArray(new PsiMethod[list.size()]);
    }

    @Nullable
    private static Condition<PsiElement> findConstructorUsages(PsiMethod constructor, Collection<PsiReference> originalReferences, List<UsageInfo> usages, PsiElement[] allElementsToDelete) {
        if (JavaSafeDeleteProcessor.isTheOnlyEmptyDefaultConstructor(constructor)) {
            return null;
        }
        HashSet<Object> newConstructors = new HashSet<Object>();
        newConstructors.add(constructor);
        HashMap constructorsToRefs = new HashMap();
        constructorsToRefs.put(constructor, originalReferences);
        HashSet<PsiMethod> passConstructors = new HashSet<PsiMethod>();
        do {
            passConstructors.clear();
            for (PsiMethod psiMethod : newConstructors) {
                Collection references = (Collection)constructorsToRefs.get(psiMethod);
                for (PsiReference reference : references) {
                    PsiMethod overridingConstructor = JavaSafeDeleteProcessor.getOverridingConstructorOfSuperCall(reference.getElement());
                    if (overridingConstructor == null || constructorsToRefs.containsKey(overridingConstructor)) continue;
                    Collection overridingConstructorReferences = ReferencesSearch.search((PsiElement)overridingConstructor).findAll();
                    constructorsToRefs.put(overridingConstructor, overridingConstructorReferences);
                    passConstructors.add(overridingConstructor);
                }
            }
            newConstructors.clear();
            newConstructors.addAll(passConstructors);
        } while (!newConstructors.isEmpty());
        Set<PsiMethod> validOverriding = JavaSafeDeleteProcessor.validateOverridingMethods(constructor, originalReferences, constructorsToRefs.keySet(), (Map<PsiMethod, Collection<PsiReference>>)constructorsToRefs, usages, allElementsToDelete);
        return usage -> {
            if (usage instanceof PsiFile) {
                return false;
            }
            return JavaSafeDeleteProcessor.isInside(usage, allElementsToDelete) || JavaSafeDeleteProcessor.isInside(usage, validOverriding);
        };
    }

    private static boolean isTheOnlyEmptyDefaultConstructor(PsiMethod constructor) {
        if (constructor.getParameterList().getParameters().length > 0) {
            return false;
        }
        PsiCodeBlock body2 = constructor.getBody();
        if (body2 != null && body2.getStatements().length > 0) {
            return false;
        }
        return constructor.getContainingClass().getConstructors().length == 1;
    }

    private static Set<PsiMethod> validateOverridingMethods(PsiMethod originalMethod, Collection<PsiReference> originalReferences, Collection<PsiMethod> overridingMethods, Map<PsiMethod, Collection<PsiReference>> methodToReferences, List<UsageInfo> usages, PsiElement[] allElementsToDelete) {
        boolean anyNewBadRefs;
        LinkedHashSet<PsiMethod> validOverriding = new LinkedHashSet<PsiMethod>(overridingMethods);
        HashSet<PsiMethod> multipleInterfaceImplementations = new HashSet<PsiMethod>();
        do {
            anyNewBadRefs = false;
            for (PsiMethod overridingMethod : overridingMethods) {
                PsiElement element;
                if (!validOverriding.contains(overridingMethod)) continue;
                Collection<PsiReference> overridingReferences = methodToReferences.get(overridingMethod);
                boolean anyOverridingRefs = false;
                for (PsiReference overridingReference : overridingReferences) {
                    element = overridingReference.getElement();
                    if (JavaSafeDeleteProcessor.isInside(element, allElementsToDelete) || JavaSafeDeleteProcessor.isInside(element, validOverriding)) continue;
                    anyOverridingRefs = true;
                    break;
                }
                if (!anyOverridingRefs && JavaSafeDeleteProcessor.isMultipleInterfacesImplementation(overridingMethod, originalMethod, allElementsToDelete)) {
                    anyOverridingRefs = true;
                    multipleInterfaceImplementations.add(overridingMethod);
                }
                if (!anyOverridingRefs) continue;
                validOverriding.remove(overridingMethod);
                anyNewBadRefs = true;
                for (PsiReference reference : originalReferences) {
                    element = reference.getElement();
                    if (JavaSafeDeleteProcessor.isInside(element, allElementsToDelete) || JavaSafeDeleteProcessor.isInside(element, overridingMethods)) continue;
                    usages.add((UsageInfo)new SafeDeleteReferenceJavaDeleteUsageInfo(element, (PsiElement)originalMethod, false));
                    validOverriding.clear();
                }
            }
        } while (anyNewBadRefs && !validOverriding.isEmpty());
        for (PsiMethod method : validOverriding) {
            if (method == originalMethod) continue;
            usages.add((UsageInfo)new SafeDeleteOverridingMethodUsageInfo(method, originalMethod));
        }
        for (PsiMethod method : overridingMethods) {
            if (!validOverriding.contains(method) && !multipleInterfaceImplementations.contains(method) && JavaSafeDeleteProcessor.canBePrivate(method, methodToReferences.get(method), validOverriding, allElementsToDelete)) {
                usages.add((UsageInfo)new SafeDeletePrivatizeMethod(method, originalMethod));
                continue;
            }
            usages.add((UsageInfo)new SafeDeleteOverrideAnnotation((PsiElement)method, (PsiElement)originalMethod));
        }
        return validOverriding;
    }

    private static boolean isMultipleInterfacesImplementation(PsiMethod method, PsiMethod originalMethod, PsiElement[] allElementsToDelete) {
        PsiMethod[] methods;
        for (PsiMethod superMethod : methods = method.findSuperMethods()) {
            if (ArrayUtil.find((Object[])allElementsToDelete, (Object)superMethod) >= 0 || MethodSignatureUtil.isSuperMethod((PsiMethod)originalMethod, (PsiMethod)superMethod)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiMethod getOverridingConstructorOfSuperCall(PsiElement element) {
        PsiElement parent;
        if (element instanceof PsiReferenceExpression && "super".equals(element.getText()) && (parent = element.getParent()) instanceof PsiMethodCallExpression && (parent = parent.getParent()) instanceof PsiExpressionStatement && (parent = parent.getParent()) instanceof PsiCodeBlock && (parent = parent.getParent()) instanceof PsiMethod && ((PsiMethod)parent).isConstructor()) {
            return (PsiMethod)parent;
        }
        return null;
    }

    private static boolean canBePrivate(PsiMethod method, Collection<PsiReference> references, Collection<? extends PsiElement> deleted, PsiElement[] allElementsToDelete) {
        PsiModifierList privateModifierList;
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        PsiManager manager = method.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        PsiElementFactory factory = facade.getElementFactory();
        try {
            PsiMethod newMethod = factory.createMethod("x3", (PsiType)PsiType.VOID);
            privateModifierList = newMethod.getModifierList();
            privateModifierList.setModifierProperty("private", true);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return false;
        }
        for (PsiReference reference : references) {
            PsiElement element = reference.getElement();
            if (JavaSafeDeleteProcessor.isInside(element, allElementsToDelete) || JavaSafeDeleteProcessor.isInside(element, deleted) || facade.getResolveHelper().isAccessible((PsiMember)method, privateModifierList, element, null, null)) continue;
            return false;
        }
        return true;
    }

    private static Condition<PsiElement> findFieldUsages(PsiField psiField, List<UsageInfo> usages, PsiElement[] allElementsToDelete) {
        Condition<PsiElement> isInsideDeleted = JavaSafeDeleteProcessor.getUsageInsideDeletedFilter(allElementsToDelete);
        LinkedHashSet parameters2 = new LinkedHashSet();
        ReferencesSearch.search((PsiElement)psiField).forEach(reference -> {
            if (!isInsideDeleted.value((Object)reference.getElement())) {
                PsiElement element = reference.getElement();
                PsiElement parent = element.getParent();
                if (parent instanceof PsiAssignmentExpression && element == ((PsiAssignmentExpression)parent).getLExpression()) {
                    PsiParameter parameter2;
                    PsiElement scope;
                    PsiElement resolve;
                    usages.add((UsageInfo)new SafeDeleteFieldWriteReference((PsiAssignmentExpression)parent, psiField));
                    PsiExpression rExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiAssignmentExpression)parent).getRExpression());
                    if (rExpression instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)rExpression).resolve()) instanceof PsiParameter && (scope = (parameter2 = (PsiParameter)resolve).getDeclarationScope()) instanceof PsiMethod && ((PsiMethod)scope).isConstructor()) {
                        parameters2.add(parameter2);
                    }
                } else {
                    TextRange range = reference.getRangeInElement();
                    usages.add((UsageInfo)new SafeDeleteReferenceJavaDeleteUsageInfo(reference.getElement(), (PsiElement)psiField, range.getStartOffset(), range.getEndOffset(), false, PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStaticStatement.class) != null));
                }
            }
            return true;
        });
        PsiMethod setterPrototype = PropertyUtilBase.generateSetterPrototype((PsiField)psiField, (PsiClass)psiField.getContainingClass());
        PsiParameter setterParameter = setterPrototype.getParameterList().getParameters()[0];
        for (PsiParameter parameter2 : parameters2) {
            PsiElement scope = parameter2.getDeclarationScope();
            if (!(scope instanceof PsiMethod) || !ReferencesSearch.search((PsiElement)parameter2, (SearchScope)new LocalSearchScope(scope)).forEach(ref -> {
                PsiExpression lExpression;
                PsiElement parent;
                PsiElement element = ref.getElement();
                return element instanceof PsiReferenceExpression && (parent = PsiUtil.skipParenthesizedExprUp((PsiElement)element.getParent())) instanceof PsiAssignmentExpression && (lExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiAssignmentExpression)parent).getLExpression())) instanceof PsiReferenceExpression && ((PsiReferenceExpression)lExpression).resolve() == psiField;
            })) continue;
            usages.add((UsageInfo)JavaSafeDeleteProcessor.createParameterCallHierarchyUsageInfo(setterPrototype, setterParameter, (PsiMethod)scope, parameter2));
        }
        JavaSafeDeleteProcessor.appendCallees((PsiMember)psiField, usages);
        return isInsideDeleted;
    }

    private static SafeDeleteParameterCallHierarchyUsageInfo createParameterCallHierarchyUsageInfo(PsiMethod called, PsiParameter calledParameter, PsiMethod caller, PsiParameter parameterInCaller) {
        return ApplicationManager.getApplication().isUnitTestMode() ? new SafeDeleteParameterCallHierarchyUsageInfo(caller, parameterInCaller, caller, parameterInCaller) : new SafeDeleteParameterCallHierarchyUsageInfo(called, calledParameter, caller, parameterInCaller);
    }

    private static void findParameterUsages(PsiParameter parameter2, List<UsageInfo> usages) {
        PsiMethod method = (PsiMethod)parameter2.getDeclarationScope();
        int parameterIndex = method.getParameterList().getParameterIndex(parameter2);
        ReferencesSearch.search((PsiElement)method).forEach(reference -> {
            PsiElement element = reference.getElement();
            if (element != null) {
                PsiParameter paramInCaller;
                JavaSafeDeleteDelegate safeDeleteDelegate = (JavaSafeDeleteDelegate)JavaSafeDeleteDelegate.EP.forLanguage(element.getLanguage());
                if (safeDeleteDelegate != null) {
                    safeDeleteDelegate.createUsageInfoForParameter(reference, usages, parameter2, method);
                }
                if (!parameter2.isVarArgs() && !RefactoringChangeUtil.isSuperMethodCall(element.getParent()) && (paramInCaller = SafeDeleteJavaCallerChooser.isTheOnlyOneParameterUsage(element.getParent(), parameterIndex, method)) != null) {
                    PsiMethod callerMethod = (PsiMethod)paramInCaller.getDeclarationScope();
                    usages.add((UsageInfo)JavaSafeDeleteProcessor.createParameterCallHierarchyUsageInfo(method, parameter2, callerMethod, paramInCaller));
                }
            }
            return true;
        });
        ReferencesSearch.search((PsiElement)parameter2).forEach(reference -> {
            PsiElement element = reference.getElement();
            PsiDocTag docTag = (PsiDocTag)PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocTag.class);
            if (docTag != null) {
                usages.add((UsageInfo)new SafeDeleteReferenceJavaDeleteUsageInfo((PsiElement)docTag, (PsiElement)parameter2, true));
                return true;
            }
            boolean isSafeDelete = false;
            if (element.getParent().getParent() instanceof PsiMethodCallExpression) {
                PsiMethod superMethod;
                PsiMethodCallExpression call = (PsiMethodCallExpression)element.getParent().getParent();
                PsiReferenceExpression methodExpression = call.getMethodExpression();
                if (methodExpression.getText().equals("super")) {
                    isSafeDelete = true;
                } else if (methodExpression.getQualifierExpression() instanceof PsiSuperExpression && (superMethod = call.resolveMethod()) != null && MethodSignatureUtil.isSuperMethod((PsiMethod)superMethod, (PsiMethod)method)) {
                    isSafeDelete = true;
                }
            }
            usages.add((UsageInfo)new SafeDeleteReferenceJavaDeleteUsageInfo(element, (PsiElement)parameter2, isSafeDelete));
            return true;
        });
        JavaSafeDeleteProcessor.findFunctionalExpressions(usages, method);
    }

    private static boolean isInside(PsiElement place, PsiElement[] ancestors) {
        return JavaSafeDeleteProcessor.isInside(place, Arrays.asList(ancestors));
    }

    private static boolean isInside(PsiElement place, Collection<? extends PsiElement> ancestors) {
        for (PsiElement psiElement : ancestors) {
            if (!JavaSafeDeleteProcessor.isInside(place, psiElement)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInside(PsiElement place, PsiElement ancestor) {
        PsiJavaFile file;
        PsiClass aClass;
        if (SafeDeleteProcessor.isInside((PsiElement)place, (PsiElement)ancestor)) {
            return true;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)place, PsiComment.class, (boolean)false) != null && ancestor instanceof PsiClass && (aClass = (PsiClass)ancestor).getParent() instanceof PsiJavaFile && PsiTreeUtil.isAncestor((PsiElement)(file = (PsiJavaFile)aClass.getParent()), (PsiElement)place, (boolean)false) && file.getClasses().length == 1;
    }

    public static void collectMethodConflicts(MultiMap<PsiElement, String> conflicts, PsiMethod method, PsiParameter parameter2) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass != null) {
            int parameterIndex = method.getParameterList().getParameterIndex(parameter2);
            PsiMethod methodCopy = (PsiMethod)method.copy();
            methodCopy.getParameterList().getParameters()[parameterIndex].delete();
            ConflictsUtil.checkMethodConflicts(containingClass, method, methodCopy, conflicts);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allElementsToDelete";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/safeDelete/JavaSafeDeleteProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findUsages";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementsToSearch";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getAdditionalElementsToDelete";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findConflicts";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "appendCallees";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SafeDeleteExternalAnnotationsUsageInfo
    extends SafeDeleteReferenceUsageInfo {
        SafeDeleteExternalAnnotationsUsageInfo(PsiElement referenceElement, PsiElement element) {
            super(element, referenceElement, true);
        }

        public void deleteElement() throws IncorrectOperationException {
            PsiElement referencedElement = this.getReferencedElement();
            if (!referencedElement.isValid()) {
                return;
            }
            ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance((Project)referencedElement.getProject());
            PsiAnnotation[] externalAnnotations = annotationsManager.findExternalAnnotations((PsiModifierListOwner)referencedElement);
            if (externalAnnotations != null) {
                for (PsiAnnotation annotation : externalAnnotations) {
                    String qualifiedName = annotation.getQualifiedName();
                    if (qualifiedName == null) continue;
                    annotationsManager.deannotate((PsiModifierListOwner)referencedElement, qualifiedName);
                }
            }
        }
    }

    private static class SafeDeleteFunctionalExpressionUsageInfo
    extends SafeDeleteReferenceUsageInfo {
        SafeDeleteFunctionalExpressionUsageInfo(@NotNull PsiElement element, PsiElement referencedElement) {
            if (element == null) {
                SafeDeleteFunctionalExpressionUsageInfo.$$$reportNull$$$0(0);
            }
            super(element, referencedElement, false);
        }

        public void deleteElement() throws IncorrectOperationException {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/safeDelete/JavaSafeDeleteProcessor$SafeDeleteFunctionalExpressionUsageInfo", "<init>"));
        }
    }
}

