/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PsiTypeTokenizer
extends Tokenizer<PsiTypeElement> {
    public void tokenize(@NotNull PsiTypeElement element, TokenConsumer consumer) {
        String elementText;
        boolean isInSource;
        PsiType type2;
        if (element == null) {
            PsiTypeTokenizer.$$$reportNull$$$0(0);
        }
        if ((type2 = element.getType()) instanceof PsiDisjunctionType) {
            this.tokenizeComplexType(element, consumer);
            return;
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
        if (psiClass == null || psiClass.getContainingFile() == null || psiClass.getContainingFile().getVirtualFile() == null) {
            return;
        }
        String name = psiClass.getName();
        if (name == null) {
            return;
        }
        VirtualFile virtualFile = psiClass.getContainingFile().getVirtualFile();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
        boolean bl = isInSource = virtualFile != null && fileIndex.isInContent(virtualFile);
        if (isInSource && (elementText = element.getText()).contains(name)) {
            consumer.consumeToken((PsiElement)element, elementText, true, 0, PsiTypeTokenizer.getRangeToCheck(elementText, name), (Splitter)IdentifierSplitter.getInstance());
        }
    }

    private void tokenizeComplexType(PsiTypeElement element, TokenConsumer consumer) {
        List subTypes = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)element, PsiTypeElement.class);
        for (PsiTypeElement subType : subTypes) {
            this.tokenize(subType, consumer);
        }
    }

    @NotNull
    private static TextRange getRangeToCheck(@NotNull String text2, @NotNull String name) {
        if (text2 == null) {
            PsiTypeTokenizer.$$$reportNull$$$0(1);
        }
        if (name == null) {
            PsiTypeTokenizer.$$$reportNull$$$0(2);
        }
        int i = text2.indexOf(name);
        TextRange textRange = new TextRange(i, i + name.length());
        if (textRange == null) {
            PsiTypeTokenizer.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/PsiTypeTokenizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/PsiTypeTokenizer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeToCheck";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToCheck";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

