/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import org.jetbrains.annotations.NotNull;

public class ArrayEqualityInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("array.comparison.display.name", new Object[0]);
        if (string == null) {
            ArrayEqualityInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("array.comparison.problem.descriptor", new Object[0]);
        if (string == null) {
            ArrayEqualityInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        PsiArrayType type2 = (PsiArrayType)infos[0];
        PsiType componentType = type2.getComponentType();
        if (componentType instanceof PsiArrayType) {
            return new ArrayEqualityFix(true);
        }
        return new ArrayEqualityFix(false);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ArrayEqualityVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/ArrayEqualityInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ArrayEqualityVisitor
    extends BaseInspectionVisitor {
        private ArrayEqualityVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression2) {
            if (expression2 == null) {
                ArrayEqualityVisitor.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression2);
            PsiExpression rhs = expression2.getROperand();
            if (rhs == null || !ComparisonUtils.isEqualityComparison((PsiExpression)expression2)) {
                return;
            }
            PsiExpression lhs = expression2.getLOperand();
            PsiType lhsType = lhs.getType();
            if (!(lhsType instanceof PsiArrayType) || !(rhs.getType() instanceof PsiArrayType)) {
                return;
            }
            this.registerError((PsiElement)expression2.getOperationSign(), lhsType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/ArrayEqualityInspection$ArrayEqualityVisitor", "visitBinaryExpression"));
        }
    }

    private static class ArrayEqualityFix
    extends InspectionGadgetsFix {
        private final boolean deepEquals;

        public ArrayEqualityFix(boolean deepEquals) {
            this.deepEquals = deepEquals;
        }

        @NotNull
        public String getName() {
            if (this.deepEquals) {
                String string = InspectionGadgetsBundle.message("replace.with.arrays.deep.equals", new Object[0]);
                if (string == null) {
                    ArrayEqualityFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("replace.with.arrays.equals", new Object[0]);
            if (string == null) {
                ArrayEqualityFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("replace.with.arrays.equals", new Object[0]);
            if (string == null) {
                ArrayEqualityFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiBinaryExpression)) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parent;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            StringBuilder newExpressionText = new StringBuilder();
            if (JavaTokenType.NE.equals(tokenType)) {
                newExpressionText.append('!');
            } else if (!JavaTokenType.EQEQ.equals(tokenType)) {
                return;
            }
            if (this.deepEquals) {
                newExpressionText.append("java.util.Arrays.deepEquals(");
            } else {
                newExpressionText.append("java.util.Arrays.equals(");
            }
            newExpressionText.append(commentTracker.markUnchanged(binaryExpression.getLOperand()).getText());
            newExpressionText.append(',');
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return;
            }
            newExpressionText.append(commentTracker.markUnchanged(rhs).getText());
            newExpressionText.append(')');
            PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)binaryExpression, newExpressionText.toString(), commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/bugs/ArrayEqualityInspection$ArrayEqualityFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

