/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ArrayHashCodeInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("array.hash.code.display.name", new Object[0]);
        if (string == null) {
            ArrayHashCodeInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("array.hash.code.problem.descriptor", new Object[0]);
        if (string == null) {
            ArrayHashCodeInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiArrayType type2 = (PsiArrayType)infos[0];
        if (type2.getComponentType() instanceof PsiArrayType) {
            return new ArrayHashCodeFix(true);
        }
        return new ArrayHashCodeFix(false);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ArrayHashCodeVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/ArrayHashCodeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ArrayHashCodeVisitor
    extends BaseInspectionVisitor {
        private ArrayHashCodeVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"hashCode".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 0) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiType type2 = qualifier.getType();
            if (!(type2 instanceof PsiArrayType)) {
                return;
            }
            this.registerMethodCallError(expression2, type2);
        }
    }

    private static class ArrayHashCodeFix
    extends InspectionGadgetsFix {
        private final boolean deepHashCode;

        public ArrayHashCodeFix(boolean deepHashCode) {
            this.deepHashCode = deepHashCode;
        }

        @NotNull
        public String getName() {
            if (this.deepHashCode) {
                String string = InspectionGadgetsBundle.message("arrays.deep.hash.code.quickfix", new Object[0]);
                if (string == null) {
                    ArrayHashCodeFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("arrays.hash.code.quickfix", new Object[0]);
            if (string == null) {
                ArrayHashCodeFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace with implicit 'hashCode'" == null) {
                ArrayHashCodeFix.$$$reportNull$$$0(2);
            }
            return "Replace with implicit 'hashCode'";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            StringBuilder newExpressionText = new StringBuilder();
            if (this.deepHashCode) {
                newExpressionText.append("java.util.Arrays.deepHashCode(");
            } else {
                newExpressionText.append("java.util.Arrays.hashCode(");
            }
            CommentTracker commentTracker = new CommentTracker();
            newExpressionText.append(commentTracker.markUnchanged(qualifier).getText());
            newExpressionText.append(')');
            PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)methodCallExpression, newExpressionText.toString(), commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/bugs/ArrayHashCodeInspection$ArrayHashCodeFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

