/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.daemon.impl.analysis.LambdaHighlightingUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CollectionQueryUpdateCalledVisitor
extends JavaRecursiveElementWalkingVisitor {
    private static final HashSet<String> COLLECTIONS_QUERIES = ContainerUtil.newHashSet((Object[])new String[]{"binarySearch", "disjoint", "frequency", "indexOfSubList", "lastIndexOfSubList", "max", "min", "nCopies", "unmodifiableList", "unmodifiableMap", "unmodifiableNavigableMap", "unmodifiableNavigableSet", "unmodifiableSet", "unmodifiableSortedMap", "unmodifiableSortedSet"});
    private static final HashSet<String> COLLECTIONS_TRANSFORMS = ContainerUtil.newHashSet((Object[])new String[]{"asLifoQueue", "checkedCollection", "checkedList", "checkedMap", "checkedNavigableMap", "checkedNavigableSet", "checkedQueue", "checkedSet", "checkedSortedMap", "checkedSortedSet", "enumeration", "newSetFromMap", "synchronizedCollection", "singleton", "singletonList", "singletonMap", "singletonSpliterator", "synchronizedList", "synchronizedMap", "synchronizedNavigableMap", "synchronizedNavigableSet", "synchronizedSet", "synchronizedSortedMap", "synchronizedSortedSet", "unmodifiableCollection"});
    @NonNls
    private final Set<String> myQueryUpdateNames;
    private final boolean myCheckForQuery;
    private boolean myQueriedUpdated;
    private final PsiVariable variable;

    CollectionQueryUpdateCalledVisitor(@Nullable PsiVariable variable, Set<String> queryUpdateNames, boolean checkForQuery) {
        this.variable = variable;
        this.myQueryUpdateNames = queryUpdateNames;
        this.myCheckForQuery = checkForQuery;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            CollectionQueryUpdateCalledVisitor.$$$reportNull$$$0(0);
        }
        if (!this.myQueriedUpdated) {
            super.visitElement(element);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitReferenceExpression(PsiReferenceExpression expression2) {
        PsiMethod method;
        super.visitReferenceExpression(expression2);
        PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression2);
        if (!(parent instanceof PsiExpressionList)) {
            return;
        }
        PsiExpressionList expressionList = (PsiExpressionList)parent;
        PsiElement grandParent = expressionList.getParent();
        if (!(grandParent instanceof PsiMethodCallExpression)) {
            return;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String name = methodExpression.getReferenceName();
        if (this.myCheckForQuery) {
            if (COLLECTIONS_QUERIES.contains(name) || COLLECTIONS_TRANSFORMS.contains(name)) {
                if (methodCallExpression.getParent() instanceof PsiExpressionStatement) {
                    return;
                }
            } else {
                if (!"addAll".equals(name) && !"copy".equals(name) && !"fill".equals(name) && !"replaceAll".equals(name)) return;
                PsiExpression[] arguments = expressionList.getExpressions();
                if (arguments.length < 2 || PsiTreeUtil.isAncestor((PsiElement)arguments[0], (PsiElement)expression2, (boolean)false)) {
                    return;
                }
            }
        } else if ("addAll".equals(name) || "fill".equals(name) || "copy".equals(name) || "replaceAll".equals(name)) {
            if (!PsiTreeUtil.isAncestor((PsiElement)expressionList.getExpressions()[0], (PsiElement)expression2, (boolean)false)) {
                return;
            }
        } else {
            if (!COLLECTIONS_TRANSFORMS.contains(name)) return;
            if (methodCallExpression.getParent() instanceof PsiExpressionStatement) {
                return;
            }
        }
        if ((method = methodCallExpression.resolveMethod()) == null) {
            return;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return;
        }
        String qualifiedName = aClass.getQualifiedName();
        if (!"java.util.Collections".equals(qualifiedName)) {
            return;
        }
        this.checkExpression((PsiExpression)expression2);
    }

    public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
        if (statement == null) {
            CollectionQueryUpdateCalledVisitor.$$$reportNull$$$0(1);
        }
        super.visitForeachStatement(statement);
        if (this.myQueriedUpdated || !this.myCheckForQuery) {
            return;
        }
        PsiExpression qualifier = statement.getIteratedValue();
        this.checkExpression(qualifier);
    }

    public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
        super.visitMethodReferenceExpression(expression2);
        if (this.myQueriedUpdated) {
            return;
        }
        String methodName = expression2.getReferenceName();
        if (!this.isQueryUpdateMethodName(methodName)) {
            if (this.myCheckForQuery) {
                PsiElement target = expression2.resolve();
                if (!(target instanceof PsiMethod)) {
                    return;
                }
                PsiMethod method = (PsiMethod)target;
                PsiType returnType = method.getReturnType();
                if (PsiType.VOID.equals((Object)returnType)) {
                    return;
                }
                PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)expression2, false);
                PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expectedType);
                if (aClass == null || LambdaHighlightingUtil.checkInterfaceFunctional(aClass) != null) {
                    return;
                }
                PsiMethod functionalMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)aClass);
                if (functionalMethod == null || PsiType.VOID.equals((Object)functionalMethod.getReturnType())) {
                    return;
                }
            } else {
                return;
            }
        }
        this.checkExpression(expression2.getQualifierExpression());
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
        if (call == null) {
            CollectionQueryUpdateCalledVisitor.$$$reportNull$$$0(2);
        }
        if (this.myQueriedUpdated) {
            return;
        }
        super.visitMethodCallExpression(call);
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        boolean isStatement = call.getParent() instanceof PsiExpressionStatement;
        if (!(this.myCheckForQuery && !isStatement || this.isQueryUpdateMethodName(methodExpression.getReferenceName()))) {
            return;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        this.checkExpression(qualifier);
    }

    private boolean isQueryUpdateMethodName(String methodName) {
        if (methodName == null) {
            return false;
        }
        if (this.myQueryUpdateNames.contains(methodName)) {
            return true;
        }
        for (String updateName : this.myQueryUpdateNames) {
            if (!methodName.startsWith(updateName)) continue;
            return true;
        }
        return false;
    }

    private void checkExpression(PsiExpression expression2) {
        if (this.myQueriedUpdated) {
            return;
        }
        if (this.variable != null && expression2 instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiElement referent = referenceExpression.resolve();
            if (referent == null) {
                return;
            }
            if (referent.equals(this.variable)) {
                this.myQueriedUpdated = true;
            }
        } else if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            this.checkExpression(parenthesizedExpression.getExpression());
        } else if (expression2 instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression2;
            PsiExpression thenExpression2 = conditionalExpression.getThenExpression();
            this.checkExpression(thenExpression2);
            PsiExpression elseExpression2 = conditionalExpression.getElseExpression();
            this.checkExpression(elseExpression2);
        } else if (this.variable == null && (expression2 == null || expression2 instanceof PsiThisExpression || expression2 instanceof PsiSuperExpression)) {
            this.myQueriedUpdated = true;
        }
    }

    boolean isQueriedUpdated() {
        return this.myQueriedUpdated;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/bugs/CollectionQueryUpdateCalledVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitForeachStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethodCallExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

