/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.bugs.BaseEqualsVisitor;
import com.siyeh.ig.psiutils.InheritanceUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EqualsBetweenInconvertibleTypesInspection
extends BaseInspection {
    public boolean WARN_IF_NO_MUTUAL_SUBCLASS_FOUND = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("equals.between.inconvertible.types.display.name", new Object[0]);
        if (string == null) {
            EqualsBetweenInconvertibleTypesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("equals.between.inconvertible.types.mutual.subclass.option", new Object[0]), (InspectionProfileEntry)this, "WARN_IF_NO_MUTUAL_SUBCLASS_FOUND");
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType comparedType = (PsiType)infos[0];
        PsiType comparisonType = (PsiType)infos[1];
        boolean convertible = (Boolean)infos[2];
        if (convertible) {
            String string = InspectionGadgetsBundle.message("equals.between.inconvertible.types.no.mutual.subclass.problem.descriptor", comparedType.getPresentableText(), comparisonType.getPresentableText());
            if (string == null) {
                EqualsBetweenInconvertibleTypesInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("equals.between.inconvertible.types.problem.descriptor", comparedType.getPresentableText(), comparisonType.getPresentableText());
        if (string == null) {
            EqualsBetweenInconvertibleTypesInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EqualsBetweenInconvertibleTypesVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/EqualsBetweenInconvertibleTypesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class EqualsBetweenInconvertibleTypesVisitor
    extends BaseEqualsVisitor {
        private EqualsBetweenInconvertibleTypesVisitor() {
        }

        public void visitBinaryExpression(PsiBinaryExpression expression2) {
            super.visitBinaryExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.EQEQ) && !tokenType.equals(JavaTokenType.NE)) {
                return;
            }
            PsiExpression lhs = expression2.getLOperand();
            PsiType lhsType = lhs.getType();
            PsiExpression rhs = expression2.getROperand();
            if (rhs == null) {
                return;
            }
            PsiType rhsType = rhs.getType();
            if (lhsType == null || rhsType == null || TypeConversionUtil.isPrimitiveAndNotNull((PsiType)lhsType) || TypeConversionUtil.isPrimitiveAndNotNull((PsiType)rhsType) || !TypeUtils.areConvertible(lhsType, rhsType)) {
                return;
            }
            this.deepCheck(lhsType, rhsType, (PsiElement)expression2.getOperationSign());
        }

        @Override
        void checkTypes(@NotNull PsiReferenceExpression expression2, @NotNull PsiType leftType, @NotNull PsiType rightType) {
            PsiElement name;
            if (expression2 == null) {
                EqualsBetweenInconvertibleTypesVisitor.$$$reportNull$$$0(0);
            }
            if (leftType == null) {
                EqualsBetweenInconvertibleTypesVisitor.$$$reportNull$$$0(1);
            }
            if (rightType == null) {
                EqualsBetweenInconvertibleTypesVisitor.$$$reportNull$$$0(2);
            }
            if ((name = expression2.getReferenceNameElement()) == null) {
                return;
            }
            if (TypeUtils.areConvertible(leftType, rightType) || TypeUtils.mayBeEqualByContract(leftType, rightType)) {
                this.deepCheck(leftType, rightType, name);
                return;
            }
            this.registerError(name, leftType, rightType, false);
        }

        private void deepCheck(@NotNull PsiType leftType, @NotNull PsiType rightType, PsiElement highlightLocation) {
            if (leftType == null) {
                EqualsBetweenInconvertibleTypesVisitor.$$$reportNull$$$0(3);
            }
            if (rightType == null) {
                EqualsBetweenInconvertibleTypesVisitor.$$$reportNull$$$0(4);
            }
            if (leftType instanceof PsiCapturedWildcardType) {
                leftType = ((PsiCapturedWildcardType)leftType).getUpperBound();
            }
            if (rightType instanceof PsiCapturedWildcardType) {
                rightType = ((PsiCapturedWildcardType)rightType).getUpperBound();
            }
            if (leftType.isAssignableFrom(rightType) || rightType.isAssignableFrom(leftType)) {
                return;
            }
            PsiClass leftClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)leftType);
            PsiClass rightClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)rightType);
            if (leftClass == null || rightClass == null) {
                return;
            }
            if (!rightClass.isInterface()) {
                PsiClass tmp = leftClass;
                leftClass = rightClass;
                rightClass = tmp;
            }
            if (leftClass == rightClass || TypeUtils.mayBeEqualByContract(leftType, rightType)) {
                PsiType[] rightParameters;
                PsiType[] leftParameters;
                if (leftType instanceof PsiClassType && rightType instanceof PsiClassType && (leftParameters = ((PsiClassType)leftType).getParameters()).length == (rightParameters = ((PsiClassType)rightType).getParameters()).length) {
                    int length = leftParameters.length;
                    for (int i = 0; i < length; ++i) {
                        PsiType leftParameter = leftParameters[i];
                        PsiType rightParameter = rightParameters[i];
                        if (!TypeUtils.areConvertible(leftParameter, rightParameter) && !TypeUtils.mayBeEqualByContract(leftParameter, rightParameter)) {
                            this.registerError(highlightLocation, leftType, rightType, false);
                            return;
                        }
                        this.deepCheck(leftParameter, rightParameter, highlightLocation);
                    }
                }
            } else if (EqualsBetweenInconvertibleTypesInspection.this.WARN_IF_NO_MUTUAL_SUBCLASS_FOUND & !InheritanceUtil.existsMutualSubclass(leftClass, rightClass, this.isOnTheFly())) {
                this.registerError(highlightLocation, leftType, rightType, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leftType";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightType";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/bugs/EqualsBetweenInconvertibleTypesInspection$EqualsBetweenInconvertibleTypesVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkTypes";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deepCheck";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

