/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.bugs.ParameterClassCheckVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class EqualsWhichDoesntCheckParameterClassInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("equals.doesnt.check.class.parameter.display.name", new Object[0]);
        if (string == null) {
            EqualsWhichDoesntCheckParameterClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("equals.doesnt.check.class.parameter.problem.descriptor", new Object[0]);
        if (string == null) {
            EqualsWhichDoesntCheckParameterClassInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EqualsWhichDoesntCheckParameterClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/EqualsWhichDoesntCheckParameterClassInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class EqualsWhichDoesntCheckParameterClassVisitor
    extends BaseInspectionVisitor {
        private EqualsWhichDoesntCheckParameterClassVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                EqualsWhichDoesntCheckParameterClassVisitor.$$$reportNull$$$0(0);
            }
            if (!MethodUtils.isEquals(method)) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters2 = parameterList.getParameters();
            PsiParameter parameter2 = parameters2[0];
            PsiCodeBlock body2 = method.getBody();
            if (body2 == null || EqualsWhichDoesntCheckParameterClassVisitor.isParameterChecked(body2, parameter2) || EqualsWhichDoesntCheckParameterClassVisitor.isParameterCheckNotNeeded(body2, parameter2)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static boolean isParameterChecked(PsiCodeBlock body2, PsiParameter parameter2) {
            ParameterClassCheckVisitor visitor = new ParameterClassCheckVisitor(parameter2);
            body2.accept((PsiElementVisitor)visitor);
            return visitor.isChecked();
        }

        private static boolean isParameterCheckNotNeeded(PsiCodeBlock body2, PsiParameter parameter2) {
            if (ControlFlowUtils.isEmptyCodeBlock(body2)) {
                return true;
            }
            PsiStatement statement = ControlFlowUtils.getOnlyStatementInBlock(body2);
            if (statement == null) {
                return false;
            }
            if (!(statement instanceof PsiReturnStatement)) {
                return true;
            }
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
            PsiExpression returnValue = returnStatement.getReturnValue();
            Object constant = ExpressionUtils.computeConstantExpression(returnValue);
            if (Boolean.FALSE.equals(constant)) {
                return true;
            }
            if (EqualsWhichDoesntCheckParameterClassVisitor.isEqualsBuilderReflectionEquals(returnValue)) {
                return true;
            }
            return EqualsWhichDoesntCheckParameterClassVisitor.isIdentityEquals(returnValue, parameter2);
        }

        private static boolean isIdentityEquals(PsiExpression expression2, PsiParameter parameter2) {
            PsiExpression rhs;
            if (!(expression2 instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
            PsiExpression lhs = binaryExpression.getLOperand();
            return EqualsWhichDoesntCheckParameterClassVisitor.isIdentityEquals(lhs, rhs = binaryExpression.getROperand(), parameter2) || EqualsWhichDoesntCheckParameterClassVisitor.isIdentityEquals(rhs, lhs, parameter2);
        }

        private static boolean isIdentityEquals(PsiExpression lhs, PsiExpression rhs, PsiParameter parameter2) {
            if (!(lhs instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement target = referenceExpression.resolve();
            if (target != parameter2) {
                return false;
            }
            if (!(rhs instanceof PsiThisExpression)) {
                return false;
            }
            PsiThisExpression thisExpression = (PsiThisExpression)rhs;
            return thisExpression.getQualifier() == null;
        }

        private static boolean isEqualsBuilderReflectionEquals(PsiExpression expression2) {
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"reflectionEquals".equals(referenceName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiClass)) {
                return false;
            }
            PsiClass aClass = (PsiClass)target;
            String className = aClass.getQualifiedName();
            return "org.apache.commons.lang.builder.EqualsBuilder".equals(className);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/bugs/EqualsWhichDoesntCheckParameterClassInspection$EqualsWhichDoesntCheckParameterClassVisitor", "visitMethod"));
        }
    }
}

