/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OrderedSet;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.bugs.ResultOfObjectAllocationIgnoredInspectionBase;
import com.siyeh.ig.fixes.IgnoreClassFix;
import com.siyeh.ig.fixes.SuppressForTestsScopeFix;
import com.siyeh.ig.ui.UiUtils;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResultOfObjectAllocationIgnoredInspection
extends ResultOfObjectAllocationIgnoredInspectionBase {
    @Nullable
    public JComponent createOptionsPanel() {
        return UiUtils.createTreeClassChooserList((Collection<String>)this.ignoredClasses, "Ignored classes", "Choose class for which object allocation can be ignored", new String[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiElement context = (PsiElement)infos[0];
        return SuppressForTestsScopeFix.build(this, context);
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        String name;
        SmartList result = new SmartList();
        PsiExpression expression2 = (PsiExpression)infos[0];
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression2.getType());
        if (aClass != null && (name = aClass.getQualifiedName()) != null) {
            result.add(new IgnoreClassFix(name, (OrderedSet<String>)this.ignoredClasses, "Ignore allocations of objects with type '" + name + "'"));
        }
        ContainerUtil.addIfNotNull((Collection)result, (Object)SuppressForTestsScopeFix.build(this, (PsiElement)expression2));
        InspectionGadgetsFix[] inspectionGadgetsFixArray = result.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
        if (inspectionGadgetsFixArray == null) {
            ResultOfObjectAllocationIgnoredInspection.$$$reportNull$$$0(0);
        }
        return inspectionGadgetsFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ResultOfObjectAllocationIgnoredInspection", "buildFixes"));
    }
}

