/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SetInspectionOptionFix;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JComponent;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PointlessNullCheckInspection
extends BaseInspection {
    private static final String REPORT_CALLS_OPTION = "REPORT_CALLS";
    public boolean REPORT_CALLS = true;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("pointless.nullcheck.display.name", new Object[0]);
        if (string == null) {
            PointlessNullCheckInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("pointless.nullcheck.option.report.calls", new Object[0]), (InspectionProfileEntry)this, REPORT_CALLS_OPTION);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiExpression parent = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)infos[1]), (Class[])new Class[]{PsiInstanceOfExpression.class, PsiMethodCallExpression.class});
        if (parent instanceof PsiMethodCallExpression) {
            String string = InspectionGadgetsBundle.message("pointless.nullcheck.problem.descriptor.call", ((PsiMethodCallExpression)parent).getMethodExpression().getReferenceName());
            if (string == null) {
                PointlessNullCheckInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("pointless.nullcheck.problem.descriptor.instanceof", new Object[0]);
        if (string == null) {
            PointlessNullCheckInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessNullCheckVisitor(this.REPORT_CALLS);
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiExpression expression2 = (PsiExpression)infos[0];
        PsiExpression parent = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)infos[1]), (Class[])new Class[]{PsiInstanceOfExpression.class, PsiMethodCallExpression.class});
        PointlessNullCheckFix removeNullCheckFix = new PointlessNullCheckFix(expression2.getText());
        if (parent instanceof PsiMethodCallExpression) {
            InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{removeNullCheckFix, new DoNotReportOnCallsFix(this)};
            if (inspectionGadgetsFixArray == null) {
                PointlessNullCheckInspection.$$$reportNull$$$0(3);
            }
            return inspectionGadgetsFixArray;
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{removeNullCheckFix};
        if (inspectionGadgetsFixArray == null) {
            PointlessNullCheckInspection.$$$reportNull$$$0(4);
        }
        return inspectionGadgetsFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/PointlessNullCheckInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class PointlessNullCheckVisitor
    extends BaseInspectionVisitor {
        private final boolean myReportCalls;

        private PointlessNullCheckVisitor(boolean reportCalls) {
            this.myReportCalls = reportCalls;
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            super.visitPolyadicExpression(expression2);
            IElementType operationTokenType = expression2.getOperationTokenType();
            if (operationTokenType.equals(JavaTokenType.ANDAND)) {
                this.checkAndChain(expression2);
            } else if (operationTokenType.equals(JavaTokenType.OROR)) {
                this.checkOrChain(expression2);
            }
        }

        private void checkOrChain(PsiPolyadicExpression expression2) {
            PsiExpression[] operands2 = expression2.getOperands();
            for (int i = 0; i < operands2.length - 1; ++i) {
                IElementType tokenType;
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)operands2[i]), PsiBinaryExpression.class);
                if (binaryExpression == null || !(tokenType = binaryExpression.getOperationTokenType()).equals(JavaTokenType.EQEQ)) continue;
                for (int j = i + 1; j < operands2.length; ++j) {
                    PsiExpression implicitCheckCandidate = BoolUtils.getNegated(PsiUtil.skipParenthesizedExprDown((PsiExpression)operands2[j]));
                    if (!this.checkExpressions(operands2, i, j, binaryExpression, implicitCheckCandidate)) continue;
                    return;
                }
            }
        }

        private void checkAndChain(PsiPolyadicExpression expression2) {
            PsiExpression[] operands2 = expression2.getOperands();
            for (int i = 0; i < operands2.length - 1; ++i) {
                IElementType tokenType;
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)operands2[i]), PsiBinaryExpression.class);
                if (binaryExpression == null || !(tokenType = binaryExpression.getOperationTokenType()).equals(JavaTokenType.NE)) continue;
                for (int j = i + 1; j < operands2.length; ++j) {
                    PsiExpression implicitCheckCandidate = PsiUtil.skipParenthesizedExprDown((PsiExpression)operands2[j]);
                    if (!this.checkExpressions(operands2, i, j, binaryExpression, implicitCheckCandidate)) continue;
                    return;
                }
            }
        }

        private boolean checkExpressions(PsiExpression[] operands2, int i, int j, PsiBinaryExpression binaryExpression, PsiExpression implicitCheckCandidate) {
            PsiReferenceExpression explicitCheckReference = PointlessNullCheckVisitor.getReferenceFromNullCheck(binaryExpression);
            if (explicitCheckReference == null) {
                return false;
            }
            PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)explicitCheckReference.resolve(), PsiVariable.class);
            PsiReferenceExpression implicitCheckReference = this.getReferenceFromImplicitNullCheckExpression(implicitCheckCandidate);
            if (implicitCheckReference == null || !implicitCheckReference.isReferenceTo((PsiElement)variable)) {
                return false;
            }
            if (PointlessNullCheckVisitor.isVariableUsed(operands2, i, j, variable)) {
                return false;
            }
            this.registerError((PsiElement)binaryExpression, binaryExpression, implicitCheckReference);
            return true;
        }

        private static boolean isVariableUsed(PsiExpression[] operands2, int i, int j, PsiVariable variable) {
            return Arrays.stream(operands2, i + 1, j).anyMatch(op -> VariableAccessUtils.variableIsUsed(variable, (PsiElement)op));
        }

        @Nullable
        private static PsiReferenceExpression getReferenceFromNullCheck(PsiBinaryExpression expression2) {
            PsiExpression comparedWithNull = ExpressionUtils.getValueComparedWithNull(expression2);
            return (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)comparedWithNull), PsiReferenceExpression.class);
        }

        @Nullable
        private PsiReferenceExpression getReferenceFromImplicitNullCheckExpression(PsiExpression expression2) {
            PsiReferenceExpression checked = PointlessNullCheckVisitor.getReferenceFromInstanceofExpression(expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2));
            if (checked == null && this.myReportCalls) {
                checked = PointlessNullCheckVisitor.getReferenceFromBooleanCall(expression2);
            }
            if (checked == null) {
                checked = this.getReferenceFromOrChain(expression2);
            }
            return checked;
        }

        @Nullable
        private static PsiReferenceExpression getReferenceFromInstanceofExpression(PsiExpression expression2) {
            if (!(expression2 instanceof PsiInstanceOfExpression)) {
                return null;
            }
            PsiExpression operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiInstanceOfExpression)expression2).getOperand());
            return (PsiReferenceExpression)ObjectUtils.tryCast((Object)operand2, PsiReferenceExpression.class);
        }

        @Nullable
        private static PsiReferenceExpression getReferenceFromBooleanCall(PsiExpression expression2) {
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
            if (!PsiType.BOOLEAN.equals((Object)call.getType())) {
                return null;
            }
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier != null && SideEffectChecker.mayHaveSideEffects(qualifier)) {
                return null;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return null;
            }
            List<? extends MethodContract> contracts2 = ControlFlowAnalyzer.getMethodCallContracts(method, call);
            if (contracts2.isEmpty()) {
                return null;
            }
            StandardMethodContract contract = (StandardMethodContract)ObjectUtils.tryCast((Object)contracts2.get(0), StandardMethodContract.class);
            if (contract == null || contract.getReturnValue() != MethodContract.ValueConstraint.FALSE_VALUE) {
                return null;
            }
            MethodContract.ValueConstraint[] arguments = contract.arguments;
            int idx = -1;
            for (int i = 0; i < arguments.length; ++i) {
                if (arguments[i] == MethodContract.ValueConstraint.NULL_VALUE) {
                    if (idx != -1) {
                        return null;
                    }
                    idx = i;
                    continue;
                }
                if (arguments[i] == MethodContract.ValueConstraint.ANY_VALUE) continue;
                return null;
            }
            if (idx == -1) {
                return null;
            }
            PsiExpression[] args = ((PsiMethodCallExpression)expression2).getArgumentList().getExpressions();
            if (args.length <= idx || method.isVarArgs() && idx == args.length - 1) {
                return null;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)ObjectUtils.tryCast((Object)args[idx], PsiReferenceExpression.class);
            if (reference == null) {
                return null;
            }
            PsiVariable target = (PsiVariable)ObjectUtils.tryCast((Object)reference.resolve(), PsiVariable.class);
            if (target == null) {
                return null;
            }
            if (!SyntaxTraverser.psiTraverser((PsiElement)call).filter(PsiReference.class).filter(ref -> !reference.equals(ref) && ref.isReferenceTo((PsiElement)target)).isEmpty()) {
                return null;
            }
            if (Stream.of(args).anyMatch(SideEffectChecker::mayHaveSideEffects)) {
                return null;
            }
            return reference;
        }

        @Nullable
        private PsiReferenceExpression getReferenceFromOrChain(PsiExpression expression2) {
            if (!(expression2 instanceof PsiPolyadicExpression)) {
                return null;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (JavaTokenType.OROR != tokenType) {
                return null;
            }
            PsiExpression[] operands2 = polyadicExpression.getOperands();
            PsiReferenceExpression referenceExpression = this.getReferenceFromImplicitNullCheckExpression(operands2[0]);
            if (referenceExpression == null) {
                return null;
            }
            PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)referenceExpression.resolve(), PsiVariable.class);
            int operandsLength = operands2.length;
            for (int i = 1; i < operandsLength; ++i) {
                PsiReferenceExpression reference2 = this.getReferenceFromImplicitNullCheckExpression(operands2[i]);
                if (reference2 != null && reference2.isReferenceTo((PsiElement)variable)) continue;
                return null;
            }
            return referenceExpression;
        }
    }

    private static class PointlessNullCheckFix
    extends InspectionGadgetsFix {
        private final String myExpressionText;

        public PointlessNullCheckFix(String expressionText) {
            this.myExpressionText = expressionText;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("pointless.nullcheck.simplify.quickfix", this.myExpressionText);
            if (string == null) {
                PointlessNullCheckFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Simplify" == null) {
                PointlessNullCheckFix.$$$reportNull$$$0(1);
            }
            return "Simplify";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiPolyadicExpression.class);
            if (polyadicExpression == null) {
                return;
            }
            Object[] children = polyadicExpression.getChildren();
            int start = IntStreamEx.ofIndices((Object[])children, child -> PsiTreeUtil.isAncestor((PsiElement)child, (PsiElement)element, (boolean)false)).findFirst().orElse(-1);
            if (start == -1) {
                return;
            }
            int end = IntStreamEx.range((int)(start + 1), (int)children.length).findFirst(arg_0 -> PointlessNullCheckFix.lambda$doFix$1((PsiElement[])children, arg_0)).orElse(-1);
            if (end == -1) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            String replacement = IntStreamEx.range((int)0, (int)start).append((IntStream)IntStreamEx.range((int)end, (int)children.length)).elements(children).map(ct::text).joining();
            ct.replaceAndRestoreComments((PsiElement)polyadicExpression, replacement);
        }

        private static /* synthetic */ boolean lambda$doFix$1(PsiElement[] children, int idx) {
            return children[idx] instanceof PsiExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/controlflow/PointlessNullCheckInspection$PointlessNullCheckFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class DoNotReportOnCallsFix
    extends DelegatingFix
    implements LowPriorityAction,
    Iconable {
        public DoNotReportOnCallsFix(PointlessNullCheckInspection inspection) {
            super(new SetInspectionOptionFix((InspectionProfileEntry)inspection, PointlessNullCheckInspection.REPORT_CALLS_OPTION, InspectionGadgetsBundle.message("pointless.nullcheck.option.report.calls.off", new Object[0]), false));
        }

        public Icon getIcon(int flags) {
            return ((Iconable)this.delegate).getIcon(flags);
        }
    }
}

