/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ConvertToVarargsMethodFix
extends InspectionGadgetsFix {
    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("convert.to.variable.arity.method.quickfix", new Object[0]);
        if (string == null) {
            ConvertToVarargsMethodFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        if (!(element instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)element;
        ArrayList<Object> writtenElements = new ArrayList<Object>();
        writtenElements.add(method);
        ArrayList<PsiReferenceExpression> methodCalls = new ArrayList<PsiReferenceExpression>();
        for (PsiReference reference : ReferencesSearch.search((PsiElement)method, (SearchScope)method.getUseScope(), (boolean)false)) {
            PsiElement referenceElement = reference.getElement();
            if (!(referenceElement instanceof PsiReferenceExpression)) continue;
            writtenElements.add(referenceElement);
            methodCalls.add((PsiReferenceExpression)referenceElement);
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(writtenElements)) {
            return;
        }
        WriteAction.run(() -> {
            ConvertToVarargsMethodFix.makeMethodVarargs(method);
            ConvertToVarargsMethodFix.makeMethodCallsVarargs(methodCalls);
        });
    }

    private static void makeMethodVarargs(PsiMethod method) {
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() == 0) {
            return;
        }
        PsiParameter[] parameters2 = parameterList.getParameters();
        PsiParameter lastParameter = parameters2[parameters2.length - 1];
        lastParameter.normalizeDeclaration();
        PsiType type2 = lastParameter.getType();
        if (!(type2 instanceof PsiArrayType)) {
            return;
        }
        PsiArrayType arrayType = (PsiArrayType)type2;
        PsiType componentType = arrayType.getComponentType();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)method.getProject());
        PsiEllipsisType ellipsisType = new PsiEllipsisType(componentType, TypeAnnotationProvider.Static.create((PsiAnnotation[])type2.getAnnotations()));
        PsiTypeElement newTypeElement = factory.createTypeElement((PsiType)ellipsisType);
        PsiTypeElement typeElement = lastParameter.getTypeElement();
        if (typeElement != null) {
            typeElement.replace((PsiElement)newTypeElement);
        }
    }

    private static void makeMethodCallsVarargs(Collection<PsiReferenceExpression> referenceExpressions) {
        for (PsiReferenceExpression referenceExpression : referenceExpressions) {
            PsiExpression[] initializers;
            PsiNewExpression newExpression;
            PsiArrayInitializerExpression arrayInitializerExpression;
            PsiExpression lastArgument;
            PsiMethodCallExpression methodCallExpression;
            PsiExpressionList argumentList;
            PsiExpression[] arguments;
            PsiElement parent = referenceExpression.getParent();
            if (!(parent instanceof PsiMethodCallExpression) || (arguments = (argumentList = (methodCallExpression = (PsiMethodCallExpression)parent).getArgumentList()).getExpressions()).length == 0 || !((lastArgument = arguments[arguments.length - 1]) instanceof PsiNewExpression) || (arrayInitializerExpression = (newExpression = (PsiNewExpression)lastArgument).getArrayInitializer()) == null) continue;
            for (PsiExpression initializer : initializers = arrayInitializerExpression.getInitializers()) {
                argumentList.add((PsiElement)initializer);
            }
            lastArgument.delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/ConvertToVarargsMethodFix", "getFamilyName"));
    }
}

