/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.util.containers.OrderedSet;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class IgnoreClassFix
extends InspectionGadgetsFix {
    final OrderedSet<String> myIgnoredClasses;
    final String myQualifiedName;
    private final String myFixName;

    public IgnoreClassFix(String qualifiedName, OrderedSet<String> ignoredClasses, String fixName) {
        this.myIgnoredClasses = ignoredClasses;
        this.myQualifiedName = qualifiedName;
        this.myFixName = fixName;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.myFixName;
        if (string == null) {
            IgnoreClassFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Ignore for these types" == null) {
            IgnoreClassFix.$$$reportNull$$$0(1);
        }
        return "Ignore for these types";
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void doFix(final Project project, ProblemDescriptor descriptor) {
        if (!this.myIgnoredClasses.add((Object)this.myQualifiedName)) {
            return;
        }
        ProjectInspectionProfileManager.getInstance((Project)project).fireProfileChanged();
        VirtualFile vFile = descriptor.getPsiElement().getContainingFile().getVirtualFile();
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(new VirtualFile[]{vFile}){

            public void undo() {
                IgnoreClassFix.this.myIgnoredClasses.remove((Object)IgnoreClassFix.this.myQualifiedName);
                ProjectInspectionProfileManager.getInstance((Project)project).fireProfileChanged();
            }

            public void redo() {
                IgnoreClassFix.this.myIgnoredClasses.add((Object)IgnoreClassFix.this.myQualifiedName);
                ProjectInspectionProfileManager.getInstance((Project)project).fireProfileChanged();
            }

            public boolean isGlobal() {
                return true;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/fixes/IgnoreClassFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

