/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiVariable;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.FinalUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeFieldStaticFinalFix
extends InspectionGadgetsFix {
    private final String fieldName;

    private MakeFieldStaticFinalFix(String fieldName) {
        this.fieldName = fieldName;
    }

    @NotNull
    public static InspectionGadgetsFix buildFixUnconditional(@NotNull PsiField field) {
        if (field == null) {
            MakeFieldStaticFinalFix.$$$reportNull$$$0(0);
        }
        MakeFieldStaticFinalFix makeFieldStaticFinalFix = new MakeFieldStaticFinalFix(field.getName());
        if (makeFieldStaticFinalFix == null) {
            MakeFieldStaticFinalFix.$$$reportNull$$$0(1);
        }
        return makeFieldStaticFinalFix;
    }

    @Nullable
    public static InspectionGadgetsFix buildFix(PsiField field) {
        PsiExpression initializer = field.getInitializer();
        if (initializer == null) {
            return null;
        }
        if (!FinalUtils.canBeFinal((PsiVariable)field)) {
            return null;
        }
        return new MakeFieldStaticFinalFix(field.getName());
    }

    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("make.static.final.quickfix", this.fieldName);
        if (string == null) {
            MakeFieldStaticFinalFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Make static final" == null) {
            MakeFieldStaticFinalFix.$$$reportNull$$$0(3);
        }
        return "Make static final";
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiElement element = descriptor.getPsiElement();
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiField)) {
            return;
        }
        PsiField field = (PsiField)parent;
        PsiModifierList modifierList = field.getModifierList();
        if (modifierList == null) {
            return;
        }
        modifierList.setModifierProperty("final", true);
        modifierList.setModifierProperty("static", true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/fixes/MakeFieldStaticFinalFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/fixes/MakeFieldStaticFinalFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixUnconditional";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFixUnconditional";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

