/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.imports;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OrderedSet;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.IgnoreClassFix;
import com.siyeh.ig.fixes.SuppressForTestsScopeFix;
import com.siyeh.ig.imports.StaticImportInspectionBase;
import com.siyeh.ig.ui.UiUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class StaticImportInspection
extends StaticImportInspectionBase {
    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        SmartList result = new SmartList();
        PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)infos[0];
        SuppressForTestsScopeFix fix = SuppressForTestsScopeFix.build(this, (PsiElement)importStaticStatement);
        ContainerUtil.addIfNotNull((Collection)result, (Object)fix);
        PsiClass aClass = importStaticStatement.resolveTargetClass();
        if (aClass != null) {
            String name = aClass.getQualifiedName();
            result.add(new IgnoreClassFix(name, (OrderedSet<String>)this.allowedClasses, "Allow static imports for class '" + name + "'"));
        }
        result.add(this.buildFix(infos));
        InspectionGadgetsFix[] inspectionGadgetsFixArray = result.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
        if (inspectionGadgetsFixArray == null) {
            StaticImportInspection.$$$reportNull$$$0(0);
        }
        return inspectionGadgetsFixArray;
    }

    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        JPanel chooserList = UiUtils.createTreeClassChooserList((Collection<String>)this.allowedClasses, "Statically importable Classes", "Choose statically importable class", new String[0]);
        panel.add((Component)chooserList, constraints);
        constraints.gridy = 1;
        constraints.weighty = 0.0;
        CheckBox checkBox1 = new CheckBox(InspectionGadgetsBundle.message("ignore.single.field.static.imports.option", new Object[0]), (InspectionProfileEntry)this, "ignoreSingleFieldImports");
        panel.add((Component)checkBox1, constraints);
        constraints.gridy = 2;
        CheckBox checkBox2 = new CheckBox(InspectionGadgetsBundle.message("ignore.single.method.static.imports.option", new Object[0]), (InspectionProfileEntry)this, "ignoreSingeMethodImports");
        panel.add((Component)checkBox2, constraints);
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/imports/StaticImportInspection", "buildFixes"));
    }
}

