/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleCharacterStartsWithInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("single.character.startswith.display.name", new Object[0]);
        if (string == null) {
            SingleCharacterStartsWithInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("single.character.startswith.problem.descriptor", new Object[0]);
        if (string == null) {
            SingleCharacterStartsWithInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new SingleCharacterStartsWithFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SingleCharacterStartsWithVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/j2me/SingleCharacterStartsWithInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SingleCharacterStartsWithVisitor
    extends BaseInspectionVisitor {
        private SingleCharacterStartsWithVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                SingleCharacterStartsWithVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"startsWith".equals(methodName) && !"endsWith".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length != 1 && args.length != 2) {
                return;
            }
            if (!SingleCharacterStartsWithVisitor.isSingleCharacterStringLiteral(args[0])) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiType type2 = qualifier.getType();
            if (!TypeUtils.isJavaLangString(type2)) {
                return;
            }
            this.registerMethodCallError(call, new Object[0]);
        }

        private static boolean isSingleCharacterStringLiteral(PsiExpression arg) {
            PsiType type2 = arg.getType();
            if (!TypeUtils.isJavaLangString(type2)) {
                return false;
            }
            if (!(arg instanceof PsiLiteralExpression)) {
                return false;
            }
            PsiLiteralExpression literal = (PsiLiteralExpression)arg;
            String value2 = (String)literal.getValue();
            if (value2 == null) {
                return false;
            }
            return value2.length() == 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/j2me/SingleCharacterStartsWithInspection$SingleCharacterStartsWithVisitor", "visitMethodCallExpression"));
        }
    }

    private static class SingleCharacterStartsWithFix
    extends InspectionGadgetsFix {
        private SingleCharacterStartsWithFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("single.character.startswith.quickfix", new Object[0]);
            if (string == null) {
                SingleCharacterStartsWithFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiReferenceExpression methodExpression = (PsiReferenceExpression)element.getParent();
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)methodExpression.getParent();
            PsiElement qualifier = methodExpression.getQualifier();
            if (qualifier == null) {
                return;
            }
            PsiExpressionList argumentList = methodCall.getArgumentList();
            PsiExpression[] expressions2 = argumentList.getExpressions();
            PsiExpression expression2 = expressions2[0];
            String expressionText = expression2.getText();
            String character = expressionText.substring(1, expressionText.length() - 1);
            if (character.equals("'")) {
                character = "\\'";
            }
            String qualifierText = qualifier.getText();
            String referenceName = methodExpression.getReferenceName();
            String newExpression = "startsWith".equals(referenceName) ? qualifierText + ".length() > 0 && " + qualifierText + ".charAt(0) == '" + character + '\'' : qualifierText + ".length() > 0 && " + qualifierText + ".charAt(" + qualifierText + ".length() - 1) == '" + character + '\'';
            CommentTracker commentTracker = new CommentTracker();
            commentTracker.markUnchanged(qualifier);
            PsiReplacementUtil.replaceExpression((PsiExpression)methodCall, newExpression, commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/SingleCharacterStartsWithInspection$SingleCharacterStartsWithFix", "getFamilyName"));
        }
    }
}

